/*
 * Decompiled with CFR 0.152.
 */
package ghidra.service.graph;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class VertexShape {
    private static Map<String, VertexShape> registeredShapes = new HashMap<String, VertexShape>();
    private static int SIZE = 50;
    public static VertexShape RECTANGLE = new RectangleVertexShape(SIZE);
    public static VertexShape ELLIPSE = new EllipseVertexShape(SIZE);
    public static VertexShape TRIANGLE_UP = new TriangleUpVertexShape(SIZE);
    public static VertexShape TRIANGLE_DOWN = new TriangleDownVertexShape(SIZE);
    public static VertexShape STAR = new StarVertexShape(SIZE);
    public static VertexShape DIAMOND = new DiamondVertexShape(SIZE);
    public static VertexShape PENTAGON = new PentagonVertexShape(SIZE);
    public static VertexShape HEXAGON = new HexagonVertexShape(SIZE);
    public static VertexShape OCTAGON = new OctagonVertexShape(SIZE);
    private Shape cachedShape;
    private String name;
    private int size;

    VertexShape(String name, int size) {
        this.name = name;
        this.size = size;
        registeredShapes.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public Shape getShape() {
        if (this.cachedShape == null) {
            this.cachedShape = this.size(this.createShape());
        }
        return this.cachedShape;
    }

    private Shape size(Shape shape) {
        AffineTransform transform = new AffineTransform();
        Rectangle bounds = shape.getBounds();
        double scale = (double)this.size / bounds.getWidth();
        transform.scale(scale, scale);
        return transform.createTransformedShape(shape);
    }

    public double getLabelPosition() {
        return 0.5;
    }

    public double getShapeToLabelRatio() {
        return 1.0;
    }

    public int getMaxWidthToHeightRatio() {
        return 10;
    }

    protected abstract Shape createShape();

    public static VertexShape getShape(String shapeName) {
        return registeredShapes.get(shapeName);
    }

    public static List<String> getShapeNames() {
        ArrayList<String> list = new ArrayList<String>(registeredShapes.keySet());
        Collections.sort(list);
        return list;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VertexShape other = (VertexShape)obj;
        return Objects.equals(this.name, other.name) && this.size == other.size;
    }

    static class OctagonVertexShape
    extends EquilateralPolygonVertexShape {
        private OctagonVertexShape(int size) {
            super("Octagon", 8, 0.0, size);
        }
    }

    static class HexagonVertexShape
    extends EquilateralPolygonVertexShape {
        private HexagonVertexShape(int size) {
            super("Hexagon", 6, 0.0, size);
        }
    }

    static class PentagonVertexShape
    extends EquilateralPolygonVertexShape {
        private PentagonVertexShape(int size) {
            super("Pentaon", 5, 3.4557519189487724, size);
        }
    }

    static class EquilateralPolygonVertexShape
    extends VertexShape {
        private int numSides;
        private double startAngle;

        protected EquilateralPolygonVertexShape(String name, int numSides, double startAngle, int size) {
            super(name, size);
            this.numSides = numSides;
            this.startAngle = startAngle;
        }

        @Override
        protected Shape createShape() {
            Path2D.Double path = new Path2D.Double();
            double deltaAngle = Math.PI * 2 / (double)this.numSides;
            double angle = this.startAngle;
            ((Path2D)path).moveTo(Math.cos(angle), Math.sin(angle));
            for (int i = 0; i < this.numSides; ++i) {
                ((Path2D)path).lineTo(Math.cos(angle += deltaAngle), Math.sin(angle));
            }
            return path;
        }

        @Override
        public int getMaxWidthToHeightRatio() {
            return 2;
        }

        @Override
        public double getShapeToLabelRatio() {
            return 1.4;
        }
    }

    static class DiamondVertexShape
    extends VertexShape {
        private DiamondVertexShape(int size) {
            super("Diamond", size);
        }

        @Override
        protected Shape createShape() {
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(0.0, -1.0);
            ((Path2D)path).lineTo(-1.0, 0.0);
            ((Path2D)path).lineTo(0.0, 1.0);
            ((Path2D)path).lineTo(1.0, 0.0);
            path.closePath();
            return path;
        }

        @Override
        public double getShapeToLabelRatio() {
            return 1.6;
        }
    }

    static class StarVertexShape
    extends VertexShape {
        private StarVertexShape(int size) {
            super("Star", size);
        }

        @Override
        protected Shape createShape() {
            int numPoints = 7;
            Path2D.Double path = new Path2D.Double();
            double outerRadius = 2.0;
            double innerRadius = 1.0;
            double deltaAngle = Math.PI / (double)numPoints;
            double angle = 4.71238898038469;
            ((Path2D)path).moveTo(outerRadius * Math.cos(angle), outerRadius * Math.sin(angle));
            for (int i = 0; i < numPoints; ++i) {
                ((Path2D)path).lineTo(innerRadius * Math.cos(angle += deltaAngle), innerRadius * Math.sin(angle));
                ((Path2D)path).lineTo(outerRadius * Math.cos(angle += deltaAngle), outerRadius * Math.sin(angle));
            }
            return path;
        }

        @Override
        public double getShapeToLabelRatio() {
            return 2.0;
        }
    }

    static class TriangleDownVertexShape
    extends VertexShape {
        private TriangleDownVertexShape(int size) {
            super("Triangle Down", size);
        }

        @Override
        protected Shape createShape() {
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(-1.0, -1.0);
            ((Path2D)path).lineTo(1.0, -1.0);
            ((Path2D)path).lineTo(0.0, 1.0);
            path.closePath();
            return path;
        }

        @Override
        public double getShapeToLabelRatio() {
            return 1.6;
        }

        @Override
        public double getLabelPosition() {
            return 0.1;
        }
    }

    static class TriangleUpVertexShape
    extends VertexShape {
        private TriangleUpVertexShape(int size) {
            super("Triangle Up", size);
        }

        @Override
        protected Shape createShape() {
            Path2D.Double path = new Path2D.Double();
            ((Path2D)path).moveTo(-1.0, 1.0);
            ((Path2D)path).lineTo(1.0, 1.0);
            ((Path2D)path).lineTo(0.0, -1.0);
            path.closePath();
            return path;
        }

        @Override
        public double getShapeToLabelRatio() {
            return 1.6;
        }

        @Override
        public double getLabelPosition() {
            return 0.9;
        }
    }

    static class EllipseVertexShape
    extends VertexShape {
        private EllipseVertexShape(int size) {
            super("Ellipse", size);
        }

        @Override
        protected Shape createShape() {
            return new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
        }

        @Override
        public double getShapeToLabelRatio() {
            return 1.4;
        }
    }

    static class RectangleVertexShape
    extends VertexShape {
        private RectangleVertexShape(int size) {
            super("Rectangle", size);
        }

        @Override
        protected Shape createShape() {
            return new Rectangle2D.Double(-1.0, -1.0, 2.0, 2.0);
        }
    }
}

