/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.evt.DbgStoppedEvent;
import agent.dbgeng.manager.evt.DbgThreadCreatedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import ghidra.comm.util.BitmaskSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class DbgAttachCommand
extends AbstractDbgCommand<Set<DbgThread>> {
    private DbgProcessCreatedEvent created = null;
    private boolean completed = false;
    private DbgProcessImpl proc;
    private BitmaskSet<DebugClient.DebugAttachFlags> flags;

    public DbgAttachCommand(DbgManagerImpl manager, DbgProcessImpl proc, BitmaskSet<DebugClient.DebugAttachFlags> flags) {
        super(manager);
        this.proc = proc;
        this.flags = flags;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof DbgProcessCreatedEvent) {
            this.created = (DbgProcessCreatedEvent)evt;
        } else if (evt instanceof DbgThreadCreatedEvent) {
            pending.claim(evt);
        } else if (evt instanceof DbgStoppedEvent) {
            pending.claim(evt);
        }
        return this.completed && this.created != null;
    }

    @Override
    public Set<DbgThread> complete(DbgPendingCommand<?> pending) {
        DebugSystemObjects so = this.manager.getSystemObjects();
        LinkedHashSet<DbgThread> threads = new LinkedHashSet<DbgThread>();
        for (DbgThreadCreatedEvent adds : pending.findAllOf(DbgThreadCreatedEvent.class)) {
            DebugThreadInfo info = (DebugThreadInfo)adds.getInfo();
            DebugThreadId tid = so.getThreadIdByHandle(info.handle);
            threads.add(this.manager.getThread(tid));
        }
        return threads;
    }

    @Override
    public void invoke() {
        DebugClient dbgeng = this.manager.getClient();
        dbgeng.attachProcess(dbgeng.getLocalServer(), this.proc.getPid().intValue(), this.flags);
        this.manager.waitForEventEx();
    }
}

