(* (c) Microsoft Corporation. All rights reserved *)
(*F# 
module Microsoft.Research.AbstractIL.Extensions.ILX.Msilxlib
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
open Microsoft.Research.AbstractIL.Extensions.ILX
module Il = Microsoft.Research.AbstractIL.IL 
F#*)  

open Il

open Nums
open Ilxsettings

let compiling_msilxlib_ref = ref false

let publickey = PublicKeyToken(Bytes.of_intarray [|103;241;202;169;071;205;028;035|])

let version = Il.parse_version Ilxconfig.version

let ilxLibraryAssemRef = ref (None : Il.assembly_ref option)
let namespace_ref = ref "System.LanguageInterop"

(* How are closures implemented? *)
let call_implementation = ref Ilxconfig.default_call_implementation
let pp_implementation = ref Ilxconfig.default_pp_implementation
let tailcall_implementation = ref Ilxconfig.default_tailcall_implementation
let entrypoint_implementation = ref Ilxconfig.default_entrypoint_implementation
let maximum_cli_library_version_to_depend_upon = ref Ilxconfig.default_maximum_cli_library_version_to_depend_upon 

(* Misc. Unused. *)
let cu_erase = ref true
let clo_erase = ref true

(* The extensions used here should match those in the Makefile *)
let add_call_suffix s =
  match !call_implementation with 
  | x when x = Ilxconfig.default_call_implementation -> s
  | VirtEntriesVirtCode ->  s^"virt"

let add_maximum_cli_library_version_to_depend_upon_suffix s =
  match !maximum_cli_library_version_to_depend_upon with 
  | x when x = Ilxconfig.default_maximum_cli_library_version_to_depend_upon -> s
  | CLI_Library_v1_0 -> s^"10"
  | CLI_Library_v2_0b2 -> s^"20b2"
  | CLI_Library_v2_0rc -> s^"20rc"


let add_tailcall_suffix (s:string) = s
(*
  match !tailcall_implementation with
  | x when x = Ilxconfig.default_tailcall_implementation -> s
  | Ilxsettings.AllTailcalls -> s^"atc"
  | Ilxsettings.NoTailcalls -> s^"ntc" *)

let add_entrypoint_suffix s = 
  match !entrypoint_implementation with
  | x when x = Ilxconfig.default_entrypoint_implementation -> s
  | Ilxsettings.MultiEntryPoints -> s^"mep"
  | Ilxsettings.SingleEntryPoints -> s^"sep"

let suffix () =  
  let s = add_call_suffix "" in 
  let s = add_maximum_cli_library_version_to_depend_upon_suffix s in 
  let s = add_tailcall_suffix s in
  let s = add_entrypoint_suffix s in
  s

let assref nm = 
  { assemRefName=nm^suffix();
    assemRefHash= None; 
    assemRefPublicKeyInfo= Some publickey;
    assemRefRetargetable=false;
    assemRefVersion=Some version;
    assemRefLocale=None; }

let scoref () =
  if !compiling_msilxlib_ref then ScopeRef_local 
  else 
    ScopeRef_assembly 
      (match !ilxLibraryAssemRef with 
      | Some o -> o
      | None -> assref "ilxlib")

let ilxNamespace () =  !namespace_ref

let minCLIMetadataVersion () = 
  match !pp_implementation with 
  | NoGenerics ->  Il.parse_version "1.0.3705"
  | TyrepGenerics | FullGenerics ->    Il.parse_version "2.0.0"
        
