(* (c) Microsoft Corporation. All rights reserved *)

(*F# 
module Microsoft.FSharp.Compiler.Ilxgen
open Microsoft.Research.AbstractIL
open Microsoft.Research.AbstractIL.Internal
open Microsoft.FSharp.Compiler 
module Il = Microsoft.Research.AbstractIL.IL
F#*) 



(*F#
[<StructuralEquality(false); StructuralComparison(false)>]
F#*)
type cenv = 
 { g: Env.tcGlobals;
   viewCcu: Tast.ccu;
   fragName: string;
   generateFilterBlocks : bool;
   workAroundReflectionEmitMethodImplBug: bool;
   amap: Import.importMap;
   main_info: Tast.attrib list option;
   optimize: bool;
   debug: bool;
   empty_ok: bool;
   manager: Il.manager option; }

type ilxGenEnv 
val empty_ilxGenEnv : Tast.ccu -> ilxGenEnv 
val add_external_ccus : Env.tcGlobals -> ilxGenEnv -> Tast.ccu list -> ilxGenEnv 
val add_incremental_local_mimpls : bool -> Env.tcGlobals -> Tast.ccu -> string -> ilxGenEnv -> Tast.typedAssembly -> ilxGenEnv 

type codegenResults = 
    { ilTypeDefs             : Il.type_def list;
      ilAssemAttrs           : Il.custom_attr list;
      ilNetModuleAttrs       : Il.custom_attr list;
      quotationResourceBytes : Bytes.bytes list }

val codegen : 
   cenv 
   -> ilxGenEnv 
   -> Tast.typedAssembly 
   -> Tast.attribs * Tast.attribs 
   -> codegenResults


val report : out_channel -> unit 
