(* (c) Microsoft Corporation 2005-2007.  *)

#light

module Microsoft.FSharp.Compiler.Server.Shared

// For FSI VS plugin, require FSI to provide services:
// e.g.
//   - interrupt
//   - intelisense completion
// 
// This is done via remoting.
// Here we define the service class.
// This dll is required for both client (fsi-vs plugin) and server (spawned fsi).

[<AbstractClass>]
type FSharpInteractiveServer() =
    inherit System.MarshalByRefObject()  
    abstract Interrupt   : unit -> unit
    abstract Completions : string -> string array
    default x.Interrupt() = ()

open System
open System.Runtime.Remoting.Channels
open System.Runtime.Remoting
open System.Runtime.Remoting.Lifetime
 
let startServer (channelName:string) (server:FSharpInteractiveServer) =
#if CLI_AT_MOST_1_1
    failwith "no Ipc on .NET 1.x" 
#else
    let chan = new Ipc.IpcChannel(channelName) 
    LifetimeServices.LeaseTime            <- TimeSpan(7,0,0,0); // days,hours,mins,secs 
    LifetimeServices.LeaseManagerPollTime <- TimeSpan(7,0,0,0);
    LifetimeServices.RenewOnCallTime      <- TimeSpan(7,0,0,0);
    LifetimeServices.SponsorshipTimeout   <- TimeSpan(7,0,0,0);
    ChannelServices.RegisterChannel(chan,false);
    let objRef = RemotingServices.Marshal(server,"FSIServer") 
    ()
#endif

let startClient channelName =
  let T = Activator.GetObject((type FSharpInteractiveServer),"ipc://" ^ channelName ^ "/FSIServer") in
  let x = T :?> FSharpInteractiveServer in
  x

(*TESTCODE:    
(* server *)
#r "FSharp.Compiler.Server.Shared.dll";;;;
open System
open System.Runtime.Remoting.Channels
open System.Runtime.Remoting
open System.Runtime.Remoting.Lifetime
open Microsoft.FSharp.Compiler.Server.Shared      
let server = {new FSharpInteractiveServer() with Interrupt() = printf "Stop!!\n"}
let channelName = "chanName"  
let chan = new Ipc.IpcChannel(channelName)
let _ = ChannelServices.RegisterChannel(chan)
let _ = RemotingConfiguration.RegisterWellKnownServiceType(
  (type FSharpInteractiveServer),
  "FSIServer",
  WellKnownObjectMode.Singleton);
  
  
let objRef = RemotingServices.Marshal(server,"ipc://" ^ channelName ^ "/FSIServer")

(* client side *)
#r "FSharp.Compiler.Server.Shared.dll";;;;  
open Microsoft.FSharp.Compiler.Server.Shared
let channelName = "chanName"
let client = startClient channelName
do  client.Interrupt()
*)
