/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.DateTime;
import fan.sys.DateTimeStr;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.FanObj;
import fan.sys.Locale;
import fan.sys.Month;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Time;
import fan.sys.TimeZone;
import fan.sys.Type;
import fan.sys.Weekday;

public final class Date
extends FanObj {
    private static final String localeKey = "date";
    public static final Date defVal = new Date(2000, 0, 1);
    final short year;
    final byte month;
    final byte day;
    private String str;

    public static Date today() {
        return DateTime.now().date();
    }

    public static Date today(TimeZone timeZone) {
        return DateTime.makeTicks(DateTime.nowTicks(), timeZone).date();
    }

    public static Date make(long l, Month month, long l2) {
        return new Date((int)l, month.ord, (int)l2);
    }

    Date(int n, int n2, int n3) {
        if (n2 < 0 || n2 > 11) {
            throw ArgErr.make("month " + n2);
        }
        if (n3 < 1 || n3 > DateTime.numDaysInMonth(n, n2)) {
            throw ArgErr.make("day " + n3);
        }
        this.year = (short)n;
        this.month = (byte)n2;
        this.day = (byte)n3;
    }

    public static Date fromStr(String string) {
        return Date.fromStr(string, true);
    }

    public static Date fromStr(String string, boolean bl) {
        try {
            int n = Date.num(string, 0) * 1000 + Date.num(string, 1) * 100 + Date.num(string, 2) * 10 + Date.num(string, 3);
            int n2 = Date.num(string, 5) * 10 + Date.num(string, 6) - 1;
            int n3 = Date.num(string, 8) * 10 + Date.num(string, 9);
            if (string.charAt(4) != '-' || string.charAt(7) != '-' || string.length() != 10) {
                throw new Exception();
            }
            return new Date(n, n2, n3);
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Date", string);
        }
    }

    static int num(String string, int n) {
        return string.charAt(n) - 48;
    }

    public final boolean equals(Object object) {
        if (object instanceof Date) {
            Date date = (Date)object;
            return this.year == date.year && this.month == date.month && this.day == date.day;
        }
        return false;
    }

    public long compare(Object object) {
        Date date = (Date)object;
        if (this.year == date.year) {
            if (this.month == date.month) {
                if (this.day == date.day) {
                    return 0L;
                }
                return this.day < date.day ? -1L : 1L;
            }
            return this.month < date.month ? -1L : 1L;
        }
        return this.year < date.year ? -1L : 1L;
    }

    public int hashCode() {
        return this.year << 16 ^ this.month << 8 ^ this.day;
    }

    public long hash() {
        return this.year << 16 ^ this.month << 8 ^ this.day;
    }

    public final String toStr() {
        if (this.str == null) {
            this.str = this.toLocale("YYYY-MM-DD");
        }
        return this.str;
    }

    public Type typeof() {
        return Sys.DateType;
    }

    public final long year() {
        return this.year;
    }

    public final int getYear() {
        return this.year;
    }

    public final Month month() {
        return Month.array[this.month];
    }

    public final long day() {
        return this.day;
    }

    public final int getDay() {
        return this.day;
    }

    public final Weekday weekday() {
        int n = (DateTime.firstWeekday(this.year, this.month) + this.day - 1) % 7;
        return Weekday.array[n];
    }

    public final long dayOfYear() {
        return DateTime.dayOfYear(this.getYear(), this.month().ord, this.getDay()) + 1;
    }

    public String toLocale() {
        return this.toLocale(null);
    }

    public String toLocale(String string) {
        Locale locale = null;
        if (string == null) {
            if (locale == null) {
                locale = Locale.cur();
            }
            string = Env.cur().locale(Sys.sysPod, localeKey, "D-MMM-YYYY", locale);
        }
        return new DateTimeStr(string, locale, this).format();
    }

    public static Date fromLocale(String string, String string2) {
        return Date.fromLocale(string, string2, true);
    }

    public static Date fromLocale(String string, String string2, boolean bl) {
        return new DateTimeStr(string2, null).parseDate(string, bl);
    }

    public String toIso() {
        return this.toStr();
    }

    public static Date fromIso(String string) {
        return Date.fromStr(string, true);
    }

    public static Date fromIso(String string, boolean bl) {
        return Date.fromStr(string, bl);
    }

    public final Date plus(Duration duration) {
        return this.plus(duration.ticks());
    }

    public final Date minus(Duration duration) {
        return this.plus(-duration.ticks());
    }

    private Date plus(long l) {
        int n;
        if (l % 86400000000000L != 0L) {
            throw ArgErr.make("Duration must be even num of days");
        }
        int n2 = this.year;
        int n3 = this.month;
        int n4 = this.day;
        int n5 = (int)(l / 86400000000000L);
        int n6 = n = n5 < 0 ? 1 : -1;
        while (n5 != 0) {
            if (n5 > 0) {
                if (++n4 > Date.numDays(n2, n3)) {
                    n4 = 1;
                    if (++n3 >= 12) {
                        n3 = 0;
                        ++n2;
                    }
                }
                --n5;
                continue;
            }
            if (--n4 <= 0) {
                if (--n3 < 0) {
                    n3 = 11;
                    --n2;
                }
                n4 = Date.numDays(n2, n3);
            }
            ++n5;
        }
        return new Date(n2, n3, n4);
    }

    public final Duration minusDate(Date date) {
        if (this.equals(date)) {
            return Duration.Zero;
        }
        Date date2 = this;
        Date date3 = date;
        if (date2.compare(date3) > 0L) {
            date3 = this;
            date2 = date;
        }
        long l = 0L;
        if (date2.year == date3.year) {
            l = date3.dayOfYear() - date2.dayOfYear();
        } else {
            l = (long)(DateTime.isLeapYear(date2.year) ? 366 : 365) - date2.dayOfYear();
            l += date3.dayOfYear();
            for (int i = date2.year + 1; i < date3.year; ++i) {
                l += DateTime.isLeapYear(i) ? 366L : 365L;
            }
        }
        if (date2 == this) {
            l = -l;
        }
        return Duration.make(l * 86400000000000L);
    }

    private static int numDays(int n, int n2) {
        if (DateTime.isLeapYear(n)) {
            return DateTime.daysInMonLeap[n2];
        }
        return DateTime.daysInMon[n2];
    }

    public final Date firstOfMonth() {
        if (this.day == 1) {
            return this;
        }
        return new Date(this.year, this.month, 1);
    }

    public final Date lastOfMonth() {
        int n = (int)this.month().numDays(this.year);
        if (this.day == n) {
            return this;
        }
        return new Date(this.year, this.month, n);
    }

    public boolean isYesterday() {
        return this.equals(Date.today().plus(Duration.negOneDay));
    }

    public boolean isToday() {
        return this.equals(Date.today());
    }

    public boolean isTomorrow() {
        return this.equals(Date.today().plus(Duration.oneDay));
    }

    public DateTime toDateTime(Time time) {
        return DateTime.makeDT(this, time);
    }

    public DateTime toDateTime(Time time, TimeZone timeZone) {
        return DateTime.makeDT(this, time, timeZone);
    }

    public DateTime midnight() {
        return DateTime.makeDT(this, Time.defVal);
    }

    public DateTime midnight(TimeZone timeZone) {
        return DateTime.makeDT(this, Time.defVal, timeZone);
    }

    public String toCode() {
        if (this.equals(defVal)) {
            return "Date.defVal";
        }
        return "Date(\"" + this.toString() + "\")";
    }
}

