/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.memory.MemoryUsage;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.BevelBorder;

public class StatusBar
extends JPanel
implements HighlightListener,
DatabaseChangeListener {
    private WindowFrame frame;
    private String coords = null;
    private String hierCoords = null;
    private JLabel fieldSelected;
    private JLabel fieldSize;
    private JLabel fieldTech;
    private JLabel fieldCoords;
    private JLabel fieldHierCoords;
    private JLabel memoryUsage;
    private static String selectionOverride = null;
    private static List<SavedSelection> allSelections = new ArrayList<SavedSelection>();

    public StatusBar(WindowFrame frame) {
        super(new GridBagLayout());
        this.setBorder(new BevelBorder(1));
        this.frame = frame;
        this.fieldSelected = new JLabel();
        this.fieldSelected.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                StatusBar.this.doSelectionPopup();
            }
        });
        this.addField(this.fieldSelected, 0, 0, 1, 0.0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.add((Component)new JSeparator(1), gbc);
        this.fieldSize = new JLabel();
        this.addField(this.fieldSize, 2, 0, 1, 0.0);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.add((Component)new JSeparator(1), gbc);
        this.fieldTech = new JLabel();
        this.addField(this.fieldTech, 4, 0, 1, 0.0);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.fill = 3;
        this.add((Component)new JSeparator(1), gbc);
        this.fieldCoords = new JLabel();
        this.fieldCoords.setHorizontalAlignment(4);
        this.addField(this.fieldCoords, 6, 0, 1, 0.35);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.gridwidth = 7;
        this.add((Component)new JSeparator(0), gbc);
        this.fieldHierCoords = new JLabel(" ");
        this.fieldHierCoords.setHorizontalAlignment(4);
        this.addField(this.fieldHierCoords, 1, 2, 6, 0.0);
        if (Job.getDebug()) {
            this.memoryUsage = new JLabel(" ");
            this.memoryUsage.setHorizontalAlignment(2);
            this.addField(this.memoryUsage, 0, 2, 1, 0.0);
        }
        Highlighter.addHighlightListener(this);
        UserInterfaceMain.addDatabaseChangeListener(this);
    }

    private void doSelectionPopup() {
        JPopupMenu selections = new JPopupMenu("selections");
        for (SavedSelection ss : allSelections) {
            JMenuItem menuItem = new JMenuItem(ss.selectionName.trim());
            menuItem.addActionListener(new RestoreSelection(ss));
            selections.add(menuItem);
        }
        selections.add(new JSeparator());
        JMenuItem menuItem = new JMenuItem("Clear all Selections");
        Font oldFont = menuItem.getFont();
        Font newFont = new Font(oldFont.getFamily(), 1, oldFont.getSize());
        menuItem.setFont(newFont);
        menuItem.addActionListener(new ClearAllSelections());
        selections.add(menuItem);
        menuItem = new JMenuItem("Save this Selection");
        menuItem.setFont(newFont);
        menuItem.addActionListener(new SaveSelection());
        selections.add(menuItem);
        selections.setVisible(true);
        selections.show(this.fieldSelected, 0, -selections.getHeight());
    }

    private void addField(JComponent field2, int x2, int y, int width, double weight) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x2;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.weightx = weight;
        gbc.fill = 2;
        gbc.anchor = 17;
        int rightInsert = ClientOS.isOSMac() ? 20 : 4;
        gbc.insets = new Insets(0, 4, 0, rightInsert);
        this.add((Component)field2, gbc);
    }

    private Highlighter getHighlighter() {
        if (TopLevel.isMDIMode()) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return null;
            }
            return wnd.getHighlighter();
        }
        return this.frame.getContent().getHighlighter();
    }

    public static void setCoordinates(String coords, WindowFrame wf) {
        StatusBar sb = null;
        sb = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame().getStatusBar() : wf.getFrame().getStatusBar();
        sb.coords = coords;
        sb.redoStatusBar();
    }

    public static void setHierarchicalCoordinates(String hierCoords, WindowFrame wf) {
        StatusBar sb = null;
        sb = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame().getStatusBar() : wf.getFrame().getStatusBar();
        sb.hierCoords = hierCoords;
        sb.redoStatusBar();
    }

    public static void setSelectionOverride(String ov) {
        selectionOverride = ov;
        StatusBar.updateStatusBar();
    }

    @Override
    public void highlightChanged(Highlighter which) {
        this.updateSelectedText();
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    public static void updateStatusBar() {
        if (TopLevel.isMDIMode()) {
            StatusBar sb = TopLevel.getCurrentJFrame().getStatusBar();
            sb.redoStatusBar();
        } else {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                StatusBar sb = wf.getFrame().getStatusBar();
                if (sb == null) continue;
                sb.redoStatusBar();
            }
        }
    }

    private void updateUsedMemory() {
        this.memoryUsage.setText("  " + MemoryUsage.getInstance().toString());
    }

    private void redoStatusBar() {
        Technology tech;
        this.updateSelectedText();
        if (Job.getDebug()) {
            this.updateUsedMemory();
        }
        Cell cell = null;
        WindowFrame thisFrame = this.frame;
        if (thisFrame == null) {
            thisFrame = WindowFrame.getCurrentWindowFrame(false);
            if (thisFrame != null) {
                cell = thisFrame.getContent().getCell();
            }
        } else {
            Cell cellInPanel = thisFrame.getContent().getCell();
            if (cellInPanel != null) {
                cell = cellInPanel;
            }
        }
        String sizeMsg = "";
        if (cell != null) {
            if (thisFrame.getContent() instanceof TextWindow) {
                TextWindow tw = (TextWindow)thisFrame.getContent();
                int len = tw.getLineCount();
                sizeMsg = "LINES: " + len;
            } else {
                ERectangle bounds = cell.getBounds();
                sizeMsg = "SIZE: " + TextUtils.formatDistance(((RectangularShape)bounds).getWidth(), cell.getTechnology()) + " x " + TextUtils.formatDistance(((RectangularShape)bounds).getHeight(), cell.getTechnology());
            }
        }
        sizeMsg = "  " + sizeMsg + "  ";
        this.fieldSize.setText(sizeMsg);
        this.fieldSize.setToolTipText(sizeMsg);
        Technology technology = tech = cell != null ? cell.getTechnology() : Technology.getCurrent();
        if (tech != null) {
            boolean validFoundry;
            String message = "TECH: " + tech.getTechName();
            String foundry = tech.getPrefFoundry();
            boolean bl = validFoundry = !foundry.equals("");
            if (tech.isScaleRelevant()) {
                message = message + " (scale=" + tech.getScale() + "nm";
                message = !validFoundry ? message + ")" : message + ",foundry=" + foundry + ")";
            }
            this.fieldTech.setText("  " + message + "  ");
            this.fieldTech.setToolTipText(message);
        }
        if (this.coords == null) {
            this.fieldCoords.setText("");
        } else {
            this.fieldCoords.setText(this.coords);
            this.fieldCoords.setToolTipText(this.coords);
        }
        if (this.hierCoords != null) {
            int widgetW;
            int width = this.fieldHierCoords.getFontMetrics(this.fieldHierCoords.getFont()).stringWidth(this.hierCoords);
            if (width > (widgetW = this.fieldHierCoords.getWidth())) {
                int chars = this.hierCoords.length() * widgetW / width;
                this.hierCoords = this.hierCoords.substring(this.hierCoords.length() - chars, this.hierCoords.length());
            }
            this.fieldHierCoords.setText(this.hierCoords);
        } else {
            this.fieldHierCoords.setText(" ");
        }
    }

    private void updateSelectedText() {
        String selectedMsg = "NOTHING SELECTED";
        if (selectionOverride != null) {
            selectedMsg = selectionOverride;
        } else {
            int nodeCount = 0;
            int arcCount = 0;
            int textCount = 0;
            Highlight lastHighlight = null;
            Highlighter highlighter = this.getHighlighter();
            if (highlighter == null) {
                this.fieldSelected.setText("  " + selectedMsg + "  ");
                this.fieldSelected.setToolTipText(selectedMsg);
                return;
            }
            NodeInst theNode = null;
            for (Highlight h : highlighter.getHighlights()) {
                if (!h.isValid()) continue;
                if (h.isHighlightEOBJ()) {
                    ElectricObject eObj = h.getElectricObject();
                    if (eObj instanceof PortInst) {
                        lastHighlight = h;
                        theNode = ((PortInst)eObj).getNodeInst();
                        ++nodeCount;
                        continue;
                    }
                    if (eObj instanceof NodeInst) {
                        lastHighlight = h;
                        theNode = (NodeInst)eObj;
                        ++nodeCount;
                        continue;
                    }
                    if (!(eObj instanceof ArcInst)) continue;
                    lastHighlight = h;
                    ++arcCount;
                    continue;
                }
                if (!h.isHighlightText()) continue;
                lastHighlight = h;
                ++textCount;
            }
            if (nodeCount + arcCount + textCount == 1) {
                selectedMsg = "SELECTED " + this.getSelectedText(lastHighlight);
                if (theNode != null) {
                    PrimitiveNodeSize npSize = theNode.getPrimitiveDependentNodeSize(null);
                    if (npSize != null) {
                        selectedMsg = selectedMsg + " (size=";
                        selectedMsg = selectedMsg + npSize.getWidthInString();
                        selectedMsg = selectedMsg + "x";
                        selectedMsg = selectedMsg + npSize.getLengthInString();
                        selectedMsg = selectedMsg + ")";
                    } else {
                        double xSize = theNode.getLambdaBaseXSize();
                        double ySize = theNode.getLambdaBaseYSize();
                        selectedMsg = selectedMsg + " (size=" + TextUtils.formatDistance(xSize, theNode.getProto().getTechnology()) + " x " + TextUtils.formatDistance(ySize, theNode.getProto().getTechnology()) + ")";
                    }
                }
            } else if (nodeCount + arcCount + textCount > 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("SELECTED:");
                if (nodeCount > 0) {
                    buf.append(" " + nodeCount + " NODES");
                }
                if (arcCount > 0) {
                    if (nodeCount > 0) {
                        buf.append(",");
                    }
                    buf.append(" " + arcCount + " ARCS");
                }
                if (textCount > 0) {
                    if (nodeCount + arcCount > 0) {
                        buf.append(",");
                    }
                    buf.append(" " + textCount + " TEXT");
                }
                buf.append(". LAST: " + this.getSelectedText(lastHighlight));
                selectedMsg = buf.toString();
            }
        }
        this.fieldSelected.setText("  " + selectedMsg + "  ");
        this.fieldSelected.setToolTipText(selectedMsg);
    }

    private String addLayerInfo(PortProto pp) {
        PrimitivePort pRp = pp.getBasePort();
        if (pRp.getParent().getTechnology().isUniversalConnectivityPort(pRp)) {
            return " [ALL]";
        }
        String descr = "";
        ArcProto[] cons = pp.getBasePort().getConnections();
        boolean first = true;
        for (int i = 0; i < cons.length; ++i) {
            ArcProto ap = cons[i];
            if (ap.getTechnology() == Generic.tech()) continue;
            descr = first ? descr + " [" : descr + ",";
            first = false;
            descr = descr + cons[i].getName();
        }
        if (!first) {
            descr = descr + "]";
        }
        return descr;
    }

    private String getSelectedText(Highlight h) {
        assert (h.isValid());
        if (h.isHighlightEOBJ()) {
            ElectricObject eObj = h.getElectricObject();
            if (eObj instanceof PortInst) {
                PortInst thePort = (PortInst)eObj;
                NodeInst theNode = thePort.getNodeInst();
                String desc = theNode.isCellInstance() ? this.addLayerInfo(thePort.getPortProto()) : "";
                return "NODE: " + theNode.describe(true) + " PORT: '" + thePort.getPortProto().getName() + "'" + desc;
            }
            if (eObj instanceof NodeInst) {
                NodeInst theNode = (NodeInst)eObj;
                Technology tech = theNode.getProto().getTechnology();
                String extra = "";
                if (Technology.getCurrent() != tech) {
                    extra = extra + tech.getTechName() + ":";
                }
                return "NODE: " + extra + theNode.describe(true);
            }
            if (eObj instanceof ArcInst) {
                ArcInst theArc = (ArcInst)eObj;
                Netlist netlist = theArc.getParent().getNetlist();
                if (netlist == null) {
                    return "netlist exception! try again";
                }
                if (!theArc.isLinked()) {
                    return "netlist exception! try again. ArcIndex = -1";
                }
                Network net = netlist.getNetwork(theArc, 0);
                String netMsg = net != null ? "NETWORK: " + net.describe(true) + ", " : "";
                return netMsg + "ARC: " + theArc.describe(true);
            }
        } else if (h.isHighlightText()) {
            String descr = "TEXT: " + h.describe();
            if (h.getVarKey() == Export.EXPORT_NAME && h.getElectricObject() instanceof Export) {
                Export e = (Export)h.getElectricObject();
                descr = descr + this.addLayerInfo(e.getOriginalPort().getPortProto());
            }
            return descr;
        }
        return null;
    }

    public void finished() {
        if (!TopLevel.isMDIMode() && this.frame.getContent().getHighlighter() != null) {
            Highlighter.removeHighlightListener(this);
        }
        UserInterfaceMain.removeDatabaseChangeListener(this);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        this.redoStatusBar();
    }

    private class RestoreSelection
    implements ActionListener {
        private SavedSelection ss;

        public RestoreSelection(SavedSelection ss) {
            this.ss = ss;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Highlight h;
            Cell cell = null;
            Iterator<Highlight> i$ = this.ss.selection.iterator();
            while (i$.hasNext() && (cell = (h = i$.next()).getCell()) == null) {
            }
            if (cell == null) {
                return;
            }
            EditWindow win = EditWindow.findWindow(cell);
            if (win != null) {
                WindowFrame.showFrame(win.getWindowFrame());
            } else {
                WindowFrame wf = WindowFrame.createEditWindow(cell);
                win = (EditWindow)wf.getContent();
            }
            Highlighter highlighter = win.getHighlighter();
            highlighter.showHighlights(this.ss.selection);
            System.out.println("Restored selection: " + this.ss.selectionName);
        }
    }

    private class ClearAllSelections
    implements ActionListener {
        private ClearAllSelections() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            allSelections.clear();
            System.out.println("Selections cleared");
        }
    }

    private class SaveSelection
    implements ActionListener {
        private SaveSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditWindow win = EditWindow.needCurrent();
            if (win == null) {
                return;
            }
            SavedSelection ss = new SavedSelection();
            ss.selectionName = StatusBar.this.fieldSelected.getText();
            ss.selection = win.getHighlighter().getHighlights();
            if (ss.selection.size() == 0) {
                System.out.println("Nothing is selected.");
                return;
            }
            allSelections.add(ss);
            System.out.println("Selection saved");
        }
    }

    private static class SavedSelection {
        String selectionName;
        List<Highlight> selection;

        private SavedSelection() {
        }
    }
}

