/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.output.CellModelPrefs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ScanChainXML
extends HierarchyEnumerator.Visitor {
    private HashMap<Cell, JtagController> jtagControllers;
    private JtagController currentJtagController;
    private HashMap<Cell, Cell> cellsToFlatten;
    private HashMap<Cell, Set<TraceElement>> elements;
    private HashMap<String, String> dataNetMap;
    private HashMap<Starter, Starter> starters;
    private HashMap<Starter, String> duplicateStarters;
    private HashMap<String, String> startFromExport;
    private List<String> chipNames;
    private boolean uniqueEntityNames = true;
    private int currentChipName = 0;
    private String outputFile = null;
    private PrintWriter out;
    private File outFile = null;
    private boolean debugTracing = false;
    private boolean optimize = true;
    private String chipTDI = "TDI";
    private String chipTDO = "TDO";
    private boolean printIgnoredElements = true;
    private List<String> scanElementInstanceNames;
    private boolean generateScanDataNets = true;
    private HashMap<Cell, Integer> elementsFlatCount;
    private HashMap<Nodable, String> jtagControllerNames = new HashMap();

    public ScanChainXML() {
        this.cellsToFlatten = new HashMap();
        this.elements = new HashMap();
        this.dataNetMap = new HashMap();
        this.starters = new HashMap();
        this.duplicateStarters = new HashMap();
        this.startFromExport = new HashMap();
        this.jtagControllers = new HashMap();
        this.chipNames = new ArrayList<String>();
        this.out = new PrintWriter(System.out);
        this.scanElementInstanceNames = new ArrayList<String>();
        this.elementsFlatCount = new HashMap();
    }

    public void start(String libName, String cellName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Did not find library " + libName + " for starting chain analysis in cell " + cellName);
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Did not find cell " + cellName + " for starting chain analysis, in library " + libName);
            return;
        }
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this, Netlist.ShortResistors.ALL);
        for (String name : this.scanElementInstanceNames) {
            System.out.println("Warning: instance not found in hierarchy: " + name);
        }
        ArrayList<Starter> chains = new ArrayList<Starter>();
        Set<TraceElement> ents = this.elements.get(cell);
        Entity jtagControllerChain = null;
        for (TraceElement e : ents) {
            if (!(e instanceof Entity) || e.getInport() == null || !e.getInport().equals(this.chipTDI)) continue;
            jtagControllerChain = (Entity)e;
            break;
        }
        if (jtagControllerChain == null && this.startFromExport.keySet().size() == 0) {
            System.out.println("Unable to find JtagController chain that starts with export " + this.chipTDI + " and ends with export " + this.chipTDO + ". Aborting");
            return;
        }
        for (Starter s : this.starters.keySet()) {
            if (s.getCell() != cell) continue;
            chains.add(s);
        }
        ArrayList<JtagInstance> jtags = new ArrayList<JtagInstance>();
        TreeSet<Entity> entitiesUsed = new TreeSet<Entity>();
        if (jtagControllerChain != null) {
            List<VarContext> contexts = jtagControllerChain.getContextsOfJtagInstances();
            for (VarContext context : contexts) {
                Nodable no = context.getNodable();
                Cell jtagCell = (Cell)no.getProto();
                JtagController controller = this.jtagControllers.get(jtagCell);
                if (controller == null) {
                    controller = this.jtagControllers.get(jtagCell.contentsView());
                }
                if (controller == null) {
                    System.out.println("Unable to find jtag controller for " + context.getInstPath(".") + ", cell " + jtagCell.describe(false));
                    continue;
                }
                JtagInstance inst = new JtagInstance(context, controller, this.getNextChipName());
                jtags.add(inst);
            }
            for (Starter s : chains) {
                VarContext context = s.getContextOfFirstElement(VarContext.globalContext, this.jtagControllers);
                if (context == null) {
                    System.out.println("No context found for starter " + s.getKey());
                    continue;
                }
                String hier = context.getInstPath(".");
                boolean used = false;
                for (JtagInstance inst : jtags) {
                    if (!context.getInstPath(".").equals(inst.getContext().getInstPath("."))) continue;
                    for (Map.Entry<Starter, String> dup : this.duplicateStarters.entrySet()) {
                        Starter copy = dup.getKey();
                        String origChain = dup.getValue();
                        if (copy.getCell() != inst.controller.getCell() || !origChain.equals(s.getChain())) continue;
                        copy.copyContentsOf(s);
                        inst.addStarter(copy);
                    }
                    inst.addStarter(s);
                    entitiesUsed.addAll(s.getEntitiesUsed());
                    used = true;
                    break;
                }
                if (used) continue;
                System.out.println("Warning: starter " + s.getKey() + " not used by any jtag controllers");
            }
        }
        Collections.sort(chains);
        Set<TraceElement> topCellEntities = this.elements.get(cell);
        ArrayList<Starter> chainsFromExports = new ArrayList<Starter>();
        for (String export : this.startFromExport.keySet()) {
            if (jtagControllerChain == null) {
                jtagControllerChain = new Entity(cell, "TDI", "TDO", false, new ArrayList(), null);
            }
            String chainName = this.startFromExport.get(export);
            TraceElement chain2 = null;
            for (TraceElement e : topCellEntities) {
                if (e.getInport() == null || !e.getInport().equals(export)) continue;
                chain2 = e;
                break;
            }
            if (chain2 == null || !(chain2 instanceof Entity)) continue;
            Entity ent = (Entity)chain2;
            Starter starter = new Starter(ent.getCell(), ent.getOutport(), ent.getInstances(), chainName, 0, null, null);
            chainsFromExports.add(starter);
            chains.add(starter);
            entitiesUsed.addAll(starter.getEntitiesUsed());
        }
        if (chainsFromExports.size() != 0) {
            if (this.currentJtagController == null) {
                System.out.println("the jtag controller has not been defined yet");
                throw new IllegalStateException();
            }
            JtagInstance inst = new JtagInstance(VarContext.globalContext, this.currentJtagController, this.getNextChipName());
            for (Starter s : chainsFromExports) {
                inst.addStarter(s);
            }
            jtags.add(inst);
        }
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.println("\n<!--");
        this.out.println("    Document      : " + this.outputFile);
        this.out.println("    Author        : automatically generated by Electric");
        this.out.println("    Description   : none");
        this.out.println("-->\n");
        this.out.println();
        this.out.println("<!DOCTYPE ChainG SYSTEM \"file:ChainG.dtd\" [");
        if (this.generateScanDataNets) {
            for (Starter chain3 : chains) {
                if (chain3.getLength() == 0) continue;
                this.out.println("<!ENTITY " + chain3.getChain() + "_dataNets '");
                chain3.writeDataNets(this.out, new StringBuffer("  "), VarContext.globalContext, this.dataNetMap);
                this.out.println("'>");
            }
        }
        if (this.optimize) {
            this.optimize(chains);
        }
        for (Entity ent : entitiesUsed) {
            ent.writeDefinition(this.out);
        }
        this.out.println("]>");
        this.out.println();
        StringBuffer indent = new StringBuffer();
        this.out.println("<ChainG>");
        indent.append("\t");
        this.out.println(indent + "<system>");
        indent.append("\t");
        int totalFlatCount = 0;
        for (JtagInstance jtag : jtags) {
            List<Starter> starters = jtag.getStarters();
            if (starters == null || starters.size() == 0) {
                System.out.println("No chains defined as starting from jtag instance " + jtag.getHierName());
                continue;
            }
            System.out.println("Writing chains for jtag instance " + jtag.getHierName());
            Collections.sort(starters, new StarterByOpcodeCompare());
            String chipName = jtag.getChipName();
            int lengthIR = ((JtagInstance)jtag).controller.lengthIR;
            this.out.println(indent + "<chip name=\"" + chipName + "\" lengthIR=\"" + lengthIR + "\">");
            indent.append("\t");
            for (Starter chain4 : starters) {
                int length = chain4.getLength();
                totalFlatCount += length;
                System.out.println("Chain " + chain4.chain + " has length " + length);
                if (length == 0) continue;
                chain4.write(this.out, indent);
            }
            indent.setLength(indent.length() - 1);
            this.out.println(indent + "</chip>");
        }
        if (this.generateScanDataNets) {
            this.out.println(indent + "<scandatanets>");
            indent.append("\t");
            for (Starter chain5 : chains) {
                if (chain5.getLength() == 0) continue;
                this.out.println(indent + "<datachain name=\"" + chain5.getChain() + "\"> &" + chain5.getChain() + "_dataNets; </datachain>");
            }
            indent.setLength(indent.length() - 1);
            this.out.println(indent + "</scandatanets>");
        }
        indent.setLength(indent.length() - 1);
        this.out.println(indent + "</system>");
        indent.setLength(indent.length() - 1);
        this.out.println("</ChainG>");
        this.out.flush();
        if (this.outFile != null) {
            System.out.println("Wrote XML file to " + this.outFile.getAbsolutePath());
            this.out.flush();
            this.out.close();
        } else {
            System.out.println("Wrote XML file to console");
        }
        System.out.println("Total Flat Count by Summation of Chains: " + totalFlatCount);
        System.out.println("Total Flat Count by Hierarchy Enumeration: " + this.elementsFlatCount.get(cell));
        if (this.elementsFlatCount.get(cell) != totalFlatCount) {
            System.out.println("Mismatch, printing Hierarchy Enumerated count by cell:");
            this.printFlatCount(cell, 0, new HashMap<Cell, Cell>());
            System.out.println("Please Note that the count may mismatch if the boundary scan chain is counted twice by the XML");
        }
    }

    public void addScanChainElement(String libName, String cellName, String access, String clears, String inport, String outport) {
        this.addScanChainElementAllViews(this.getCell(libName, cellName), access, clears, inport, outport, false, "", "", null);
    }

    public void addScanChainElement(String libName, String cellName, String access, String clears, String inport, String outport, String dataport, String dataport2) {
        this.addScanChainElementAllViews(this.getCell(libName, cellName), access, clears, inport, outport, false, dataport, dataport2, null);
    }

    public void addPassThroughCell(String libName, String cellName, String inport, String outport) {
        this.addScanChainElementAllViews(this.getCell(libName, cellName), null, null, inport, outport, true, "", "", null);
    }

    public void addPassThroughCell(String libName, String cellName, String inport, String outport, String instanceName) {
        this.addScanChainElementAllViews(this.getCell(libName, cellName), null, null, inport, outport, true, "", "", instanceName);
        if (instanceName != null) {
            this.scanElementInstanceNames.add(instanceName);
        }
    }

    public void addCellToFlatten(String libName, String cellName) {
        Cell cell = this.getCell(libName, cellName);
        if (cell != null) {
            this.cellsToFlatten.put(cell, cell);
        }
        if ((cell = this.getCellOtherView(cell)) != null) {
            this.cellsToFlatten.put(cell, cell);
        }
    }

    public void setJtagController(String jtagLib, String jtagCellName, int lengthIR) {
        this.setJtagController(jtagLib, jtagCellName, lengthIR, "TDI", "TDOb");
    }

    public void setJtagController(String jtagLib, String jtagCellName, int lengthIR, String inport, String outport) {
        Cell cell = this.getCell(jtagLib, jtagCellName);
        this.currentJtagController = new JtagController(cell, inport, outport, false, lengthIR);
        this.addJtagControllerAllViews(cell, inport, outport, lengthIR);
    }

    public void setChipTDI(String TDIport) {
        this.chipTDI = TDIport;
    }

    public void setChipTDO(String TDOport) {
        this.chipTDO = TDOport;
    }

    public void addJtagPort(int opcode, String soutPortName, String sinPortName, String chainName) throws JobException {
        if (this.currentJtagController == null) {
            System.out.println("Can't add port " + soutPortName + " because the jtag controller has not been defined yet");
            throw new IllegalStateException();
        }
        this.addJtagPortStarterAllViews(this.currentJtagController.getCell(), sinPortName, soutPortName, chainName, opcode);
    }

    public void startFromExport(String exportName, String chainName) {
        this.startFromExport.put(exportName, chainName);
    }

    public void setChipName(String name) {
        this.chipNames.add(name);
    }

    public void setUniqueEntityNames(boolean unique) {
        this.uniqueEntityNames = unique;
    }

    public void generateScanDataNets(boolean generate) {
        this.generateScanDataNets = generate;
    }

    public void setPrintIgnoredInstances(boolean print) {
        this.printIgnoredElements = print;
    }

    private String getNextChipName() {
        String name;
        if (this.currentChipName >= this.chipNames.size()) {
            name = "dummy" + this.currentChipName;
            System.out.println("Warning: creating dummy chip name because not enough calls to setChipName() vs number of jtag controllers");
        } else {
            name = this.chipNames.get(this.currentChipName);
        }
        ++this.currentChipName;
        return name;
    }

    public void setOutput(String file) {
        this.outputFile = file;
        try {
            this.outFile = new File(this.outputFile);
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.outFile)));
        }
        catch (IOException e) {
            System.out.println(e.getMessage() + "\nWriting XML to console");
            this.outFile = null;
            this.outputFile = null;
        }
    }

    public void debugTracing() {
        this.debugTracing = true;
    }

    private void addScanChainElementAllViews(Cell cell, String access, String clears, String inport, String outport, boolean passThrough, String dataport, String dataport2, String instanceName) {
        if (cell == null) {
            return;
        }
        for (Cell otherCell : cell.getCellsInGroup()) {
            if (!otherCell.isSchematic() && otherCell.getView() != View.LAYOUT) continue;
            ScanChainElement e = new ScanChainElement(otherCell, access, clears, inport, outport, passThrough, dataport, dataport2, instanceName);
            this.add(e);
        }
    }

    private void addJtagPortStarterAllViews(Cell cell, String sinPortName, String soutPortName, String chainName, int opcode) {
        if (cell == null) {
            return;
        }
        for (Cell otherCell : cell.getCellsInGroup()) {
            if (!otherCell.isSchematic() && otherCell.getView() != View.LAYOUT) continue;
            Starter s = new Starter(otherCell, soutPortName, null, chainName, opcode, null, null);
            boolean add = true;
            for (Starter olds : this.starters.keySet()) {
                if (olds.getCell() != otherCell || !olds.getOutport().equals(soutPortName)) continue;
                this.duplicateStarters.put(s, olds.getChain());
                add = false;
            }
            if (!add) continue;
            this.starters.put(s, s);
            this.add(s);
            ScanChainElement e = new ScanChainElement(otherCell, "", "", sinPortName, null, true, "", "", null);
            this.add(e);
        }
    }

    private void addJtagControllerAllViews(Cell cell, String inport, String outport, int lengthIR) {
        if (cell == null) {
            return;
        }
        for (Cell otherCell : cell.getCellsInGroup()) {
            if (!otherCell.isSchematic() && otherCell.getView() != View.LAYOUT) continue;
            JtagController jtag = new JtagController(otherCell, inport, outport, false, lengthIR);
            this.jtagControllers.put(otherCell, jtag);
            this.add(jtag);
        }
    }

    private Cell getCellOtherView(Cell cell) {
        View otherView = null;
        if (cell.getView() == View.LAYOUT) {
            otherView = View.SCHEMATIC;
        }
        if (cell.isSchematic()) {
            otherView = View.LAYOUT;
        }
        if (cell.isIcon()) {
            otherView = View.LAYOUT;
        }
        Cell otherCell = cell.otherView(otherView);
        return otherCell;
    }

    private Cell getCell(String libName, String cellName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Warning: Did not find library " + libName + " for cell " + cellName);
            return null;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Warning: Did not find cell " + cellName + ", in library " + libName);
            return null;
        }
        if (cell.isIcon() && (cell = cell.otherView(View.SCHEMATIC)) == null) {
            System.out.println("Warning: Did not find cell schematic cell for " + cellName + "{ic}, in library " + libName);
            return null;
        }
        return cell;
    }

    private void add(TraceElement e) {
        Set<TraceElement> traceElements = this.elements.get(e.cell);
        if (traceElements == null) {
            traceElements = new TreeSet<TraceElement>();
            this.elements.put(e.getCell(), traceElements);
        }
        for (TraceElement ele : traceElements) {
            if (ele.getClass() != e.getClass() || ele.getCell() != e.getCell()) continue;
            boolean namesSame = false;
            if (ele.getInstanceName() != null && e.getInstanceName() != null && ele.getInstanceName().equals(e.getInstanceName())) {
                namesSame = true;
            }
            if (ele.getInstanceName() == null && e.getInstanceName() == null) {
                namesSame = true;
            }
            if (!namesSame) continue;
            boolean inportsSame = false;
            if (ele.inport == e.inport) {
                inportsSame = true;
            }
            if (ele.inport != null && e.inport != null && ele.inport.equals(e.inport)) {
                inportsSame = true;
            }
            if (!inportsSame) continue;
            boolean outportsSame = false;
            if (ele.outport == e.outport) {
                inportsSame = true;
            }
            if (ele.outport != null && e.outport != null && ele.outport.equals(e.outport)) {
                outportsSame = true;
            }
            if (!inportsSame || !outportsSame) continue;
            System.out.println("Warning, already cell " + e.cell.describe(false) + ", inport " + e.inport + " already added");
            return;
        }
        traceElements.add(e);
    }

    @Override
    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        Set<TraceElement> traceElements = this.elements.get(cell);
        if (traceElements == null) {
            return true;
        }
        boolean scanChainElement = false;
        for (TraceElement e : traceElements) {
            if (!(e instanceof ScanChainElement)) continue;
            ScanChainElement sc = (ScanChainElement)e;
            for (DataNet datanet : sc.getDataNets()) {
                this.mapDataNet(info, datanet);
            }
            scanChainElement = true;
        }
        return !scanChainElement;
    }

    private void mapDataNet(HierarchyEnumerator.CellInfo info, DataNet dataNet) {
        if (dataNet == null) {
            return;
        }
        Network net = ScanChainXML.getNetwork(info.getNetlist(), dataNet.getName());
        String flatContext = "";
        String netName = dataNet.getName();
        if (net != null) {
            HierarchyEnumerator.NetDescription desc = info.netIdToNetDescription(info.getNetID(net));
            netName = desc.getNet().getName();
            flatContext = desc.getCellInfo().getContext().getInstPath(".x");
        }
        if (net == null) {
            VarContext netContext = info.getContext();
            String name = dataNet.getName();
            Cell cell = info.getCell();
            if (name.contains(".")) {
                String[] hier = name.split("\\.");
                for (int i = 0; i < hier.length - 1; ++i) {
                    String instName = hier[i];
                    Iterator<Nodable> nit = cell.getNodables();
                    while (nit.hasNext()) {
                        Nodable no = nit.next();
                        if (!no.getName().equals(instName) || !no.isCellInstance()) continue;
                        Cell proto = (Cell)no.getProto();
                        cell = proto.getEquivalent();
                        if (cell == null) {
                            cell = proto;
                        }
                        netContext = netContext.push(no);
                    }
                }
                net = ScanChainXML.getNetwork(cell.getNetlist(), hier[hier.length - 1]);
                flatContext = netContext.getInstPath(".x");
                netName = hier[hier.length - 1];
            }
        }
        if (net == null) {
            System.out.println("Error: Cannot find data net " + dataNet.getName() + " in cell " + info.getCell() + ", please check dataNet spec for this cell");
            return;
        }
        String contextualName = ScanChainElement.getDataNetPath(dataNet, info.getContext());
        flatContext = flatContext != null && !flatContext.equals("") ? "x" + flatContext + "." : "";
        netName = netName.replace('.', '_');
        String flatName = flatContext + netName;
        this.dataNetMap.put(contextualName, flatName);
    }

    @Override
    public void exitCell(HierarchyEnumerator.CellInfo info) {
        Set<TraceElement> processedElements = this.elements.get(info.getCell());
        if (processedElements != null) {
            boolean foundinst = false;
            for (TraceElement e : processedElements) {
                if (e.getInstanceName() == null) continue;
                foundinst = true;
                break;
            }
            if (!foundinst) {
                return;
            }
        }
        String currentHier = info.getContext().getInstPath(".");
        if (this.debugTracing) {
            System.out.println("---------------------------");
        }
        if (this.debugTracing) {
            System.out.println("Tracing cell " + info.getCell().describe(false) + " " + currentHier);
        }
        HashMap<String, Instance> instancesByInput = new HashMap<String, Instance>();
        HashMap<String, Instance> instancesByOutput = new HashMap<String, Instance>();
        ArrayList<Instance> instancesWithNoInput = new ArrayList<Instance>();
        boolean instanceElementPresent = false;
        int flatCount = 0;
        Iterator<NodeInst> it = info.getCell().getNodes();
        while (it.hasNext()) {
            Set<TraceElement> traceElements;
            Cell laycell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            Cell subcell = (Cell)ni.getProto();
            Cell contents = subcell.contentsView();
            if (contents != null) {
                subcell = contents;
            }
            if (info.getCell().isSchematic() && this.enumerateLayoutView(subcell) && (laycell = subcell.otherView(View.LAYOUT)) != null) {
                subcell = laycell;
            }
            if ((traceElements = this.elements.get(subcell)) == null) continue;
            boolean instOk = false;
            for (TraceElement e : traceElements) {
                ScanChainElement sc;
                if (ni.getNameKey().busWidth() > 1 && !(e instanceof ScanChainElement)) {
                    for (int i = 0; i < ni.getNameKey().busWidth(); ++i) {
                        Nodable no = Netlist.getNodableFor(ni, i);
                        instOk = this.createInstance(no, info, instancesByInput, instancesByOutput, instancesWithNoInput, e);
                    }
                    continue;
                }
                String instanceName = info.getContext().push(ni).getInstPath(".");
                if (e.getInstanceName() != null) {
                    if (e.getInstanceName().equals(instanceName)) {
                        instOk = this.createInstance(ni, info, instancesByInput, instancesByOutput, instancesWithNoInput, e);
                        this.scanElementInstanceNames.remove(instanceName);
                    }
                    instanceElementPresent = true;
                } else {
                    instOk = this.createInstance(ni, info, instancesByInput, instancesByOutput, instancesWithNoInput, e);
                }
                if (!(e instanceof ScanChainElement) || (sc = (ScanChainElement)e).isPassThrough() || !instOk) continue;
                flatCount += ni.getNameKey().busWidth();
            }
            Integer ii = this.elementsFlatCount.get(subcell);
            if (ii == null) continue;
            flatCount += ii * ni.getNameKey().busWidth();
        }
        this.elementsFlatCount.put(info.getCell(), new Integer(flatCount));
        for (Instance inst : instancesByInput.values()) {
            if (inst.prev != null) continue;
            instancesWithNoInput.add(inst);
        }
        Set<TraceElement> traceElements = this.elements.get(info.getCell());
        if (traceElements == null) {
            traceElements = new TreeSet<TraceElement>();
            this.elements.put(info.getCell(), traceElements);
        }
        String entName = null;
        if (instanceElementPresent) {
            entName = info.getContext().getInstPath(".");
        }
        int startercount = 0;
        Iterator i$ = instancesWithNoInput.iterator();
        while (i$.hasNext()) {
            String outnet;
            Entity ent;
            Instance inst;
            Instance last2 = inst = (Instance)i$.next();
            ArrayList<Instance> instances = new ArrayList<Instance>();
            instances.add(last2);
            while (last2.next != null) {
                last2 = last2.next;
                instances.add(last2);
            }
            String inex = null;
            if (inst.innet != null && inst.innet.isExported() && inst.innet.getExports().hasNext()) {
                inex = inst.innet.getName();
            }
            String outex = null;
            if (last2.outnet != null && last2.outnet.isExported() && last2.outnet.getExports().hasNext()) {
                outex = last2.outnet.getName();
            }
            String entity = "Entity";
            if (this.starters.containsKey(inst.e) && inst.e instanceof Starter) {
                entName = info.getContext().getInstPath(".");
                Starter oldStart = (Starter)inst.e;
                ent = new Starter(info.getCell(), outex, instances, oldStart.chain, oldStart.opcode, oldStart, entName);
                this.starters.put((Starter)ent, (Starter)ent);
                ++startercount;
                entity = "Starter";
                if (outex == null && last2.e.outport != null) {
                    String string2 = outnet = last2.outnet == null ? null : last2.outnet.getName();
                    if (inst.e.isPassThrough()) {
                        if (!this.printIgnoredElements) continue;
                        System.out.println("Warning: pass-through instance " + last2.no.getName() + " in cell " + info.getCell().describe(false) + " has nothing connected to its output port " + last2.e.outport + "(" + outnet + ")");
                        continue;
                    }
                    System.out.println("Error: instance " + last2.no.getName() + " in cell " + info.getCell().describe(false) + " has nothing connected to its output port " + last2.e.outport + "(" + outnet + ")");
                    continue;
                }
            } else {
                String innet;
                boolean passThrough = true;
                for (Instance entinst : instances) {
                    if (entinst.getTraceElement().isPassThrough()) continue;
                    passThrough = false;
                    break;
                }
                if (inex == null && inst.getTraceElement().getInport() != null && outex == null && last2.getTraceElement().getOutport() != null && passThrough) {
                    String outnet2;
                    innet = inst.innet == null ? null : inst.innet.getName();
                    String string3 = outnet2 = last2.outnet == null ? null : last2.outnet.getName();
                    if (!this.printIgnoredElements) continue;
                    System.out.println("Warning: Ignoring pass-through chain with both networks exported: " + info.getCell().describe(false) + " from input net \"" + innet + "\" to output net \"" + outnet2 + "\"");
                    continue;
                }
                if (inex == null && inst.e.inport != null) {
                    String string4 = innet = inst.innet == null ? null : inst.innet.getName();
                    if (passThrough) {
                        if (!this.printIgnoredElements) continue;
                        System.out.println("Warning: Ignoring pass-through instance with unconnected input port: " + inst.no.getName() + " in cell " + info.getCell().describe(false) + ", inport " + inst.e.inport + "(" + innet + ")");
                        continue;
                    }
                    System.out.println("Error: instance " + inst.no.getName() + " in cell " + info.getCell().describe(false) + " has nothing connected to its input port " + inst.e.inport + "(" + innet + ")");
                    continue;
                }
                if (outex == null && last2.e.outport != null) {
                    String string5 = outnet = last2.outnet == null ? null : last2.outnet.getName();
                    if (passThrough) {
                        if (!this.printIgnoredElements) continue;
                        System.out.println("Warning: Ignoring pass-through instance with unconnected output port: " + last2.no.getName() + " in cell " + info.getCell().describe(false) + ", outport " + last2.e.outport + "(" + outnet + ")");
                        continue;
                    }
                    System.out.println("Error: instance " + last2.no.getName() + " in cell " + info.getCell().describe(false) + " has nothing connected to its output port " + last2.e.outport + "(" + outnet + ")");
                    continue;
                }
                ent = new Entity(info.getCell(), inex, outex, passThrough, instances, entName);
            }
            if (this.debugTracing) {
                System.out.println("Creating " + entity + " for cell " + info.getCell().describe(false) + ", in=" + inex + ", out=" + outex + ", key=" + ent.getKey());
            }
            traceElements.add(ent);
        }
    }

    private boolean createInstance(Nodable ni, HierarchyEnumerator.CellInfo info, HashMap<String, Instance> instancesByInput, HashMap<String, Instance> instancesByOutput, List<Instance> instancesWithNoInput, TraceElement e) {
        Network innet;
        Instance inst = new Instance(ni, info.getContext(), ni.getNameKey().busWidth(), e);
        Nodable inno = ni;
        Nodable outno = ni;
        if (ni instanceof NodeInst && ni.getNameKey().busWidth() > 1) {
            NodeInst nin = (NodeInst)ni;
            inno = Netlist.getNodableFor(nin, 0);
            outno = Netlist.getNodableFor(nin, nin.getNameKey().busWidth() - 1);
        }
        Network globalGnd = info.getNetlist().getNetwork(Global.ground);
        if (e.inport != null) {
            innet = ScanChainXML.getNetwork(inno, info.getNetlist(), e.inport);
            Instance prev = null;
            if (innet != null) {
                Instance branch;
                prev = instancesByOutput.get(innet.getName());
                if (innet == globalGnd) {
                    if (this.printIgnoredElements) {
                        System.out.println("Warning: Ignoring instance with grounded sin: " + inst.getName() + " in cell " + info.getCell().describe(false));
                    }
                    return false;
                }
                if (prev != null) {
                    inst.prev = prev;
                    prev.next = inst;
                    if (this.debugTracing) {
                        System.out.println("  Chaining " + prev.describeOutnet() + " -> " + inst.describeInnet());
                    }
                }
                if ((branch = instancesByInput.get(innet.getName())) != null) {
                    if (prev != null) {
                        System.out.println("Error! Chain branches from: " + prev.describeOutput());
                    } else {
                        System.out.println("Error! Chain branches from net " + innet.getName() + " in cell " + ni.getParent().describe(false));
                    }
                    System.out.println("       into: " + inst.describeInput() + " (key=" + inst.getTraceElement().getKey() + ")");
                    System.out.println("       into: " + branch.describeInput() + " (key=" + branch.getTraceElement().getKey() + ")");
                }
                inst.innet = innet;
                instancesByInput.put(innet.getName(), inst);
            } else {
                System.out.println("Error: Can't find input network for port " + e.getInport() + " on element " + e.getCell().describe(false));
            }
        } else {
            instancesWithNoInput.add(inst);
        }
        if (e.outport != null) {
            Network outnet = ScanChainXML.getNetwork(outno, info.getNetlist(), e.outport);
            Instance next2 = null;
            if (outnet != null) {
                Instance merge;
                next2 = instancesByInput.get(outnet.getName());
                if (next2 != null) {
                    inst.next = next2;
                    next2.prev = inst;
                    if (this.debugTracing) {
                        System.out.println("  Chaining " + inst.describeOutnet() + " -> " + next2.describeInnet());
                    }
                }
                if ((merge = instancesByOutput.get(outnet.getName())) != null) {
                    if (next2 != null) {
                        System.out.println("Error! Chain merges into " + next2.describeInput());
                    } else {
                        System.out.println("Error! Chain merges into net " + outnet.getName() + " in cell " + ni.getParent().describe(false));
                    }
                    System.out.println("       from: " + inst.describeOutput() + " (key=" + inst.getTraceElement().getKey() + ")");
                    System.out.println("       from: " + merge.describeOutput() + " (key=" + merge.getTraceElement().getKey() + ")");
                }
                inst.outnet = outnet;
                instancesByOutput.put(outnet.getName(), inst);
            } else {
                System.out.println("Error: Can't find output network for port " + e.getOutport() + " on element " + e.getCell().describe(false));
            }
        }
        if (this.debugTracing) {
            innet = inst.innet == null ? null : inst.innet.getName();
            String outnet = inst.outnet == null ? null : inst.outnet.getName();
            System.out.println("  Created instance " + inst.no.getName() + " in=" + e.inport + "(" + (String)((Object)innet) + ")" + " out=" + e.outport + "(" + outnet + ") for element " + e.getKey());
        }
        return true;
    }

    @Override
    public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
        if (ni.isCellInstance()) {
            Cell layCell;
            Cell cell = (Cell)ni.getProto();
            Cell schcell = cell.contentsView();
            if (schcell == null) {
                schcell = cell;
            }
            if (cell.isSchematic() && this.enumerateLayoutView(schcell) && (layCell = schcell.otherView(View.LAYOUT)) != null) {
                HierarchyEnumerator.enumerateCell(layCell, info.getContext().push(ni), (HierarchyEnumerator.Visitor)this);
                return false;
            }
        }
        return true;
    }

    private boolean enumerateLayoutView(Cell cell) {
        return CellModelPrefs.spiceModelPrefs.isUseLayoutView(cell);
    }

    private void checkBadFanout(Instance prev, Instance next1, Instance next2) {
        if (next1 == null || next2 == null) {
            return;
        }
        if (prev == null) {
            return;
        }
        System.out.println("Error! Chain branches from: " + prev.describeOutput());
        System.out.println("       into: " + next1.describeInput());
        System.out.println("       into: " + next2.describeInput());
    }

    private void checkBadFanin(Instance prev1, Instance prev2, Instance next2) {
        if (prev1 == null || prev2 == null) {
            return;
        }
        if (next2 == null) {
            return;
        }
        System.out.println("Error! Chain merges into " + next2.describeInput());
        System.out.println("       from: " + prev1.describeOutput());
        System.out.println("       from: " + prev2.describeOutput());
    }

    private void setJtagControllerName(Nodable no, String name) {
        this.jtagControllerNames.put(no, name);
    }

    private String getJtagControllerName(Nodable no) {
        return this.jtagControllerNames.get(no);
    }

    private void printFlatCount(Cell cell, int indent, Map<Cell, Cell> alreadyPrinted) {
        if (this.elementsFlatCount.get(cell) == null) {
            return;
        }
        if (this.elementsFlatCount.get(cell) == 0) {
            return;
        }
        if (alreadyPrinted.containsKey(cell)) {
            return;
        }
        alreadyPrinted.put(cell, cell);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buf.append(" ");
        }
        System.out.println(buf + cell.describe(false) + ": " + this.elementsFlatCount.get(cell));
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Cell laycell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            Cell c = (Cell)ni.getProto();
            Cell contents = c.contentsView();
            if (contents != null) {
                c = contents;
            }
            if (cell.isSchematic() && this.enumerateLayoutView(c) && (laycell = c.otherView(View.LAYOUT)) != null) {
                c = laycell;
            }
            this.printFlatCount(c, indent + 2, alreadyPrinted);
        }
    }

    private void optimize(List<Starter> chains) {
        int done = 1;
        done = 0;
        done += this.flatten(chains);
        done += this.combineInstances();
    }

    private int flatten(List<Starter> chains) {
        int done = 0;
        HashMap<Entity, Cell> alreadyFlattened = new HashMap<Entity, Cell>();
        for (Starter chain2 : chains) {
            done += chain2.flattenInstances(this.cellsToFlatten, alreadyFlattened);
        }
        return done;
    }

    private int combineInstances() {
        int done = 0;
        for (Set<TraceElement> list2 : this.elements.values()) {
            for (TraceElement e : list2) {
                if (!(e instanceof Entity)) continue;
                Entity ent = (Entity)e;
                done += ent.combineInstances();
            }
        }
        return done;
    }

    private static Network getNetwork(Nodable no, Netlist netlist, String portName) {
        Iterator<PortProto> it = no.getProto().getPorts();
        while (it.hasNext()) {
            PortProto pp = it.next();
            Name name = pp.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                Name subname = name.subname(i);
                if (!subname.toString().equals(portName)) continue;
                return netlist.getNetwork(no, pp, i);
            }
        }
        System.out.println("Error: Could not find port " + portName + " on " + no.getProto().describe(false) + "(" + no.getName() + ") in cell " + no.getParent().describe(false));
        return null;
    }

    private static Network getNetwork(Netlist netlist, String name) {
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.hasName(name)) continue;
            return net;
        }
        return null;
    }

    private static Port getPort(Nodable no, String portName) {
        if (portName == null) {
            return null;
        }
        Iterator<PortProto> it = no.getProto().getPorts();
        while (it.hasNext()) {
            PortProto pp = it.next();
            Name name = pp.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                Name subname = name.subname(i);
                if (!subname.toString().equals(portName)) continue;
                return new Port(subname, no, pp, i);
            }
        }
        System.out.println("Could not find " + portName + " on " + no.getName());
        return null;
    }

    private static ExPort getExPort(Cell cell, String exportName) {
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export ex = (Export)it.next();
            Name name = ex.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                Name subname = name.subname(i);
                if (!subname.toString().equals(exportName)) continue;
                return new ExPort(subname, ex, i);
            }
        }
        return null;
    }

    private static class ExPort {
        private Export ex;
        private int index;
        private Name name;

        private ExPort(Name name, Export ex, int index) {
            this.name = name;
            this.ex = ex;
            this.index = index;
        }

        public String toString() {
            if (this.name == null) {
                return null;
            }
            return this.name.toString();
        }

        public void print() {
            System.out.println("  Name: " + this.name);
            System.out.println("  Ex: " + this.ex);
            System.out.println("  int: " + this.index);
        }
    }

    private static class Port {
        private PortProto pp;
        private int index;
        private Name name;
        private Nodable no;

        private Port(Name name, Nodable no, PortProto pp, int index) {
            this.name = name;
            this.no = no;
            this.pp = pp;
            this.index = index;
        }

        public String toString() {
            if (this.name == null) {
                return null;
            }
            return this.no.getName() + ":" + this.name.toString();
        }

        public void print() {
            System.out.println("  Name: " + this.name);
            System.out.println("  No: " + this.no);
            System.out.println("  int: " + this.index);
            System.out.println("  pp: " + this.pp);
        }
    }

    private static class ArrayedNameList {
        private List<ArrayedName> arrayedNames;

        public ArrayedNameList(String name) {
            this.arrayedNames = new ArrayList<ArrayedName>();
            ArrayList<String> names = new ArrayList<String>();
            int openBrackets = 0;
            int last2 = 0;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '[') {
                    ++openBrackets;
                }
                if (c == ']') {
                    --openBrackets;
                }
                if (c != ',' || openBrackets != 0) continue;
                int start = last2;
                if (start >= 0 && i > start) {
                    names.add(name.substring(start, i));
                }
                last2 = i + 1;
            }
            if (openBrackets == 0 && last2 < name.length()) {
                names.add(name.substring(last2, name.length()));
            }
            for (String s : names) {
                this.arrayedNames.add(new ArrayedName(s));
            }
        }

        private ArrayedNameList(List<ArrayedName> arrayedNames) {
            this.arrayedNames = arrayedNames;
        }

        public int getNumNames() {
            return this.arrayedNames.size();
        }

        public ArrayedName get(int index) {
            if (index < 0 || index > this.getNumNames() - 1) {
                return null;
            }
            return this.arrayedNames.get(index);
        }

        public int numDimensions() {
            int maxDimension = 0;
            for (int i = 0; i < this.getNumNames(); ++i) {
                int m = this.get(i).numDimensions();
                if (m <= maxDimension) continue;
                maxDimension = m;
            }
            return maxDimension;
        }

        public ArrayedNameList combineSequentialNumeric(ArrayedNameList next2, int dimension) {
            ArrayedName combined;
            ArrayedName thisLast = this.get(this.getNumNames() - 1);
            ArrayedName nextFirst = next2.get(0);
            if (thisLast != null && nextFirst != null && (combined = thisLast.combineSequentialNumeric(nextFirst, dimension)) != null) {
                int i;
                ArrayList<ArrayedName> newList = new ArrayList<ArrayedName>();
                for (i = 0; i < this.getNumNames() - 1; ++i) {
                    newList.add(this.get(i));
                }
                newList.add(combined);
                for (i = 1; i < next2.getNumNames(); ++i) {
                    newList.add(next2.get(i));
                }
                return new ArrayedNameList(newList);
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.getNumNames(); ++i) {
                ArrayedName name = this.get(i);
                buf.append(name.toString());
                if (i >= this.getNumNames() - 1) continue;
                buf.append(',');
            }
            return buf.toString();
        }

        public static void main(String[] args) {
            ArrayedNameList n1 = new ArrayedNameList("foo[1],foo[2]");
            ArrayedNameList n2 = new ArrayedNameList("foo[3],foo[4]");
            ArrayedNameList.printTest(n1, n2, 0);
            ArrayedNameList.printTest(n1, n2, 1);
            n1 = new ArrayedNameList("foo[1,a],bar[2:4]");
            n2 = new ArrayedNameList("bar[5],xxx[2]");
            ArrayedNameList.printTest(n1, n2, 0);
            ArrayedNameList.printTest(n1, n2, 1);
            n1 = new ArrayedNameList("foo[1,a],bar[3:5][2:4]");
            n2 = new ArrayedNameList("bar[6][2:4],xxx[2]");
            ArrayedNameList.printTest(n1, n2, 0);
            ArrayedNameList.printTest(n1, n2, 1);
        }

        public static void printTest(ArrayedNameList n1, ArrayedNameList n2, int dim) {
            System.out.println("Combining dimension " + dim + " of: " + n1 + " and " + n2 + " --> " + n1.combineSequentialNumeric(n2, dim));
        }
    }

    private static class ArrayedName {
        private String name;
        private List<ArrayIndex> indices;

        public ArrayedName(String arrayedName) {
            this.indices = new ArrayList<ArrayIndex>();
            String[] parts = arrayedName.trim().split("[\\[\\]]");
            for (int i = 0; i < parts.length; ++i) {
                if (i == 0) {
                    if (parts[0].equals("")) {
                        System.out.println("Invalid name for " + arrayedName);
                    }
                    this.name = parts[0];
                    continue;
                }
                String str = parts[i].trim();
                if (str.equals("")) continue;
                ArrayIndex index = new ArrayIndex(parts[i]);
                this.indices.add(index);
            }
            Collections.reverse(this.indices);
        }

        public ArrayedName(String name, List<ArrayIndex> indices) {
            this.name = name;
            this.indices = indices;
        }

        public String getName() {
            return this.name;
        }

        public int numDimensions() {
            return this.indices.size();
        }

        public ArrayIndex getIndex(int i) {
            if (i < 0 || i > this.indices.size() - 1) {
                return null;
            }
            return this.indices.get(i);
        }

        public ArrayedName combineSequentialNumeric(ArrayedName next2, int dimension) {
            ArrayIndex index = this.getIndex(dimension);
            if (index == null) {
                return null;
            }
            if (!index.isNumericOnly()) {
                return null;
            }
            if (!this.name.equals(next2.getName())) {
                return null;
            }
            if (this.numDimensions() != next2.numDimensions()) {
                return null;
            }
            for (int i = 0; i < this.numDimensions(); ++i) {
                ArrayIndex nexti;
                ArrayIndex curi;
                if (i == dimension || (curi = this.getIndex(i)).equals(nexti = next2.getIndex(i))) continue;
                return null;
            }
            ArrayIndex nextIndex = next2.getIndex(dimension);
            ArrayIndex combined = index.combineSequentialNumeric(nextIndex);
            if (combined == null) {
                return null;
            }
            ArrayList<ArrayIndex> newIndices = new ArrayList<ArrayIndex>();
            for (int i = 0; i < this.numDimensions(); ++i) {
                if (i == dimension) {
                    newIndices.add(combined);
                    continue;
                }
                newIndices.add(this.getIndex(i));
            }
            return new ArrayedName(this.getName(), newIndices);
        }

        public String toString() {
            StringBuffer str = new StringBuffer(this.name);
            for (int i = this.indices.size() - 1; i >= 0; --i) {
                ArrayIndex ind = this.getIndex(i);
                str.append("[");
                str.append(ind.toString());
                str.append("]");
            }
            return str.toString();
        }

        public static void main(String[] args) {
            ArrayedName n1 = new ArrayedName("foo[1]");
            ArrayedName n2 = new ArrayedName("foo[2]");
            ArrayedName.printTest(n1, n2, 0);
            ArrayedName.printTest(n1, n2, 1);
            n1 = new ArrayedName("foo[1:2][5:4][1:2]");
            n2 = new ArrayedName("foo[1:2][3:1][1:2]");
            ArrayedName.printTest(n1, n2, 1);
            ArrayedName.printTest(n1, n2, 2);
        }

        public static void printTest(ArrayedName n1, ArrayedName n2, int dim) {
            System.out.println("Combining dimension " + dim + " of: " + n1 + " and " + n2 + " --> " + n1.combineSequentialNumeric(n2, dim));
        }
    }

    private static class ArrayIndex {
        private List<Object> indices;
        boolean numericOnly;

        public ArrayIndex(String indices) {
            this.indices = new ArrayList<Object>();
            this.numericOnly = true;
            String[] parts = indices.split(",");
            for (int i = 0; i < parts.length; ++i) {
                this.addBlock(parts[i]);
            }
        }

        public ArrayIndex(List<Object> indices) {
            this.numericOnly = true;
            this.indices = indices;
            for (int i = 0; i < indices.size(); ++i) {
                if (indices.get(i) instanceof Range) continue;
                this.numericOnly = false;
            }
        }

        private void addBlock(String block) {
            if ((block = block.trim()).matches("\\d+")) {
                int start = Integer.parseInt(block);
                this.indices.add(new Range(start, start));
            } else if (block.matches("\\d+:\\d+")) {
                String[] range2 = block.split(":");
                int start = Integer.parseInt(range2[0]);
                int end = Integer.parseInt(range2[1]);
                this.indices.add(new Range(start, end));
            } else if (block.matches("\\w+")) {
                this.indices.add(block);
            } else {
                System.out.println("Invalid array index " + block);
            }
        }

        public boolean isNumericOnly() {
            return this.numericOnly;
        }

        public boolean equals(Object o) {
            ArrayIndex a = (ArrayIndex)o;
            if (this.getNumIndices() != a.getNumIndices()) {
                return false;
            }
            for (int i = 0; i < this.indices.size(); ++i) {
                Object index = a.indices.get(i);
                if (this.indices.get(i).equals(index)) continue;
                return false;
            }
            return true;
        }

        public int getNumIndices() {
            return this.indices.size();
        }

        public Object getIndex(int index) {
            if (index < 0 || index > this.indices.size() - 1) {
                return null;
            }
            return this.indices.get(index);
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            Iterator<Object> it = this.indices.iterator();
            while (it.hasNext()) {
                Object next2 = it.next();
                if (next2 instanceof String) {
                    str.append((String)next2);
                }
                if (next2 instanceof Range) {
                    str.append(((Range)next2).toString());
                }
                if (!it.hasNext()) continue;
                str.append(",");
            }
            return str.toString();
        }

        public ArrayIndex combineSequentialNumeric(ArrayIndex next2) {
            if (!this.isNumericOnly()) {
                return null;
            }
            if (!next2.isNumericOnly()) {
                return null;
            }
            Object thisLastObj = this.getIndex(this.getNumIndices() - 1);
            Object otherFirstObj = next2.getIndex(0);
            if (!(thisLastObj instanceof Range) || !(otherFirstObj instanceof Range)) {
                return null;
            }
            Range thisLast = (Range)thisLastObj;
            Range otherFirst = (Range)otherFirstObj;
            if (thisLast == null || otherFirst == null) {
                return null;
            }
            Range newRange = thisLast.combine(otherFirst);
            if (newRange == null) {
                return null;
            }
            ArrayList<Object> indices = new ArrayList<Object>(this.indices);
            indices.remove(this.getNumIndices() - 1);
            indices.add(newRange);
            return new ArrayIndex(indices);
        }
    }

    private static class Range {
        private int start;
        private int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getRange() {
            return Math.abs(this.end - this.start);
        }

        public boolean isAscending(boolean includeSingular) {
            if (this.start < this.end) {
                return true;
            }
            if (this.start == this.end) {
                return includeSingular;
            }
            return false;
        }

        public boolean isDescending(boolean includeSingular) {
            if (this.start > this.end) {
                return true;
            }
            if (this.start == this.end) {
                return includeSingular;
            }
            return false;
        }

        public boolean equals(Object o) {
            Range r = (Range)o;
            return this.getStart() == r.getStart() && this.getEnd() == r.getEnd();
        }

        public String toString() {
            if (this.start == this.end) {
                return String.valueOf(this.start);
            }
            return this.start + ":" + this.end;
        }

        public Range combine(Range next2) {
            int diff2 = Math.abs(this.getEnd() - next2.getStart());
            if (diff2 != 1) {
                return null;
            }
            if (this.isAscending(true) && next2.isAscending(true)) {
                return new Range(this.getStart(), next2.getEnd());
            }
            if (this.isDescending(true) && next2.isDescending(true)) {
                return new Range(this.getStart(), next2.getEnd());
            }
            return null;
        }
    }

    private static class JtagInstance {
        private final JtagController controller;
        private String chipName;
        private VarContext context;
        private List<Starter> starters;

        private JtagInstance(VarContext context, JtagController controller, String chipName) {
            this.context = context;
            this.controller = controller;
            this.chipName = chipName;
            this.starters = new ArrayList<Starter>();
        }

        public String getHierName() {
            return this.context.getInstPath(".");
        }

        public String getChipName() {
            return this.chipName;
        }

        public VarContext getContext() {
            return this.context;
        }

        public void addStarter(Starter s) {
            this.starters.add(s);
            s.setChipName(this.chipName);
        }

        public List<Starter> getStarters() {
            return this.starters;
        }
    }

    private static class JtagController
    extends TraceElement {
        public final int lengthIR;

        private JtagController(Cell cell, String inport, String outport, boolean passThrough, int lengthIR) {
            super(cell, inport, outport, passThrough, null);
            this.lengthIR = lengthIR;
        }

        public int getLengthIR() {
            return this.lengthIR;
        }
    }

    private class Instance {
        private final Nodable no;
        private final VarContext context;
        private final int length;
        private final TraceElement e;
        private Instance prev;
        private Instance next;
        private Network innet;
        private Network outnet;
        private String nameOverride;

        private Instance(Nodable no, VarContext context, int length, TraceElement e) {
            this.no = no;
            this.context = context;
            this.length = length;
            this.e = e;
            this.prev = null;
            this.next = null;
            this.innet = null;
            this.outnet = null;
            this.nameOverride = null;
        }

        public String describeOutput() {
            return this.no.getParent().getName() + "." + this.no.getName() + "." + this.e.outport;
        }

        public String describeInput() {
            return this.no.getParent().getName() + "." + this.no.getName() + "." + this.e.inport;
        }

        public String describeOutnet() {
            return this.no.getName() + "[" + this.e.outport + "(" + this.outnet + ")]";
        }

        public String describeInnet() {
            return this.no.getName() + "[" + this.e.inport + "(" + this.innet + ")]";
        }

        public void write(PrintWriter out, StringBuffer indent, List<String> usedNames) {
            String name = this.getName();
            if (ScanChainXML.this.uniqueEntityNames && usedNames.contains(name) && this.e.inport != null) {
                name = name + "_" + this.e.inport;
            }
            if (this.e instanceof Entity) {
                Entity ent = (Entity)this.e;
                if (ent.getLength() == 0) {
                    return;
                }
                out.println(indent + "<subchain name=\"" + name + "\"> &" + this.e.getKey() + "; </subchain>");
                usedNames.add(name);
            } else {
                ScanChainElement ele = (ScanChainElement)this.e;
                if (ele.isPassThrough()) {
                    return;
                }
                out.print(indent + "<subchain name=\"" + name + "\"");
                out.print(" length=\"" + this.length + "\"");
                if (ele.access != null) {
                    out.print(" access=\"" + ele.access + "\"");
                }
                if (ele.clears != null) {
                    out.print(" clears=\"" + ele.clears + "\"");
                }
                out.println(" />");
            }
        }

        public void writeDataNets(PrintWriter out, StringBuffer indent, VarContext context, HashMap<String, String> dataNetMap) {
            if (this.e instanceof Entity) {
                Entity ent = (Entity)this.e;
                ent.writeDataNets(out, indent, context.push(this.no), dataNetMap);
            } else {
                ScanChainElement ele = (ScanChainElement)this.e;
                if (ele.isPassThrough()) {
                    return;
                }
                for (int i = 0; i < this.no.getNameKey().busWidth(); ++i) {
                    String flatName2;
                    String flatName;
                    Nodable thisno = this.no;
                    if (this.no instanceof NodeInst) {
                        thisno = Netlist.getNodableFor((NodeInst)this.no, i);
                    }
                    VarContext subContext = context.push(thisno);
                    out.print(indent + "<datanet name=\"" + subContext.getInstPath(".") + "\"");
                    if (ele.getDataNets().size() > 0 && (flatName = this.getFlatDataNet(ele.getDataNets().get(0), subContext, dataNetMap)) != null) {
                        out.print(" net=\"" + flatName + "\"");
                    }
                    if (ele.getDataNets().size() > 1 && (flatName2 = this.getFlatDataNet(ele.getDataNets().get(1), subContext, dataNetMap)) != null) {
                        out.print(" net2=\"" + flatName2 + "\"");
                    }
                    out.println(" />");
                }
            }
        }

        private String getFlatDataNet(DataNet dataNet, VarContext context, HashMap<String, String> dataNetMap) {
            if (dataNet == null) {
                return null;
            }
            String contextName = ScanChainElement.getDataNetPath(dataNet, context);
            if (contextName == null) {
                return null;
            }
            String flatName = dataNetMap.get(contextName);
            if (flatName == null) {
                return null;
            }
            return flatName + dataNet.getOptions();
        }

        public int getLength() {
            if (this.e instanceof ScanChainElement) {
                ScanChainElement ele = (ScanChainElement)this.e;
                if (ele.isPassThrough()) {
                    return 0;
                }
                return this.length;
            }
            Entity ent = (Entity)this.e;
            return ent.getLength();
        }

        public void setNameOverride(String name) {
            this.nameOverride = name;
        }

        public String getName() {
            return this.nameOverride == null ? this.no.getName() : this.nameOverride;
        }

        protected TraceElement getTraceElement() {
            return this.e;
        }

        protected Nodable getNodable() {
            return this.no;
        }

        protected VarContext getContext() {
            return this.context;
        }
    }

    public static class StarterByOpcodeCompare
    implements Comparator<Starter> {
        @Override
        public int compare(Starter s1, Starter s2) {
            int compareChipName = s1.getChipName().compareTo(s2.getChipName());
            if (compareChipName == 0) {
                if (s1.opcode == s2.opcode) {
                    return 0;
                }
                if (s1.opcode < s2.opcode) {
                    return -1;
                }
                return 1;
            }
            return compareChipName;
        }
    }

    private class Starter
    extends Entity {
        private final String chain;
        private final int opcode;
        private String chipName;
        private Starter child;

        private Starter(Cell cell, String outport, List<Instance> instances, String chain2, int opcode, Starter child, String hierInstanceName) {
            super(cell, null, outport, false, instances, hierInstanceName);
            this.chain = chain2;
            this.opcode = opcode;
            this.chipName = "Temp_";
            this.child = child;
        }

        public void write(PrintWriter out, StringBuffer indent) {
            out.println(indent + "<chain name=\"" + this.chain + "\" opcode=\"" + Integer.toBinaryString(this.opcode) + "\">");
            indent.append("\t");
            this.writeContents(out, indent);
            indent.setLength(indent.length() - 1);
            out.println(indent + "</chain>");
        }

        public void writeData(PrintWriter out, StringBuffer indent, VarContext context, HashMap<String, String> dataNetMap) {
            out.println(indent + "<chain name=\"" + this.chain + "\" opcode=\"" + Integer.toBinaryString(this.opcode) + "\">");
            indent.append("\t");
            this.writeDataNets(out, indent, context, dataNetMap);
            indent.setLength(indent.length() - 1);
            out.println(indent + "</chain>");
        }

        @Override
        public String getKey() {
            return Starter.getKey(this.getCell(), this.getOrigStarterInstanceName() + "_" + this.chain, this.getInstanceName());
        }

        public void setChipName(String chipName) {
            this.chipName = chipName;
            if (this.child != null) {
                this.child.setChipName(chipName);
            }
        }

        public String getChipName() {
            return this.chipName;
        }

        public String getChain() {
            String chipName = this.getChipName();
            return chipName + "_" + this.chain;
        }

        public String getOrigStarterInstanceName() {
            if (this.child == null) {
                return this.getInstanceName();
            }
            String name = this.child.getOrigStarterInstanceName();
            if (name == null) {
                name = this.getInstanceName();
            }
            return name;
        }
    }

    private class Entity
    extends TraceElement {
        private List<Instance> instances;

        private Entity(Cell cell, String inport, String outport, boolean passThrough, List<Instance> instances, String hierInstanceName) {
            super(cell, inport, outport, passThrough, hierInstanceName);
            this.instances = new ArrayList<Instance>();
            if (instances != null) {
                this.instances.addAll(instances);
            }
        }

        public void writeDefinition(PrintWriter out) {
            if (this.getLength() == 0) {
                return;
            }
            out.println("<!ENTITY " + this.getKey() + " '");
            ArrayList<String> usedNames = new ArrayList<String>();
            for (Instance inst : this.instances) {
                inst.write(out, new StringBuffer("\t"), usedNames);
            }
            out.println("'>");
        }

        public void writeContents(PrintWriter out, StringBuffer indent) {
            ArrayList<String> usedNames = new ArrayList<String>();
            for (Instance inst : this.instances) {
                inst.write(out, indent, usedNames);
            }
        }

        public void writeDataNets(PrintWriter out, StringBuffer indent, VarContext context, HashMap<String, String> dataNetMap) {
            for (Instance inst : this.instances) {
                inst.writeDataNets(out, indent, context, dataNetMap);
            }
        }

        public int getLength() {
            int len = 0;
            for (Instance inst : this.instances) {
                len += inst.getLength();
            }
            return len;
        }

        public int flattenInstances(HashMap<Cell, Cell> cellsToFlatten, HashMap<Entity, Cell> alreadyFlattened) {
            int flattened = 0;
            if (alreadyFlattened.containsKey(this)) {
                return 0;
            }
            if (this instanceof Starter) {
                return 0;
            }
            for (int i = 0; i < this.instances.size(); ++i) {
                Instance inst = this.instances.get(i);
                TraceElement ele = inst.getTraceElement();
                if (!(ele instanceof Entity)) continue;
                Entity ent = (Entity)ele;
                flattened += ent.flattenInstances(cellsToFlatten, alreadyFlattened);
                if (ent.getRealInstances().size() != 1 && !cellsToFlatten.containsKey(ent.getCell())) continue;
                this.instances.remove(i);
                ArrayList<Instance> newInstances = new ArrayList<Instance>();
                for (Instance subinst : ent.getRealInstances()) {
                    Instance newinst = new Instance(subinst.getNodable(), subinst.getContext(), subinst.getLength(), subinst.getTraceElement());
                    if (ent.getRealInstances().size() == 1) {
                        newinst.setNameOverride(inst.getName());
                    } else {
                        newinst.setNameOverride(inst.getName() + "." + subinst.getName());
                    }
                    newInstances.add(newinst);
                }
                this.instances.addAll(i, newInstances);
                ++flattened;
                break;
            }
            alreadyFlattened.put(this, this.getCell());
            return flattened;
        }

        private int combineInstances() {
            ArrayList<ArrayedNameList> arrayedNames = new ArrayList<ArrayedNameList>();
            int combosDone = 0;
            int maxDimension = 0;
            for (Instance inst : this.instances) {
                if (inst.getTraceElement() instanceof ScanChainElement) {
                    ArrayedNameList name = new ArrayedNameList(inst.getName());
                    arrayedNames.add(name);
                    int m = name.numDimensions();
                    if (m <= maxDimension) continue;
                    maxDimension = m;
                    continue;
                }
                arrayedNames.add(null);
            }
            for (int m = 0; m < maxDimension; ++m) {
                ArrayedNameList last2 = null;
                for (int i = 0; i < arrayedNames.size(); ++i) {
                    ArrayedNameList next2 = (ArrayedNameList)arrayedNames.get(i);
                    if (last2 == null || next2 == null) {
                        last2 = next2;
                        continue;
                    }
                    Instance lastinst = this.instances.get(i - 1);
                    Instance nextinst = this.instances.get(i);
                    ScanChainElement lastE = (ScanChainElement)lastinst.getTraceElement();
                    ScanChainElement nextE = (ScanChainElement)nextinst.getTraceElement();
                    ArrayedNameList combined = last2.combineSequentialNumeric(next2, m);
                    if (lastE.combinable(nextE) && combined != null) {
                        Instance newInst = new Instance(lastinst.getNodable(), lastinst.getContext(), lastinst.getLength() + nextinst.getLength(), lastinst.getTraceElement());
                        newInst.setNameOverride(combined.toString());
                        this.instances.remove(i - 1);
                        this.instances.remove(i - 1);
                        arrayedNames.remove(i - 1);
                        arrayedNames.remove(i - 1);
                        this.instances.add(i - 1, newInst);
                        arrayedNames.add(i - 1, combined);
                        next2 = combined;
                        --i;
                        ++combosDone;
                    }
                    last2 = next2;
                }
            }
            return combosDone;
        }

        protected List<Instance> getInstances() {
            return this.instances;
        }

        protected List<Instance> getRealInstances() {
            ArrayList<Instance> realinstances = new ArrayList<Instance>();
            for (Instance inst : this.instances) {
                ScanChainElement ele;
                if (inst.getTraceElement() instanceof ScanChainElement && (ele = (ScanChainElement)inst.getTraceElement()).isPassThrough()) continue;
                realinstances.add(inst);
            }
            return realinstances;
        }

        protected List<Instance> getFlatInstances() {
            ArrayList<Instance> flatinstances = new ArrayList<Instance>();
            for (Instance inst : this.instances) {
                TraceElement e = inst.e;
                if (e.isPassThrough()) continue;
                if (e instanceof Entity) {
                    Entity ent = (Entity)e;
                    flatinstances.addAll(ent.getFlatInstances());
                    continue;
                }
                flatinstances.add(inst);
            }
            return flatinstances;
        }

        public List<VarContext> getContextsOfJtagInstances() {
            ArrayList<VarContext> contexts = new ArrayList<VarContext>();
            this.getContextsOfJtagInstances(contexts, VarContext.globalContext);
            return contexts;
        }

        private void getContextsOfJtagInstances(List<VarContext> contexts, VarContext parentContext) {
            for (Instance inst : this.instances) {
                if (inst.e instanceof Entity) {
                    Entity ent = (Entity)inst.e;
                    ent.getContextsOfJtagInstances(contexts, parentContext.push(inst.getNodable()));
                    continue;
                }
                if (!(inst.e instanceof JtagController)) continue;
                contexts.add(parentContext.push(inst.getNodable()));
            }
        }

        public VarContext getContextOfFirstElement(VarContext parentContext, HashMap<Cell, JtagController> jtagControllers) {
            for (Instance inst : this.instances) {
                if (inst.e.isPassThrough()) continue;
                if (inst.e instanceof Entity) {
                    Entity ent = (Entity)inst.e;
                    if (jtagControllers.get(ent.getCell()) != null) {
                        return parentContext.push(inst.getNodable());
                    }
                    VarContext context = ent.getContextOfFirstElement(parentContext.push(inst.getNodable()), jtagControllers);
                    if (context == null) continue;
                    return context;
                }
                if (!(inst.e instanceof ScanChainElement) && !(inst.e instanceof JtagController)) continue;
                VarContext context = parentContext.push(inst.getNodable());
                return context;
            }
            return null;
        }

        public void copyContentsOf(Entity ent) {
            this.instances.clear();
            this.instances.addAll(ent.getInstances());
        }

        public Set<Entity> getEntitiesUsed() {
            TreeSet<Entity> entities = new TreeSet<Entity>();
            for (Instance inst : this.instances) {
                TraceElement ele = inst.getTraceElement();
                if (!(ele instanceof Entity)) continue;
                Entity ent = (Entity)ele;
                entities.add(ent);
                entities.addAll(ent.getEntitiesUsed());
            }
            return entities;
        }

        public String toString() {
            return this.getKey();
        }
    }

    private static class DataNet {
        public final String net;
        public final String options;

        public DataNet(String netName) {
            int i = netName.indexOf(40);
            if (i != -1) {
                this.net = netName.substring(0, i);
                this.options = netName.substring(i, netName.length());
            } else {
                this.net = netName;
                this.options = "";
            }
        }

        public DataNet(String net, String options) {
            this.net = net;
            this.options = options;
        }

        public String toString() {
            return this.net + this.options;
        }

        public String getName() {
            return this.net;
        }

        public String getOptions() {
            return this.options;
        }
    }

    private static class ScanChainElement
    extends TraceElement {
        private final String access;
        private final String clears;
        private final List<DataNet> dataports;

        private ScanChainElement(Cell cell, String access, String clears, String inport, String outport, boolean passThrough, String dataport, String dataport2, String hierInstanceName) {
            super(cell, inport, outport, passThrough, hierInstanceName);
            this.access = access;
            this.clears = clears;
            this.dataports = new ArrayList<DataNet>();
            if (dataport != null && !dataport.equals("")) {
                this.dataports.add(new DataNet(dataport));
            }
            if (dataport2 != null && !dataport2.equals("")) {
                this.dataports.add(new DataNet(dataport2));
            }
        }

        public List<DataNet> getDataNets() {
            return this.dataports;
        }

        public static String getDataNetPath(DataNet dataNet, VarContext context) {
            if (dataNet == null) {
                return null;
            }
            return context.getInstPath(".") + "." + dataNet.getName();
        }

        public String getAccess() {
            return this.access;
        }

        public String getClears() {
            return this.clears;
        }

        public boolean combinable(ScanChainElement other) {
            if (this.access == null && other.getAccess() != null) {
                return false;
            }
            if (this.access != null && other.getAccess() == null) {
                return false;
            }
            if (this.access != null && other.getAccess() != null && !this.access.equals(other.getAccess())) {
                return false;
            }
            if (this.clears == null && other.getClears() != null) {
                return false;
            }
            if (this.clears != null && other.getClears() == null) {
                return false;
            }
            return this.clears == null || other.getClears() == null || this.clears.equals(other.getClears());
        }
    }

    private static class TraceElement
    implements Comparable {
        private final Cell cell;
        private final String inport;
        private final String outport;
        private final boolean passThrough;
        private String hierInstanceName;

        private TraceElement(Cell cell, String inport, String outport, boolean passThrough, String hierInstanceName) {
            this.cell = cell;
            this.inport = inport;
            this.outport = outport;
            this.passThrough = passThrough;
            this.hierInstanceName = hierInstanceName;
        }

        public static String getKey(Cell cell, String inport, String hierInstanceName) {
            String name = hierInstanceName == null ? "" : "_" + hierInstanceName;
            String key = cell.getLibrary().getName() + "_" + cell.getName() + "_" + inport + name;
            key = key.replaceAll("[\\[\\]@]", "_");
            return key;
        }

        public String getKey() {
            return TraceElement.getKey(this.cell, this.inport, this.hierInstanceName);
        }

        public String getInstanceName() {
            return this.hierInstanceName;
        }

        public void setInstanceName(String name) {
            this.hierInstanceName = name;
        }

        public Cell getCell() {
            return this.cell;
        }

        public int compareTo(Object o) {
            TraceElement e = (TraceElement)o;
            return this.getKey().compareTo(e.getKey());
        }

        public boolean equals(Object o) {
            TraceElement e = (TraceElement)o;
            return this.getKey().equals(e.getKey());
        }

        public String getOutport() {
            return this.outport;
        }

        public String getInport() {
            return this.inport;
        }

        public boolean isPassThrough() {
            return this.passThrough;
        }
    }
}

