/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEFDEF;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DEF
extends LEFDEF {
    private static final int LIMITNETS = -1;
    private static final boolean READCOMPONENTS = true;
    private static final boolean READPINS = true;
    private static final boolean READBLOCKAGES = true;
    private static final boolean READSPECIALNETS = true;
    private static final boolean READNETS = true;
    private static final boolean LIMITINGAREA = false;
    private static final double MAXX = 79100.0;
    private static final double MAXY = 200000.0;
    private double scaleUnits;
    private Map<String, LEFDEF.ViaDef> allViaDefs;
    private Map<String, PortInst> specialNetsHT = null;
    private Map<String, PortInst> normalNetsHT = null;
    private Map<String, NodeInst> instanceMap = null;
    private NodeInst dummyNodeInst = null;
    private boolean schImport = false;
    private Job job;
    private Map<Cell, Map<String, String>> cellModifiedNetNames = new HashMap<Cell, Map<String, String>>();
    private Map<Cell, Set<String>> cellOriginalNetNames = new HashMap<Cell, Set<String>>();
    private Map<Cell, Long> cellAutonames = new HashMap<Cell, Long>();
    private Pattern pat_starleftbracket = Pattern.compile(".*\\\\\\[");
    private Pattern pat_leftbracket = Pattern.compile("\\\\\\[");
    private Pattern pat_starrightbracket = Pattern.compile(".*\\\\\\]");
    private Pattern pat_rightbracket = Pattern.compile("\\\\\\]");
    private DEFPreferences localPrefs;
    private Map<String, Cell> dummyCells = new HashMap<String, Cell>();
    private static final boolean NEWPORTSTORAGE = false;
    private Map<Double, List<NodeInst>> portHT = null;
    private RTNode<PortInstBound> portRoot;

    DEF(EditingPreferences ep, DEFPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.initKeywordParsing();
        this.scaleUnits = 1000.0;
        this.allViaDefs = new HashMap<String, LEFDEF.ViaDef>();
        this.instanceMap = new HashMap<String, NodeInst>();
        this.initializeLEFDEF(tech);
        try {
            if (this.readFile(lib, currentCells)) {
                return null;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR reading DEF libraries");
        }
        return lib;
    }

    @Override
    protected String preprocessLine(String line) {
        int sharpPos = line.indexOf(35);
        if (sharpPos >= 0) {
            return line.substring(0, sharpPos);
        }
        return line;
    }

    private boolean readFile(Library lib, Map<Library, Cell> currentCells) throws IOException {
        Cell cell = null;
        while (true) {
            if (this.job != null && this.job.checkAbort()) {
                System.out.println("DEF import aborted!");
                break;
            }
            String key = this.getAKeyword();
            if (key == null) break;
            if (key.equalsIgnoreCase("BUSBITCHARS") || key.equalsIgnoreCase("DIEAREA") || key.equalsIgnoreCase("DIVIDERCHAR") || key.equalsIgnoreCase("GCELLGRID") || key.equalsIgnoreCase("HISTORY") || key.equalsIgnoreCase("NAMESCASESENSITIVE") || key.equalsIgnoreCase("ROW") || key.equalsIgnoreCase("TECHNOLOGY") || key.equalsIgnoreCase("TRACKS") || key.equalsIgnoreCase("VERSION")) {
                if (!this.ignoreToSemicolon(key, cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DEFAULTCAP") || key.equalsIgnoreCase("GROUPS") || key.equalsIgnoreCase("NONDEFAULTRULES") || key.equalsIgnoreCase("PROPERTYDEFINITIONS") || key.equalsIgnoreCase("REGIONS")) {
                if (!this.ignoreBlock(key, cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DESIGN")) {
                String cellName = this.mustGetKeyword("DESIGN", cell);
                if (cellName == null) {
                    return true;
                }
                cell = currentCells.get(lib);
                if (!Input.isNewLibraryCreated()) {
                    View cellView;
                    if (!(cell != null && cell.getCellName().getName().equals(cellName) || (cell = lib.findNodeProto(cellName)) != null)) {
                        cell = Cell.makeInstance(this.ep, lib, cellName + "{lay}");
                    }
                    if ((cellView = cell.getCellName().getView()).getAbbreviation().equals("sch")) {
                        this.schImport = true;
                    }
                } else if (cell == null || !cell.getCellName().getName().equals(cellName)) {
                    cell = Cell.makeInstance(this.ep, lib, cellName + "{lay}");
                }
                if (cell == null) {
                    this.reportError("Cannot create cell '" + cellName + "'", cell);
                    return true;
                }
                cell.setTechnology(this.curTech);
                Netlist theNetList = cell.getNetlist();
                HashSet<String> netNames = new HashSet<String>();
                Iterator<Network> itN = theNetList.getNetworks();
                while (itN.hasNext()) {
                    Network n = itN.next();
                    netNames.add(n.getName());
                }
                this.cellOriginalNetNames.put(cell, netNames);
                if (!this.ignoreToSemicolon("DESIGN", cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("UNITS")) {
                if (!this.readUnits(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("VIAS")) {
                if (!this.readVias(lib, cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("COMPONENTS")) {
                this.reportSection("COMPONENTS");
                if (!this.readComponents(cell, lib)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("PINS")) {
                this.reportSection("PINS");
                if (!this.readPins(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("BLOCKAGES")) {
                this.reportSection("BLOCKAGES");
                if (!this.readBlockages(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("SPECIALNETS")) {
                if (this.localPrefs.logicalPlacement || this.localPrefs.physicalPlacement) {
                    this.reportSection("SPECIALNETS");
                    boolean fail = this.readNets(cell, true);
                    if (!fail) continue;
                    return true;
                }
                if (!this.ignoreBlock(key, cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("NETS")) {
                if (this.localPrefs.logicalPlacement || this.localPrefs.physicalPlacement) {
                    this.reportSection("NETS");
                    boolean fail = this.readNets(cell, false);
                    if (fail) {
                        return true;
                    }
                } else if (this.ignoreBlock(key, cell)) {
                    return true;
                }
                if (!this.ignoreBlock(key, cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("END")) {
                key = this.getAKeyword();
                break;
            }
            this.reportError("Unknown top-level keyword: " + key, cell);
        }
        return false;
    }

    private void reportSection(String name) {
        if (Job.getDebug()) {
            long pct = this.byteCount * 100L / this.fileLength;
            System.out.println("Reading " + name + " starting at " + pct + "%");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean readBlockages(Cell cell) throws IOException {
        block19: {
            if (this.ignoreToSemicolon("BLOCKAGES", cell)) {
                return true;
            }
            do lbl-1000:
            // 3 sources

            {
                block20: {
                    if (this.job != null && this.job.checkAbort()) {
                        System.out.println("DEF import aborted!");
                        return true;
                    }
                    key = this.mustGetKeyword("BLOCKAGES", cell);
                    if (key == null) {
                        return true;
                    }
                    if (!key.equals("-")) break block20;
                    key = this.mustGetKeyword("BLOCKAGES", cell);
                    np /* !! */  = null;
                    if (key.equalsIgnoreCase("PLACEMENT")) {
                        np /* !! */  = Generic.tech().drcNode;
                    } else if (key.equalsIgnoreCase("LAYER")) {
                        key = this.mustGetKeyword("BLOCKAGES", cell);
                        li = this.getLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown blockage layer (" + key + ")", cell);
                            return true;
                        }
                        np /* !! */  = li.pin;
                    }
                    key = this.mustGetKeyword("BLOCKAGES", cell);
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("+")) {
                        key = this.mustGetKeyword("BLOCKAGES", cell);
                        if (key == null) {
                            return true;
                        }
                        if (key.equalsIgnoreCase("SOFT")) {
                            key = this.mustGetKeyword("BLOCKAGES", cell);
                            if (key == null) {
                                return true;
                            }
                        } else {
                            this.reportError("Unknown Placement keyword in Blockages section (" + key + ")", cell);
                            return true;
                        }
                    }
                    if (key.equalsIgnoreCase("RECT")) {
                        ll = this.readCoordinate(cell);
                        if (ll == null) {
                            return true;
                        }
                        ur = this.readCoordinate(cell);
                        if (ur == null) {
                            return true;
                        }
                        sX = Math.abs(ll.getX() - ur.getX());
                        sY = Math.abs(ll.getY() - ur.getY());
                        cX = (ll.getX() + ur.getX()) / 2.0;
                        loc = EPoint.fromLambda(cX, cY = (ll.getY() + ur.getY()) / 2.0);
                        if (this.acceptNode(loc, sX, sY) && this.makeNode(np /* !! */ , loc, sX, sY, cell) == null) {
                            return true;
                        }
                    } else {
                        this.reportError("Expected RECT in BLOCKAGES section", cell);
                        return true;
                    }
                    if (!this.ignoreToSemicolon(key, cell)) ** GOTO lbl-1000
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block19;
            } while (!this.ignoreToSemicolon(key, cell));
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readPins(Cell cell) throws IOException {
        String key;
        block5: {
            if (this.ignoreToSemicolon("PINS", cell)) {
                return true;
            }
            while (true) {
                if (this.job != null && this.job.checkAbort()) {
                    System.out.println("DEF import aborted!");
                    return true;
                }
                key = this.mustGetKeyword("PINs", cell);
                if (key == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readPin(cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block5;
                if (this.ignoreToSemicolon(key, cell)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key = this.mustGetKeyword("PIN", cell);
        if (key == null) {
            return true;
        }
        String pinName = this.translateDefName(key);
        PortCharacteristic portCharacteristic = null;
        NodeProto np = null;
        Point2D ll = null;
        Point2D ur = null;
        Point2D xy = null;
        boolean haveCoord = false;
        GetOrientation orient = null;
        while (true) {
            if ((key = this.mustGetKeyword("PIN", cell)) == null) {
                return true;
            }
            if (key.equals("+")) {
                key = this.mustGetKeyword("PIN", cell);
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("NET")) {
                    key = this.mustGetKeyword("net name", cell);
                    if (key != null) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("DIRECTION")) {
                    key = this.mustGetKeyword("DIRECTION", cell);
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("INPUT")) {
                        portCharacteristic = PortCharacteristic.IN;
                        continue;
                    }
                    if (key.equalsIgnoreCase("OUTPUT")) {
                        portCharacteristic = PortCharacteristic.OUT;
                        continue;
                    }
                    if (key.equalsIgnoreCase("INOUT")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("FEEDTHRU")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    this.reportError("Unknown direction (" + key + ")", cell);
                    return true;
                }
                if (key.equalsIgnoreCase("USE")) {
                    key = this.mustGetKeyword("USE", cell);
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("SIGNAL")) continue;
                    if (key.equalsIgnoreCase("POWER")) {
                        portCharacteristic = PortCharacteristic.PWR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("GROUND")) {
                        portCharacteristic = PortCharacteristic.GND;
                        continue;
                    }
                    if (key.equalsIgnoreCase("CLOCK")) {
                        portCharacteristic = PortCharacteristic.CLK;
                        continue;
                    }
                    if (key.equalsIgnoreCase("TIEOFF") || key.equalsIgnoreCase("ANALOG")) continue;
                    this.reportError("Unknown usage (" + key + ")", cell);
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.mustGetKeyword("LAYER", cell);
                    if (key == null) {
                        return true;
                    }
                    if (!this.schImport) {
                        LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown pin layer (" + key + ")", cell);
                            return true;
                        }
                        np = li.pin;
                    }
                    if ((ll = this.readCoordinate(cell)) == null) {
                        return true;
                    }
                    ur = this.readCoordinate(cell);
                    if (ur != null) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED")) continue;
                xy = this.readCoordinate(cell);
                if (xy == null) {
                    return true;
                }
                orient = new GetOrientation(cell);
                haveCoord = true;
                continue;
            }
            if (key.equals(";")) break;
        }
        if (this.schImport) {
            ArcProto apTry = null;
            Iterator<Comparable<ArcProto>> it = this.curTech.getArcs();
            while (it.hasNext() && !(apTry = it.next()).getName().equals("wire")) {
            }
            if (apTry == null) {
                this.reportError("Unable to resolve pin component", cell);
                return true;
            }
            it = this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitivePort pp;
                PrimitiveNode loc_np = (PrimitiveNode)it.next();
                if (loc_np.getNumPorts() != 1 || !(pp = loc_np.getPort(0)).connectsTo(apTry)) continue;
                np = loc_np;
                break;
            }
        }
        if (!haveCoord && !this.localPrefs.ignoreUngeneratedPins) {
            haveCoord = true;
            xy = new Point2D.Double(0.0, 0.0);
        }
        if (np != null && haveCoord) {
            FixpTransform trans = orient.orient.pureRotate();
            trans.transform(ll, ll);
            trans.transform(ur, ur);
            double sX = Math.abs(ll.getX() - ur.getX());
            double sY = Math.abs(ll.getY() - ur.getY());
            double cX = (ll.getX() + ur.getX()) / 2.0 + xy.getX();
            double cY = (ll.getY() + ur.getY()) / 2.0 + xy.getY();
            EPoint loc = EPoint.fromLambda(cX, cY);
            if (this.acceptNode(loc, sX, sY)) {
                Export e;
                NodeInst ni = this.makeNode(np, loc, sX, sY, cell);
                if (ni == null) {
                    return true;
                }
                PortInst pi = ni.findPortInstFromProto(np.getPort(0));
                Export ex = cell.findExport(pinName);
                if (ex != null) {
                    EPoint exPi;
                    EPoint exEp = ex.getPoly().getCenter();
                    if (exEp.equals(exPi = pi.getPoly().getCenter())) {
                        this.reportWarning("Cell already has an export named " + pinName + ", not making new export because both have the same center (" + TextUtils.formatDistance(exEp.getX()) + "," + TextUtils.formatDistance(exEp.getY()) + ")", ni, cell);
                        return false;
                    }
                    String oldName = pinName;
                    if ((pinName = ElectricObject.uniqueObjectName(pinName, cell, Export.class, false, true)) == null) {
                        this.reportError("Cell already has an export named " + oldName + ", export was not created", cell);
                        return true;
                    }
                    this.reportWarning("Cell already has an export named " + oldName + ", making new export named " + pinName, ni, cell);
                }
                if ((e = Export.newInstance(cell, pi, pinName, this.ep, portCharacteristic)) == null) {
                    this.reportError("Unable to create pin name", cell);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean readComponents(Cell cell, Library lib) throws IOException {
        String key;
        block5: {
            if (this.ignoreToSemicolon("COMPONENTS", cell)) {
                return true;
            }
            while (true) {
                if (this.job != null && this.job.checkAbort()) {
                    System.out.println("DEF import aborted!");
                    return true;
                }
                key = this.mustGetKeyword("COMPONENTs", cell);
                if (key == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readComponent(cell, lib)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block5;
                if (this.ignoreToSemicolon(key, cell)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private Cell makeDummyCell(String name, Library lib) {
        Cell cell = this.dummyCells.get(name);
        if (cell != null) {
            return cell;
        }
        this.reportWarning("Cell " + name + " not found: making a dummy cell for it", cell);
        cell = Cell.makeInstance(this.ep, lib, name);
        this.dummyCells.put(name, cell);
        PrimitiveNode cornerNp = Generic.tech().essentialBoundsNode;
        double cornerWid = cornerNp.getDefWidth(this.ep);
        double cornerHei = cornerNp.getDefHeight(this.ep);
        NodeInst.makeInstance((NodeProto)cornerNp, this.ep, EPoint.fromLambda(-50.0, -50.0), cornerWid, cornerHei, cell, Orientation.RR, null);
        NodeInst.makeInstance(cornerNp, this.ep, EPoint.fromLambda(50.0, 50.0), cornerWid, cornerHei, cell);
        PrimitiveNode portNp = Generic.tech().universalPinNode;
        double portWid = portNp.getDefWidth(this.ep);
        double portHei = portNp.getDefHeight(this.ep);
        NodeInst ni = NodeInst.makeInstance(portNp, this.ep, EPoint.fromLambda(0.0, 0.0), portWid, portHei, cell);
        Export.newInstance(cell, ni.getOnlyPortInst(), "dummyPort", this.ep);
        return cell;
    }

    private boolean readComponent(Cell cell, Library lib) throws IOException {
        String key = this.mustGetKeyword("COMPONENT", cell);
        if (key == null) {
            return true;
        }
        String compName = key;
        String compNameLC = compName.toLowerCase();
        key = this.mustGetKeyword("COMPONENT", cell);
        if (key == null) {
            return true;
        }
        String modelName = key;
        Cell np = cell.getView() != null ? this.getNodeProto(modelName, cell.getLibrary(), cell) : this.getNodeProto(modelName, cell.getLibrary());
        if (np == null) {
            if (this.localPrefs.makeDummyCells) {
                np = this.makeDummyCell(modelName, lib);
            } else {
                this.reportError("Unknown cell (" + modelName + ").  To allow this, use DEF Preferences and check 'Make dummy cells for unknown cells'", cell);
                return true;
            }
        }
        double nx = 0.0;
        double ny = 0.0;
        boolean hasLocation = false;
        double sX = np.getDefWidth();
        double sY = np.getDefHeight();
        Orientation or = Orientation.IDENT;
        while (true) {
            if ((key = this.mustGetKeyword("COMPONENT", cell)) == null) {
                return true;
            }
            if (key.equals("+")) {
                key = this.mustGetKeyword("COMPONENT", cell);
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED") && !key.equalsIgnoreCase("COVER")) continue;
                Point2D pt = this.readCoordinate(cell);
                if (pt == null) {
                    return true;
                }
                nx = pt.getX();
                ny = pt.getY();
                hasLocation = true;
                or = this.FetchOrientation(cell);
                continue;
            }
            if (key.equals(";")) break;
        }
        EPoint loc = EPoint.fromLambda(nx, ny);
        if (this.acceptNode(loc, sX, sY)) {
            NodeInst ni = this.makeNodeMoreInfo(np, loc, sX, sY, cell, or, compName);
            if (ni == null) {
                return true;
            }
            this.instanceMap.put(compNameLC, ni);
            if (!hasLocation) {
                this.reportWarning("Instance " + compName + " of model " + modelName + " has no location in cell " + cell.describe(false) + ". Placing it at (0,0)", ni, cell);
            }
        } else {
            if (this.dummyNodeInst == null) {
                this.dummyNodeInst = NodeInst.makeDummyInstance((NodeProto)np, this.ep);
            }
            this.instanceMap.put(compNameLC, this.dummyNodeInst);
        }
        return false;
    }

    private boolean readNets(Cell cell, boolean special) throws IOException {
        if (special) {
            this.specialNetsHT = new HashMap<String, PortInst>();
        } else {
            this.normalNetsHT = new HashMap<String, PortInst>();
        }
        this.initNets();
        int numNets = 0;
        String key = this.mustGetKeyword("NETs", cell);
        if (key == null) {
            return true;
        }
        if (TextUtils.isANumber(key)) {
            numNets = TextUtils.atoi(key);
        }
        if (!key.equals(";") && this.ignoreToSemicolon(key, cell)) {
            return true;
        }
        int net = 1;
        while (true) {
            if (this.job != null && this.job.checkAbort()) {
                System.out.println("DEF import aborted!");
                return true;
            }
            key = this.mustGetKeyword("NETs", cell);
            if (key == null) {
                return true;
            }
            if (key.equals("-")) {
                boolean fail = this.readNet(cell, special, net, numNets);
                if (fail) {
                    return true;
                }
            } else if (key.equalsIgnoreCase("END")) break;
            ++net;
        }
        key = this.getAKeyword();
        this.connectSpecialNormalNets();
        return false;
    }

    private void connectSpecialNormalNets() {
        if (this.specialNetsHT == null) {
            return;
        }
        if (this.normalNetsHT == null) {
            return;
        }
        if (!this.localPrefs.logicalPlacement) {
            return;
        }
        for (String netName : this.specialNetsHT.keySet()) {
            PortInst specPi = this.specialNetsHT.get(netName);
            PortInst normalPi = null;
            if (!this.normalNetsHT.containsKey(netName) || (normalPi = this.normalNetsHT.get(netName)) == null || !this.makeUnroutedConnection(specPi, normalPi, null)) continue;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean readNet(Cell cell, boolean special, int netNum, int totalNets) throws IOException {
        block180: {
            if (this.schImport && special) {
                this.ignoreToSemicolon("NET", cell);
                return false;
            }
            key = this.mustGetKeyword("NET", cell);
            if (key == null) {
                return true;
            }
            netName = this.translateDefName(key);
            arcNameToUse = special == false ? netName : null;
            map = this.cellModifiedNetNames.get(cell);
            newN = null;
            if (map != null) {
                newN = map.get(netName);
            }
            if (newN == null) {
                names = this.cellOriginalNetNames.get(cell);
                existingName = false;
                if (names != null) {
                    existingName = names.contains(netName);
                }
                if (existingName) {
                    ai = cell.findArc(netName);
                    if (ai != null) {
                        topology = cell.getTopology();
                        ni = cell.findNode(netName);
                        if (ni != null) {
                            System.out.println("H");
                        }
                        do {
                            l = (l = this.cellAutonames.get(cell)) == null ? 0L : l + 1L;
                            this.cellAutonames.put(cell, l);
                        } while (cell.findArc(newN = l + netName) != null);
                        if (Job.getDebug()) {
                            System.out.println("Net name already taken '" + netName + "'. Using '" + newN + "'");
                        }
                        if (map == null) {
                            map = new HashMap<String, String>();
                            this.cellModifiedNetNames.put(cell, map);
                        }
                        map.put(netName, newN);
                    }
                } else {
                    if (names == null) {
                        names = new HashSet<String>();
                        this.cellOriginalNetNames.put(cell, names);
                    }
                    names.add(netName);
                    if (Job.getDebug()) {
                        System.out.println("Caching '" + netName + "' as well");
                    }
                }
            } else {
                newN = null;
                arcNameToUse = null;
            }
            if (newN != null) {
                arcNameToUse = newN;
            }
            if ((key = this.mustGetKeyword("NET", cell)) == null) {
                return true;
            }
            adjustPinLocPi = false;
            adjustPinLocLastPi = false;
            wantPinPairs = true;
            connectAllComponents = false;
            wildcardPort = null;
            lastX = 0.0;
            lastY = 0.0;
            curX = 0.0;
            curY = 0.0;
            specialWidth = 0.0;
            pathStart = true;
            lastLogPi = null;
            lastPi = null;
            lastPT = null;
            li = null;
            foundCoord = false;
            stackedViaFlag = false;
            while (true) {
                block181: {
                    if (this.job != null && this.job.checkAbort()) {
                        System.out.println("DEF import aborted!");
                        return true;
                    }
                    if (key.equals(";")) {
                        if (lastPi != null) {
                            if (special) {
                                this.specialNetsHT.put(netName, lastPi);
                            } else {
                                this.normalNetsHT.put(netName, lastPi);
                            }
                        }
                        if (!(lastLogPi == null || lastPi == null || !this.localPrefs.logicalPlacement || this.localPrefs.ignoreLogicalInSpecialNets && special)) {
                            fail = this.makeUnroutedConnection(lastPi, lastLogPi, arcNameToUse);
                            arcNameToUse = null;
                            if (fail) {
                                return true;
                            }
                        }
                        break block180;
                    }
                    if (key.equals("+")) {
                        wantPinPairs = false;
                        if (this.schImport) {
                            this.ignoreToSemicolon("NET", cell);
                            break block180;
                        }
                        key = this.mustGetKeyword("NET", cell);
                        if (key == null) {
                            return true;
                        }
                        if (key.equalsIgnoreCase("USE")) {
                            key = this.mustGetKeyword("NET", cell);
                            if (key == null) {
                                return true;
                            }
                        } else if (key.equalsIgnoreCase("SHIELDNET")) {
                            key = this.mustGetKeyword("NET", cell);
                            if (key == null) {
                                return true;
                            }
                        } else if (key.equalsIgnoreCase("ROUTED")) {
                            key = this.mustGetKeyword("NET", cell);
                            if (key == null) {
                                return true;
                            }
                            li = this.getLayerInformation(key);
                            if (li.pin == null) {
                                this.reportError("Unknown routed net layer (" + key + ")", cell);
                                return true;
                            }
                            pathStart = true;
                            if (special) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                                specialWidth = this.convertDEFString(key);
                            }
                        } else {
                            if (key.equalsIgnoreCase("POLYGON")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                                li = this.getLayerInformation(key);
                                if (li.pin == null) {
                                    this.reportError("Unknown polygon layer (" + key + ")", cell);
                                    return true;
                                }
                                coords = new ArrayList<Point2D.Double>();
                                while (true) {
                                    if ((key = this.mustGetKeyword("NET", cell)) == null) {
                                        return true;
                                    }
                                    if (!key.equals("(")) break;
                                    key = this.mustGetKeyword("NET", cell);
                                    if (key == null) {
                                        return true;
                                    }
                                    curX = this.convertDEFString(key);
                                    key = this.mustGetKeyword("NET", cell);
                                    if (key == null) {
                                        return true;
                                    }
                                    curY = this.convertDEFString(key);
                                    key = this.mustGetKeyword("NET", cell);
                                    if (key == null) {
                                        return true;
                                    }
                                    if (!key.equals(")")) {
                                        this.reportError("Expected ')' of polygon coordinate pair", cell);
                                        return true;
                                    }
                                    coords.add(new Point2D.Double(curX, curY));
                                }
                                if (coords.size() <= 2) continue;
                                lX = ((Point2D)coords.get(0)).getX();
                                hX = ((Point2D)coords.get(0)).getX();
                                lY = ((Point2D)coords.get(0)).getY();
                                hY = ((Point2D)coords.get(0)).getY();
                                for (i = 1; i < coords.size(); ++i) {
                                    if (((Point2D)coords.get(i)).getX() < lX) {
                                        lX = ((Point2D)coords.get(i)).getX();
                                    }
                                    if (((Point2D)coords.get(i)).getX() > hX) {
                                        hX = ((Point2D)coords.get(i)).getX();
                                    }
                                    if (((Point2D)coords.get(i)).getY() < lY) {
                                        lY = ((Point2D)coords.get(i)).getY();
                                    }
                                    if (!(((Point2D)coords.get(i)).getY() > hY)) continue;
                                    hY = ((Point2D)coords.get(i)).getY();
                                }
                                loc = EPoint.fromLambda((lX + hX) / 2.0, (lY + hY) / 2.0);
                                ptrace = new EPoint[coords.size()];
                                for (i = 0; i < coords.size(); ++i) {
                                    ptrace[i] = EPoint.fromLambda(((Point2D)coords.get(i)).getX() - loc.getX(), ((Point2D)coords.get(i)).getY() - loc.getY());
                                }
                                newNi = this.makeNode(li.pure, loc, hX - lX, hY - lY, cell);
                                if (newNi == null) {
                                    return true;
                                }
                                newNi.setTraceRelative(ptrace, loc, Orientation.IDENT);
                                continue;
                            }
                            if (key.equalsIgnoreCase("RECT")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                                li = this.getLayerInformation(key);
                                if (li.pin == null) {
                                    this.reportError("Unknown net rect layer (" + key + ")", cell);
                                    return true;
                                }
                                pathStart = true;
                            } else if (key.equalsIgnoreCase("FIXED")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                                li = this.getLayerInformation(key);
                                if (li.pin == null) {
                                    this.reportError("Unknown fixed net layer (" + key + ")", cell);
                                    return true;
                                }
                                pathStart = true;
                                if (special) {
                                    key = this.mustGetKeyword("NET", cell);
                                    if (key == null) {
                                        return true;
                                    }
                                    specialWidth = this.convertDEFString(key);
                                }
                            } else if (key.equalsIgnoreCase("SHIELD")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                                li = this.getLayerInformation(key);
                                if (li.pin == null) {
                                    this.reportError("Unknown shield net layer (" + key + ")", cell);
                                    return true;
                                }
                                pathStart = true;
                                if (special) {
                                    key = this.mustGetKeyword("NET", cell);
                                    if (key == null) {
                                        return true;
                                    }
                                    specialWidth = this.convertDEFString(key);
                                }
                            } else if (key.equalsIgnoreCase("SHAPE")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                            } else if (key.equalsIgnoreCase("SOURCE")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                            } else if (key.equalsIgnoreCase("ORIGINAL")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                            } else if (key.equalsIgnoreCase("NONDEFAULTRULE")) {
                                key = this.mustGetKeyword("NET", cell);
                                if (key == null) {
                                    return true;
                                }
                            } else {
                                this.reportError("Cannot handle '" + key + "' nets", cell);
                                return true;
                            }
                        }
                        if ((key = this.mustGetKeyword("NET", cell)) != null) continue;
                        return true;
                    }
                    if (!wantPinPairs) break block181;
                    if (!key.equals("(")) {
                        this.reportError("Expected '(' of pin pair", cell);
                        return true;
                    }
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    pi = null;
                    if (!key.equalsIgnoreCase("PIN")) ** GOTO lbl264
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    pp = (Export)cell.findPortProto(key = this.translateDefName(key));
                    if (pp != null) {
                        pi = pp.getOriginalPort();
                    } else {
                        this.reportWarning("Unknown pin '" + key + "' on cell '" + cell.describe(false) + "'", cell);
                        return this.ignoreToSemicolon("NETS", cell) != false;
lbl264:
                        // 1 sources

                        found = null;
                        if (key.equals("*")) {
                            connectAllComponents = true;
                        } else {
                            connectAllComponents = false;
                            lcKey = key.toLowerCase();
                            found = this.instanceMap.get(lcKey);
                            if (found == null) {
                                this.reportError("Unknown component '" + key + "' on cell '" + cell.describe(false) + "'", cell);
                                return true;
                            }
                        }
                        key = this.mustGetKeyword("NET", cell);
                        if (key == null) {
                            return true;
                        }
                        if (connectAllComponents) {
                            wildcardPort = key;
                        } else if (found != this.dummyNodeInst) {
                            pp = found.getProto().findPortProto(key);
                            if (pp == null && (pp = found.getProto().findPortProto("dummyPort")) == null) {
                                if (!this.localPrefs.ignoreUngeneratedPins) {
                                    this.reportError("Unknown port '" + key + "' on component " + found, cell);
                                    return true;
                                }
                                this.reportWarning("Unknown port '" + key + "' on component " + found, cell);
                            }
                            if (pp != null) {
                                pi = found.findPortInstFromProto(pp);
                            }
                        }
                    }
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    if (!key.equals(")")) {
                        this.reportError("Expected ')' of pin pair", cell);
                        return true;
                    }
                    if (pi != null) {
                        if (!(!this.localPrefs.logicalPlacement || this.localPrefs.ignoreLogicalInSpecialNets && special)) {
                            if (connectAllComponents) {
                                pi = this.connectGlobal(cell, wildcardPort);
                                if (pi == null) {
                                    return true;
                                }
                            } else if (lastLogPi != null) {
                                fail = this.makeUnroutedConnection(pi, lastLogPi, arcNameToUse);
                                arcNameToUse = null;
                                if (fail) {
                                    return true;
                                }
                            }
                        }
                        lastLogPi = pi;
                    }
                    if ((key = this.mustGetKeyword("NET", cell)) != null) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("NEW")) {
                    if (!(lastLogPi == null || lastPi == null || !this.localPrefs.logicalPlacement || this.localPrefs.ignoreLogicalInSpecialNets && special)) {
                        fail = this.makeUnroutedConnection(lastPi, lastLogPi, arcNameToUse);
                        arcNameToUse = null;
                        if (fail) {
                            return true;
                        }
                    }
                    if ((key = this.mustGetKeyword("NET", cell)) == null) {
                        return true;
                    }
                    li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown new net layer (" + key + ")", cell);
                        return true;
                    }
                    pathStart = true;
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    if (!special) continue;
                    specialWidth = this.convertDEFString(key);
                    key = this.mustGetKeyword("NET", cell);
                    if (key != null) continue;
                    return true;
                }
                if (!stackedViaFlag) {
                    foundCoord = false;
                }
                if (key.equals("(")) {
                    foundCoord = true;
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    curX = key.equals("*") != false ? lastX : this.convertDEFString(key);
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    curY = key.equals("*") != false ? lastY : this.convertDEFString(key);
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    if (TextUtils.isANumber(key) && (key = this.mustGetKeyword("NET", cell)) == null) {
                        return true;
                    }
                    if (!key.equals(")")) {
                        this.reportError("Expected ')' of coordinate pair", cell);
                        return true;
                    }
                }
                if (!stackedViaFlag && (key = this.mustGetKeyword("NET", cell)) == null) {
                    return true;
                }
                vd = this.findViaDef(key);
                if (!this.localPrefs.physicalPlacement || this.schImport) {
                    if (vd == null || (key = this.mustGetKeyword("NET", cell)) != null) continue;
                    return true;
                }
                pi = null;
                piPT = null;
                placedVia = false;
                if (vd != null) {
                    sX = vd.sX;
                    sY = vd.sY;
                    if (vd.via == null) {
                        this.reportError("Cannot create via '" + vd.viaName + "'", cell);
                        return true;
                    }
                    if (pathStart) {
                        if (!this.localPrefs.usePureLayerNodes) {
                            lastPi = this.findConnection(curX, curY, li.arc, cell, null);
                        }
                        if (this.acceptNode(loc = EPoint.fromLambda(curX, curY), 0.0, 0.0)) {
                            lastPT = loc;
                        }
                    }
                    so = vd.via.getProtoSizeOffset();
                    loc = EPoint.fromLambda(curX, curY);
                    if (this.acceptNode(loc, sX += so.getLowXOffset() + so.getHighXOffset(), sY += so.getLowYOffset() + so.getHighYOffset())) {
                        ni = this.makeNode(vd.via, loc, sX, sY, cell);
                        if (ni == null) {
                            return true;
                        }
                        pi = ni.getOnlyPortInst();
                        piPT = EPoint.fromLambda(curX, curY);
                        width = li.getWidth(this.ep);
                        if (special) {
                            width = specialWidth;
                        } else if (DEF.widthsFromLEF != null && (wid = (Double)DEF.widthsFromLEF.get(li.arc)) != null) {
                            width = wid;
                        }
                        if (li.arc == null || this.localPrefs.usePureLayerNodes) {
                            if (pathStart && lastPT != null && foundCoord && (!this.localPrefs.ignorePhysicalInNets || special) && (lastPT.getX() != piPT.getX() || lastPT.getY() != piPT.getY()) && (newNi = this.makeNode(li.pure, locNi = EPoint.fromLambda(((lX = Math.min(lastPT.getX(), piPT.getX()) - width / 2.0) + (hX = Math.max(lastPT.getX(), piPT.getX()) + width / 2.0)) / 2.0, ((lY = Math.min(lastPT.getY(), piPT.getY()) - width / 2.0) + (hY = Math.max(lastPT.getY(), piPT.getY()) + width / 2.0)) / 2.0), sXNi = hX - lX, sYNi = hY - lY, cell)) == null) {
                                return true;
                            }
                        } else if (pathStart && lastPi != null && foundCoord && (!this.localPrefs.ignorePhysicalInNets || special)) {
                            fail = this.makeConnection(cell, li.arc, width, lastPi, pi, lastPT, piPT, arcNameToUse);
                            arcNameToUse = null;
                            if (fail) {
                                return true;
                            }
                        }
                    }
                    placedVia = true;
                    key = this.mustGetKeyword("NET", cell);
                    if (key == null) {
                        return true;
                    }
                    vdStack = this.findViaDef(key);
                    stackedViaFlag = vdStack != null;
                } else {
                    if (li == null) {
                        this.reportError("No Layer specified for pin", cell);
                        return true;
                    }
                    testPT = EPoint.fromLambda(curX, curY);
                    if (this.acceptNode(testPT, 0.0, 0.0)) {
                        if (!this.localPrefs.usePureLayerNodes && (pi = this.getPin(curX, curY, li, cell)) == null) {
                            return true;
                        }
                        piPT = testPT;
                    }
                    adjustPinLocPi = true;
                }
                if (!foundCoord) continue;
                if (!pathStart) {
                    if (this.localPrefs.usePureLayerNodes) {
                        if (piPT == null && this.acceptNode(loc = EPoint.fromLambda(curX, curY), 0.0, 0.0)) {
                            piPT = loc;
                        }
                    } else if (pi == null || !pi.getPortProto().connectsTo(li.arc)) {
                        np = li.pin;
                        sX = np.getDefWidth(this.ep);
                        sY = np.getDefHeight(this.ep);
                        loc = EPoint.fromLambda(curX, curY);
                        if (this.acceptNode(loc, sX, sY)) {
                            ni = this.makeNode(np, loc, sX, sY, cell);
                            if (ni == null) {
                                return true;
                            }
                            pi = ni.getOnlyPortInst();
                            piPT = EPoint.fromLambda(curX, curY);
                        }
                    }
                    width = li.getWidth(this.ep);
                    if (special) {
                        width = specialWidth;
                    } else if (DEF.widthsFromLEF != null && (wid = (Double)DEF.widthsFromLEF.get(li.arc)) != null) {
                        width = wid;
                    }
                    if (adjustPinLocLastPi && special) {
                        dX = 0.0;
                        dY = 0.0;
                        if (curX != lastX) {
                            dX = width / 2.0;
                            if (curX < lastX) {
                                dX = -dX;
                            }
                        }
                        if (curY != lastY) {
                            dY = width / 2.0;
                            if (curY < lastY) {
                                dY = -dY;
                            }
                        }
                        if (lastPi != null) {
                            lastPi.getNodeInst().move(dX, dY);
                        }
                        if (lastPT != null) {
                            lastPT = EPoint.fromLambda(lastPT.getX() + dX, lastPT.getY() + dY);
                        }
                        adjustPinLocLastPi = false;
                    }
                    if (adjustPinLocPi && special) {
                        dX = 0.0;
                        dY = 0.0;
                        if (curX != lastX) {
                            dX = -width / 2.0;
                            if (curX < lastX) {
                                dX = -dX;
                            }
                        }
                        if (curY != lastY) {
                            dY = -width / 2.0;
                            if (curY < lastY) {
                                dY = -dY;
                            }
                        }
                        if (pi != null) {
                            pi.getNodeInst().move(dX, dY);
                        }
                        if (piPT != null) {
                            piPT = EPoint.fromLambda(piPT.getX() + dX, piPT.getY() + dY);
                        }
                        adjustPinLocPi = false;
                    }
                    if (!this.localPrefs.ignorePhysicalInNets || special) {
                        if (li.arc == null || this.localPrefs.usePureLayerNodes) {
                            if (lastPT != null && piPT != null && (lastPT.getX() != piPT.getX() || lastPT.getY() != piPT.getY()) && (newNi = this.makeNode(li.pure, locNi = EPoint.fromLambda(((lX = Math.min(lastPT.getX(), piPT.getX()) - width / 2.0) + (hX = Math.max(lastPT.getX(), piPT.getX()) + width / 2.0)) / 2.0, ((lY = Math.min(lastPT.getY(), piPT.getY()) - width / 2.0) + (hY = Math.max(lastPT.getY(), piPT.getY()) + width / 2.0)) / 2.0), sXNi = hX - lX, sYNi = hY - lY, cell)) == null) {
                                return true;
                            }
                        } else {
                            fail = this.makeConnection(cell, li.arc, width, lastPi, pi, lastPT, piPT, arcNameToUse);
                            arcNameToUse = null;
                            if (fail) {
                                return true;
                            }
                        }
                    }
                }
                lastX = curX;
                lastY = curY;
                pathStart = false;
                lastPi = pi;
                lastPT = piPT;
                adjustPinLocLastPi = adjustPinLocPi;
                adjustPinLocPi = false;
                if (placedVia) {
                    if (li.equals(vd.gLay1)) {
                        li = vd.gLay2;
                    } else if (li.equals(vd.gLay2)) {
                        li = vd.gLay1;
                    }
                }
                if (!key.equalsIgnoreCase("NEW") && !key.equals(";")) continue;
                width = li.getWidth(this.ep);
                if (special) {
                    width = specialWidth;
                } else if (DEF.widthsFromLEF != null && (wid = (Double)DEF.widthsFromLEF.get(li.arc)) != null) {
                    width = wid;
                }
                if (li.arc == null || this.localPrefs.usePureLayerNodes) {
                    if (piPT == null || this.localPrefs.ignorePhysicalInNets && !special || curX == piPT.getX() && curY == piPT.getY() || (newNi = this.makeNode(np = li.pure, locNi = EPoint.fromLambda(((lX = Math.min(curX, piPT.getX()) - width / 2.0) + (hX = Math.max(curX, piPT.getX()) + width / 2.0)) / 2.0, ((lY = Math.min(curY, piPT.getY()) - width / 2.0) + (hY = Math.max(curY, piPT.getY()) + width / 2.0)) / 2.0), sXNi = hX - lX, sYNi = hY - lY, cell)) != null) continue;
                    return true;
                }
                if (pi == null || (nextPi = this.findConnection(curX, curY, li.arc, cell, pi.getNodeInst())) == null || this.localPrefs.ignorePhysicalInNets && !special) continue;
                fail = this.makeConnection(cell, li.arc, width, pi, nextPi, piPT, EPoint.fromLambda(curX, curY), arcNameToUse);
                arcNameToUse = null;
                if (fail) break;
            }
            return true;
        }
        return false;
    }

    private PortInst connectGlobal(Cell cell, String portName) {
        PortInst lastPi = null;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            boolean fail;
            PortInst pi;
            EPoint pt;
            NodeInst ni = it.next();
            PortProto pp = ni.getProto().findPortProto(portName);
            if (pp == null || !this.acceptNode(pt = (pi = ni.findPortInstFromProto(pp)).getCenter(), 0.0, 0.0)) continue;
            if (lastPi != null && (fail = this.makeUnroutedConnection(pi, lastPi, null))) {
                return null;
            }
            lastPi = pi;
        }
        return lastPi;
    }

    private boolean readVias(Library lib, Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("VIAS", cell)) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("VIAs", cell)) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readVia(lib)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key, cell)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readVia(Library lib) throws IOException {
        if (this.schImport) {
            this.ignoreToSemicolon("VIA", null);
            return false;
        }
        String key = this.mustGetKeyword("VIA", null);
        if (key == null) {
            return true;
        }
        Cell cell = Cell.makeInstance(this.ep, lib, key + "{lay}");
        LEFDEF.ViaDef vd = new LEFDEF.ViaDef(key, cell);
        this.allViaDefs.put(key.toLowerCase(), vd);
        NodeInst ni = this.makeNode(Generic.tech().universalPinNode, EPoint.fromLambda(0.0, 0.0), 0.0, 0.0, cell);
        if (ni == null) {
            return true;
        }
        Export e = Export.newInstance(cell, ni.getOnlyPortInst(), "viaPort", this.ep, PortCharacteristic.UNKNOWN);
        if (e == null) {
            this.reportError("Unable to create export in " + vd.viaName + " via", cell);
            return true;
        }
        double cutSizeX = 0.0;
        double cutSizeY = 0.0;
        double cutSpacingX = 0.0;
        double cutSpacingY = 0.0;
        double leftEnclosure = 0.0;
        double rightEnclosure = 0.0;
        double topEnclosure = 0.0;
        double bottomEnclosure = 0.0;
        int rowColX = 0;
        int rowColY = 0;
        LEFDEF.GetLayerInformation lowMetalLayer = null;
        LEFDEF.GetLayerInformation highMetalLayer = null;
        LEFDEF.GetLayerInformation viaLayer = null;
        while (true) {
            if ((key = this.mustGetKeyword("VIA", cell)) == null) {
                return true;
            }
            if (key.equals("+")) {
                double cY;
                Point2D ll;
                key = this.mustGetKeyword("VIA", cell);
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("CUTSIZE")) {
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    cutSizeX = this.convertDEFString(key);
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    cutSizeY = this.convertDEFString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("CUTSPACING")) {
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    cutSpacingX = this.convertDEFString(key);
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    cutSpacingY = this.convertDEFString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("ENCLOSURE")) {
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    leftEnclosure = this.convertDEFString(key);
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    bottomEnclosure = this.convertDEFString(key);
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    rightEnclosure = this.convertDEFString(key);
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    topEnclosure = this.convertDEFString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("ROWCOL")) {
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    rowColX = TextUtils.atoi(key);
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    rowColY = TextUtils.atoi(key);
                    continue;
                }
                if (key.equalsIgnoreCase("LAYERS")) {
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    lowMetalLayer = this.getLayerInformation(key);
                    if (lowMetalLayer.pure == null) {
                        this.reportError("Layer " + key + " not found", cell);
                        return true;
                    }
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    viaLayer = this.getLayerInformation(key);
                    if (viaLayer.pure == null) {
                        this.reportError("Layer " + key + " not found", cell);
                        return true;
                    }
                    key = this.mustGetKeyword("VIA", cell);
                    if (key == null) {
                        return true;
                    }
                    highMetalLayer = this.getLayerInformation(key);
                    if (highMetalLayer.pure != null) continue;
                    this.reportError("Layer " + key + " not found", cell);
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.mustGetKeyword("VIA", cell);
                if (key == null) {
                    return true;
                }
                LEFDEF.GetLayerInformation li = this.getLayerInformation(key);
                if (li.pure == null) {
                    this.reportError("Layer " + key + " not found", cell);
                    return true;
                }
                if (li.layerFun.isMetal()) {
                    if (vd.gLay1 == null) {
                        vd.gLay1 = li;
                    } else {
                        vd.gLay2 = li;
                    }
                }
                if ((ll = this.readCoordinate(cell)) == null) {
                    return true;
                }
                Point2D ur = this.readCoordinate(cell);
                if (ur == null) {
                    return true;
                }
                double sX = Math.abs(ll.getX() - ur.getX());
                double sY = Math.abs(ll.getY() - ur.getY());
                double cX = (ll.getX() + ur.getX()) / 2.0;
                ni = this.makeNode(li.pure, EPoint.fromLambda(cX, cY = (ll.getY() + ur.getY()) / 2.0), sX, sY, cell);
                if (ni != null) continue;
                return true;
            }
            if (key.equals(";")) break;
        }
        if (rowColX > 0 && rowColY > 0 && lowMetalLayer != null && highMetalLayer != null && viaLayer != null) {
            double cutsWidth = (double)rowColX * cutSizeX + (double)(rowColX - 1) * cutSpacingX;
            double cutsHeight = (double)rowColY * cutSizeY + (double)(rowColY - 1) * cutSpacingY;
            for (int x2 = 0; x2 < rowColX; ++x2) {
                for (int y = 0; y < rowColY; ++y) {
                    double xP = -cutsWidth / 2.0 + (double)x2 * (cutSizeX + cutSpacingX) + cutSizeX / 2.0;
                    double yP = -cutsHeight / 2.0 + (double)y * (cutSizeY + cutSpacingY) + cutSizeY / 2.0;
                    ni = this.makeNode(viaLayer.pure, EPoint.fromLambda(xP, yP), cutSizeX, cutSizeY, cell);
                    if (ni != null) continue;
                    return true;
                }
            }
            double sX = cutsWidth + leftEnclosure + rightEnclosure;
            double sY = cutsHeight + topEnclosure + bottomEnclosure;
            double cX = (rightEnclosure - leftEnclosure) / 2.0;
            double cY = (topEnclosure - bottomEnclosure) / 2.0;
            EPoint metCtr = EPoint.fromLambda(cX, cY);
            ni = this.makeNode(lowMetalLayer.pure, metCtr, sX, sY, cell);
            if (ni == null) {
                return true;
            }
            ni = this.makeNode(highMetalLayer.pure, metCtr, sX, sY, cell);
            if (ni == null) {
                return true;
            }
        }
        if (vd.gLay1 != null && vd.gLay2 != null) {
            String[] preferredArcs = new String[]{vd.gLay1.arc.getFullName(), vd.gLay2.arc.getFullName()};
            e.newVar(Export.EXPORT_PREFERRED_ARCS, (Object)preferredArcs, this.ep);
        }
        vd.sX = vd.via.getDefWidth(this.ep);
        vd.sY = vd.via.getDefHeight(this.ep);
        return false;
    }

    private boolean readUnits(Cell cell) throws IOException {
        String key = this.mustGetKeyword("UNITS", cell);
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("DISTANCE")) {
            this.reportError("Expected 'DISTANCE' after 'UNITS'", cell);
            return true;
        }
        key = this.mustGetKeyword("UNITS", cell);
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("MICRONS")) {
            this.reportError("Expected 'MICRONS' after 'UNITS'", cell);
            return true;
        }
        key = this.mustGetKeyword("UNITS", cell);
        if (key == null) {
            return true;
        }
        this.scaleUnits = TextUtils.atof(key) * this.localPrefs.overallscale;
        return this.ignoreToSemicolon("UNITS", cell);
    }

    private boolean ignoreToSemicolon(String command, Cell cell) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command, cell)) != null) continue;
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private boolean ignoreBlock(String command, Cell cell) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command, cell)) != null) continue;
            return true;
        } while (!key.equalsIgnoreCase("END"));
        this.getAKeyword();
        return false;
    }

    private Point2D readCoordinate(Cell cell) throws IOException {
        String key = this.mustGetKeyword("coordinate", cell);
        if (key == null) {
            return null;
        }
        if (!key.equals("(")) {
            this.reportError("Expected '(' in coordinate", cell);
            return null;
        }
        key = this.mustGetKeyword("coordinate", cell);
        if (key == null) {
            return null;
        }
        double x2 = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate", cell);
        if (key == null) {
            return null;
        }
        double y = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate", cell);
        if (key == null) {
            return null;
        }
        if (TextUtils.isANumber(key) && (key = this.mustGetKeyword("coordinate", cell)) == null) {
            return null;
        }
        if (!key.equals(")")) {
            this.reportError("Expected ')' in coordinate", cell);
            return null;
        }
        return new Point2D.Double(x2, y);
    }

    private String mustGetKeyword(String where, Cell cell) throws IOException {
        String key = this.getAKeyword();
        if (key == null) {
            this.reportError("EOF parsing " + where + " at line " + this.lineReader.getLineNumber(), cell);
        }
        return key;
    }

    private double convertDEFString(String key) {
        double v = TextUtils.atof(key) / this.scaleUnits;
        return TextUtils.convertFromDistance(v, this.curTech, TextUtils.UnitScale.MICRO);
    }

    private void reportError(String command, Cell cell) {
        String msg = "Error on line " + this.lineReader.getLineNumber() + ": " + command;
        System.out.println(msg);
        errorLogger.logError(msg, cell, 0);
    }

    private void reportWarning(String command, Cell cell) {
        String msg = "Warning on line " + this.lineReader.getLineNumber() + ": " + command;
        System.out.println(msg);
        errorLogger.logWarning(msg, cell, 0);
    }

    private void reportWarning(String command, Geometric geom, Cell cell) {
        String msg = "Warning on line " + this.lineReader.getLineNumber() + ": " + command;
        System.out.println(msg);
        errorLogger.logWarning(msg, geom, cell, null, 0);
    }

    private Cell getNodeProto(String name, Library curlib, Cell parent) {
        CellName cn = this.schImport ? CellName.newName(name, View.ICON, 0) : CellName.newName(name, parent.getView(), 0);
        Cell cell = curlib.findNodeProto(cn.toString());
        if (cell != null) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Cell getNodeProto(String name, Library curlib) {
        Cell cell = curlib.findNodeProto(name);
        if (cell != null) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Orientation FetchOrientation(Cell cell) throws IOException {
        int angle;
        String key = this.mustGetKeyword("orientation", cell);
        if (key == null) {
            return null;
        }
        boolean transpose2 = false;
        if (key.equalsIgnoreCase("N")) {
            angle = 0;
        } else if (key.equalsIgnoreCase("S")) {
            angle = 1800;
        } else if (key.equalsIgnoreCase("E")) {
            angle = 2700;
        } else if (key.equalsIgnoreCase("W")) {
            angle = 900;
        } else if (key.equalsIgnoreCase("FN")) {
            angle = 900;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FS")) {
            angle = 2700;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FE")) {
            angle = 1800;
            transpose2 = true;
        } else if (key.equalsIgnoreCase("FW")) {
            angle = 0;
            transpose2 = true;
        } else {
            this.reportError("Unknown orientation (" + key + ")", cell);
            return null;
        }
        return Orientation.fromC(angle, transpose2);
    }

    private boolean acceptNode(EPoint loc, double sX, double sY) {
        return true;
    }

    private NodeInst makeNodeMoreInfo(NodeProto np, EPoint loc, double sX, double sY, Cell cell, Orientation or, String name) {
        NodeInst ni = cell.findNode(name);
        if (ni != null) {
            return ni;
        }
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(loc.getX(), loc.getY(), 0.0, 0.0);
        Iterator<Geometric> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Geometric geom = it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != np) continue;
            ERectangle bound = ni.getBounds();
            double expectedX = bound.getMinX();
            double expectedY = bound.getMinY();
            if (np instanceof Cell) {
                expectedX -= ((Cell)np).getBounds().getMinX();
                expectedY -= ((Cell)np).getBounds().getMinY();
            }
            if (expectedX != loc.getX() || expectedY != loc.getY()) continue;
            if (Job.getDebug()) {
                System.out.println("Replacing previous name of " + np.describe(false) + " instance '" + ni.getName() + "' by '" + name + "'");
            }
            ni.setName(name);
            return ni;
        }
        ni = NodeInst.makeInstance(np, this.ep, loc, sX, sY, cell, or, name);
        if (ni == null) {
            this.reportError("Unable to create node", cell);
            return null;
        }
        if (np instanceof Cell) {
            Cell subCell = (Cell)np;
            ERectangle bound = ni.getBounds();
            double diffX = loc.getX() - bound.getMinX() + subCell.getBounds().getMinX();
            double diffY = loc.getY() - bound.getMinY() + subCell.getBounds().getMinY();
            if (diffX != 0.0 || diffY != 0.0) {
                ni.move(diffX, diffY);
            }
        }
        return ni;
    }

    private NodeInst makeNode(NodeProto np, EPoint loc, double sX, double sY, Cell cell) {
        NodeInst ni = NodeInst.makeInstance(np, this.ep, loc, sX, sY, cell);
        if (ni == null) {
            this.reportError("Unable to create node", cell);
            return null;
        }
        return ni;
    }

    private boolean makeUnroutedConnection(PortInst pi1, PortInst pi2, String name) {
        ArcInst ai;
        AbstractFixpPoint pt2;
        Poly poly2;
        AbstractFixpPoint pt1;
        if (pi1 == null || pi2 == null) {
            return false;
        }
        Poly poly1 = pi1.getPoly();
        if (!poly1.isInside(pt1 = poly1.getCenter())) {
            PolyBase.Point[] pts = poly1.getPoints();
            pt1 = pts[0];
        }
        if (!(poly2 = pi2.getPoly()).isInside(pt2 = poly2.getCenter())) {
            PolyBase.Point[] pts = poly2.getPoints();
            pt2 = pts[0];
        }
        if ((ai = ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, pi1, pi2, pt1, pt2, name)) == null) {
            Cell cell = pi1.getNodeInst().getParent();
            System.out.println("Warning: could not create unrouted arc from (" + ((Point2D)pt1).getX() + "," + ((Point2D)pt1).getY() + ") to (" + ((Point2D)pt2).getX() + "," + ((Point2D)pt2).getY() + ") in cell " + cell.describe(false) + ", ignoring coordinates");
            ai = ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, pi1, pi2);
            if (ai == null) {
                this.reportError("Could not create unrouted arc from port " + pi1.getPortProto().getName() + " of node " + pi1.getNodeInst().describe(false) + " to port " + pi2.getPortProto().getName() + " of node " + pi2.getNodeInst().describe(false), cell);
                return true;
            }
            ai.setName(name, this.ep);
        }
        return false;
    }

    private boolean makeConnection(Cell cell, ArcProto ap, double width, PortInst pi1, PortInst pi2, EPoint pt1, EPoint pt2, String name) {
        if (pi1 == null || pi2 == null) {
            return false;
        }
        long gridExtendOverMin = DBMath.lambdaToGrid(0.5 * width) - ap.getBaseExtend().getGrid();
        TextDescriptor nameDescriptor = this.ep.getArcTextDescriptor();
        ArcInst ai = ArcInst.newInstanceNoCheck(cell, ap, name, nameDescriptor, pi1, pi2, pt1, pt2, gridExtendOverMin, -1, ImmutableArcInst.DEFAULT_FLAGS);
        if (ai == null) {
            this.reportError("Could not create arc", cell);
            return true;
        }
        return false;
    }

    private LEFDEF.ViaDef findViaDef(String key) {
        if (key.equals(";")) {
            return null;
        }
        String lcName = key.toLowerCase();
        LEFDEF.ViaDef vd = this.allViaDefs.get(lcName);
        if (vd != null) {
            return vd;
        }
        if (viaDefsFromLEF != null && (vd = (LEFDEF.ViaDef)viaDefsFromLEF.get(lcName)) != null) {
            return vd;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Cell cell;
            Library lib = it.next();
            if (lib.isHidden() || (cell = lib.findNodeProto(key)) == null) continue;
            LEFDEF.ViaDef vDef = new LEFDEF.ViaDef(key, cell);
            this.allViaDefs.put(lcName, vDef);
            vDef.sX = cell.getBounds().getWidth();
            vDef.sY = cell.getBounds().getHeight();
            if (cell.getNumPorts() > 0) {
                Export e = cell.getPort(0);
                Variable var = e.getVar(Export.EXPORT_PREFERRED_ARCS);
                if (var != null) {
                    String[] preferredArcs = (String[])var.getObject();
                    vDef.gLay1 = this.getLayerInformation(preferredArcs[0]);
                    vDef.gLay2 = this.getLayerInformation(preferredArcs[1]);
                } else {
                    ArcProto[] cons = e.getBasePort().getConnections();
                    for (int i = 0; i < cons.length; ++i) {
                        if (cons[i].getTechnology() == Generic.tech()) continue;
                        if (vDef.gLay1 == null) {
                            vDef.gLay1 = this.getLayerInformation(cons[i].getName());
                            continue;
                        }
                        if (vDef.gLay2 != null) continue;
                        vDef.gLay2 = this.getLayerInformation(cons[i].getName());
                    }
                }
            }
            return vDef;
        }
        return null;
    }

    private void initNets() {
        this.portHT = new HashMap<Double, List<NodeInst>>();
    }

    private PortInst findConnection(double x2, double y, ArcProto ap, Cell cell, NodeInst noti) {
        Double key = new Double(x2 + y);
        List<NodeInst> pl = this.portHT.get(key);
        if (pl != null) {
            Point2D.Double pt = new Point2D.Double(x2, y);
            for (NodeInst ni : pl) {
                if (ni == noti) continue;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    Poly poly;
                    PortInst pi = it.next();
                    if (!pi.getPortProto().connectsTo(ap) || !(poly = pi.getPoly()).isInside(pt)) continue;
                    return pi;
                }
            }
        }
        return null;
    }

    private PortInst getPin(double x2, double y, LEFDEF.GetLayerInformation li, Cell cell) {
        PortInst pi = this.findConnection(x2, y, li.arc, cell, null);
        if (pi != null) {
            return pi;
        }
        NodeProto pin = li.pin;
        double sX = pin.getDefWidth(this.ep);
        double sY = pin.getDefHeight(this.ep);
        NodeInst ni = this.makeNode(pin, EPoint.fromLambda(x2, y), sX, sY, cell);
        if (ni == null) {
            return null;
        }
        pi = ni.getOnlyPortInst();
        Double key = new Double(x2 + y);
        List<NodeInst> pl = this.portHT.get(key);
        if (pl == null) {
            pl = new ArrayList<NodeInst>();
            this.portHT.put(key, pl);
        }
        pl.add(ni);
        return pi;
    }

    private String translateDefName(String name) {
        int quotedBracketPos = name.indexOf("\\[");
        if (quotedBracketPos >= 0) {
            name = name.replaceAll("\\\\\\[", "_").replaceAll("\\\\\\]", "_");
        }
        Matcher m_starleftbracket = this.pat_starleftbracket.matcher(name);
        Matcher m_starrightbracket = this.pat_starrightbracket.matcher(name);
        if (m_starleftbracket.matches() || m_starrightbracket.matches()) {
            Matcher m_leftbracket = this.pat_leftbracket.matcher(name);
            String tmpa = m_leftbracket.replaceAll("[");
            Matcher m_rightbracket = this.pat_rightbracket.matcher(tmpa);
            String tmpb = m_rightbracket.replaceAll("]");
            return tmpb;
        }
        return name;
    }

    private static class PortInstBound
    implements RTBounds {
        private final PortInst pi;
        private final FixpRectangle bound;

        PortInstBound(PortInst p, FixpRectangle b) {
            this.pi = p;
            this.bound = b;
        }

        @Override
        public FixpRectangle getBounds() {
            return this.bound;
        }
    }

    private class GetOrientation {
        private Orientation orient;

        private GetOrientation(Cell cell) throws IOException {
            int angle;
            String key = DEF.this.mustGetKeyword("orientation", cell);
            if (key == null) {
                return;
            }
            boolean transpose2 = false;
            if (key.equalsIgnoreCase("N")) {
                angle = 0;
            } else if (key.equalsIgnoreCase("S")) {
                angle = 1800;
            } else if (key.equalsIgnoreCase("E")) {
                angle = 2700;
            } else if (key.equalsIgnoreCase("W")) {
                angle = 900;
            } else if (key.equalsIgnoreCase("FN")) {
                angle = 900;
                transpose2 = true;
            } else if (key.equalsIgnoreCase("FS")) {
                angle = 2700;
                transpose2 = true;
            } else if (key.equalsIgnoreCase("FE")) {
                angle = 1800;
                transpose2 = true;
            } else if (key.equalsIgnoreCase("FW")) {
                angle = 0;
                transpose2 = true;
            } else {
                DEF.this.reportError("Unknown orientation (" + key + ")", cell);
                return;
            }
            this.orient = Orientation.fromC(angle, transpose2);
        }
    }

    public static class DEFPreferences
    extends Input.InputPreferences {
        public boolean physicalPlacement;
        public boolean ignorePhysicalInNets;
        public boolean usePureLayerNodes;
        public boolean logicalPlacement;
        public boolean ignoreLogicalInSpecialNets;
        public boolean makeDummyCells;
        public boolean ignoreUngeneratedPins;
        public double overallscale = 1.0;

        public DEFPreferences(boolean factory) {
            super(factory);
            if (factory) {
                this.physicalPlacement = IOTool.isFactoryDEFPhysicalPlacement();
                this.ignorePhysicalInNets = IOTool.isFactoryDEFIgnorePhysicalInNets();
                this.usePureLayerNodes = IOTool.isFactoryDEFUsePureLayerNodes();
                this.logicalPlacement = IOTool.isFactoryDEFLogicalPlacement();
                this.ignoreLogicalInSpecialNets = IOTool.isFactoryDEFIgnoreLogicalInSpecialNets();
                this.makeDummyCells = IOTool.isFactoryDEFMakeDummyCells();
                this.ignoreUngeneratedPins = IOTool.isFactoryDEFIgnoreUngeneratedPins();
            } else {
                this.physicalPlacement = IOTool.isDEFPhysicalPlacement();
                this.ignorePhysicalInNets = IOTool.isDEFIgnorePhysicalInNets();
                this.usePureLayerNodes = IOTool.isDEFUsePureLayerNodes();
                this.logicalPlacement = IOTool.isDEFLogicalPlacement();
                this.ignoreLogicalInSpecialNets = IOTool.isDEFIgnoreLogicalInSpecialNets();
                this.makeDummyCells = IOTool.isDEFMakeDummyCells();
                this.ignoreUngeneratedPins = IOTool.isDEFIgnoreUngeneratedPins();
            }
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            DEF in = new DEF(ep, this);
            in.job = job;
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }
}

