/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.ClientJobManager;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CantEditException;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.util.concurrent.debug.Debug;
import com.sun.electric.util.ElapseTimer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job
implements Serializable {
    private static boolean GLOBALDEBUG = false;
    static final int PROTOCOL_VERSION = 20;
    public static boolean LOCALDEBUGFLAG;
    static final Logger logger;
    public static final int MIN_NUM_SECONDS = 60000;
    static ServerJobManager serverJobManager;
    static ClientJobManager clientJobManager;
    static AbstractUserInterface currentUI;
    static Thread clientThread;
    boolean deleteWhenDone;
    public ElapseTimer timer = ElapseTimer.createInstance();
    boolean started;
    public boolean finished;
    boolean aborted;
    boolean scheduledToAbort;
    public boolean reportExecution = false;
    Tool tool;
    final TechId curTechId;
    final LibId curLibId;
    final CellId curCellId;
    transient EJob ejob;
    transient EDatabase database;
    private static final ThreadLocal<UserInterface> threadUserInterface;

    public static boolean getDebug() {
        return GLOBALDEBUG;
    }

    public static void setDebug(boolean f2) {
        GLOBALDEBUG = f2;
        Debug.setDebug(GLOBALDEBUG);
    }

    public static void initJobManager(int numThreads, String loggingFilePath, int socketPort, AbstractUserInterface ui, Job initDatabaseJob) {
        currentUI = ui;
        serverJobManager = new ServerJobManager(numThreads, loggingFilePath, false, socketPort);
        serverJobManager.runLoop(initDatabaseJob);
    }

    public static void pipeServer(int numThreads, String loggingFilePath, int socketPort) {
        Pref.forbidPreferences();
        EDatabase.setServerDatabase(new EDatabase(IdManager.stdIdManager.getInitialSnapshot()));
        Tool.initAllTools();
        serverJobManager = new ServerJobManager(numThreads, loggingFilePath, true, socketPort);
    }

    public static void socketClient(String serverMachineName, int socketPort, AbstractUserInterface ui, Job initDatabaseJob) {
        currentUI = ui;
        try {
            clientJobManager = new ClientJobManager(serverMachineName, socketPort);
            clientJobManager.runLoop(initDatabaseJob);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void pipeClient(Process process, AbstractUserInterface ui, Job initDatabaseJob, boolean skipOneLine) {
        currentUI = ui;
        try {
            clientJobManager = new ClientJobManager(process, skipOneLine);
            clientJobManager.runLoop(initDatabaseJob);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Job(String jobName, Tool tool, Type jobType, Cell upCell, Cell downCell, Priority priority) {
        UserInterface ui = Job.getUserInterface();
        this.ejob = new EJob(this, jobType, jobName, EditingPreferences.getInstance());
        this.database = ui != null ? ui.getDatabase() : EDatabase.clientDatabase();
        this.tool = tool;
        this.deleteWhenDone = true;
        Technology curTech = ui != null ? ui.getCurrentTechnology() : null;
        this.curTechId = curTech != null ? curTech.getId() : null;
        Library curLib = ui != null ? ui.getCurrentLibrary() : null;
        this.curLibId = curLib != null ? curLib.getId() : null;
        Cell curCell = ui != null ? ui.getCurrentCell() : null;
        this.curCellId = curCell != null ? curCell.getId() : null;
    }

    public void startJob() {
        this.startJob(true);
    }

    public void startJobOnMyResult() {
        this.startJob(true, true);
    }

    public void startJob(boolean deleteWhenDone) {
        this.startJob(deleteWhenDone, false);
    }

    private void startJob(boolean deleteWhenDone, boolean onMySnapshot) {
        boolean doItOnServer;
        this.deleteWhenDone = deleteWhenDone;
        UserInterface ui = Job.getUserInterface();
        Key curJobKey = ui.getJobKey();
        boolean startedByServer = curJobKey.doItOnServer;
        boolean bl = doItOnServer = this.ejob.jobType != Type.CLIENT_EXAMINE;
        if (startedByServer) {
            assert (doItOnServer);
            this.ejob.client = Job.serverJobManager.serverConnections.get(curJobKey.clientId);
            this.ejob.jobKey = this.ejob.client.newJobId(startedByServer, doItOnServer);
            this.timer.start();
            this.ejob.serialize(EDatabase.serverDatabase());
            this.ejob.clientJob = null;
            serverJobManager.addJob(this.ejob, onMySnapshot);
        } else {
            this.ejob.client = currentUI;
            this.ejob.jobKey = this.ejob.client.newJobId(startedByServer, doItOnServer);
            this.timer.start();
            this.ejob.serverJob = null;
            if (doItOnServer) {
                this.ejob.serialize(EDatabase.clientDatabase());
                currentUI.putProcessingEJob(this.ejob, onMySnapshot);
                if (serverJobManager != null) {
                    serverJobManager.addJob(this.ejob, onMySnapshot);
                } else {
                    assert (SwingUtilities.isEventDispatchThread());
                    try {
                        clientJobManager.writeEJob(this.ejob);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                currentUI.putProcessingEJob(this.ejob, onMySnapshot);
            }
        }
    }

    protected void showSnapshot() {
        assert (this.ejob.jobType == Type.CHANGE);
        EThread thread = (EThread)Thread.currentThread();
        assert (thread.isServerThread);
        assert (thread.ejob == this.ejob);
        Snapshot snapshot = EDatabase.serverDatabase().backup();
        Client.fireServerEvent(new Client.SnapshotEvent(snapshot));
    }

    protected void fieldVariableChanged(String variableName) {
        this.ejob.fieldVariableChanged(variableName);
    }

    public abstract boolean doIt() throws JobException;

    public void terminateIt(Throwable jobException) {
        if (jobException == null) {
            this.terminateOK();
        } else {
            this.terminateFail(jobException);
        }
    }

    public void terminateOK() {
    }

    public void terminateFail(Throwable jobException) {
        if (jobException instanceof CantEditException) {
            ((CantEditException)jobException).presentProblem();
        } else if (jobException instanceof JobException) {
            String message = jobException.getMessage();
            if (message == null) {
                message = "Job " + this.ejob.jobName + " failed";
            }
            System.out.println(message);
        } else {
            ActivityLogger.logException(jobException);
        }
    }

    protected void setReportExecutionFlag(boolean flag) {
        this.reportExecution = flag;
    }

    protected synchronized void setProgress(String progress) {
        if (serverJobManager != null) {
            serverJobManager.setProgress(this.ejob, progress);
        } else {
            this.ejob.progress = progress;
        }
    }

    private synchronized String getProgress() {
        return this.ejob.progress;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void abort() {
        if (this.aborted) {
            System.out.println("Job already aborted: " + this.getStatus());
            return;
        }
        this.scheduledToAbort = true;
        if (this.ejob.jobType != Type.CLIENT_EXAMINE && this.ejob.serverJob != null) {
            this.ejob.serverJob.scheduledToAbort = true;
        }
    }

    private synchronized void setAborted() {
        this.aborted = true;
    }

    protected synchronized boolean getScheduledToAbort() {
        return this.scheduledToAbort;
    }

    private synchronized boolean getAborted() {
        return this.aborted;
    }

    public boolean getDeleteWhenDone() {
        return this.deleteWhenDone;
    }

    public boolean checkAbort() {
        if (this.getAborted()) {
            return true;
        }
        boolean scheduledAbort = this.getScheduledToAbort();
        if (scheduledAbort) {
            System.out.println(this + ": aborted");
            this.setReportExecutionFlag(true);
            this.setAborted();
        }
        return scheduledAbort;
    }

    public static Iterator<Job> getAllJobs() {
        return serverJobManager != null ? serverJobManager.getAllJobs() : currentUI.getAllJobs().iterator();
    }

    public static Job getRunningJob() {
        Thread thread = Thread.currentThread();
        return thread instanceof EThread ? ((EThread)thread).getRunningJob() : null;
    }

    public static boolean inServerThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof EThread && ((EThread)thread).isServerThread;
    }

    public static void setCurrentLibraryInJob(Library lib) {
        EThread thread = (EThread)Thread.currentThread();
        assert (thread.ejob.jobType == Type.CHANGE);
        thread.userInterface.curLibId = lib != null ? lib.getId() : null;
    }

    public String getStatus() {
        switch (this.ejob.state) {
            case WAITING: {
                return "waiting";
            }
            case RUNNING: {
                return this.getProgress() == null ? "running" : this.getProgress();
            }
            case SERVER_DONE: {
                return this.getProgress() == null ? "done" : this.getProgress();
            }
            case CLIENT_DONE: {
                return "cdone";
            }
        }
        if (!this.started) {
            return "waiting";
        }
        if (this.aborted) {
            return "aborted";
        }
        if (this.finished) {
            return "done";
        }
        if (this.scheduledToAbort) {
            return "scheduled to abort";
        }
        if (this.getProgress() == null) {
            return "running";
        }
        return this.getProgress();
    }

    public boolean remove() {
        if (!this.finished && !this.aborted) {
            return false;
        }
        if (serverJobManager != null) {
            serverJobManager.removeJob(this);
        } else {
            currentUI.removeProcessingEJob(this.getKey());
        }
        return true;
    }

    public static UserInterface getUserInterface() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof EThread) {
            return ((EThread)currentThread).getUserInterface();
        }
        if (currentThread == clientThread) {
            return currentUI;
        }
        return threadUserInterface.get();
    }

    public static void setUserInterface(UserInterface ui) {
        Thread currentThread = Thread.currentThread();
        assert (!(currentThread instanceof EThread) && currentThread != clientThread);
        if (ui == null) {
            throw new UnsupportedOperationException();
        }
        threadUserInterface.set(ui);
    }

    public static AbstractUserInterface getExtendedUserInterface() {
        return currentUI;
    }

    public static boolean isClientThread() {
        return Thread.currentThread() == clientThread;
    }

    public EDatabase getDatabase() {
        return this.database;
    }

    public Environment getEnvironment() {
        return this.database.getEnvironment();
    }

    public TechPool getTechPool() {
        return this.database.getTechPool();
    }

    public Tool getTool() {
        return this.tool;
    }

    public EditingPreferences getEditingPreferences() {
        return this.ejob.editingPreferences;
    }

    public static void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        if (currentUI != null) {
            currentUI.updateNetworkErrors(cell, errors);
        }
    }

    public static void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        currentUI.updateIncrementalDRCErrors(cell, newErrors, delErrors);
    }

    public static Snapshot findValidSnapshot() {
        return EThread.findValidSnapshot();
    }

    public String toString() {
        return this.ejob.jobName + " (" + this.getStatus() + ")";
    }

    public static void error(boolean errorHasOccurred, String msg) {
        if (!errorHasOccurred) {
            return;
        }
        RuntimeException e = new RuntimeException(msg);
        ActivityLogger.logException(e);
        throw e;
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Job " + this.toString());
        if (this.finished) {
            buf.append(" took: " + this.timer);
            Date start = new Date(this.timer.getStart());
            Date end = new Date(this.timer.getEnd());
            buf.append(" (started at " + start + ", ended at " + end + " )");
        } else if (this.getProgress() == null) {
            buf.append(" has not finished. Current running time: " + this.timer);
        } else {
            buf.append(" did not successfully finish.");
        }
        return buf.toString();
    }

    public Key getKey() {
        return this.ejob.jobKey;
    }

    public Inform getInform() {
        return new Inform(this);
    }

    public boolean isExamine() {
        return this.ejob.isExamine();
    }

    static {
        logger = LoggerFactory.getLogger(Job.class);
        threadUserInterface = new ThreadLocal<UserInterface>(){};
    }

    public static class Inform
    implements Serializable {
        private final Key jobKey;
        private final boolean isChange;
        private final String toString;
        private final int finished;
        private ElapseTimer timer;

        Inform(Job job) {
            this.jobKey = job.getKey();
            this.isChange = job.ejob.jobType == Type.CHANGE || job.ejob.jobType == Type.UNDO;
            this.toString = job.toString();
            this.timer = job.timer;
            this.finished = job.finished ? 1 : (job.getProgress() == null ? 0 : -1);
        }

        Inform(Key jobKey, boolean isChange, String toString2, ElapseTimer timer, int finished) {
            this.jobKey = jobKey;
            this.isChange = isChange;
            this.toString = toString2;
            this.timer = timer;
            this.finished = finished;
        }

        public void abort() {
            Iterator<Job> it = Job.getAllJobs();
            while (it.hasNext()) {
                Job job = it.next();
                if (!job.getKey().equals(this.jobKey)) continue;
                job.abort();
                break;
            }
        }

        public boolean remove() {
            return false;
        }

        public Key getKey() {
            return this.jobKey;
        }

        public String toString() {
            return this.toString;
        }

        public String getInfo() {
            StringBuilder buf = new StringBuilder();
            buf.append("Job " + this.toString());
            if (this.finished == 1) {
                buf.append(" took: " + this.timer);
                Date start = new Date(this.timer.getStart());
                buf.append(" (started at " + start + ")");
            } else if (this.finished == 0) {
                buf.append(" has not finished. Current running time: " + this.timer.currentTimeString());
            } else {
                buf.append(" did not successfully finish.");
            }
            return buf.toString();
        }

        public boolean isChangeJobQueuedOrRunning() {
            return this.finished != 1 && this.isChange;
        }

        public void write(IdWriter writer) throws IOException {
            this.jobKey.write(writer);
            writer.writeBoolean(this.isChange);
            writer.writeString(this.toString);
            writer.writeLong(this.timer.getStart());
            writer.writeLong(this.timer.getEnd());
            writer.writeInt(this.finished);
        }

        public static Inform read(IdReader reader) throws IOException {
            Key jobKey = Key.read(reader);
            boolean isChange = reader.readBoolean();
            String toString2 = reader.readString();
            long startTime = reader.readLong();
            long endTime = reader.readLong();
            ElapseTimer timer = ElapseTimer.createInstanceByValues(startTime, endTime);
            int finished = reader.readInt();
            return new Inform(jobKey, isChange, toString2, timer, finished);
        }
    }

    public static class Key
    implements Serializable {
        public final int clientId;
        public final int jobId;
        public final boolean doItOnServer;

        Key(int clientId, int jobId, boolean doItOnServer) {
            this.clientId = clientId;
            this.jobId = jobId;
            this.doItOnServer = doItOnServer;
        }

        Key(Client client, int jobId, boolean doItOnServer) {
            this(client.connectionId, jobId, doItOnServer);
        }

        public boolean startedByServer() {
            return this.jobId > 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Key) {
                Key that = (Key)o;
                if (this.clientId == that.clientId && this.jobId == that.jobId) {
                    assert (this.doItOnServer == that.doItOnServer);
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.jobId;
        }

        public void write(IdWriter writer) throws IOException {
            writer.writeInt(this.clientId);
            writer.writeInt(this.jobId);
            writer.writeBoolean(this.doItOnServer);
        }

        public static Key read(IdReader reader) throws IOException {
            int clientId = reader.readInt();
            int jobId = reader.readInt();
            boolean doItOnServer = reader.readBoolean();
            return new Key(clientId, jobId, doItOnServer);
        }
    }

    public static enum Priority {
        USER,
        VISCHANGES,
        INVISCHANGES,
        ANALYSIS;

    }

    public static enum Type {
        CHANGE,
        UNDO,
        SERVER_EXAMINE,
        CLIENT_EXAMINE;


        public boolean isExamine() {
            return this == CLIENT_EXAMINE || this == SERVER_EXAMINE;
        }
    }
}

