/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.index.mapper.AllFieldMapper;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BooleanFieldMapper;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.IpFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParentFieldMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.mapper.UidFieldMapper;
import org.elasticsearch.index.mapper.VersionFieldMapper;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.plugins.MapperPlugin;

public class IndicesModule
extends AbstractModule {
    private final List<NamedWriteableRegistry.Entry> namedWritables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final MapperRegistry mapperRegistry;

    public IndicesModule(List<MapperPlugin> mapperPlugins) {
        this.mapperRegistry = new MapperRegistry(this.getMappers(mapperPlugins), this.getMetadataMappers(mapperPlugins));
        this.registerBuiltinWritables();
    }

    private void registerBuiltinWritables() {
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_age", MaxAgeCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_docs", MaxDocsCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_size", MaxSizeCondition::new));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWritables;
    }

    private Map<String, Mapper.TypeParser> getMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, Mapper.TypeParser> mappers = new LinkedHashMap<String, Mapper.TypeParser>();
        for (NumberFieldMapper.NumberType numberType : NumberFieldMapper.NumberType.values()) {
            mappers.put(numberType.typeName(), new NumberFieldMapper.TypeParser(numberType));
        }
        for (Enum enum_ : RangeFieldMapper.RangeType.values()) {
            mappers.put(((RangeFieldMapper.RangeType)enum_).typeName(), new RangeFieldMapper.TypeParser((RangeFieldMapper.RangeType)enum_));
        }
        mappers.put("boolean", new BooleanFieldMapper.TypeParser());
        mappers.put("binary", new BinaryFieldMapper.TypeParser());
        mappers.put("date", new DateFieldMapper.TypeParser());
        mappers.put("ip", new IpFieldMapper.TypeParser());
        mappers.put("text", new TextFieldMapper.TypeParser());
        mappers.put("keyword", new KeywordFieldMapper.TypeParser());
        mappers.put("object", new ObjectMapper.TypeParser());
        mappers.put("nested", new ObjectMapper.TypeParser());
        mappers.put("completion", new CompletionFieldMapper.TypeParser());
        mappers.put("geo_point", new GeoPointFieldMapper.TypeParser());
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            mappers.put("geo_shape", new GeoShapeFieldMapper.TypeParser());
        }
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, Mapper.TypeParser> entry : mapperPlugin.getMappers().entrySet()) {
                if (mappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Mapper [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(mappers);
    }

    private Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        metadataMappers.put("_uid", new UidFieldMapper.TypeParser());
        metadataMappers.put("_id", new IdFieldMapper.TypeParser());
        metadataMappers.put("_routing", new RoutingFieldMapper.TypeParser());
        metadataMappers.put("_index", new IndexFieldMapper.TypeParser());
        metadataMappers.put("_source", new SourceFieldMapper.TypeParser());
        metadataMappers.put("_type", new TypeFieldMapper.TypeParser());
        metadataMappers.put("_all", new AllFieldMapper.TypeParser());
        metadataMappers.put("_version", new VersionFieldMapper.TypeParser());
        metadataMappers.put("_parent", new ParentFieldMapper.TypeParser());
        metadataMappers.put("_seq_no", new SeqNoFieldMapper.TypeParser());
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperPlugin.getMetadataMappers().entrySet()) {
                if (entry.getKey().equals("_field_names")) {
                    throw new IllegalArgumentException("Plugin cannot contain metadata mapper [_field_names]");
                }
                if (metadataMappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("MetadataFieldMapper [" + entry.getKey() + "] is already registered");
            }
        }
        metadataMappers.put("_field_names", new FieldNamesFieldMapper.TypeParser());
        return Collections.unmodifiableMap(metadataMappers);
    }

    @Override
    protected void configure() {
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(SyncedFlushService.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetaData.class).asEagerSingleton();
        this.bind(GlobalCheckpointSyncAction.class).asEagerSingleton();
        this.bind(TransportResyncReplicationAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.class).asEagerSingleton();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }
}

