/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.store.StoreFileMetaData;

public class BlobStoreIndexShardSnapshot
implements ToXContentFragment {
    private final String snapshot;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int numberOfFiles;
    private final long totalSize;
    private final List<FileInfo> indexFiles;
    private static final String NAME = "name";
    private static final String INDEX_VERSION = "index_version";
    private static final String START_TIME = "start_time";
    private static final String TIME = "time";
    private static final String NUMBER_OF_FILES = "number_of_files";
    private static final String TOTAL_SIZE = "total_size";
    private static final String FILES = "files";
    private static final ParseField PARSE_NAME = new ParseField("name", new String[0]);
    private static final ParseField PARSE_INDEX_VERSION = new ParseField("index_version", "index-version");
    private static final ParseField PARSE_START_TIME = new ParseField("start_time", new String[0]);
    private static final ParseField PARSE_TIME = new ParseField("time", new String[0]);
    private static final ParseField PARSE_NUMBER_OF_FILES = new ParseField("number_of_files", new String[0]);
    private static final ParseField PARSE_TOTAL_SIZE = new ParseField("total_size", new String[0]);
    private static final ParseField PARSE_FILES = new ParseField("files", new String[0]);

    public BlobStoreIndexShardSnapshot(String snapshot, long indexVersion, List<FileInfo> indexFiles, long startTime, long time, int numberOfFiles, long totalSize) {
        assert (snapshot != null);
        assert (indexVersion >= 0L);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.indexFiles = Collections.unmodifiableList(new ArrayList<FileInfo>(indexFiles));
        this.startTime = startTime;
        this.time = time;
        this.numberOfFiles = numberOfFiles;
        this.totalSize = totalSize;
    }

    private BlobStoreIndexShardSnapshot() {
        this.snapshot = "";
        this.indexVersion = 0L;
        this.indexFiles = Collections.emptyList();
        this.startTime = 0L;
        this.time = 0L;
        this.numberOfFiles = 0;
        this.totalSize = 0L;
    }

    public long indexVersion() {
        return this.indexVersion;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public List<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NAME, this.snapshot);
        builder.field(INDEX_VERSION, this.indexVersion);
        builder.field(START_TIME, this.startTime);
        builder.field(TIME, this.time);
        builder.field(NUMBER_OF_FILES, this.numberOfFiles);
        builder.field(TOTAL_SIZE, this.totalSize);
        builder.startArray(FILES);
        for (FileInfo fileInfo : this.indexFiles) {
            FileInfo.toXContent(fileInfo, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static BlobStoreIndexShardSnapshot fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String snapshot = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int numberOfFiles = 0;
        long totalSize = 0L;
        ArrayList<FileInfo> indexFiles = new ArrayList<FileInfo>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if ((token = parser.currentToken()) == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if (PARSE_NAME.match(currentFieldName)) {
                            snapshot = parser.text();
                            continue;
                        }
                        if (PARSE_INDEX_VERSION.match(currentFieldName)) {
                            indexVersion = parser.longValue();
                            continue;
                        }
                        if (PARSE_START_TIME.match(currentFieldName)) {
                            startTime = parser.longValue();
                            continue;
                        }
                        if (PARSE_TIME.match(currentFieldName)) {
                            time = parser.longValue();
                            continue;
                        }
                        if (PARSE_NUMBER_OF_FILES.match(currentFieldName)) {
                            numberOfFiles = parser.intValue();
                            continue;
                        }
                        if (PARSE_TOTAL_SIZE.match(currentFieldName)) {
                            totalSize = parser.longValue();
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if (PARSE_FILES.match(currentFieldName)) {
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                indexFiles.add(FileInfo.fromXContent(parser));
                            }
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                    }
                    throw new ElasticsearchParseException("unexpected token  [{}]", new Object[]{token});
                }
                throw new ElasticsearchParseException("unexpected token [{}]", new Object[]{token});
            }
        }
        return new BlobStoreIndexShardSnapshot(snapshot, indexVersion, Collections.unmodifiableList(indexFiles), startTime, time, numberOfFiles, totalSize);
    }

    public static class FileInfo {
        private static final String UNKNOWN_CHECKSUM = "_na_";
        private final String name;
        private final ByteSizeValue partSize;
        private final long partBytes;
        private final long numberOfParts;
        private final StoreFileMetaData metadata;
        static final String NAME = "name";
        static final String PHYSICAL_NAME = "physical_name";
        static final String LENGTH = "length";
        static final String CHECKSUM = "checksum";
        static final String PART_SIZE = "part_size";
        static final String WRITTEN_BY = "written_by";
        static final String META_HASH = "meta_hash";

        public FileInfo(String name, StoreFileMetaData metaData, ByteSizeValue partSize) {
            this.name = name;
            this.metadata = metaData;
            long partBytes = Long.MAX_VALUE;
            if (partSize != null && partSize.getBytes() > 0L) {
                partBytes = partSize.getBytes();
            }
            long totalLength = metaData.length();
            long numberOfParts = totalLength / partBytes;
            if (totalLength % partBytes > 0L) {
                ++numberOfParts;
            }
            if (numberOfParts == 0L) {
                ++numberOfParts;
            }
            this.numberOfParts = numberOfParts;
            this.partSize = partSize;
            this.partBytes = partBytes;
        }

        public String name() {
            return this.name;
        }

        public String partName(long part) {
            if (this.numberOfParts > 1L) {
                return this.name + ".part" + part;
            }
            return this.name;
        }

        public static String canonicalName(String blobName) {
            if (blobName.contains(".part")) {
                return blobName.substring(0, blobName.indexOf(".part"));
            }
            return blobName;
        }

        public String physicalName() {
            return this.metadata.name();
        }

        public long length() {
            return this.metadata.length();
        }

        public ByteSizeValue partSize() {
            return this.partSize;
        }

        public long partBytes(int part) {
            if (this.numberOfParts == 1L) {
                return this.length();
            }
            if ((long)part < this.numberOfParts - 1L) {
                return this.partBytes;
            }
            return this.length() - this.partBytes * (this.numberOfParts - 1L);
        }

        public long numberOfParts() {
            return this.numberOfParts;
        }

        public String checksum() {
            return this.metadata.checksum();
        }

        public StoreFileMetaData metadata() {
            return this.metadata;
        }

        public boolean isSame(StoreFileMetaData md) {
            return this.metadata.isSame(md);
        }

        public boolean isSame(FileInfo fileInfo) {
            if (this.numberOfParts != fileInfo.numberOfParts) {
                return false;
            }
            if (this.partBytes != fileInfo.partBytes) {
                return false;
            }
            if (!this.name.equals(fileInfo.name)) {
                return false;
            }
            if (this.partSize != null ? !this.partSize.equals(fileInfo.partSize) : fileInfo.partSize != null) {
                return false;
            }
            return this.metadata.isSame(fileInfo.metadata);
        }

        public boolean hasUnknownChecksum() {
            return this.metadata.checksum().equals(UNKNOWN_CHECKSUM);
        }

        public static void toXContent(FileInfo file, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", file.name);
            builder.field(PHYSICAL_NAME, file.metadata.name());
            builder.field(LENGTH, file.metadata.length());
            if (!file.metadata.checksum().equals(UNKNOWN_CHECKSUM)) {
                builder.field(CHECKSUM, file.metadata.checksum());
            }
            if (file.partSize != null) {
                builder.field(PART_SIZE, file.partSize.getBytes());
            }
            if (file.metadata.writtenBy() != null) {
                builder.field(WRITTEN_BY, file.metadata.writtenBy());
            }
            if (file.metadata.hash() != null && file.metadata().hash().length > 0) {
                builder.field(META_HASH, file.metadata.hash());
            }
            builder.endObject();
        }

        public static FileInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String name = null;
            String physicalName = null;
            long length = -1L;
            String checksum = null;
            ByteSizeValue partSize = null;
            Version writtenBy = null;
            String writtenByStr = null;
            BytesRef metaHash = new BytesRef();
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token.isValue()) {
                            if ("name".equals(currentFieldName)) {
                                name = parser.text();
                                continue;
                            }
                            if (PHYSICAL_NAME.equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if (LENGTH.equals(currentFieldName)) {
                                length = parser.longValue();
                                continue;
                            }
                            if (CHECKSUM.equals(currentFieldName)) {
                                checksum = parser.text();
                                continue;
                            }
                            if (PART_SIZE.equals(currentFieldName)) {
                                partSize = new ByteSizeValue(parser.longValue());
                                continue;
                            }
                            if (WRITTEN_BY.equals(currentFieldName)) {
                                writtenByStr = parser.text();
                                writtenBy = Lucene.parseVersionLenient(writtenByStr, null);
                                continue;
                            }
                            if (META_HASH.equals(currentFieldName)) {
                                metaHash.bytes = parser.binaryValue();
                                metaHash.offset = 0;
                                metaHash.length = metaHash.bytes.length;
                                continue;
                            }
                            throw new ElasticsearchParseException("unknown parameter [{}]", currentFieldName);
                        }
                        throw new ElasticsearchParseException("unexpected token  [{}]", new Object[]{token});
                    }
                    throw new ElasticsearchParseException("unexpected token [{}]", new Object[]{token});
                }
            }
            if (name == null || !Strings.validFileName(name)) {
                throw new ElasticsearchParseException("missing or invalid file name [" + name + "]", new Object[0]);
            }
            if (physicalName == null || !Strings.validFileName(physicalName)) {
                throw new ElasticsearchParseException("missing or invalid physical file name [" + physicalName + "]", new Object[0]);
            }
            if (length < 0L) {
                throw new ElasticsearchParseException("missing or invalid file length", new Object[0]);
            }
            if (writtenBy == null) {
                throw new ElasticsearchParseException("missing or invalid written_by [" + writtenByStr + "]", new Object[0]);
            }
            if (checksum == null) {
                throw new ElasticsearchParseException("missing checksum for name [" + name + "]", new Object[0]);
            }
            return new FileInfo(name, new StoreFileMetaData(physicalName, length, checksum, writtenBy, metaHash), partSize);
        }

        public String toString() {
            return "[name: " + this.name + ", numberOfParts: " + this.numberOfParts + ", partSize: " + this.partSize + ", partBytes: " + this.partBytes + ", metadata: " + this.metadata + "]";
        }
    }
}

