/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;

public final class IndexingSlowLog
implements IndexingOperationListener {
    private final Index index;
    private boolean reformat;
    private long indexWarnThreshold;
    private long indexInfoThreshold;
    private long indexDebugThreshold;
    private long indexTraceThreshold;
    private int maxSourceCharsToLog;
    private SlowLogLevel level;
    private final Logger indexLogger;
    private static final String INDEX_INDEXING_SLOWLOG_PREFIX = "index.indexing.slowlog";
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.warn", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.info", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.debug", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING = Setting.timeSetting("index.indexing.slowlog.threshold.index.trace", TimeValue.timeValueNanos(-1L), TimeValue.timeValueMillis(-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING = Setting.boolSetting("index.indexing.slowlog.reformat", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<SlowLogLevel> INDEX_INDEXING_SLOWLOG_LEVEL_SETTING = new Setting<SlowLogLevel>("index.indexing.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING = new Setting<Integer>("index.indexing.slowlog.source", "1000", value -> {
        try {
            return Integer.parseInt(value, 10);
        }
        catch (NumberFormatException e) {
            return Booleans.parseBoolean(value, true) ? Integer.MAX_VALUE : 0;
        }
    }, Setting.Property.Dynamic, Setting.Property.IndexScope);

    IndexingSlowLog(IndexSettings indexSettings) {
        this.indexLogger = Loggers.getLogger("index.indexing.slowlog.index", indexSettings.getSettings(), new String[0]);
        this.index = indexSettings.getIndex();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING, this::setReformat);
        this.reformat = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_REFORMAT_SETTING);
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING, this::setWarnThreshold);
        this.indexWarnThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING, this::setInfoThreshold);
        this.indexInfoThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING, this::setDebugThreshold);
        this.indexDebugThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING, this::setTraceThreshold);
        this.indexTraceThreshold = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_THRESHOLD_INDEX_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_LEVEL_SETTING, this::setLevel);
        this.setLevel(indexSettings.getValue(INDEX_INDEXING_SLOWLOG_LEVEL_SETTING));
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING, this::setMaxSourceCharsToLog);
        this.maxSourceCharsToLog = indexSettings.getValue(INDEX_INDEXING_SLOWLOG_MAX_SOURCE_CHARS_TO_LOG_SETTING);
    }

    private void setMaxSourceCharsToLog(int maxSourceCharsToLog) {
        this.maxSourceCharsToLog = maxSourceCharsToLog;
    }

    private void setLevel(SlowLogLevel level) {
        this.level = level;
        Loggers.setLevel(this.indexLogger, level.name());
    }

    private void setWarnThreshold(TimeValue warnThreshold) {
        this.indexWarnThreshold = warnThreshold.nanos();
    }

    private void setInfoThreshold(TimeValue infoThreshold) {
        this.indexInfoThreshold = infoThreshold.nanos();
    }

    private void setDebugThreshold(TimeValue debugThreshold) {
        this.indexDebugThreshold = debugThreshold.nanos();
    }

    private void setTraceThreshold(TimeValue traceThreshold) {
        this.indexTraceThreshold = traceThreshold.nanos();
    }

    private void setReformat(boolean reformat) {
        this.reformat = reformat;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index indexOperation, Engine.IndexResult result) {
        if (!result.hasFailure()) {
            ParsedDocument doc = indexOperation.parsedDoc();
            long tookInNanos = result.getTook();
            if (this.indexWarnThreshold >= 0L && tookInNanos > this.indexWarnThreshold) {
                this.indexLogger.warn("{}", (Object)new SlowLogParsedDocumentPrinter(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexInfoThreshold >= 0L && tookInNanos > this.indexInfoThreshold) {
                this.indexLogger.info("{}", (Object)new SlowLogParsedDocumentPrinter(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexDebugThreshold >= 0L && tookInNanos > this.indexDebugThreshold) {
                this.indexLogger.debug("{}", (Object)new SlowLogParsedDocumentPrinter(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            } else if (this.indexTraceThreshold >= 0L && tookInNanos > this.indexTraceThreshold) {
                this.indexLogger.trace("{}", (Object)new SlowLogParsedDocumentPrinter(this.index, doc, tookInNanos, this.reformat, this.maxSourceCharsToLog));
            }
        }
    }

    boolean isReformat() {
        return this.reformat;
    }

    long getIndexWarnThreshold() {
        return this.indexWarnThreshold;
    }

    long getIndexInfoThreshold() {
        return this.indexInfoThreshold;
    }

    long getIndexTraceThreshold() {
        return this.indexTraceThreshold;
    }

    long getIndexDebugThreshold() {
        return this.indexDebugThreshold;
    }

    int getMaxSourceCharsToLog() {
        return this.maxSourceCharsToLog;
    }

    SlowLogLevel getLevel() {
        return this.level;
    }

    static final class SlowLogParsedDocumentPrinter {
        private final ParsedDocument doc;
        private final long tookInNanos;
        private final boolean reformat;
        private final int maxSourceCharsToLog;
        private final Index index;

        SlowLogParsedDocumentPrinter(Index index, ParsedDocument doc, long tookInNanos, boolean reformat, int maxSourceCharsToLog) {
            this.doc = doc;
            this.index = index;
            this.tookInNanos = tookInNanos;
            this.reformat = reformat;
            this.maxSourceCharsToLog = maxSourceCharsToLog;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.index).append(" ");
            sb.append("took[").append(TimeValue.timeValueNanos(this.tookInNanos)).append("], ");
            sb.append("took_millis[").append(TimeUnit.NANOSECONDS.toMillis(this.tookInNanos)).append("], ");
            sb.append("type[").append(this.doc.type()).append("], ");
            sb.append("id[").append(this.doc.id()).append("], ");
            if (this.doc.routing() == null) {
                sb.append("routing[]");
            } else {
                sb.append("routing[").append(this.doc.routing()).append("]");
            }
            if (this.maxSourceCharsToLog == 0 || this.doc.source() == null || this.doc.source().length() == 0) {
                return sb.toString();
            }
            try {
                String source = XContentHelper.convertToJson(this.doc.source(), this.reformat, this.doc.getXContentType());
                sb.append(", source[").append(Strings.cleanTruncate(source, this.maxSourceCharsToLog)).append("]");
            }
            catch (IOException e) {
                sb.append(", source[_failed_to_convert_[").append(e.getMessage()).append("]]");
            }
            return sb.toString();
        }
    }
}

