//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;
import lti.java.jcf.RuntimeConstants;       

/**
 * JcfInterfaceCollection is simply an array of CptClass indicies of the interfaces
 * that the class implements. Reading and writing are supported.
 */ 
public class JcfInterfaceCollection implements RuntimeConstants
{
  /** The actual interface constant pool indicies. */
  public short data[];
  protected JcfConstantPool constPool;

  public JcfInterfaceCollection (JcfClassInput ist, JcfConstantPool p)
    throws ClassFormatError, IOException
  {
    constPool = p;
    data = new short[ist.readShort()];
    for (int i = 0; i < data.length; i++)
      { data[i] = ist.readCPRef(); }
  }

  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeShort ((short)data.length);
    for (int i = 0; i < data.length; i++)
      { ost.writeCPRef(data[i]); }
  }
}
