/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util;

/**
 * Used by the Init class. It represents an application
 * Option and it's value.
 *
 * @version $Id: Option.java,v 1.9 2002/10/06 16:42:07 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class Option 
{
    /** Option type boolean. */
    public static final int BOOLEAN = 0;
    /** Option type string. */
    public static final int STRING = 1;
    /** Option type integer. */
    public static final int INTEGER = 2;

    private String[] _asType = {"b", "s"};

    private String _sName;
    private String _sDescription;
    private int _type;
    private Object _oValue;
    private boolean _bMandatory = false;

    public Option( String sName_, String sInitString_ ) 
    {
        _sName = sName_;
        Util.debug( this, "<init>(..).sInitString_: " + sInitString_ );
        int comma = sInitString_.indexOf( ',' );
        if ( comma == -1 )
        {
            throw new ApplicationException( "ccl.util.Init option " + _sName + " is not defined correctly! Could not find first comma, e.g. 's,o,Some text.' but instead I got '" + sInitString_ + "'" );
        }
        String sType = sInitString_.substring( 0, comma ).trim();

        int secondComma = sInitString_.indexOf( ',', comma + 1 );
        if ( secondComma == -1 )
        {
            throw new ApplicationException( "ccl.util.Init option " + _sName + " is not defined correctly! Could not find second comma, e.g. 's,o,Some text.' but instead I got '" + sInitString_ + "'" );
        }
        String sMandatoryOptional = sInitString_.substring( comma + 1, secondComma ).trim();

        _sDescription = sInitString_.substring( secondComma + 1 ).trim();

        // Up to now no other types are allowed.
        if ( sType.equals( _asType[BOOLEAN] ) ) 
        {
            _type = BOOLEAN;
        }
        else if ( sType.equals( _asType[ STRING ] ) ) 
        {
            _type = STRING;
        }
        else 
        {
            Util.panicIf( true, "ccl.util.Option.Option(String): Type not allowed: '" + sType + "'" );
        }

        if ( sMandatoryOptional.charAt(0) == 'm' )
        {
            _bMandatory = true;
        }

        Util.debug("Option.Option(String): _sName: " + _sName);
        Util.debug("Option.Option(String): _sDescription: " + _sDescription);
        Util.debug("Option.Option(String): _bMandatory: " + _bMandatory);
        Util.debug("Option.Option(String): _type: " + _type);
    }

    public String getName() 
    {
        return _sName;
    }

    public String getDescription() 
    {
        return _sDescription;
    }

    public boolean isMandatory() 
    {
        return _bMandatory;
    }

    public int getType() 
    {
        return _type;
    }
}
