/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing.test;

import ccl.swing.SwingUtil;
import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * Tests for ccl.swing.SwingUtil utility methods.
 *
 * @version $Id: SwingUtilTest.java,v 1.8 2003/10/18 07:53:18 clemens Exp clemens $
 * @author  Chr. Clemens Lee (clemens@kclee.com)
 */
public class SwingUtilTest extends Test 
{
    public SwingUtilTest() 
    {
        super();
    }

    public SwingUtilTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * Tests for ccl.swing.SwingUtil utility methods.
     *
     * @exception   Exception   for whatever can go wrong.
     */
    protected void _doIt()
        throws Exception
    {
        boolean bSkip = false;
        //bSkip = true;
        if ( bSkip == false )
        {
            Test pTest = null;

            pTest = (Test)(new DateFieldTest( this ));
            pTest.run();
            setTests( pTest );

            pTest = new CCLLineBorderTest( this );
            pTest.run();
            setTests( pTest );
            
            pTest = new GraphicsUtilTest( this );
            pTest.run();
            setTests( pTest );
            
            pTest = (Test)(new DoubleListTest( this ));
            pTest.run();
            setTests( pTest );
        }

        final Frame frame = new Frame();
            
        // test for getFirstComponent(..) with a file chooser.
        final JFileChooser pFileChooser = new JFileChooser
            ( FileUtil.getTempDir() );
        pFileChooser.setDialogTitle( "SwingUtilTest" );
        
        pFileChooser.setFileSelectionMode( JFileChooser.FILES_AND_DIRECTORIES );
        
        Runnable runFileChooser = new Runnable() {
            public void run()
                {
                    pFileChooser.showDialog( frame, null );
                }
        };
        
        Thread thrFileChooser = new Thread( runFileChooser );
        thrFileChooser.start();
        Util.sleep( 8 );
        
        Assert( frame.getOwnedWindows().length == 1 );
        Assert( frame.getOwnedWindows()[ 0 ] instanceof JDialog );
        JDialog dialog = (JDialog)frame.getOwnedWindows()[ 0 ];
        
        bugIf( dialog == null );

        JPanel panel = (JPanel)SwingUtil.getFirstComponent( dialog
                                                            , "javax.swing.JPanel" );
        bugIf( panel == null );
        
        //Util.setDebug( true );
        Util.debug( this, "_doIt().dialog: " + SwingUtil.getContainerDump( dialog ) );
        // What are we testing here?
        // We are searching for the JTextField where the user can type in the file or
        // directory name.
        // Under jdk 1.3 this is class javax.swing.plaf.metal.MetalFileChooserUI$1.
        // Under jdk 1.4 this is class javax.swing.plaf.metal.MetalFileChooserUI$2.
        String sTextFieldClassName = "javax.swing.plaf.metal.MetalFileChooserUI$";
        String sJavaVersion = System.getProperty( "java.version" ).substring( 0, 3 );
        float javaVersion = Util.atof( sJavaVersion );
        if ( javaVersion < 1.4f )
        {
            sTextFieldClassName += "1";
        }
        else 
        {
            sTextFieldClassName += "2";
        }

        JTextField textField = (JTextField)SwingUtil.getFirstComponent( dialog
                                                                        , sTextFieldClassName );
        bugIf( textField == null );
        
        dialog.setVisible( false );
    }

    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test)(new SwingUtilTest());
        pTest.setVerbose( true );
        pTest.run();
        Test.printResult( pTest );

        System.exit( 0 );
    }
}
