/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.Frame;
import java.awt.event.*;

import javax.swing.*;

/**
 * Modal dialog that sets itself invisible when it gets 
 * closed.
 *
 * @version  $Id: ExitJDialog.java,v 1.8 2002/10/06 16:41:32 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class ExitJDialog extends JDialog
                         implements WindowListener
{
    public ExitJDialog() 
{
        this(new JFrame(), "Dialog", true);
    }

    public ExitJDialog(Frame frmParent_) 
{
        this(frmParent_, "Dialog", true);
    }

    public ExitJDialog(String sTitle_) 
{
        this(new JFrame(), sTitle_, true);
    }

    public ExitJDialog(Frame frmParent_, String sTitle_) 
{
        this(frmParent_, sTitle_, true);
    }

    public ExitJDialog(Frame pFrame_, boolean pBoolean_) 
{
        this(pFrame_, "Dialog", pBoolean_);
    }

    public ExitJDialog(Frame pFrame_, String pString_, boolean pBoolean_) 
{
        super(pFrame_, pString_, pBoolean_);
        addWindowListener(this);
    }

    public void exit() 
{
        setVisible(false);
    }

    public void windowActivated(WindowEvent event) 
{
    }

    public void windowDeactivated(WindowEvent event) 
{
    }
    
    public void windowClosed(WindowEvent event) 
{
    }
    
    public void windowDeiconified(WindowEvent event) 
{
    }
    
    public void windowIconified(WindowEvent event) 
{
    }
    
    public void windowOpened(WindowEvent event) 
{
    }
    
    public void windowClosing(WindowEvent event) 
{
        exit();
    }
}
