/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
 * A DoubleList is a panel that consists of to lists which are connected
 * through a DoubleListModel. An element of the first list can be selected
 * and then the second list will show elements that belong to this object
 * from the first list.
 *
 * @version $Id: DoubleList.java,v 1.8 2002/10/06 16:41:30 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class DoubleList extends JPanel 
                        implements MouseListener 
{
    private JList _lstFirst;
    private JList _lstSecond;
    private Vector _vSecond = null;
    private boolean _bMultiSelect = false;
    private int _firstIndex = -1;
    private DoubleListModel _pDoubleListModel = null;

    private JScrollPane _jspFirst = null;
    private JScrollPane _jspSecond = null;

    public void _showSecondList() 
    {
        if ( getFirstIndex() >= 0 )
        {
            _lstSecond.clearSelection();
            _lstSecond.setModel( _pDoubleListModel.getSecondModel
                                 ( getFirstIndex() )
                                 );
        }
    }

    public DoubleList( Vector vFirstList_, 
                       Vector vSecondList_,
                       boolean bMultiSelect_ )
    {
        super();

        _bMultiSelect = bMultiSelect_;
        _pDoubleListModel = new DoubleListModel( vFirstList_,
                                                 vSecondList_ );

        AutoGridBagLayout pAutoGridBagLayout =
               new AutoGridBagLayout();
        setLayout( new GridLayout( 0, 2 ) );

        DefaultListModel dlmFirst = _pDoubleListModel.
               getFirstModel();
        _lstFirst = new JList( dlmFirst );
        _lstFirst.setFont( new Font( "Dialog", Font.BOLD, 12 ) );
        _lstFirst.addMouseListener(this);
        _lstFirst.setSelectionMode( ListSelectionModel.
                                    SINGLE_SELECTION );

        _lstSecond = new JList( new DefaultListModel() );
        if ( bMultiSelect_ ) 
        {
            _lstSecond.setSelectionMode
                   ( ListSelectionModel.
                     MULTIPLE_INTERVAL_SELECTION );
        }
        else 
        {
            _lstSecond.setSelectionMode
                   ( ListSelectionModel.SINGLE_SELECTION );
        }
        _lstSecond.setFont( new Font( "Dialog", Font.BOLD, 12 ) );
        _lstSecond.addMouseListener(this);
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        _jspFirst = new JScrollPane( _lstFirst );
        _jspFirst.setBorder( new CCLBorder() );
        _jspSecond = new JScrollPane( _lstSecond );
        _jspSecond.setBorder( new CCLBorder() );
        add( _jspFirst );
        add( _jspSecond );
    }

    public void setLists( Vector vFirstList_,
                          Vector vSecondList_ )
    {
        _pDoubleListModel.set( vFirstList_, vSecondList_ );
        _lstFirst.clearSelection();
        _lstSecond.clearSelection();
        _lstFirst.setModel( _pDoubleListModel.getFirstModel() );
        _lstSecond.setModel( new DefaultListModel() );
    }

    public void setBackground( Color pColor_ ) 
    {
        super.setBackground( pColor_ );

        if ( _jspFirst != null ) 
        {
            _jspFirst.setBackground( pColor_ );
        }
        if ( _jspSecond != null ) 
        {
            _jspSecond.setBackground( pColor_ );
        }
    }

    public void mousePressed( MouseEvent pMouseEvent_) 
    {
        Object oSource = pMouseEvent_.getSource();
        if (oSource == _lstFirst) 
        {
            _firstIndex = _lstFirst.getSelectedIndex();
            _showSecondList();

            return;
        }
    }

    public void mouseClicked( MouseEvent pMouseEvent_ ) 
    {
    }
    
    public void mouseEntered( MouseEvent pMouseEvent_ ) 
    {
    }
    
    public void mouseExited( MouseEvent pMouseEvent_ ) 
    {
    }

    public void mouseReleased( MouseEvent pMouseEvent_ ) 
    {
    }

    public void setListBackground(Color pColor_) 
    {
        _lstFirst.setBackground(pColor_);
        _lstSecond.setBackground(pColor_);

        _lstFirst.setSelectionForeground( pColor_ );
        _lstSecond.setSelectionForeground( pColor_ );
    }

    public void setListForeground(Color pColor_) 
    {
        _lstFirst.setForeground(pColor_);
        _lstSecond.setForeground(pColor_);

        _lstFirst.setSelectionBackground( pColor_ );
        _lstSecond.setSelectionBackground( pColor_ );        
    }

    /**
     * Returns a vector with the original elements from the first list.
     */
    public Vector getFirstVector() 
    {
        return SwingUtil.toVector
               ( (DefaultListModel) _lstFirst.getModel() );
    }

    public Vector getSecondVector() 
    {
        Vector vSecond = new Vector();
        Enumeration eSubLists = _pDoubleListModel.
               getSecondVector().elements();
        while( eSubLists.hasMoreElements() ) 
        {
            DefaultListModel dlmNext = (DefaultListModel) eSubLists.
                   nextElement();
            Vector vNext = SwingUtil.toVector( dlmNext );
            vSecond.addElement( vNext );
        }

        return vSecond;
    }

    public JList getFirstList() 
    {
        return _lstFirst;
    }

    public JList getSecondList() 
    {
        return _lstSecond;
    }

    public void setFirstSelectedIndex( int index_ ) 
    {
        _firstIndex = index_;
        _lstFirst.setSelectedIndex( index_ );
        _showSecondList();
    }

    public int getFirstIndex() 
    {
        return _firstIndex;
    }

    public String getFirstItem() 
    {
        if (_firstIndex == -1) 
        {
            return null;
        }

        return (String) _pDoubleListModel.getFirstModel()
                                         .getElementAt( _firstIndex );
    }

    /**
     * Returns the first selected value, or null if the selection is empty.
     *
     * @return   the first selected value
     */
    public Object getFirstSelectedValue()
    {
        if (_firstIndex == -1) 
        {
            return null;
        }

        return _pDoubleListModel.getFirstModel().
               getElementAt( _firstIndex );
    }

    public int getSecondSelectedIndex() 
    {
        return _lstSecond.getSelectedIndex();
    }

    public String getSecondSelectedItem() 
    {
        if ( getSecondSelectedIndex() == -1 ) 
        {
            return null;
        }

        return _lstSecond.getSelectedValue().toString();
    }

    public Vector getSecondSelectedItems() 
    {
        Vector vSelectedItems = new Vector();
        if (!_bMultiSelect) 
        {
            if (getSecondSelectedIndex() == -1) 
            {
                return null;
            }
            vSelectedItems.addElement(getSecondSelectedItem());
        } 
        else 
        {
            Object aItems[] = _lstSecond.getSelectedValues();
            if (aItems == null) 
            {
                return null;
            }
            for( int i = 0; i < aItems.length; i++ )
            {
                vSelectedItems.addElement(aItems[i]);
            }
        }

        return vSelectedItems;
    }

    public DoubleListModel getModel() 
    {
        return _pDoubleListModel;
    }
}

