/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2003
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

/**
 * A standard button border that should look quite familiar
 * to most people.
 *
 * @version  $Id: CCLButtonBorder.java,v 1.1 2003/05/01 16:44:10 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>
 */
public class CCLButtonBorder extends AbstractBorder
{
    private Insets _insets = new Insets( 3, 3, 3, 3 );

    /**
     * Default constructor. To reduce memory using use
     * factory method in SwingUtil.
     *
     * @see   SwingUtil#createCCLButtonBorder
     */
    public CCLButtonBorder() 
    {
        super();
    }
    
    /**
     * Active painting of the border.
     */
    public void paintBorder(Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
    {
        int w = width  - 1;
        int h = height;
        Color clrBackground = c.getBackground();
        g.setColor(clrBackground.darker());
        g.drawLine(x, h-2, x+w, h-2);
        g.drawLine(x+w-1, h-2, x+w-1, 0);
        g.setColor(clrBackground.brighter());
        g.drawLine(x, 0, x+w, 0);
        g.drawLine(x, 0, x, h-1);
        g.setColor(Color.black);
        g.drawLine(x, h-1, x+w, h-1);
        g.drawLine(x+w, h-1, x+w, 0);
    }

    /**
     * Returns insets used for this border object.
     */
    public Insets getBorderInsets(Component c) 
    {
        return _insets;
    }

    /**
     * This border is always opaque.
     */
    public boolean isBorderOpaque() 
    {
        return true;
    }
}
