/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;

/**
 * A window with frame like a Dialog under XWindows.
 *
 * @version  $Id: CCLBorderWindow.java,v 1.4 2002/10/06 16:41:27 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class CCLBorderWindow extends Window 
{
    private static final Insets INSETS = new Insets( 6, 6, 6, 6 );

    public CCLBorderWindow(Frame frmParent_) 
    {
        super(frmParent_);
    }

    public Insets getInsets() 
    {
        return INSETS;
    }

    public void paint(Graphics g) 
    {
        super.paint(g);
        int w = getSize().width  - 1;
        int h = getSize().height - 1;
        Color clrBackground = getParent().getBackground();
        // 1. Rahmen
        // links normal
        g.setColor(clrBackground);
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, 0, 0, h);
        // rechts schwarz
        g.setColor(clrBackground.darker().darker());
        g.drawLine(w, 0, w, h);
        g.drawLine(0, h, w, h);
        
        // 2. Rahme
        // links hell
        g.setColor(clrBackground.brighter());
        g.drawLine(1, 1, w - 1, 1);
        g.drawLine(1, 1, 1, h - 1);
        // rechts dark
        g.setColor(clrBackground.darker());
        g.drawLine(w - 1, 1    , w - 1, h - 1);
        g.drawLine(1    , h - 1, w - 1, h - 1);
        
        // 3-4. Rahmen
        // Originalfarbe
        g.setColor(clrBackground);
        g.drawLine(2, 2, w - 2, 2);
        g.drawLine(2, 2, 2    , h - 2);
        g.drawLine(w - 2, 2    , w - 2, h - 2);
        g.drawLine(2    , h - 2, w - 2, h - 2);
        g.drawLine(3, 3, w - 3, 3);
        g.drawLine(3, 3, 3    , h - 3);
        g.drawLine(w - 3, 3    , w - 3, h - 3);
        g.drawLine(3    , h - 3, w - 3, h - 3);
        
        // 5. Rahmen
        // links darker
        g.setColor(clrBackground.darker());
        g.drawLine(4, 4, w - 4, 4);
        g.drawLine(4, 4, 4    , h - 4);
        // unten heller
        g.setColor(clrBackground.brighter());
        g.drawLine(w - 4, h - 4, w - 4, 4);
        g.drawLine(w - 4, h - 4, 4, h - 4);
        
        // 6. Rahmen
        // oben links
        g.setColor(clrBackground.darker().darker());
        g.drawLine(5, 5, w - 5, 5);
        g.drawLine(5, 5, 5, h - 5);
        // unten rechts
        g.setColor(clrBackground);
        g.drawLine(w - 5, h - 5, w - 5, 5);
        g.drawLine(w - 5, h - 5, 5, h - 5);
    }
}
