/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet.test;

import ccl.servlet.XMLImportHandler;
import ccl.util.ClassPathUtil;
import ccl.util.DBUtil;
import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * This class conducts some basic tests of the 
 * ccl.servlet.XMLImportHandler
 * class using a postgresql database, if it exists. In that
 * case it creates a database with name ccltest. Be sure you
 * don't have a database with the same name in use, as that
 * would be dropped with all its data. If you have no postgresql
 * in your system, the tests will be skipped.
 *
 * @version $Id: XMLImportHandlerTest.java,v 1.7 2003/11/23 09:13:50 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class XMLImportHandlerTest extends Test 
{
    /**
     * Default constructor.
     */
    public XMLImportHandlerTest() 
    {
        super();
    }

    /**
     * Standard test class constructor.
     */
    public XMLImportHandlerTest( Test pTest_ ) 
    {
        super( pTest_ );
    }

    /**
     * Executes all test code relevant to the xml import handler
     * class.
     *
     * @exception   Exception   if anything goes wrong the test fails as well.
     */
    protected void _doIt()
        throws Exception
    {
        Connection connection = null;
        try
        {
            connection = DBUtil.createPGConnection( "template1" );
        }
        catch( Exception exception )
        {
            // ok, no postgresql existing, just skip tests
            Util.print( " No PostgreSQL database found, skipping corresponding tests! " );

            return;
        }
        Statement statement = connection.createStatement();
        
        try
        {
            statement.executeUpdate( "drop database ccltest" );
        }
        catch( SQLException sqlException )
        {
            // if test database does not exist yet, fine
            /*Util.printlnErr( String.valueOf( sqlException ) );*/
        }
        statement.executeUpdate( "create database ccltest with encoding = 'LATIN1'" );
        statement.close();
        connection.close();

        connection = DBUtil.createPGConnection( "ccltest" );
        statement = connection.createStatement();

        // so far, so good
        Assert( true );

        // get test directory and add create_tables.sql
        String sCreateTablesFile = FileUtil.concatPath( ClassPathUtil.getApplicationHome( this )
                                                        , "test" )
               + File.separator + "create_tables.sql";
        String sCreateTablesSQL = FileUtil.readFile( sCreateTablesFile );
        statement.executeUpdate( sCreateTablesSQL );

        // again - so far, so good
        Assert( true );

        ResultSet result = statement.executeQuery( "select count(*) from tblTransaction" );
        result.next();
        Assert( Util.atoi( result.getString( 1 ) ) == 0 );
        result.close();
        
        statement.close();

        //
        // database is set up, now import xml file
        //

        String sImportFile = FileUtil.concatPath( ClassPathUtil.getApplicationHome( this )
                                                  , "test" )
               + File.separator + "xmlimport_test.xml";
        XMLImportHandler.parse( connection, sImportFile );

        statement = connection.createStatement();
        result = statement.executeQuery( "select count(*) from tblTransaction" );
        result.next();
        Assert( Util.atoi( result.getString( 1 ) ) == 3 );
        result.close();
        statement.close();

        connection.close();

        //
        // do it again and old stuff should be removed first
        //

        connection = DBUtil.createPGConnection( "ccltest" );
        statement = connection.createStatement();
        sImportFile = FileUtil.concatPath( ClassPathUtil.getApplicationHome( this )
                                                  , "test" )
               + File.separator + "xmlimport_test2.xml";
        XMLImportHandler.parse( connection, sImportFile );

        statement = connection.createStatement();
        result = statement.executeQuery( "select count(*) from tblTransaction" );
        result.next();
        Assert( Util.atoi( result.getString( 1 ) ) == 4 );
        result.close();

        // is the database able to contain an umlaut?
        statement.executeUpdate( "insert into Account ( id, name, description, currency_iso, type, parent, tax_percentage, tax_deductible ) values ( 3, 'Umlat', 'Tt', 'EUR', 'Bank', null, 0.0, 0 )" );
        
        result = statement.executeQuery( "select name from Account where id = 3" );
        result.next();
        String name = result.getString( "name" );
        Assert( name.equals( "Umlat" )
                , "Name should be 'Umlat' but is: '" + name + "'" );
        result.close();

        // does the database received the umlaut?
        result = statement.executeQuery( "select name from Account where id = 2" );
        result.next();
        name = result.getString( "name" );
        Assert( name.equals( "Psedo DEM" )
                , "Name should be 'Psedo DEM' but is: '" + name + "'" );
        result.close();

        statement.close();
    }

    public static void main( String[] asArg_ ) 
    {
        Test pTest = (Test)(new XMLImportHandlerTest());
        pTest.setVerbose( true );
        pTest.setTiming ( true );
        pTest.run();
        Test.printResult( pTest );

        System.exit( 0 );
    }
}
