/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.platform;

import ccl.util.FileUtil;
import ccl.util.Util;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * This is the base class to invoke some native methods.
 * In case the underlying OS is Linux, the appropriate
 * native system methods are invoked, otherwise empty
 * dummy methods are invoked which do nothing.
 *
 * @author  Chr. Clemens Lee
 * @version $Id: Native.java,v 1.9 2003/05/01 16:43:59 clemens Exp clemens $
 */
public class Native 
{
    private static Native _pNative = null;

    /**
     * Native is a singleton class. Use 'getInstance()'
     * to create a Native object.
     */
    protected Native() 
    {
        super();
    }

    /**
     * Native is a singleton class. Use this method
     * to create a Native object.
     */
    public static Native getInstance() 
    {
        if ( _pNative == null) 
        {
            if ( Util.isOSLinux() ) 
            {
                _pNative = new Linux();
                if ( Linux.isLibLoaded() == false ) 
                {
                    // lib could not be found, use dummy class instead.
                    _pNative = new Native();
                }
            }
            else 
            {
                _pNative = new Native();
            }
        }
        
        return _pNative;
    }

    /**
     * Set input focus on a system window.
     */
    public void requestInputFocus( String sWindowTitle_ ) 
    {
    }

    /**
     * Create a symbolic link (on Unix).
     */
    public int symlink( String sOldPath_, 
                        String sNewPath_ ) 
    {
        // symbolic links are not supported on dummy platform
        return -1;
    }

    /**
     * Remove a symbolic link (on Unix).
     */
    public boolean unlink( String sPath_ ) 
    {
        return true;
    }

    /**
     * @return   Returns an empty Hashtable on windows.
     *           If /etc/passwd can be read, the keys
     *           of the hashtable are user ids and their
     *           values are user names.
     */
    public static Hashtable getUserNames() 
    {
        Hashtable htRetVal = new Hashtable();

        if ( Util.isOSWindows() ) 
        {
            return htRetVal;
        }

        String sPasswd = null;
        try 
        {
            sPasswd = FileUtil.readFile( "/etc/passwd" );
        }
        catch( Exception pException ) 
        {
            sPasswd = "";
        }

        Vector vPasswds = Util.stringToLines( sPasswd );
        Enumeration ePasswds = vPasswds.elements();
        while ( ePasswds.hasMoreElements() ) 
        { 
            String sLine = (String)ePasswds.nextElement();
            Vector vWords = Util.stringToLines( sLine, ':' );
            String sUserName = (String)vWords.elementAt( 0 );
            String sUID = (String)vWords.elementAt( 2 );

            htRetVal.put( sUID, sUserName );
        }

        return htRetVal;
    }

    /**
     * Get process ID of the current Java program/process.
     */
    public int getPID() 
    {
        return -1;
    }

    /**
     * Get process ID of the current Java main process.
     */
    public int getMainJavaPID() 
    {
        return -1;
    }
  
    /**
     * Sets the location of the frame using native system
     * routines.
     */
    public void setLocation( Frame frame, int x, int y )
    {
        frame.setLocation( x, y );
    }
  
    /**
     * Sets the location of the dialog using native system
     * routines.
     */
    public void setLocation( Dialog dialog, int x, int y )
    {
        dialog.setLocation( x, y );
    }
}
