/*
 *  JavaDump 1.0
 *  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
 *
 *  File:     JavaDump.java
 *  Module:   JavaDump (application)
 *  Version:  1.00.053
 *  Date:     May - June 1997
 *  Author:   Matt Yourst [yourst@laserstars.com]
 *  Language: Java 1.1+
 *
 *  ABSTRACT
 *
 *  Generates a complete report on the structures within
 *  Java class files. Sends report (in HTML format) to
 *  standard output; can be redirected to file if desired.
 *  Very useful for debugging and exploring class files.
 *
 *  Just changed it, so output format is in ascii. 
 *  Chr. Clemens Lee 2000-04-05 clemens@kclee.com
 */

package ccl.jcf;

import java.io.*;
import lti.java.jcf.*;

import ccl.util.FileUtil;

/**
 *
 *  JavaDump 1.0
 *  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
 *
 *  File:     JavaDump.java
 *  Module:   JavaDump (application)
 *  Version:  1.00.053
 *  Date:     May - June 1997
 *  Author:   Matt Yourst [yourst@laserstars.com]
 *  Language: Java 1.1+
 *
 *  ABSTRACT
 *
 *  Generates a complete report on the structures within
 *  Java class files. Sends report (in HTML format) to
 *  standard output; can be redirected to file if desired.
 *  Very useful for debugging and exploring class files.
 *
 *  Just changed it, so output format is in ascii. 
 *  Chr. Clemens Lee 2000-04-05 clemens@kclee.com
*/
public class JavaDump
{
  public static void main(String args[]) throws Exception
  {
    if (args.length < 2)
    {
      System.out.println("JavaDump 1.0  Copyright 1997 Matt Yourst");
      System.out.println();
      System.out.println("Purpose:");
      System.out.println("  Generates a complete report on the structures within");
      System.out.println("  Java class files. Sends report (in HTML format) to");
      System.out.println("  standard output; can be redirected to file if desired.");
      System.out.println("Syntax is:");
      System.out.println("  JavaDump <class file name> [-noconstpool]");
      System.out.println("  -noconstpool = Omit constant pool from report");
      return;
    }
         String sOutputFileName = args[1];
    //
    // Open the class file.
    //
    FileInputStream fist = null;
    try 
{
      fist = new FileInputStream(args[0]);
    }
 catch (IOException ioe) 
{
      System.err.println("JavaDump Error: Cannot open " + args[0]);
      return;
    }
    JcfClassInputStream ist = new JcfClassInputStream(
      new BufferedInputStream(fist, Math.min(fist.available(), 32767)));
    //
    // Read into JcfClassFile object
    //
    JcfClassFile jcf = null;
    try 
{
      // Read from class input stream, and create structures.
      jcf = new JcfClassFile(ist);
      fist.close();
    }
 catch (Exception ex) 
{
      System.err.println("JavaDump Error: Exception while reading class file");
      fist.close();
      throw ex; // Display a stack trace and terminate.
    }
    //
    // Perform complete dump
    //
         StringBuffer sbOutput = new StringBuffer();
    int flags = 0;
    if ((args.length >= 2) && (args[1].equals("-noconstpool")))
      flags |= DumpClassToTxt.OMIT_CONSTPOOL;
    new DumpClassToTxt(jcf, sbOutput, flags).dump();

         try 
{
                 FileUtil.writeFile(sOutputFileName, sbOutput.toString());
         }
 catch(Exception pException) 
{
                 ccl.util.Util.debug("JavaDump.main(..).pException: " + pException);
         }

    //
    // Finally exit
    //
  }
}
