/*
 * Decompiled with CFR 0.152.
 */
package junit.framework.test;

import ccl.util.Test;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.TestCase;
import junit.framework.test.AssertTestCase;

public class TestCaseTest
extends Test {
    private boolean hasBeenInvoked = false;

    public void testGetMethods() {
        this._enterSubTest("getMethods");
        Vector vMethods = TestCase.getMethods((Object)this);
        this.Assert(vMethods != null);
        this.Assert(vMethods.size() >= 2);
        this.Assert(TestCaseTest.containsMethod(vMethods, "testGetMethods"));
        this.Assert(TestCaseTest.containsMethod(vMethods, "testGetTestMethods"));
        this.Assert(TestCaseTest.containsMethod(vMethods, "testDummy2"));
        this.Assert(TestCaseTest.containsMethod(vMethods, "testDummy3"));
        this._exitSubTest();
    }

    public void testGetTestMethods() {
        this._enterSubTest("getTestMethods");
        Vector vMethods = TestCase.getTestMethods((Object)this);
        this.Assert(vMethods != null);
        this.Assert(vMethods.size() >= 2, "Test methods: " + vMethods);
        this.Assert(TestCaseTest.containsMethod(vMethods, "testGetMethods"));
        this.Assert(TestCaseTest.containsMethod(vMethods, "testGetTestMethods"));
        this.Assert(!TestCaseTest.containsMethod(vMethods, "_doIt"));
        this.Assert(!TestCaseTest.containsMethod(vMethods, "testDummy1"));
        this.Assert(!TestCaseTest.containsMethod(vMethods, "testDummy2"));
        this.Assert(!TestCaseTest.containsMethod(vMethods, "testDummy3"));
        this.Assert(TestCaseTest.containsMethod(vMethods, "testInvokeMe"));
        this._exitSubTest();
    }

    public void testInvokeTestMethod() throws Exception {
        this._enterSubTest("invokeTestMethod");
        Vector vMethods = TestCase.getTestMethods((Object)this);
        Method testInvokeMeMethod = (Method)vMethods.elementAt(TestCaseTest.indexOfMethod(vMethods, "testInvokeMe"));
        this.hasBeenInvoked = false;
        TestCase.invokeTestMethod((Method)testInvokeMeMethod, (Object)this);
        this.Assert(this.hasBeenInvoked);
        this._exitSubTest();
    }

    private void testDummy1() {
    }

    public int testDummy2() {
        return -1;
    }

    public void testDummy3(int i) {
    }

    public void testInvokeMe() {
        this.hasBeenInvoked = true;
    }

    public void testAssert() {
        this._enterSubTest("testAssert");
        AssertTestCase testCase = new AssertTestCase();
        testCase.setVerbose(true);
        testCase.run();
        this.Assert(testCase.getGlobalTests() == 1L);
        this._exitSubTest();
    }

    public TestCaseTest() {
    }

    public TestCaseTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        this.testAssert();
        this.testInvokeTestMethod();
        this.testGetTestMethods();
        this.testGetMethods();
    }

    public static void main(String[] asArg_) {
        TestCaseTest pTest = new TestCaseTest();
        pTest.setVerbose(true);
        pTest.setTiming(true);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }

    public static int indexOfMethod(Vector vMethods, String sMethodName) {
        boolean methodFound = false;
        Enumeration eMethods = vMethods.elements();
        int index = 0;
        while (eMethods.hasMoreElements()) {
            Method nextMethod = (Method)eMethods.nextElement();
            String sMethods = nextMethod.getName();
            if (sMethods.equals(sMethodName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean containsMethod(Vector vMethods, String sMethodName) {
        return TestCaseTest.indexOfMethod(vMethods, sMethodName) != -1;
    }
}

