/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.Util;
import java.io.PrintStream;
import java.util.Observable;

public class OutputErrorStreamManager
extends Observable {
    private boolean _bAutoClear = true;
    private StringBuffer _buffer = null;
    private int _lastFlushIndex = 0;
    private boolean _bVisible = true;
    private OutputErrorStream _newOut = null;
    private OutputErrorStream _newErr = null;
    private PrintStream _outOrig = null;
    private PrintStream _errOrig = null;

    public void setAutoClear(boolean bAutoClear_) {
        this._bAutoClear = bAutoClear_;
    }

    public void install() {
        Util.panicIf(this._buffer != null);
        this._outOrig = System.out;
        this._errOrig = System.err;
        this._buffer = new StringBuffer(256);
        this._newOut = new OutputErrorStream(this._outOrig);
        this._newErr = new OutputErrorStream(this._errOrig);
        try {
            System.setOut(this._newOut);
            System.setErr(this._newErr);
        }
        catch (SecurityException exception) {
            Util.printlnErr("Warning: an AccessControlException happened while trying to redirect\nstandard output streams. Please relax your security policy for your jdk\nin order to let the application run with its full functionality.\nYou should grand more permissions in file $JAVA_HOME/jre/lib/security/java.policy.\nE.g. put\n'grant {\n    permission java.security.AllPermission;\n};'\nin that file (backup the original content).\nIf you don't want to do anything like this the application should still\nwork with most of its functionality.\n");
        }
    }

    public void deinstall() {
        if (this._buffer != null) {
            try {
                System.setOut(this._outOrig);
                System.setErr(this._errOrig);
            }
            catch (SecurityException exception) {
                Util.println("Again AccessControlException: please relax your security policy for your jdk\nin order to let Jacob run with its full functionality.\nYou should grand more permissions in file e.g. $JAVA_HOME/jre/lib/security/java.policy.");
            }
        }
        this._buffer = null;
        this._newOut = null;
        this._newErr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStreamsBuffer() {
        String retVal = null;
        StringBuffer stringBuffer = this._buffer;
        synchronized (stringBuffer) {
            retVal = this._buffer.toString();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStreamsBuffer() {
        StringBuffer stringBuffer = this._buffer;
        synchronized (stringBuffer) {
            this._buffer.setLength(0);
            this._lastFlushIndex = 0;
        }
    }

    public void setVisible(boolean bVisible_) {
        this._bVisible = bVisible_;
    }

    protected synchronized void setChanged() {
        super.setChanged();
    }

    public class OutputErrorStream
    extends PrintStream {
        private PrintStream _out = null;

        public OutputErrorStream(PrintStream out_) {
            super(out_);
            this._out = out_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void _notifyObservers() {
            StringBuffer stringBuffer = OutputErrorStreamManager.this._buffer;
            synchronized (stringBuffer) {
                int len = OutputErrorStreamManager.this._buffer.length() - OutputErrorStreamManager.this._lastFlushIndex;
                if (len > 0) {
                    char[] acNewOutput = new char[len];
                    OutputErrorStreamManager.this._buffer.getChars(OutputErrorStreamManager.this._lastFlushIndex, OutputErrorStreamManager.this._buffer.length(), acNewOutput, 0);
                    OutputErrorStreamManager.this.notifyObservers(new String(acNewOutput));
                    if (OutputErrorStreamManager.this._bAutoClear) {
                        OutputErrorStreamManager.this.clearStreamsBuffer();
                    } else {
                        OutputErrorStreamManager.this._lastFlushIndex = OutputErrorStreamManager.this._buffer.length();
                    }
                }
            }
        }

        public void flush() {
            this._notifyObservers();
            this._out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) {
            StringBuffer stringBuffer = OutputErrorStreamManager.this._buffer;
            synchronized (stringBuffer) {
                OutputErrorStreamManager.this._buffer.append((char)b);
                OutputErrorStreamManager.this.setChanged();
                if ((char)b == '\n') {
                    this._notifyObservers();
                }
            }
            if (OutputErrorStreamManager.this._bVisible) {
                this._out.write(b);
            }
        }

        public void write(byte[] buf, int off, int len) {
            int index = off;
            while (index - off < len) {
                this.write(buf[index]);
                ++index;
            }
        }
    }
}

