/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.Exitable;
import ccl.util.FileObject;
import ccl.util.FileUtil;
import ccl.util.IniFile;
import ccl.util.Option;
import ccl.util.Util;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Init {
    private static final String S_PROJECTSUFFIX_KEY = "ProjectSuffix";
    private static final String S_INI_SUFFIX = ".ini";
    private static final String S_INIFILE_INIT = "Init";
    private static final String S_INIFILE_INIT_FILE = "File";
    private static final String S_INIFILE_INIT_OLDFILES = "OldFiles";
    private static final String S_INIFILE_INIT_DEBUG = "Debug";
    private static final String S_INIFILE_INIT_AUTHOR = "Author";
    private static final String S_INIFILE_HELP = "Help";
    private static final String S_INIFILE_HELP_USAGE = "HelpUsage";
    private static final String S_INIFILE_COLORS = "Colors";
    private static final String S_INIFILE_SYSTEM_COLORS = "UseSystemColors";
    private static final String S_INIFILE_COLORS_BACK = "Background";
    private static final String S_INIFILE_COLORS_LISTBACK = "ListBackground";
    private static final String S_INIFILE_COLORS_LISTFORE = "ListForeground";
    private static final String S_INIFILE_COLORS_LISTHIGHLIGHT = "ListHighlight";
    private static final String S_OPTION_STRING = " string";
    private int _maxProjects = 9;
    private String _sInfoHeader;
    private Color _clrBackground = null;
    private Color _clrForeground = null;
    private Color _clrListBackground = null;
    private Color _clrListForeground = null;
    private Color _clrListHighlight = null;
    private Color _clrTextBackground = null;
    private Color _clrTextForeground = null;
    private String _sBackground = null;
    private String _sForeground = null;
    private String _sListBackground = null;
    private String _sListForeground = null;
    private String _sListHighlight = null;
    private String _sTextBackground = null;
    private String _sTextForeground = null;
    private String _sAuthor = "<unknown author>";
    private String _sFileFullName = "";
    private String _sApplicationName = null;
    private String _sApplicationPath = null;
    private String _sFullIniFileName = null;
    private Hashtable _hshKeyValues = new Hashtable();
    private Hashtable _htOptions = new Hashtable();
    private Vector _vArguments = new Vector();
    private Vector _vOldFiles = new Vector();
    private boolean _bSurpressInifileOption = false;
    private String _sIniFileContent = null;
    private boolean _bColorsInitialized = false;

    private static String _getArchivePath(String sApplicationName_) {
        String sClasspath = System.getProperty("java.class.path");
        return Init._getArchivePath(sApplicationName_, sClasspath);
    }

    private static String _getArchivePath(String sApplicationName_, String sClassPath) {
        Vector vClasspath = Util.stringToLines(sClassPath, File.pathSeparatorChar);
        Enumeration eClasspath = vClasspath.elements();
        while (eClasspath.hasMoreElements()) {
            String sNextPath = (String)eClasspath.nextElement();
            if (!Util.endsWith(sNextPath, ".zip") && !Util.endsWith(sNextPath, ".jar")) continue;
            int lastSeparator = sNextPath.lastIndexOf(File.separatorChar);
            String sArchiveName = sNextPath.substring(lastSeparator + 1, sNextPath.length() - 4);
            Util.debug("ccl.util.Init._getArchivePath(..).sArchiveName: " + sArchiveName);
            if (!sArchiveName.startsWith(sApplicationName_)) continue;
            String sApplicationPath = sNextPath.substring(0, lastSeparator + 1);
            if (Util.isEmpty(sApplicationPath)) {
                sApplicationPath = ".";
            }
            return sApplicationPath;
        }
        return ".";
    }

    private void _setClassPath() {
        String sStartPath = System.getProperty("user.dir");
        Util.debug("_setClassPath: sStartPath: " + sStartPath);
        String sClassPath = System.getProperty("java.class.path");
        Util.debug("_setClassPath: sClassPath: " + sClassPath);
        Vector vClassPaths = Util.stringToLines(sClassPath, File.pathSeparatorChar);
        Util.debug("_setClassPath: vClassPaths: " + vClassPaths);
        int classPath = 0;
        while (classPath < vClassPaths.size()) {
            String sSingleClassPath = (String)vClassPaths.elementAt(classPath);
            Util.debug("_setClassPath: sSingleClassPath: " + sSingleClassPath);
            if (sSingleClassPath.startsWith(".")) {
                sSingleClassPath = FileUtil.concatPath(sStartPath, sSingleClassPath);
                try {
                    File flSingleClassPath = new File(sSingleClassPath);
                    sSingleClassPath = flSingleClassPath.getCanonicalPath();
                }
                catch (Exception e) {
                    // empty catch block
                }
                vClassPaths.setElementAt(sSingleClassPath, classPath);
            }
            ++classPath;
        }
        sClassPath = Util.concat(vClassPaths, File.pathSeparatorChar);
        if (sClassPath.length() > 0 && !Util.endsWith(sClassPath, File.pathSeparatorChar)) {
            sClassPath = sClassPath + Util.cToS(File.pathSeparatorChar);
        }
        Util.debug("_setClassPath: sClassPath: " + sClassPath);
        Properties pProperties = System.getProperties();
        pProperties.put("java.class.path", sClassPath);
    }

    private void _initColors() {
        String sColor;
        Object vRGBString = null;
        this._sBackground = "192 192 192";
        this._sForeground = "0 0 0";
        this._sListBackground = this._sBackground;
        this._sListHighlight = this._sListForeground = this._sForeground;
        this._sTextBackground = "255 255 255";
        this._sTextForeground = this._sForeground;
        boolean bSystemColors = Util.atob(this.getKeyValue(S_INIFILE_COLORS, S_INIFILE_SYSTEM_COLORS));
        Util.debug(this, (Object)("_init().bSystemColors: " + bSystemColors));
        if (bSystemColors) {
            this._clrBackground = new Color(SystemColor.window.getRGB());
            Util.debug(this, (Object)("_init().SystemColor: " + this._clrBackground));
        } else {
            sColor = this.getKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_BACK);
            if (!Util.isEmpty(sColor)) {
                this._sBackground = sColor;
            }
        }
        Util.debug(this, (Object)("_initColors()._sBackground: " + this._sBackground));
        sColor = this.getKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_LISTBACK);
        if (!Util.isEmpty(sColor)) {
            this._sListBackground = sColor;
        }
        if (!Util.isEmpty(sColor = this.getKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_LISTFORE))) {
            this._sListForeground = sColor;
        }
        if (!Util.isEmpty(sColor = this.getKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_LISTHIGHLIGHT))) {
            this._sListHighlight = sColor;
        }
        this._bColorsInitialized = true;
    }

    public static String getApplicationPath(String sApplicationName, String sPackageName, String sClassPath) {
        String sApplicationPath = Init._getArchivePath(sApplicationName.toLowerCase(), sClassPath);
        Util.debug("ccl.util.Init.getApplicationPath(..).sApplicationPath.1: " + sApplicationPath);
        if (sApplicationPath.equals(".")) {
            Util.debug("ccl.util.Init.getApplicationPath(..).sPackageName: " + sPackageName);
            sApplicationPath = FileUtil.getPackagePath(sPackageName, sClassPath);
            Util.debug("ccl.util.Init.getApplicationPath>(..).sApplicationPath.2: " + sApplicationPath);
            if (Util.isEmpty(sApplicationPath)) {
                sApplicationPath = Init._getArchivePath(sPackageName, sClassPath);
                Util.debug("ccl.util.Init.<init>(..).sApplicationPath.3: " + sApplicationPath);
            }
        }
        sApplicationPath = FileUtil.getAbsolutePath(sApplicationPath);
        Util.debug("ccl.util.Init.getApplicationPath(..).sApplicationPath.4: " + sApplicationPath);
        if (sApplicationPath.length() > 0 && sApplicationPath.charAt(sApplicationPath.length() - 1) != File.separatorChar) {
            sApplicationPath = sApplicationPath + File.separator;
        }
        if (sApplicationPath.endsWith(File.separator + "lib" + File.separator)) {
            sApplicationPath = sApplicationPath.substring(0, sApplicationPath.lastIndexOf(File.separator + "lib" + File.separator));
        } else if (sApplicationPath.indexOf(File.separator + "classes" + File.separator) != -1) {
            sApplicationPath = sApplicationPath.substring(0, sApplicationPath.lastIndexOf(File.separator + "classes" + File.separator));
        }
        if (sApplicationPath.equals("lib") || sApplicationPath.equals("lib" + File.separator)) {
            sApplicationPath = ".";
        }
        return sApplicationPath;
    }

    private void _init() {
        boolean bDebug = Util.atob(this.getKeyValue(S_INIFILE_INIT_DEBUG));
        if (bDebug) {
            Util.setDebug(bDebug);
        }
        this._sFileFullName = this.getKeyValue(S_INIFILE_INIT_FILE);
        Util.debug("Init: <init>: _sFileFullName: " + this._sFileFullName);
        if (this._sFileFullName == null) {
            this._sFileFullName = "";
        }
        String sOldFiles = this.getKeyValue(S_INIFILE_INIT_OLDFILES);
        int i = 0;
        int j = 0;
        while (j < this._maxProjects) {
            int k = sOldFiles.indexOf(59, i);
            if (k == -1) break;
            String string3 = sOldFiles.substring(i, k);
            this._vOldFiles.addElement(new FileObject(string3));
            i = k + 1;
            ++j;
        }
        String tempAuthor = this.getKeyValue(S_INIFILE_INIT_AUTHOR);
        Util.debug("_init().tempAuthor: " + tempAuthor);
        if (!Util.isEmpty(tempAuthor)) {
            this._sAuthor = tempAuthor;
        }
    }

    private static Color _stringToColor(String sInitColor_) {
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            Vector vRGB = Util.stringToLines(sInitColor_, ' ');
            red = Util.atoi((String)vRGB.elementAt(0));
            green = Util.atoi((String)vRGB.elementAt(1));
            blue = Util.atoi((String)vRGB.elementAt(2));
        }
        catch (ArrayIndexOutOfBoundsException arrayException) {
            Util.printlnErr("ccl.util.Init._stringToColor(..).sInitColor_: -->" + sInitColor_ + "<--");
            arrayException.printStackTrace();
        }
        Color colRetVal = new Color(red, green, blue);
        return colRetVal;
    }

    public Init(Exitable pExitable_, String[] asArg_, String sInfoHeader_, String sIniFileContent_) {
        if (asArg_ == null) {
            asArg_ = new String[]{};
        }
        this._setDebug(asArg_);
        this._sIniFileContent = sIniFileContent_;
        Util.debug(this, (Object)("<init>(..)._sIniFileContent: " + this._sIniFileContent));
        this._sInfoHeader = sInfoHeader_;
        String sClassName = pExitable_.getClass().getName();
        Util.debug("Init.<init>(..).sClassName: " + sClassName);
        this._setClassPath();
        String sPackageName = ".";
        if (sClassName.indexOf(46) == -1) {
            this._sApplicationName = new String(sClassName);
        } else {
            String sTempClassName = sClassName.substring(sClassName.lastIndexOf(46) + 1);
            if (!(sTempClassName.equals("Main") || sTempClassName.equals("Controller") || sTempClassName.equals("ViewController"))) {
                sPackageName = sClassName.substring(0, sClassName.lastIndexOf(46));
                this._sApplicationName = sClassName.substring(sClassName.lastIndexOf(46) + 1);
            } else {
                sPackageName = sClassName.substring(0, sClassName.lastIndexOf(46));
                this._sApplicationName = sPackageName.substring(sPackageName.lastIndexOf(46) + 1, sPackageName.length());
                this._sApplicationName = Util.firstCharToUpperCase(this._sApplicationName);
            }
        }
        Util.debug(this, (Object)("<init>(..)._sApplicationName: " + this._sApplicationName));
        this._sApplicationPath = Init.getApplicationPath(this._sApplicationName, sPackageName, System.getProperty("java.class.path"));
        Util.panicIf(asArg_ == null);
        int nr = 0;
        while (nr < asArg_.length) {
            Util.debug("Init.<init>(..).asArg_[" + nr + "]: " + asArg_[nr]);
            if (asArg_[nr].charAt(0) == '-' && asArg_[nr].equals("-inifile")) {
                if (nr + 1 >= asArg_.length) {
                    Util.println("Error: No ini file name specified.");
                    pExitable_.setExit();
                    return;
                }
                this._sFullIniFileName = new String(asArg_[nr + 1]);
                break;
            }
            ++nr;
        }
        if (Util.isEmpty(this._sFullIniFileName)) {
            String sTempClassName = pExitable_.getClass().getName().toLowerCase();
            sTempClassName = sTempClassName.substring(sTempClassName.lastIndexOf(46) + 1);
            this._sFullIniFileName = this._sApplicationPath + File.separator + sTempClassName + S_INI_SUFFIX;
            Util.debug(this, (Object)("<init>(..)._sFullIniFileName: " + this._sFullIniFileName));
            if (FileUtil.existsFile(this._sFullIniFileName)) {
                this._sApplicationName = Util.firstCharToUpperCase(sTempClassName);
                this._bSurpressInifileOption = true;
            } else {
                this._sFullIniFileName = this._sApplicationPath + File.separator + this._sApplicationName.toLowerCase() + S_INI_SUFFIX;
                if (!FileUtil.existsFile(this._sFullIniFileName)) {
                    int classesIndex = this._sFullIniFileName.lastIndexOf(File.separator + "classes" + File.separator);
                    String sNewFullIniFileName = this._sFullIniFileName.substring(0, classesIndex + 1) + "src" + File.separator + sPackageName.replace('.', File.separatorChar) + File.separator + this._sApplicationName.toLowerCase() + S_INI_SUFFIX;
                    Util.debug(this, (Object)("<init>(..).sNewFullIniFileName: " + sNewFullIniFileName));
                    if (FileUtil.existsFile(sNewFullIniFileName)) {
                        this._sFullIniFileName = sNewFullIniFileName;
                    }
                }
            }
        } else {
            this._sFullIniFileName = FileUtil.getAbsoluteFileName(this._sFullIniFileName);
            if (Util.isEmpty(this._sFullIniFileName)) {
                Util.println("Error: No ini file name specified.");
                pExitable_.setExit();
                return;
            }
        }
        Util.debug("Init.<init>(..)._sFullIniFileName: " + this._sFullIniFileName);
        this._init();
        this._processParameters(pExitable_, asArg_);
    }

    private void _setDebug(String[] asArg_) {
        if (asArg_ != null) {
            int option = 0;
            while (option < asArg_.length) {
                if (asArg_[option].equals("-debug")) {
                    Util.setDebug(true);
                }
                ++option;
            }
        }
    }

    private void _processParameters(Exitable pExitable_, String[] asArg_) {
        int nr = 0;
        while (nr < asArg_.length) {
            if (asArg_[nr].charAt(0) != '-') {
                this._vArguments.addElement(new String(asArg_[nr]));
            } else {
                String sOption = asArg_[nr].substring(1, asArg_[nr].length());
                Util.debug("Init.<init>(..).sOption: " + sOption);
                if (sOption.equals("version")) {
                    Util.println("" + this._sApplicationName.toUpperCase() + " version " + this.getVersionString() + " " + this.getVersionDate() + " by " + this.getAuthor());
                    pExitable_.setExit();
                } else {
                    if (sOption.equals("help")) {
                        this.printHelpMessage();
                        pExitable_.setExit();
                        return;
                    }
                    if (sOption.equals("inifile")) {
                        ++nr;
                        if (this._bSurpressInifileOption) {
                            Util.println("Error: No custom ini file supported!");
                            pExitable_.setExit();
                            return;
                        }
                    } else if (!sOption.equals("debug")) {
                        String sOptionDocu = this.getKeyValue(S_INIFILE_HELP, sOption);
                        if (!Util.isEmpty(sOptionDocu)) {
                            Option pOption = new Option(sOption, sOptionDocu);
                            Object oOptionValue = new Boolean(true);
                            if (pOption.getType() == 1) {
                                if (nr + 1 >= asArg_.length) {
                                    Util.println("Error: Option " + sOption + " needs a string value.");
                                    this.printHelpMessage();
                                    pExitable_.setExit();
                                    return;
                                }
                                oOptionValue = new String(asArg_[nr + 1]);
                                ++nr;
                            }
                            this._htOptions.put(sOption, oOptionValue);
                        } else {
                            Util.println("Error: Option '" + sOption + "' is not acceptable.");
                            this.printHelpMessage();
                            pExitable_.setExit();
                            return;
                        }
                    }
                }
            }
            ++nr;
        }
    }

    public Init(Exitable pExitable_, String[] asArg_, String sInfoHeader_) {
        this(pExitable_, asArg_, sInfoHeader_, null);
    }

    protected Init() {
    }

    public String getHelpMessage() {
        String sOptions = this.getKeyValue(S_INIFILE_HELP, "Options");
        Vector vOptions = Util.stringToLines(sOptions, ',');
        Hashtable<String, Option> htOptions = new Hashtable<String, Option>();
        int maxOptionLength = 7;
        Enumeration eOptions = vOptions.elements();
        while (eOptions.hasMoreElements()) {
            String sNextOption = (String)eOptions.nextElement();
            Util.debug(this, (Object)("printHelpMessage().sNextOption: " + sNextOption));
            Option pOption = new Option(sNextOption, this.getKeyValue(S_INIFILE_HELP, sNextOption));
            htOptions.put(sNextOption, pOption);
            if (sNextOption.length() <= maxOptionLength) continue;
            maxOptionLength = sNextOption.length();
        }
        String sUsage = this.getKeyValue(S_INIFILE_HELP, S_INIFILE_HELP_USAGE);
        String sSynopsis = "Usage: " + this._sApplicationName.toLowerCase() + " ";
        String sMandatory = "";
        String sOptional = "";
        String sRemarks = "";
        Enumeration eOptions2 = vOptions.elements();
        while (eOptions2.hasMoreElements()) {
            String sOption = (String)eOptions2.nextElement();
            Option optNext = (Option)htOptions.get(sOption);
            sRemarks = sRemarks + "       " + sOption + ":   " + Util.getSpaces(maxOptionLength - sOption.length()) + optNext.getDescription() + "\n";
            if (optNext.getType() == 1) {
                sOption = sOption + S_OPTION_STRING;
            }
            if (optNext.isMandatory()) {
                sMandatory = sMandatory + "-" + sOption + " ";
                continue;
            }
            sOptional = sOptional + "[-" + sOption + "] ";
        }
        sRemarks = sRemarks + "       version:   " + Util.getSpaces(maxOptionLength - 7) + "Prints the version number of the program.\n" + "       help:   " + Util.getSpaces(maxOptionLength - 4) + "Prints this help message.\n" + "       debug:   " + Util.getSpaces(maxOptionLength - 5) + "Prints debugging information while running.";
        if (!this._bSurpressInifileOption) {
            sRemarks = sRemarks + "\n       inifile:   " + Util.getSpaces(maxOptionLength - 7) + "Starts this application with another ini file than\n" + "           " + Util.getSpaces(maxOptionLength) + "the default one.";
        }
        sOptional = sOptional + "[-version] [-help] [-debug] [-inifile foo.ini] ";
        sSynopsis = sSynopsis + sMandatory + sOptional + sUsage;
        String sRetVal = sSynopsis + "\n" + sRemarks + "\n";
        return sRetVal;
    }

    public void printHelpMessage() {
        Util.print(this.getHelpMessage());
    }

    public synchronized boolean setKeyValue(String sKey_, int value_) {
        return this.setKeyValue(sKey_, Util.itoa(value_));
    }

    public synchronized boolean setKeyValue(String sKey_, String sValue_) {
        return this.setKeyValue(S_INIFILE_INIT, sKey_, sValue_);
    }

    public synchronized boolean setKeyValue(String sSection_, String sKey_, String sValue_) {
        this._hshKeyValues.put(sSection_ + sKey_, sValue_);
        IniFile.setKeyValue(this._sFullIniFileName, sSection_, sKey_, sValue_);
        return IniFile.getStatus() != 0;
    }

    public Vector getArguments() {
        return (Vector)this._vArguments.clone();
    }

    public Hashtable getOptions() {
        return (Hashtable)this._htOptions.clone();
    }

    public Enumeration getArgumentsElements() {
        return this._vArguments.elements();
    }

    public synchronized String getKeyValue(String sSection_, String sKey_) {
        if (this._hshKeyValues.containsKey(sSection_ + sKey_)) {
            return (String)this._hshKeyValues.get(sSection_ + sKey_);
        }
        String sValue = IniFile.getKeyValue(this._sFullIniFileName, sSection_, sKey_, this._sIniFileContent);
        Util.debug("Init.getKeyValue(..).IniFile.status(): " + IniFile.getStatus());
        this._hshKeyValues.put(sSection_ + sKey_, sValue);
        return sValue;
    }

    public synchronized String getKeyValue(String sKey_) {
        return this.getKeyValue(S_INIFILE_INIT, sKey_);
    }

    public String getInfoHeader() {
        return this._sInfoHeader;
    }

    public Color getBackground() {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        if (this._clrBackground == null) {
            this._clrBackground = Init._stringToColor(this._sBackground);
        }
        return new Color(this._clrBackground.getRGB());
    }

    public Color getForeground() {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        if (this._clrForeground == null) {
            this._clrForeground = Init._stringToColor(this._sForeground);
        }
        return new Color(this._clrForeground.getRGB());
    }

    public Color getListBackground() {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        if (this._clrListBackground == null) {
            this._clrListBackground = Init._stringToColor(this._sListBackground);
        }
        return new Color(this._clrListBackground.getRGB());
    }

    public Color getListForeground() {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        if (this._clrListForeground == null) {
            this._clrListForeground = Init._stringToColor(this._sListForeground);
        }
        return new Color(this._clrListForeground.getRGB());
    }

    public Color getListHighlight() {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        if (this._clrListHighlight == null) {
            this._clrListHighlight = Init._stringToColor(this._sListHighlight);
        }
        return new Color(this._clrListHighlight.getRGB());
    }

    public String colorToString(Color pColor_) {
        Util.panicIf(pColor_ == null);
        return "" + pColor_.getRed() + " " + pColor_.getGreen() + " " + pColor_.getBlue();
    }

    public void setBackground(Color pColor_) {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        Util.panicIf(pColor_ == null);
        this._clrBackground = new Color(pColor_.getRGB());
        this.setKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_BACK, this.colorToString(this._clrBackground));
    }

    public void setListBackground(Color pColor_) {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        Util.panicIf(pColor_ == null);
        this._clrListBackground = new Color(pColor_.getRGB());
        this.setKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_LISTBACK, this.colorToString(this._clrListBackground));
    }

    public void setListForeground(Color pColor_) {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        Util.panicIf(pColor_ == null);
        this._clrListForeground = new Color(pColor_.getRGB());
        this.setKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_LISTFORE, this.colorToString(this._clrListForeground));
    }

    public void setListHighlight(Color pColor_) {
        if (!this._bColorsInitialized) {
            this._initColors();
        }
        Util.panicIf(pColor_ == null);
        this._clrListHighlight = new Color(pColor_.getRGB());
        this.setKeyValue(S_INIFILE_COLORS, S_INIFILE_COLORS_LISTHIGHLIGHT, this.colorToString(this._clrListHighlight));
    }

    public void setApplicationName(String sApplicationName_) {
        this._sApplicationName = sApplicationName_;
    }

    public String getApplicationName() {
        return this._sApplicationName;
    }

    public String getApplicationPath() {
        return this._sApplicationPath;
    }

    public String getHelpBrokerURL() {
        String sPath = this.getApplicationPath();
        Util.debug(this, (Object)("getHelpBrokerURL(..).sPath: " + sPath));
        sPath = Util.replace(sPath, '\\', '/');
        if (!Util.endsWith(sPath, "/")) {
            sPath = sPath + "/";
        }
        if (Util.endsWith(sPath, "/lib/") || sPath.equals("lib/")) {
            sPath = sPath + "../";
        } else {
            int classesIndex = sPath.lastIndexOf("/classes/");
            if (classesIndex == -1) {
                if (sPath.startsWith("classes/")) {
                    classesIndex = 0;
                }
            } else {
                ++classesIndex;
            }
            if (classesIndex != -1) {
                sPath = sPath.substring(0, classesIndex);
            }
        }
        sPath = FileUtil.getAbsoluteFileName(sPath);
        Util.debug(this, (Object)("getHelpBrokerURL(..).sPath: " + sPath));
        String sHSFile = "file:" + sPath + "/doc/" + this.getApplicationName().toLowerCase() + ".hs";
        return sHSFile;
    }

    public String getApplicationDocPath() {
        String sPath = this.getApplicationPath();
        if (!Util.endsWith(sPath = Util.replace(sPath, '\\', '/'), "/")) {
            sPath = sPath + "/";
        }
        if (Util.endsWith(sPath, "/lib/") || sPath.equals("lib/")) {
            sPath = sPath + "../";
        } else {
            int classesIndex = sPath.lastIndexOf("/classes/");
            if (classesIndex == -1) {
                if (sPath.startsWith("classes/")) {
                    classesIndex = 0;
                }
            } else {
                ++classesIndex;
            }
            if (classesIndex != -1) {
                sPath = sPath.substring(0, classesIndex);
            }
        }
        sPath = FileUtil.getAbsoluteFileName(sPath);
        sPath = FileUtil.concatPath(sPath, "doc");
        return sPath;
    }

    private void _saveOldFiles() {
        String sOldFiles = "";
        int i = 0;
        while (i < this._vOldFiles.size()) {
            FileObject pFileObject = (FileObject)this._vOldFiles.elementAt(i);
            Util.debug("Init._saveOldFiles()._vOldFiles: " + this._vOldFiles);
            if (Util.equalsCaseless(pFileObject.getName(), this.getFileName())) {
                this._vOldFiles.removeElementAt(i);
                --i;
            } else {
                sOldFiles = sOldFiles + pFileObject.getFileFullName() + ";";
            }
            ++i;
        }
        if (Util.getOccurances(sOldFiles, 59) > this._maxProjects) {
            sOldFiles = sOldFiles.substring(sOldFiles.indexOf(59) + 1, sOldFiles.length());
            this._vOldFiles.removeElementAt(0);
        }
        Util.debug("Init._saveOldFiles().sOldFiles: " + sOldFiles);
        this.setKeyValue(S_INIFILE_INIT_OLDFILES, sOldFiles);
    }

    public boolean setFileFullName(String sFileFullName_) {
        if (!Util.isEmpty(this.getFileFullName())) {
            this.makeThisFileOld();
        }
        if (Util.isEmpty(sFileFullName_)) {
            this._sFileFullName = "";
            this.setKeyValue(S_INIFILE_INIT, S_INIFILE_INIT_FILE, "");
            this._saveOldFiles();
            int status = IniFile.getStatus();
            boolean bRetVal = status != 0;
            return bRetVal;
        }
        this._sFileFullName = FileUtil.getAbsoluteFileName(sFileFullName_);
        Util.debug(this, (Object)("setFileFullName(..)._sApplicationPath: " + this._sApplicationPath));
        Util.debug(this, (Object)("setFileFullName(..)._sApplicationName: " + this._sApplicationName));
        this.setKeyValue(S_INIFILE_INIT, S_INIFILE_INIT_FILE, this._sFileFullName);
        int status = IniFile.getStatus();
        boolean bRetVal = status != 0;
        Util.debug("Init: setFileFullName: _vOldFiles: " + this._vOldFiles);
        String sOldFiles = "";
        int i = 0;
        while (i < this._vOldFiles.size()) {
            FileObject pFileObject = (FileObject)this._vOldFiles.elementAt(i);
            if (Util.equalsCaseless(pFileObject.getName(), this.getFileName())) {
                Util.debug("Init: setFileFullName: pFileObject.getName(): " + pFileObject.getName());
                Util.debug("Init.setFileFullName().getFileName(): " + this.getFileName());
                this._vOldFiles.removeElementAt(i);
                --i;
            } else {
                sOldFiles = sOldFiles + pFileObject.getFileFullName() + ";";
            }
            ++i;
        }
        if (Util.getOccurances(sOldFiles, 59) > this._maxProjects) {
            sOldFiles = sOldFiles.substring(sOldFiles.indexOf(59) + 1, sOldFiles.length());
            this._vOldFiles.removeElementAt(0);
        }
        Util.debug("Init: setFileFullName: sOldFiles: " + sOldFiles);
        this.setKeyValue(S_INIFILE_INIT_OLDFILES, sOldFiles);
        return bRetVal;
    }

    public String getFileName() {
        Util.debug("Init: getFileName: _sFileFullName: " + this._sFileFullName);
        String sRetVal = new String(this._sFileFullName);
        sRetVal = sRetVal.replace('\\', '/');
        int indexStart = sRetVal.lastIndexOf(47) + 1;
        int indexStop = sRetVal.lastIndexOf(46);
        if (indexStart == -1 || indexStop == -1 || indexStart > indexStop) {
            return "";
        }
        sRetVal = sRetVal.substring(indexStart, indexStop);
        sRetVal = Util.firstCharToUpperCase(sRetVal);
        return sRetVal;
    }

    public String getFileFullName() {
        return this._sFileFullName;
    }

    public String getFilePath() {
        String sRetVal = new String(this._sFileFullName);
        int indexStop = (sRetVal = sRetVal.replace('\\', '/')).lastIndexOf(47) + 1;
        Util.panicIf(indexStop == -1);
        sRetVal = sRetVal.substring(0, indexStop);
        return sRetVal;
    }

    public String getProjectHome() {
        return FileUtil.getAbsoluteFileName(new File(this.getFileFullName()).getParent());
    }

    public Enumeration getOldFilesElements() {
        return this._vOldFiles.elements();
    }

    public int getOldFilesSize() {
        return this._vOldFiles.size();
    }

    public String getOldFileFullName(String string) {
        Enumeration enumeration = this._vOldFiles.elements();
        while (enumeration.hasMoreElements()) {
            FileObject pFileObject = (FileObject)enumeration.nextElement();
            if (!Util.equalsCaseless(pFileObject.getName(), string)) continue;
            return pFileObject.getFileFullName();
        }
        Util.panicIf(true, "ccl.util.Init.getOldFileFullName(.).A file should always have been found!");
        return null;
    }

    public void makeThisFileOld() {
        if (this._sFileFullName != null && !this._sFileFullName.equals("")) {
            Util.debug("Init.makeThisFileOld()._sFileFullName: " + this._sFileFullName);
            FileObject pFileObject = new FileObject(this._sFileFullName);
            Util.debug("Init.makeThisFileOld().pFileObject: " + pFileObject);
            this._vOldFiles.addElement(pFileObject);
            Util.debug("Init.makeThisFileOld()._vOldFiles: " + this._vOldFiles);
        }
    }

    public String getVersionString() {
        Util.debug(this, (Object)("getVersionString()._sInfoHeader: " + this._sInfoHeader));
        if (this._sInfoHeader == null) {
            return "1.1";
        }
        int index = this._sInfoHeader.indexOf(" ", 9) + 1;
        String sHead = this._sInfoHeader.substring(index, this._sInfoHeader.length());
        index = sHead.indexOf(32);
        String sVersion = sHead.substring(0, index);
        Util.debug(this, (Object)("getVersionString().sVersion: " + sVersion));
        return sVersion;
    }

    public int getVersion() {
        String sVersion = this.getVersionString();
        sVersion = sVersion.substring(0, sVersion.indexOf(46));
        return Util.atoi(sVersion);
    }

    public int getRelease() {
        String sVersion = this.getVersionString();
        String sRelease = sVersion.substring(sVersion.indexOf(46) + 1, sVersion.length());
        return Util.atoi(sRelease);
    }

    public String getVersionDate() {
        String sVersion = this.getVersionString();
        int index = this._sInfoHeader.indexOf(sVersion) + sVersion.length() + 1;
        String sHead = this._sInfoHeader.substring(index, this._sInfoHeader.length());
        index = sHead.indexOf(32);
        String sDate = sHead.substring(0, index);
        int year = Util.atoi(sDate.substring(0, 4));
        int month = Util.atoi(sDate.substring(5, 7)) - 1;
        int day = Util.atoi(sDate.substring(8, 10));
        sDate = "" + year + "-" + Util.paddWithZero(month + 1, 2) + "-" + Util.paddWithZero(day, 2);
        return sDate;
    }

    public String getVersionTime() {
        String sVersion = this.getVersionString();
        int index = this._sInfoHeader.indexOf(sVersion) + sVersion.length() + 12;
        String sHead = this._sInfoHeader.substring(index, this._sInfoHeader.length());
        index = sHead.indexOf(32);
        String sTime = sHead.substring(0, index);
        return sTime;
    }

    public static String getProjectSuffixKey() {
        return S_PROJECTSUFFIX_KEY;
    }

    public String getAuthor() {
        return this._sAuthor;
    }

    public void setAuthor(String sAuthor_) {
        this._sAuthor = sAuthor_;
    }

    public String createBackupFile() {
        String sErrorMessage = null;
        if (this._sFullIniFileName == null) {
            return sErrorMessage;
        }
        try {
            FileUtil.createBackupFile(this._sFullIniFileName);
        }
        catch (IOException exception) {
            sErrorMessage = "Failure to create backup for initialization file\n'" + this._sFullIniFileName + "':\n" + exception;
        }
        return sErrorMessage;
    }

    public Object clone() {
        Init iniRetVal = new Init();
        iniRetVal._maxProjects = this._maxProjects;
        iniRetVal._sInfoHeader = this._sInfoHeader;
        iniRetVal._clrBackground = this.getBackground();
        iniRetVal._clrForeground = this.getForeground();
        iniRetVal._clrListBackground = this.getListBackground();
        iniRetVal._clrListForeground = this.getListForeground();
        iniRetVal._clrListHighlight = this.getListHighlight();
        iniRetVal._clrTextBackground = null;
        iniRetVal._clrTextForeground = null;
        iniRetVal._sAuthor = this._sAuthor;
        iniRetVal._sFileFullName = this._sFileFullName;
        iniRetVal._sApplicationName = this._sApplicationName;
        iniRetVal._sApplicationPath = this._sApplicationPath;
        iniRetVal._sFullIniFileName = this._sFullIniFileName;
        iniRetVal._htOptions = (Hashtable)this._htOptions.clone();
        iniRetVal._vArguments = (Vector)this._vArguments.clone();
        iniRetVal._vOldFiles = (Vector)this._vOldFiles.clone();
        iniRetVal._bSurpressInifileOption = this._bSurpressInifileOption;
        iniRetVal._sIniFileContent = this._sIniFileContent;
        return iniRetVal;
    }
}

