/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class TableScrollPane
extends JScrollPane {
    private JTable _table = null;

    public TableScrollPane(JTable aTable) {
        super(aTable);
        this._table = aTable;
    }

    public void paintComponent(Graphics g) {
        TableScrollPane.paintComponent(g, this._table, this);
    }

    public static void paintComponent(Graphics g, JTable table, JScrollPane scrollpane) {
        Rectangle d = scrollpane.getViewport().getVisibleRect();
        d.width += scrollpane.getBorder().getBorderInsets((Component)scrollpane).left;
        d.height += 100;
        g.setColor(Color.white);
        g.fillRect(d.x, d.y, d.width, d.height);
        g.setColor(scrollpane.getBackground());
        g.fillRect(d.x + d.width, d.y, 100, 100);
        g.setColor(table.getGridColor());
        TableColumnModel model = table.getColumnModel();
        int offset = scrollpane.getBorder().getBorderInsets((Component)scrollpane).left - 1;
        Enumeration<TableColumn> eColumns = model.getColumns();
        while (eColumns.hasMoreElements()) {
            TableColumn column = eColumns.nextElement();
            if (!eColumns.hasMoreElements()) break;
            g.drawLine(offset += column.getWidth(), 0, offset, d.height);
        }
        Border border = scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle r = scrollpane.getViewportBorderBounds();
            border.paintBorder(scrollpane, g, r.x, r.y, r.width, r.height);
        }
    }

    public void setViewportView(Component view) {
        if (view instanceof JTable) {
            this._table = (JTable)view;
        }
        super.setViewportView(view);
    }
}

