/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.ExitJFrame;
import ccl.swing.MainJMenuBar;
import ccl.swing.RunnableAction;
import ccl.swing.SwingUtil;
import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class MainJFrame
extends ExitJFrame
implements Runnable,
ActionListener,
ChangeListener {
    public static final String S_DOC_DIR = "doc";
    private static final String S_MODIFIED_TITLE = " *";
    private Thread _pThread = null;
    private RunnableAction _pRunnableAction = null;
    private boolean _bStopThread = false;
    private boolean _bExit = false;
    private boolean _bAboutSelected = false;
    private boolean _bModified = false;
    private Init _pInit = null;
    private boolean _bBusy = false;
    private boolean _bConfirming = false;
    static /* synthetic */ Class class$ccl$swing$MainJMenuBar;

    public void setBusy(boolean busy) {
        this._bBusy = busy;
        this.getGlassPane().setVisible(busy);
        int cursorType = 0;
        if (busy) {
            cursorType = 3;
        }
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(cursorType));
    }

    public boolean isBusy() {
        return this._bBusy;
    }

    public MainJFrame() {
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().addKeyListener(new KeyAdapter(){});
    }

    public MainJFrame(String sTitle_) {
        this(sTitle_, new String[0], "");
    }

    public MainJFrame(String[] asArg_, String sRcsHeader_) {
        this("", asArg_, sRcsHeader_);
    }

    public MainJFrame(String sTitle_, String[] asArg_, String sRcsHeader_) {
        this();
        this.initialize(sTitle_, asArg_, sRcsHeader_);
    }

    public MainJFrame(String sTitle_, String[] asArg_, String sRcsHeader_, String sIniFile_) {
        this();
        this.initialize(sTitle_, asArg_, sRcsHeader_, sIniFile_);
    }

    public void initialize(String[] asArg_, String sInfoHeader_) {
        this.initialize("", asArg_, sInfoHeader_);
    }

    public void initialize(String sTitle_, String[] asArg_, String sRcsHeader_) {
        this.initialize(sTitle_, asArg_, sRcsHeader_, null);
    }

    public void initialize(String sTitle_, String[] asArg_, String sRcsHeader_, String sIniFileContent_) {
        Util.debug(this, (Object)"initialize(..).START");
        this.setTitle(sTitle_);
        this.setDefaultCloseOperation(0);
        this._bExit = false;
        this._pInit = new Init(this, asArg_, sRcsHeader_, sIniFileContent_);
        this.setBackground(this._pInit.getBackground());
        this.setForeground(this._pInit.getForeground());
        String sIconFileName = this._pInit.getApplicationName().toLowerCase() + ".gif";
        Util.debug("sIconFileName: " + sIconFileName);
        try {
            URL urlImage = this.getClass().getResource(sIconFileName);
            Util.debug(this, (Object)("initialize(..).urlImage: " + urlImage));
            if (urlImage != null) {
                Image pImage = Toolkit.getDefaultToolkit().getImage(urlImage);
                this.setIconImage(pImage);
            } else {
                Util.printlnErr("Warning: could not find image for '" + this._pInit.getApplicationName() + "' application main frame.");
            }
        }
        catch (MissingResourceException pMissingResourceException) {
            Util.printlnErr(this, (Object)("initialize(..).pMissingResourceException for file " + sIconFileName + ": " + pMissingResourceException));
        }
        catch (NullPointerException pNullPointerException) {
            Util.printlnErr(this, (Object)("initialize(..).pNullPointerException for file " + sIconFileName));
            pNullPointerException.printStackTrace();
        }
        SwingUtil.setMainFrame(this);
    }

    public synchronized void setMenuBar(Vector vMenus_) {
        MainJMenuBar pMainJMenuBar = new MainJMenuBar(vMenus_, this);
        Util.debug(this, (Object)("setJMenuBar(..).pMainJMenuBar: " + pMainJMenuBar));
        this.setJMenuBar(pMainJMenuBar);
    }

    public synchronized void updateMenu() {
        ((MainJMenuBar)this.getJMenuBar()).updateMenu();
    }

    public void runAction(RunnableAction pRunnableAction_) {
        if (this._pThread != null && pRunnableAction_ != null && this._pRunnableAction == null) {
            this._pRunnableAction = pRunnableAction_;
            this._pThread.interrupt();
        }
    }

    protected void runHook() {
        if (this._pRunnableAction != null) {
            try {
                this._pRunnableAction.run();
            }
            catch (Exception pException) {
                pException.printStackTrace();
            }
            this._pRunnableAction = null;
        }
    }

    public Init getInit() {
        return this._pInit;
    }

    public void run() {
        this._bStopThread = false;
        while (!this._bStopThread && this._pThread != null) {
            this.runHook();
            if (this._bAboutSelected) {
                this._bAboutSelected = false;
                SwingUtil.showAboutDialog(this);
            }
            if (this._bExit) {
                this._bStopThread = this._bExit = this.exit();
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void start() {
        Util.debug(this, (Object)"start().START");
        if (!this._bExit) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            this.stop();
            this._pThread.interrupt();
            try {
                this._pThread.join();
                this._pThread = null;
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
lbl12:
            // 3 sources

            ** while (this._pThread != null)
        }
lbl13:
        // 1 sources

        this._pThread = new Thread(this);
        this._pThread.start();
        bFinished = false;
        while (!bFinished) {
            try {
                this._pThread.join();
                bFinished = true;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        Util.debug("MainJFrame.start().END");
    }

    public void stop() {
        this._bStopThread = true;
        if (this._pThread != null) {
            this._pThread.interrupt();
        }
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Util.debug("MainJFrame: actionPerformed: pActionEvent_: " + pActionEvent_);
        Object oSource = pActionEvent_.getSource();
        if (oSource instanceof JMenuItem) {
            String sMenuItem = ((JMenuItem)oSource).getText();
            if (sMenuItem.equals("Beenden") || sMenuItem.equals("Exit")) {
                Util.debug("MainJFrame.actionPerformed(..).EXIT");
                this.setExit();
            } else if (sMenuItem.equals("Info...") || sMenuItem.equals("About...") || sMenuItem.equals("Info") || sMenuItem.equals("About")) {
                this._bAboutSelected = true;
            } else if (!(sMenuItem.equals("Inhalt...") || sMenuItem.equals("Contents...") || sMenuItem.equals("Inhalt") || sMenuItem.equals("Contents") || '1' > sMenuItem.charAt(0) || sMenuItem.charAt(0) > '9')) {
                this.openOldProject(sMenuItem.substring(sMenuItem.indexOf(32) + 1, sMenuItem.length()));
                this.interrupt();
                return;
            }
        }
    }

    public HelpBroker getHelpBroker() {
        MainJFrame pMainJFrame_ = this;
        HelpSet pHelpSet = null;
        String sHSFile = pMainJFrame_.getInit().getHelpBrokerURL();
        try {
            URL urlHelpSet = new URL(sHSFile);
            Util.debug((class$ccl$swing$MainJMenuBar == null ? (class$ccl$swing$MainJMenuBar = MainJFrame.class$("ccl.swing.MainJMenuBar")) : class$ccl$swing$MainJMenuBar).getName() + ".getHelpBroker(..).urlHelpSet: " + urlHelpSet);
            Util.debug((class$ccl$swing$MainJMenuBar == null ? (class$ccl$swing$MainJMenuBar = MainJFrame.class$("ccl.swing.MainJMenuBar")) : class$ccl$swing$MainJMenuBar).getName() + ".getHelpBroker(..).TEST");
            pHelpSet = new HelpSet(null, urlHelpSet);
            Util.debug((class$ccl$swing$MainJMenuBar == null ? (class$ccl$swing$MainJMenuBar = MainJFrame.class$("ccl.swing.MainJMenuBar")) : class$ccl$swing$MainJMenuBar).getName() + ".getHelpBroker(..).pHelpSet: " + pHelpSet);
        }
        catch (Exception pException) {
            Util.printlnErr("HelpSet " + sHSFile + " not found!");
        }
        HelpBroker pHelpBroker = pHelpSet.createHelpBroker();
        return pHelpBroker;
    }

    public void setExit() {
        if (this.isBusy()) {
            SwingUtil.showMessage(this, "Application is busy right now, try to exit in a view seconds again.\nThanks.");
            return;
        }
        if (!this._confirmClose()) {
            return;
        }
        Util.debug("MainJFrame.setExit().BEGIN");
        this._bExit = true;
        if (this._pThread != null) {
            this._pThread.interrupt();
        }
    }

    protected boolean isExitSet() {
        return this._bExit;
    }

    public void windowClosing(WindowEvent event) {
        Util.debug("MainJFrame.windowClosing(..).BEGIN");
        this.setExit();
    }

    public void setBackground(Color pColor_) {
        super.setBackground(pColor_);
        if (UIManager.getLookAndFeel().getClass().getName().startsWith("javax.swing.plaf.")) {
            this.getRootPane().setBackground(pColor_);
            this.getContentPane().setBackground(pColor_);
            this.getLayeredPane().setBackground(pColor_);
            CCLMetalTheme theme = new CCLMetalTheme(pColor_);
            MetalLookAndFeel.setCurrentTheme(theme);
            try {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException lafException) {
                // empty catch block
            }
            UIManager.put("ScrollBarUI", "ccl.swing.CCLScrollBarUI");
            UIManager.put("ScrollBar.thumb", theme.getControl());
            UIManager.put("ScrollBar.thumbShadow", ((MetalTheme)theme).getControlShadow());
            UIManager.put("ScrollBar.thumbHighlight", ((MetalTheme)theme).getControlHighlight());
            UIManager.put("TabbedPane.background", pColor_);
            UIManager.put("TabbedPane.tabAreaBackground", pColor_);
            UIManager.put("TabbedPane.highlight", pColor_);
            UIManager.put("TabbedPane.lightHighlight", pColor_);
            UIManager.put("TabbedPane.selected", pColor_);
            UIManager.put("TabbedPane.selectedHighlight", pColor_);
            UIManager.put("Label.foreground", Color.black);
            UIManager.put("Label.background", pColor_);
            UIManager.put("Panel.background", pColor_);
            UIManager.put("CheckBox.background", pColor_);
            UIManager.put("RadioButton.background", pColor_);
            UIManager.put("TitledBorder.titleColor", Color.black);
            UIManager.put("ScrollPane.border", pColor_);
            UIManager.put("ScrollPane.background", pColor_);
            UIManager.put("TextArea.background", pColor_);
            UIManager.put("TextPane.background", pColor_);
            UIManager.put("TextArea.selectionBackground", Color.black);
            UIManager.put("TextArea.selectionForeground", theme.getControl());
            UIManager.put("TextPane.selectionBackground", Color.black);
            UIManager.put("TextPane.selectionForeground", theme.getControl());
            UIManager.put("Tree.background", pColor_);
            UIManager.put("Tree.textBackground", pColor_);
            UIManager.put("Tree.selectionBackground", pColor_.darker());
            UIManager.put("Tree.selectionForeground", pColor_.brighter());
            UIManager.put("List.background", pColor_);
            UIManager.put("List.selectionBackground", pColor_.darker());
            UIManager.put("List.selectionForeground", pColor_.brighter());
            UIManager.put("TableHeader.background", pColor_);
        }
    }

    public void interrupt() {
        if (this._pThread != null) {
            this._pThread.interrupt();
        }
    }

    public void setModified(boolean bModified_) {
        this._bModified = bModified_;
        if (this._bModified) {
            String sTitle = this.getTitle();
            if (!Util.endsWith(sTitle, S_MODIFIED_TITLE)) {
                sTitle = sTitle + S_MODIFIED_TITLE;
                this.setTitle(sTitle);
            }
        } else {
            String sTitle = this.getTitle();
            if (Util.endsWith(sTitle, S_MODIFIED_TITLE)) {
                sTitle = sTitle.substring(0, sTitle.length() - S_MODIFIED_TITLE.length());
                this.setTitle(sTitle);
            }
        }
    }

    public void newFile() {
        try {
            SwingUtil.invokeAndWaitIfNecessary(new Runnable(){

                public void run() {
                    MainJFrame.this.getInit().setFileFullName("");
                    MainJFrame.this.setModified(false);
                    MainJFrame.this.setTitle();
                    MainJFrame.this.updateMenu();
                }
            });
        }
        catch (Exception exception) {
            Util.printlnErr(exception);
        }
    }

    public void open() {
        if (!this._confirmClose()) {
            return;
        }
        String sProjectFullName = null;
        Init pInit = this.getInit();
        String sProjectSuffix = this._getProjectSuffix();
        sProjectSuffix = sProjectSuffix.substring(1);
        String[] asProjectSuffixes = new String[]{sProjectSuffix};
        String sOldProjectPath = pInit.getFilePath().replace('/', File.separatorChar);
        sProjectFullName = SwingUtil.getFileName((Frame)this, "Choose a Project", asProjectSuffixes, sOldProjectPath);
        if (sProjectFullName == null) {
            return;
        }
        if (!FileUtil.existsFile(sProjectFullName)) {
            SwingUtil.showMessage(this, "Sorry, the specified file\n\n'" + sProjectFullName + "'\n\ndoes not exist!");
            return;
        }
        this.open(sProjectFullName);
    }

    public void open(String sProjectFileName_) {
        this.getInit().setFileFullName(sProjectFileName_);
        this.setModified(false);
        this.setTitle();
        this.updateMenu();
    }

    public void openOldProject(String sOldProjectName_) {
        String sOldProjectFullName = null;
        sOldProjectFullName = this.getInit().getOldFileFullName(sOldProjectName_);
        if (sOldProjectFullName == null) {
            return;
        }
        this.open(sOldProjectFullName);
    }

    protected void _backup(String sFileName_) {
        Util.debug(this, (Object)("_backup(..).sFileName_: " + sFileName_));
        Util.debug(this, (Object)("_backup(..).exists: " + FileUtil.exists(sFileName_)));
        if (FileUtil.exists(sFileName_)) {
            Util.debug(this, (Object)"_backup(..).MOVING");
            boolean bError = FileUtil.move(sFileName_, sFileName_ + ".bak");
            Util.debug(this, (Object)("_backup(..).error: " + bError));
        }
    }

    public void save() {
        Util.debug("ccl.swing.MainJFrame.save().ENTER");
        String sTempFileName = this.getInit().getFileFullName();
        Util.debug("MainJFrame.save().sTempFileName: " + sTempFileName);
        if (Util.isEmpty(sTempFileName)) {
            this.saveAs();
            return;
        }
        this._backup(sTempFileName);
        this.save(sTempFileName);
        this.setModified(false);
        this.setTitle();
        this.updateMenu();
    }

    protected String _getProjectSuffix() {
        String sProjectSuffix = this.getInit().getKeyValue(Init.getProjectSuffixKey());
        if (Util.isEmpty(sProjectSuffix)) {
            sProjectSuffix = ".xml";
            Init init = this.getInit();
            this.getInit();
            init.setKeyValue(Init.getProjectSuffixKey(), sProjectSuffix);
        }
        return sProjectSuffix;
    }

    public void saveAs() {
        boolean bOK;
        String sProjectSuffix = this._getProjectSuffix();
        String sOldProjectPath = this.getInit().getFilePath().replace('/', File.separatorChar);
        String sFileName = SwingUtil.getFileName(this, "Save As", "*" + sProjectSuffix, sOldProjectPath, "Save As");
        if (sFileName == null) {
            return;
        }
        if (!Util.endsWith(sFileName, sProjectSuffix)) {
            SwingUtil.showMessage(this, "Sorry, project file name must end with '" + sProjectSuffix + "'.");
            return;
        }
        if (FileUtil.existsDir(sFileName)) {
            SwingUtil.showMessage(this, "Sorry, file\n\n'" + sFileName + "'\n\nis a directory." + "Please choose another file name " + "to save your data.");
            this.saveAs();
            return;
        }
        if (FileUtil.existsFile(sFileName) && !(bOK = SwingUtil.isOKOrCancel(this, "File\n\n'" + sFileName + "'\n\nexists already. " + "Is it OK to overwrite " + "it?"))) {
            return;
        }
        this.getInit().setFileFullName(sFileName);
        this.save();
    }

    public void save(String sFileName_) {
    }

    protected boolean _confirmClose() {
        if (this._bConfirming) {
            return false;
        }
        this._bConfirming = true;
        if (!this._bModified) {
            this._bConfirming = false;
            return true;
        }
        int yesNoOrCancel = SwingUtil.wannaSave(this);
        if (yesNoOrCancel == 0) {
            this.save();
            this._bConfirming = false;
            return true;
        }
        this._bConfirming = false;
        return yesNoOrCancel != 2;
    }

    protected boolean _isQuitGuardOK() {
        return this._confirmClose();
    }

    public void stateChanged(ChangeEvent pChangeEvent_) {
        this.setModified(true);
    }

    public void setTitle() {
        String sTitle = this.getInit().getApplicationName();
        String sProjectName = this.getInit().getFileName();
        if (!Util.isEmpty(sProjectName)) {
            sTitle = sTitle + ": " + sProjectName;
        }
        if (this._bModified) {
            sTitle = sTitle + S_MODIFIED_TITLE;
        }
        this.setTitle(sTitle);
    }

    public boolean isModified() {
        return this._bModified;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CCLMetalTheme
    extends DefaultMetalTheme {
        private ColorUIResource _secondary3 = null;
        private ColorUIResource _highlight = null;
        private ColorUIResource _shadow = null;
        private ColorUIResource _darkShadow = null;

        public CCLMetalTheme(Color color_) {
            this._secondary3 = new ColorUIResource(color_);
            this._highlight = new ColorUIResource(color_.brighter());
            this._shadow = new ColorUIResource(color_.darker());
            this._darkShadow = new ColorUIResource(color_.darker().darker());
        }

        public ColorUIResource getControlHighlight() {
            return this._highlight;
        }

        public ColorUIResource getControlShadow() {
            return this._shadow;
        }

        public ColorUIResource getControlDarkShadow() {
            return this._darkShadow;
        }

        protected ColorUIResource getPrimary1() {
            return this.getSecondary1();
        }

        protected ColorUIResource getPrimary2() {
            return this.getSecondary2();
        }

        protected ColorUIResource getPrimary3() {
            return this.getSecondary3();
        }

        protected ColorUIResource getSecondary1() {
            return this._darkShadow;
        }

        protected ColorUIResource getSecondary2() {
            return this._shadow;
        }

        protected ColorUIResource getSecondary3() {
            return this._secondary3;
        }

        public ColorUIResource getPrimaryControlDarkShadow() {
            return this._darkShadow;
        }

        public ColorUIResource getPrimaryControlHighlight() {
            return this._highlight;
        }

        public ColorUIResource getSeparatorBackground() {
            return this.getControlHighlight();
        }

        public ColorUIResource getMenuSelectedForeground() {
            return this.getControlHighlight();
        }
    }
}

