/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.PropertyExpression;

public class ConstantExpression
extends Expression {
    public static final ConstantExpression VOID = new ConstantExpression(Void.class);
    public static final ConstantExpression NULL = new ConstantExpression(null);
    public static final ConstantExpression TRUE = new ConstantExpression(Boolean.TRUE);
    public static final ConstantExpression FALSE = new ConstantExpression(Boolean.FALSE);
    public static final ConstantExpression EMPTY_STRING = new ConstantExpression("");
    public static final Expression EMPTY_ARRAY = new PropertyExpression(new ClassExpression(ArgumentListExpression.class.getName()), "EMPTY_ARRAY");
    private Object value;

    public ConstantExpression(Object value) {
        this.value = value;
    }

    public String toString() {
        return super.toString() + "[value=" + this.value + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstantExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public String getText() {
        return this.value == null ? "null" : this.value.toString();
    }
}

