/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class RevFlagFilter
extends RevFilter {
    final RevFlagSet flags;

    public static RevFilter has(RevFlag a) {
        RevFlagSet s2 = new RevFlagSet();
        s2.add(a);
        return new HasAll(s2);
    }

    public static RevFilter hasAll(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        set.addAll(Arrays.asList(a));
        return new HasAll(set);
    }

    public static RevFilter hasAll(RevFlagSet a) {
        return new HasAll(new RevFlagSet(a));
    }

    public static RevFilter hasAny(RevFlag ... a) {
        RevFlagSet set = new RevFlagSet();
        set.addAll(Arrays.asList(a));
        return new HasAny(set);
    }

    public static RevFilter hasAny(RevFlagSet a) {
        return new HasAny(new RevFlagSet(a));
    }

    RevFlagFilter(RevFlagSet m4) {
        this.flags = m4;
    }

    @Override
    public RevFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + String.valueOf(this.flags);
    }

    private static class HasAll
    extends RevFlagFilter {
        HasAll(RevFlagSet m4) {
            super(m4);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAll(this.flags);
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }
    }

    private static class HasAny
    extends RevFlagFilter {
        HasAny(RevFlagSet m4) {
            super(m4);
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return c.hasAny(this.flags);
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }
    }
}

