/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import org.pcollections.Empty;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class OrderedPSet<E>
extends AbstractSet<E>
implements POrderedSet<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final OrderedPSet<Object> EMPTY = new OrderedPSet(Empty.set(), Empty.vector());
    private PSet<E> contents;
    private PVector<E> order;

    public static <E> OrderedPSet<E> empty() {
        return EMPTY;
    }

    public static <E> OrderedPSet<E> from(Collection<? extends E> list) {
        if (list instanceof OrderedPSet) {
            return (OrderedPSet)list;
        }
        return OrderedPSet.empty().plusAll((Collection)list);
    }

    public static <E> OrderedPSet<E> singleton(E e) {
        return OrderedPSet.empty().plus((Object)e);
    }

    private OrderedPSet(PSet<E> c, PVector<E> o) {
        this.contents = c;
        this.order = o;
    }

    @Override
    public OrderedPSet<E> plus(E e) {
        if (this.contents.contains(e)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.plus(e), this.order.plus(e));
    }

    @Override
    public OrderedPSet<E> plusAll(Collection<? extends E> list) {
        POrderedSet<E> s = this;
        for (E e : list) {
            s = s.plus((Object)e);
        }
        return s;
    }

    @Override
    public OrderedPSet<E> minus(Object e) {
        if (!this.contents.contains(e)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.minus(e), this.order.minus(e));
    }

    @Override
    public OrderedPSet<E> minusAll(Collection<?> list) {
        POrderedSet<E> s = this;
        for (Object e : list) {
            s = s.minus(e);
        }
        return s;
    }

    @Override
    public Iterator<E> iterator() {
        return this.order.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public E get(int index) {
        return this.order.get(index);
    }

    @Override
    public int indexOf(Object o) {
        if (!this.contents.contains(o)) {
            return -1;
        }
        return this.order.indexOf(o);
    }
}

