/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigParser;
import com.google.turbine.model.Const;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

public final class BytecodeBinder {
    public static Type.ClassTy bindClassTy(Sig.ClassTySig sig, Scope scope, ImmutableList<ClassFile.TypeAnnotationInfo> annotations) {
        return BytecodeBinder.bindClassTy(sig, scope, BytecodeBinder.typeAnnotationsByPath(annotations, scope), ClassFile.TypeAnnotationInfo.TypePath.root());
    }

    private static Type.ClassTy bindClassTy(Sig.ClassTySig sig, Scope scope, ImmutableListMultimap<ClassFile.TypeAnnotationInfo.TypePath, AnnoInfo> annotations, ClassFile.TypeAnnotationInfo.TypePath typePath) {
        StringBuilder sb = new StringBuilder();
        if (!sig.pkg().isEmpty()) {
            sb.append(sig.pkg()).append('/');
        }
        boolean first = true;
        LinkedHashMap<ClassSymbol, Sig.SimpleClassTySig> syms = new LinkedHashMap<ClassSymbol, Sig.SimpleClassTySig>();
        for (Sig.SimpleClassTySig s : sig.classes()) {
            if (!first) {
                sb.append('$');
            }
            sb.append(s.simpleName());
            ClassSymbol sym = new ClassSymbol(sb.toString());
            syms.put(sym, s);
            first = false;
        }
        ArrayDeque<ClassSymbol> outers = new ArrayDeque<ClassSymbol>();
        ClassSymbol curr = (ClassSymbol)Iterables.getLast(syms.keySet());
        while (curr != null) {
            outers.addFirst(curr);
            curr = scope.outer(curr);
        }
        ArrayList<Type.ClassTy.SimpleClassTy> classes = new ArrayList<Type.ClassTy.SimpleClassTy>();
        for (ClassSymbol curr2 : outers) {
            ImmutableList.Builder tyArgs = ImmutableList.builder();
            Sig.SimpleClassTySig s = (Sig.SimpleClassTySig)syms.get(curr2);
            if (s != null) {
                for (int i = 0; i < s.tyArgs().size(); ++i) {
                    tyArgs.add((Object)BytecodeBinder.bindTy((Sig.TySig)s.tyArgs().get(i), scope, annotations, typePath.typeArgument(i)));
                }
            }
            classes.add(Type.ClassTy.SimpleClassTy.create(curr2, (ImmutableList<Type>)tyArgs.build(), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath)));
            typePath = typePath.nested();
        }
        return Type.ClassTy.create(classes);
    }

    private static Type wildTy(Sig.WildTySig sig, Scope scope, ImmutableListMultimap<ClassFile.TypeAnnotationInfo.TypePath, AnnoInfo> annotations, ClassFile.TypeAnnotationInfo.TypePath typePath) {
        switch (sig.boundKind()) {
            case NONE: {
                return Type.WildUnboundedTy.create((ImmutableList<AnnoInfo>)annotations.get((Object)typePath));
            }
            case LOWER: {
                return Type.WildLowerBoundedTy.create(BytecodeBinder.bindTy(((Sig.LowerBoundTySig)sig).bound(), scope, annotations, typePath.wild()), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath));
            }
            case UPPER: {
                return Type.WildUpperBoundedTy.create(BytecodeBinder.bindTy(((Sig.UpperBoundTySig)sig).bound(), scope, annotations, typePath.wild()), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath));
            }
        }
        throw new AssertionError((Object)sig.boundKind());
    }

    public static Type bindTy(Sig.TySig sig, Scope scope, ImmutableList<ClassFile.TypeAnnotationInfo> annotations) {
        return BytecodeBinder.bindTy(sig, scope, BytecodeBinder.typeAnnotationsByPath(annotations, scope), ClassFile.TypeAnnotationInfo.TypePath.root());
    }

    static Type bindTy(Sig.TySig sig, Scope scope, ImmutableListMultimap<ClassFile.TypeAnnotationInfo.TypePath, AnnoInfo> annotations, ClassFile.TypeAnnotationInfo.TypePath typePath) {
        switch (sig.kind()) {
            case BASE_TY_SIG: {
                return Type.PrimTy.create(((Sig.BaseTySig)sig).type(), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath));
            }
            case CLASS_TY_SIG: {
                return BytecodeBinder.bindClassTy((Sig.ClassTySig)sig, scope, annotations, typePath);
            }
            case TY_VAR_SIG: {
                return Type.TyVar.create(scope.apply(((Sig.TyVarSig)sig).name()), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath));
            }
            case ARRAY_TY_SIG: {
                return BytecodeBinder.bindArrayTy((Sig.ArrayTySig)sig, scope, annotations, typePath);
            }
            case WILD_TY_SIG: {
                return BytecodeBinder.wildTy((Sig.WildTySig)sig, scope, annotations, typePath);
            }
            case VOID_TY_SIG: {
                return Type.VOID;
            }
        }
        throw new AssertionError((Object)sig.kind());
    }

    private static Type bindArrayTy(Sig.ArrayTySig arrayTySig, Scope scope, ImmutableListMultimap<ClassFile.TypeAnnotationInfo.TypePath, AnnoInfo> annotations, ClassFile.TypeAnnotationInfo.TypePath typePath) {
        return Type.ArrayTy.create(BytecodeBinder.bindTy(arrayTySig.elementType(), scope, annotations, typePath.array()), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath));
    }

    private static ImmutableListMultimap<ClassFile.TypeAnnotationInfo.TypePath, AnnoInfo> typeAnnotationsByPath(ImmutableList<ClassFile.TypeAnnotationInfo> typeAnnotations, Scope scope) {
        if (typeAnnotations.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (ClassFile.TypeAnnotationInfo typeAnnotation : typeAnnotations) {
            result.put((Object)typeAnnotation.path(), (Object)BytecodeBinder.bindAnnotationValue(typeAnnotation.anno(), scope).info());
        }
        return result.build();
    }

    public static Type.ClassTy asNonParametricClassTy(ClassSymbol sym, ImmutableList<ClassFile.TypeAnnotationInfo> annotations, Scope scope) {
        return BytecodeBinder.asNonParametricClassTy(sym, scope, BytecodeBinder.typeAnnotationsByPath(annotations, scope));
    }

    private static Type.ClassTy asNonParametricClassTy(ClassSymbol sym, Scope scope, ImmutableListMultimap<ClassFile.TypeAnnotationInfo.TypePath, AnnoInfo> annotations) {
        if (annotations.isEmpty()) {
            return Type.ClassTy.asNonParametricClassTy(sym);
        }
        ArrayDeque<ClassSymbol> outers = new ArrayDeque<ClassSymbol>();
        ClassSymbol curr = sym;
        while (curr != null) {
            outers.addFirst(curr);
            curr = scope.outer(curr);
        }
        ArrayList<Type.ClassTy.SimpleClassTy> classes = new ArrayList<Type.ClassTy.SimpleClassTy>();
        ClassFile.TypeAnnotationInfo.TypePath typePath = ClassFile.TypeAnnotationInfo.TypePath.root();
        for (ClassSymbol curr2 : outers) {
            classes.add(Type.ClassTy.SimpleClassTy.create(curr2, (ImmutableList<Type>)ImmutableList.of(), (ImmutableList<AnnoInfo>)annotations.get((Object)typePath)));
            typePath = typePath.nested();
        }
        return Type.ClassTy.create(classes);
    }

    public static Const bindValue(ClassFile.AnnotationInfo.ElementValue value, final Scope scope) {
        switch (value.kind()) {
            case ENUM: {
                return BytecodeBinder.bindEnumValue((ClassFile.AnnotationInfo.ElementValue.EnumConstValue)value);
            }
            case CONST: {
                return ((ClassFile.AnnotationInfo.ElementValue.ConstValue)value).value();
            }
            case ARRAY: {
                return BytecodeBinder.bindArrayValue((ClassFile.AnnotationInfo.ElementValue.ArrayValue)value, scope);
            }
            case CLASS: {
                return new TurbineClassValue(BytecodeBinder.bindTy(new SigParser(((ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue)value).className()).parseType(), new Scope(){

                    @Override
                    public TyVarSymbol apply(String x) {
                        throw new IllegalStateException(x);
                    }

                    @Override
                    public @Nullable ClassSymbol outer(ClassSymbol sym) {
                        return scope.outer(sym);
                    }
                }, (ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.of()));
            }
            case ANNOTATION: {
                return BytecodeBinder.bindAnnotationValue(((ClassFile.AnnotationInfo.ElementValue.ConstTurbineAnnotationValue)value).annotation(), scope);
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    static TurbineAnnotationValue bindAnnotationValue(ClassFile.AnnotationInfo value, Scope scope) {
        ClassSymbol sym = BytecodeBinder.asClassSymbol(value.typeName());
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Map.Entry<String, ClassFile.AnnotationInfo.ElementValue> e : value.elementValuePairs().entrySet()) {
            values.put((Object)e.getKey(), (Object)BytecodeBinder.bindValue(e.getValue(), scope));
        }
        return new TurbineAnnotationValue(new AnnoInfo(null, sym, null, (ImmutableMap<String, Const>)values.buildOrThrow()));
    }

    static ImmutableList<AnnoInfo> bindAnnotations(List<ClassFile.AnnotationInfo> input, Scope scope) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ClassFile.AnnotationInfo annotation : input) {
            TurbineAnnotationValue anno = BytecodeBinder.bindAnnotationValue(annotation, scope);
            if (BytecodeBinder.shouldSkip(anno)) continue;
            result.add((Object)anno.info());
        }
        return result.build();
    }

    private static boolean shouldSkip(TurbineAnnotationValue anno) {
        return anno.sym().equals(ClassSymbol.PROFILE_ANNOTATION) || anno.sym().equals(ClassSymbol.PROPRIETARY_ANNOTATION);
    }

    private static ClassSymbol asClassSymbol(String s) {
        return new ClassSymbol(s.substring(1, s.length() - 1));
    }

    private static Const bindArrayValue(ClassFile.AnnotationInfo.ElementValue.ArrayValue value, Scope scope) {
        ImmutableList.Builder elements = ImmutableList.builder();
        for (ClassFile.AnnotationInfo.ElementValue element : value.elements()) {
            elements.add((Object)BytecodeBinder.bindValue(element, scope));
        }
        return new Const.ArrayInitValue((ImmutableList<Const>)elements.build());
    }

    public static Const.Value bindConstValue(Type type, Const.Value value) {
        if (type.tyKind() != Type.TyKind.PRIM_TY) {
            return value;
        }
        switch (((Type.PrimTy)type).primkind()) {
            case CHAR: {
                return new Const.CharValue((char)BytecodeBinder.asInt(value));
            }
            case SHORT: {
                return new Const.ShortValue((short)BytecodeBinder.asInt(value));
            }
            case BOOLEAN: {
                return new Const.BooleanValue(BytecodeBinder.asInt(value) != 0);
            }
            case BYTE: {
                return new Const.ByteValue((byte)BytecodeBinder.asInt(value));
            }
        }
        return value;
    }

    private static int asInt(Const.Value value) {
        return ((Const.IntValue)value).value();
    }

    private static Const bindEnumValue(ClassFile.AnnotationInfo.ElementValue.EnumConstValue value) {
        return new EnumConstantValue(new FieldSymbol(BytecodeBinder.asClassSymbol(value.typeName()), value.constName()));
    }

    public static ModuleInfo bindModuleInfo(String path, Supplier<byte[]> bytes) {
        ClassFile classFile = ClassReader.read(path, bytes.get());
        ClassFile.ModuleInfo module = classFile.module();
        Objects.requireNonNull(module, path);
        return new ModuleInfo(module.name(), module.version(), module.flags(), (ImmutableList<AnnoInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.RequireInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ExportInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.OpenInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.UseInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ProvideInfo>)ImmutableList.of());
    }

    private BytecodeBinder() {
    }

    static interface Scope {
        public TyVarSymbol apply(String var1);

        public @Nullable ClassSymbol outer(ClassSymbol var1);
    }
}

