/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.NearbyCallers;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="getNanos() only accesses the underlying nanosecond-adjustment of the duration.", explanation="If you call duration.getNanos(), you must also call duration.getSeconds() in 'nearby' code. If you are trying to convert this duration to nanoseconds, you probably meant to use Durations.toNanos(duration) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class ProtoDurationGetSecondsGetNano
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_SECONDS = MethodMatchers.instanceMethod().onExactClass("com.google.protobuf.Duration").named("getSeconds");
    private static final Matcher<ExpressionTree> GET_NANOS = MethodMatchers.instanceMethod().onExactClass("com.google.protobuf.Duration").named("getNanos");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (GET_NANOS.matches((Tree)tree, state) && !NearbyCallers.containsCallToSameReceiverNearby(tree, GET_SECONDS, state, true)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

