/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="This test has @Parameters but is using the default JUnit4 runner. The parameters will have no effect.", severity=BugPattern.SeverityLevel.ERROR)
public final class ParametersButNotParameterized
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String PARAMETERIZED = "org.junit.runners.Parameterized";
    private static final String PARAMETER = "org.junit.runners.Parameterized.Parameter";
    private static final String PARAMETERS = "org.junit.runners.Parameterized.Parameters";

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUnitMatchers.hasJUnit4TestRunner.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (tree.getMembers().stream().noneMatch(m -> ASTHelpers.hasAnnotation((Tree)m, (String)PARAMETER, (VisitorState)state) || ASTHelpers.hasAnnotation((Tree)m, (String)PARAMETERS, (VisitorState)state))) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"RunWith");
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace((Tree)annotation, String.format("@RunWith(%s.class)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)PARAMETERIZED)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

