/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="A `test` prefix for a JUnit4 test is redundant, and a holdover from JUnit3. The `@Test` annotation makes it clear it's a test.")
public final class UnnecessaryTestMethodPrefix
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<Tree> TEST = Matchers.hasAnnotation((String)"org.junit.Test");

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        final HashSet sites = new HashSet();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            public Void visitMethod(MethodTree tree, Void unused) {
                if (!TEST.matches((Tree)tree, this.state)) {
                    return (Void)super.visitMethod(tree, (Object)unused);
                }
                String name = tree.getName().toString();
                if (!name.startsWith("test") || name.equals("test")) {
                    return (Void)super.visitMethod(tree, (Object)unused);
                }
                String newName = Ascii.toLowerCase((char)name.charAt(4)) + name.substring(5);
                fixBuilder.merge(SuggestedFixes.renameMethod((MethodTree)tree, (String)newName, (VisitorState)this.state));
                sites.add(tree);
                return (Void)super.visitMethod(tree, (Object)unused);
            }
        }.scan(state.getPath(), null);
        SuggestedFix fix = fixBuilder.build();
        for (Tree site : sites) {
            state.reportMatch(this.describeMatch(site, (Fix)fix));
        }
        return Description.NO_MATCH;
    }
}

