/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="Migrate off a deprecated overload of org.robolectric.shadow.api.Shadow#directlyOn", severity=BugPattern.SeverityLevel.WARNING)
public class RobolectricShadowDirectlyOn
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("org.robolectric.shadow.api.Shadow").withSignature("<T>directlyOn(T,java.lang.Class<T>)");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        TreePath path = state.getPath().getParentPath();
        if (!(path.getLeaf() instanceof MemberSelectTree)) {
            return Description.NO_MATCH;
        }
        Tree parentTree = (path = path.getParentPath()).getLeaf();
        if (!(parentTree instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree parent = (MethodInvocationTree)parentTree;
        if (!tree.equals(ASTHelpers.getReceiver((ExpressionTree)parent))) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)parent);
        String argReplacement = Streams.concat((Stream[])new Stream[]{Stream.of(state.getConstantExpression((Object)((Name)symbol.getSimpleName()).toString())), Streams.zip(symbol.getParameters().stream(), parent.getArguments().stream(), (p, a) -> String.format("ClassParameter.from(%s.class, %s)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)state.getTypes().erasure((Type)p.asType())), state.getSourceForNode((Tree)a)))}).collect(Collectors.joining(", ", ", ", ""));
        fix.replace(state.getEndPosition((Tree)tree), state.getEndPosition((Tree)parent), "").postfixWith((Tree)Iterables.getLast(tree.getArguments()), argReplacement).addImport("org.robolectric.util.ReflectionHelpers.ClassParameter");
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

