/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repositoryv2;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.installer.PackageInstaller;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

public class MavenInstaller
implements PackageInstaller {
    public static final String MAVEN_DIR_NAME = "m2repository";
    public static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";

    public boolean uninstall(LocalPackage p, ProgressIndicator progress, RepoManager manager, FileOp fop) {
        fop.deleteFileOrFolder(p.getLocation());
        if (fop.exists(p.getLocation())) {
            progress.logWarning("Failed to uninstall " + p);
            return false;
        }
        manager.markInvalid();
        return MavenInstaller.removeVersion(p, fop, progress);
    }

    private static boolean removeVersion(LocalPackage p, FileOp fop, ProgressIndicator progress) {
        PackageInfo info = MavenInstaller.parsePackageInfo(p.getLocation(), (RepoPackage)p);
        MavenMetadata metadata = MavenInstaller.parseMetadata(new File(p.getLocation().getParent(), MAVEN_METADATA_FILE_NAME), info, progress, fop);
        if (metadata == null) {
            return false;
        }
        metadata.versioning.versions.version.remove(info.version);
        return MavenInstaller.writeMetadata(new File(p.getLocation().getParentFile(), MAVEN_METADATA_FILE_NAME), progress, fop, metadata);
    }

    public boolean install(RemotePackage p, Downloader downloader, SettingsController settings, ProgressIndicator progress, RepoManager manager, FileOp fop) {
        if (!p.getPath().startsWith(MAVEN_DIR_NAME)) {
            progress.logError("Maven package paths must start with m2repository");
            return false;
        }
        URL url = InstallerUtil.resolveCompleteArchiveUrl((RemotePackage)p, (ProgressIndicator)progress);
        if (url == null) {
            return false;
        }
        try {
            String path = p.getPath();
            path = path.replace(';', File.separatorChar);
            File dest = new File(manager.getLocalPath(), path);
            if (!InstallerUtil.checkValidPath((File)dest, (RepoManager)manager, (ProgressIndicator)progress)) {
                return false;
            }
            File in = downloader.downloadFully(url, settings, progress);
            File out = FileOpUtils.getNewTempDir((String)"BasicInstaller", (FileOp)fop);
            if (out == null || !fop.mkdirs(out)) {
                throw new IOException("Failed to create temp dir");
            }
            fop.deleteOnExit(out);
            InstallerUtil.unzip((File)in, (File)out, (FileOp)fop, (long)p.getArchive().getComplete().getSize(), (ProgressIndicator)progress);
            fop.delete(in);
            File[] topDirContents = fop.listFiles(out);
            if (topDirContents.length != 1) {
                throw new IOException("Archive didn't have single top level directory");
            }
            File packageRoot = topDirContents[0];
            InstallerUtil.writePackageXml((RemotePackage)p, (File)packageRoot, (RepoManager)manager, (FileOp)fop, (ProgressIndicator)progress);
            FileOpUtils.safeRecursiveOverwrite((File)packageRoot, (File)dest, (FileOp)fop, (ProgressIndicator)progress);
            PackageInfo info = MavenInstaller.parsePackageInfo(dest, (RepoPackage)p);
            MavenInstaller.addVersion(new File(dest.getParentFile(), MAVEN_METADATA_FILE_NAME), info, progress, fop);
            manager.markInvalid();
            return true;
        }
        catch (IOException e) {
            progress.logWarning("An error occurred during installation.", (Throwable)e);
            return false;
        }
    }

    private static PackageInfo parsePackageInfo(File path, RepoPackage p) {
        PackageInfo result = new PackageInfo();
        result.version = path.getName();
        result.artifactId = path.getParentFile().getName();
        result.groupId = p.getPath().substring(p.getPath().indexOf(59) + 1, p.getPath().lastIndexOf(result.artifactId) - 1).replace(';', '.');
        return result;
    }

    private static boolean addVersion(File metadataFile, PackageInfo info, ProgressIndicator progress, FileOp fop) {
        MavenMetadata metadata = MavenInstaller.parseMetadata(metadataFile, info, progress, fop);
        if (metadata == null) {
            return false;
        }
        metadata.versioning.versions.version.add(info.version);
        return MavenInstaller.writeMetadata(metadataFile, progress, fop, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeMetadata(File file, ProgressIndicator progress, FileOp fop, MavenMetadata metadata) {
        Marshaller marshaller;
        Revision max = null;
        for (String s : metadata.versioning.versions.version) {
            Revision rev = Revision.parseRevision((String)s);
            if (max != null && (rev.isPreview() || rev.compareTo(max) <= 0)) continue;
            max = rev;
        }
        if (max != null) {
            metadata.versioning.release = max.toString();
        }
        metadata.versioning.lastUpdated = System.currentTimeMillis();
        try {
            JAXBContext context;
            try {
                context = JAXBContext.newInstance((Class[])new Class[]{MavenMetadata.class});
            }
            catch (JAXBException e) {
                progress.logError("Failed to create JAXBContext", (Throwable)e);
                return false;
            }
            marshaller = context.createMarshaller();
        }
        catch (JAXBException e) {
            progress.logError("Failed to create Marshaller", (Throwable)e);
            return false;
        }
        ByteArrayOutputStream metadataOutBytes = new ByteArrayOutputStream();
        try {
            marshaller.marshal((Object)new JAXBElement(new QName("metadata"), MavenMetadata.class, (Object)metadata), (OutputStream)metadataOutBytes);
        }
        catch (JAXBException e) {
            progress.logWarning("Failed to write maven metadata: ", (Throwable)e);
            return false;
        }
        OutputStream metadataOutFile = null;
        try {
            metadataOutFile = fop.newFileOutputStream(file);
            metadataOutFile.write(metadataOutBytes.toByteArray());
        }
        catch (FileNotFoundException e) {
            progress.logWarning("Failed to write metadata file.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            progress.logWarning("Failed to write metadata file.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (metadataOutFile != null) {
                try {
                    metadataOutFile.close();
                }
                catch (IOException e) {}
            }
        }
        if (!MavenInstaller.writeHashFile(file, "MD5", progress, metadataOutBytes, fop)) {
            return false;
        }
        return MavenInstaller.writeHashFile(file, "SHA1", progress, metadataOutBytes, fop);
    }

    private static MavenMetadata parseMetadata(File file, PackageInfo info, ProgressIndicator progress, FileOp fop) {
        MavenMetadata metadata;
        if (fop.exists(file)) {
            metadata = MavenInstaller.unmarshalMetadata(file, progress, fop);
            if (metadata == null) {
                return null;
            }
            if (!metadata.artifactId.equals(info.artifactId)) {
                progress.logWarning("New artifact id '" + info.artifactId + "' doesn't match existing '" + metadata.artifactId);
                return null;
            }
            if (!metadata.groupId.equals(info.groupId)) {
                progress.logWarning("New group id '" + info.groupId + "' doesn't match existing '" + metadata.groupId);
                return null;
            }
        } else {
            metadata = new MavenMetadata();
            metadata.artifactId = info.artifactId;
            metadata.groupId = info.groupId;
            metadata.versioning = new MavenMetadata.Versioning();
            metadata.versioning.versions = new MavenMetadata.Versioning.Versions();
            metadata.versioning.versions.version = Lists.newArrayList();
        }
        return metadata;
    }

    @VisibleForTesting
    static MavenMetadata unmarshalMetadata(File metadataFile, ProgressIndicator progress, FileOp fop) {
        MavenMetadata result;
        InputStream metadataInputStream;
        Unmarshaller unmarshaller;
        JAXBContext context;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{MavenMetadata.class});
        }
        catch (JAXBException e) {
            progress.logError("Failed to create JAXBContext", (Throwable)e);
            return null;
        }
        try {
            unmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException e) {
            progress.logError("Failed to create unmarshaller", (Throwable)e);
            return null;
        }
        try {
            metadataInputStream = fop.newFileInputStream(metadataFile);
        }
        catch (FileNotFoundException e) {
            progress.logWarning("Couldn't open metadata file", (Throwable)e);
            return null;
        }
        try {
            result = (MavenMetadata)unmarshaller.unmarshal(metadataInputStream);
        }
        catch (JAXBException e) {
            progress.logWarning("Couldn't parse maven metadata file: " + metadataFile);
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeHashFile(File file, String algorithm, ProgressIndicator progress, ByteArrayOutputStream metadataOutBytes, FileOp fop) {
        OutputStream md5OutFile;
        MessageDigest digest;
        File md5File = new File(file.getParent(), "maven-metadata.xml." + algorithm.toLowerCase());
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            progress.logError(algorithm + " algorithm not found", (Throwable)e);
            return false;
        }
        try {
            md5OutFile = fop.newFileOutputStream(md5File);
        }
        catch (FileNotFoundException e) {
            progress.logWarning("Failed to open " + algorithm + " file");
            return false;
        }
        try {
            md5OutFile.write(DatatypeConverter.printHexBinary((byte[])digest.digest(metadataOutBytes.toByteArray())).getBytes());
        }
        catch (IOException e) {
            progress.logWarning("Failed to write " + algorithm + " file");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                md5OutFile.close();
            }
            catch (IOException e) {}
        }
        return true;
    }

    private static class PackageInfo {
        public String artifactId;
        public String groupId;
        public String version;

        private PackageInfo() {
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="metadata")
    @VisibleForTesting
    static class MavenMetadata {
        protected String groupId;
        protected String artifactId;
        protected Versioning versioning;

        MavenMetadata() {
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class Versioning {
            protected String release;
            protected Versions versions;
            protected long lastUpdated;

            @XmlAccessorType(value=XmlAccessType.FIELD)
            public static class Versions {
                protected List<String> version;
            }
        }
    }
}

