/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

@Beta
public enum Scope {
    RESOURCE_FILE,
    BINARY_RESOURCE_FILE,
    RESOURCE_FOLDER,
    ALL_RESOURCE_FILES,
    JAVA_FILE,
    ALL_JAVA_FILES,
    CLASS_FILE,
    ALL_CLASS_FILES,
    MANIFEST,
    PROGUARD_FILE,
    JAVA_LIBRARIES,
    GRADLE_FILE,
    PROPERTY_FILE,
    TEST_SOURCES,
    OTHER;

    public static final EnumSet<Scope> ALL;
    public static final EnumSet<Scope> RESOURCE_FILE_SCOPE;
    public static final EnumSet<Scope> RESOURCE_FOLDER_SCOPE;
    public static final EnumSet<Scope> ALL_RESOURCES_SCOPE;
    public static final EnumSet<Scope> JAVA_FILE_SCOPE;
    public static final EnumSet<Scope> CLASS_FILE_SCOPE;
    public static final EnumSet<Scope> GRADLE_SCOPE;
    public static final EnumSet<Scope> MANIFEST_SCOPE;
    public static final EnumSet<Scope> OTHER_SCOPE;
    public static final EnumSet<Scope> PROGUARD_SCOPE;
    public static final EnumSet<Scope> PROPERTY_SCOPE;
    public static final EnumSet<Scope> MANIFEST_AND_RESOURCE_SCOPE;
    public static final EnumSet<Scope> JAVA_AND_RESOURCE_FILES;
    public static final EnumSet<Scope> CLASS_AND_ALL_RESOURCE_FILES;
    public static final EnumSet<Scope> ALL_CLASSES_AND_LIBRARIES;
    public static final EnumSet<Scope> JAVA_LIBRARY_SCOPE;
    public static final EnumSet<Scope> BINARY_RESOURCE_FILE_SCOPE;

    public static boolean checkSingleFile(EnumSet<Scope> scopes) {
        int size = scopes.size();
        if (size == 2) {
            return scopes.contains((Object)JAVA_FILE) && scopes.contains((Object)CLASS_FILE);
        }
        return size == 1 && (scopes.contains((Object)JAVA_FILE) || scopes.contains((Object)CLASS_FILE) || scopes.contains((Object)RESOURCE_FILE) || scopes.contains((Object)PROGUARD_FILE) || scopes.contains((Object)PROPERTY_FILE) || scopes.contains((Object)GRADLE_FILE) || scopes.contains((Object)MANIFEST));
    }

    public static EnumSet<Scope> intersect(EnumSet<Scope> scope1, EnumSet<Scope> scope2) {
        EnumSet<Scope> scope = EnumSet.copyOf(scope1);
        scope.retainAll(scope2);
        return scope;
    }

    public static EnumSet<Scope> infer(Collection<Project> projects) {
        EnumSet<Scope> scope = EnumSet.noneOf(Scope.class);
        for (Project project : projects) {
            List<File> subset = project.getSubset();
            if (subset != null) {
                for (File file : subset) {
                    String name = file.getName();
                    if (name.equals("AndroidManifest.xml")) {
                        scope.add(MANIFEST);
                        continue;
                    }
                    if (name.endsWith(".xml")) {
                        scope.add(RESOURCE_FILE);
                        continue;
                    }
                    if (name.endsWith(".java")) {
                        scope.add(JAVA_FILE);
                        continue;
                    }
                    if (name.endsWith(".class")) {
                        scope.add(CLASS_FILE);
                        continue;
                    }
                    if (name.endsWith(".gradle")) {
                        scope.add(GRADLE_FILE);
                        continue;
                    }
                    if (name.equals("proguard.cfg") || name.equals("proguard-project.txt")) {
                        scope.add(PROGUARD_FILE);
                        continue;
                    }
                    if (name.endsWith(".properties")) {
                        scope.add(PROPERTY_FILE);
                        continue;
                    }
                    if (name.endsWith(".png")) {
                        scope.add(BINARY_RESOURCE_FILE);
                        continue;
                    }
                    if (!name.equals("res") && !file.getParent().equals("res")) continue;
                    scope.add(ALL_RESOURCE_FILES);
                    scope.add(RESOURCE_FILE);
                    scope.add(BINARY_RESOURCE_FILE);
                    scope.add(RESOURCE_FOLDER);
                }
                continue;
            }
            scope = ALL;
            break;
        }
        return scope;
    }

    static {
        ALL = EnumSet.allOf(Scope.class);
        RESOURCE_FILE_SCOPE = EnumSet.of(RESOURCE_FILE);
        RESOURCE_FOLDER_SCOPE = EnumSet.of(RESOURCE_FOLDER);
        ALL_RESOURCES_SCOPE = EnumSet.of(ALL_RESOURCE_FILES);
        JAVA_FILE_SCOPE = EnumSet.of(JAVA_FILE);
        CLASS_FILE_SCOPE = EnumSet.of(CLASS_FILE);
        GRADLE_SCOPE = EnumSet.of(GRADLE_FILE);
        MANIFEST_SCOPE = EnumSet.of(MANIFEST);
        OTHER_SCOPE = EnumSet.of(OTHER);
        PROGUARD_SCOPE = EnumSet.of(PROGUARD_FILE);
        PROPERTY_SCOPE = EnumSet.of(PROPERTY_FILE);
        MANIFEST_AND_RESOURCE_SCOPE = EnumSet.of(MANIFEST, RESOURCE_FILE);
        JAVA_AND_RESOURCE_FILES = EnumSet.of(RESOURCE_FILE, JAVA_FILE);
        CLASS_AND_ALL_RESOURCE_FILES = EnumSet.of(ALL_RESOURCE_FILES, CLASS_FILE);
        ALL_CLASSES_AND_LIBRARIES = EnumSet.of(ALL_CLASS_FILES, JAVA_LIBRARIES);
        JAVA_LIBRARY_SCOPE = EnumSet.of(JAVA_LIBRARIES);
        BINARY_RESOURCE_FILE_SCOPE = EnumSet.of(BINARY_RESOURCE_FILE);
    }
}

