/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.InvalidTargetingOnScopingAnnotation;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

@BugPattern(name="QualifierWithTypeUse", summary="Injection frameworks currently don't understand Qualifiers in TYPE_PARAMETER or TYPE_USE contexts.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class QualifierWithTypeUse
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final MultiMatcher<ClassTree, AnnotationTree> HAS_TARGET_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"java.lang.annotation.Target"));
    private static final Matcher<ClassTree> IS_QUALIFIER_WITH_TARGET = Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.ANNOTATION_TYPE), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"javax.inject.Qualifier"), Matchers.hasAnnotation((String)"com.google.inject.BindingAnnotation")})});
    private static final ImmutableSet<ElementType> FORBIDDEN_ELEMENT_TYPES = ImmutableSet.of((Object)((Object)ElementType.TYPE_PARAMETER), (Object)((Object)ElementType.TYPE_USE));

    public Description matchClass(ClassTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult targetAnnotation;
        if (IS_QUALIFIER_WITH_TARGET.matches((Tree)tree, state) && (targetAnnotation = HAS_TARGET_ANNOTATION.multiMatchResult((Tree)tree, state)).matches()) {
            AnnotationTree annotationTree = (AnnotationTree)targetAnnotation.onlyMatchingNode();
            Target target = (Target)ASTHelpers.getAnnotation((Tree)tree, Target.class);
            if (QualifierWithTypeUse.hasTypeUseOrTypeParameter(target)) {
                return this.describeMatch(annotationTree, QualifierWithTypeUse.removeTypeUse(target, annotationTree));
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean hasTypeUseOrTypeParameter(Target targetAnnotation) {
        return targetAnnotation != null && !Collections.disjoint(FORBIDDEN_ELEMENT_TYPES, Arrays.asList(targetAnnotation.value()));
    }

    private static Fix removeTypeUse(Target targetAnnotation, AnnotationTree tree) {
        EnumSet<ElementType> elements = EnumSet.copyOf(Arrays.asList(targetAnnotation.value()));
        elements.removeAll((Collection<?>)FORBIDDEN_ELEMENT_TYPES);
        if (elements.isEmpty()) {
            return SuggestedFix.delete((Tree)tree);
        }
        return InvalidTargetingOnScopingAnnotation.replaceTargetAnnotation(tree, elements);
    }
}

