/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.ModuleNameReader;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ModuleFinder {
    protected static final Context.Key<ModuleFinder> moduleFinderKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Names names;
    private final ClassFinder classFinder;
    private final JavaFileManager fileManager;
    private final JCDiagnostic.Factory diags;
    private final DeferredCompletionFailureHandler dcfh;
    private ModuleNameReader moduleNameReader;
    public ModuleNameFromSourceReader moduleNameFromSourceReader;
    ModuleLocationIterator moduleLocationIterator = new ModuleLocationIterator();

    public static ModuleFinder instance(Context context) {
        ModuleFinder instance = context.get(moduleFinderKey);
        if (instance == null) {
            instance = new ModuleFinder(context);
        }
        return instance;
    }

    protected ModuleFinder(Context context) {
        context.put(moduleFinderKey, this);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        this.classFinder = ClassFinder.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
    }

    public Symbol.ModuleSymbol findModule(Name name) {
        return this.findModule(this.syms.enterModule(name));
    }

    public Symbol.ModuleSymbol findModule(Symbol.ModuleSymbol msym) {
        List<Symbol.ModuleSymbol> list;
        if (msym.kind != Kinds.Kind.ERR && msym.sourceLocation == null && msym.classLocation == null && (list = this.scanModulePath(msym)).isEmpty()) {
            msym.kind = Kinds.Kind.ERR;
        }
        if (msym.kind != Kinds.Kind.ERR && msym.module_info.sourcefile == null && msym.module_info.classfile == null) {
            this.findModuleInfo(msym);
        }
        return msym;
    }

    public List<Symbol.ModuleSymbol> findAllModules() {
        List<Symbol.ModuleSymbol> list = this.scanModulePath(null);
        for (Symbol.ModuleSymbol msym : list) {
            if (msym.kind == Kinds.Kind.ERR || msym.module_info.sourcefile != null || msym.module_info.classfile != null) continue;
            this.findModuleInfo(msym);
        }
        return list;
    }

    public Symbol.ModuleSymbol findSingleModule() {
        try {
            JavaFileObject src_fo = this.getModuleInfoFromLocation(StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE);
            JavaFileObject class_fo = this.getModuleInfoFromLocation(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
            JavaFileObject fo = src_fo == null ? class_fo : (class_fo == null ? src_fo : this.classFinder.preferredFileObject(src_fo, class_fo));
            Symbol.ModuleSymbol msym = fo == null ? this.syms.unnamedModule : this.readModule(fo);
            if (msym.patchLocation == null) {
                msym.classLocation = StandardLocation.CLASS_OUTPUT;
            } else {
                msym.patchOutputLocation = StandardLocation.CLASS_OUTPUT;
            }
            return msym;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private Symbol.ModuleSymbol readModule(JavaFileObject fo) throws IOException {
        Name name;
        switch (fo.getKind()) {
            case SOURCE: {
                name = this.moduleNameFromSourceReader.readModuleName(fo);
                if (name != null) break;
                JCDiagnostic diag = this.diags.fragment(CompilerProperties.Fragments.FileDoesNotContainModule);
                Symbol.ClassSymbol errModuleInfo = this.syms.defineClass(this.names.module_info, this.syms.errModule);
                throw new ClassFinder.BadClassFile(errModuleInfo, fo, diag, this.diags, this.dcfh);
            }
            case CLASS: {
                try {
                    name = this.names.fromString(this.readModuleName(fo));
                }
                catch (ModuleNameReader.BadClassFile | IOException ex) {
                    name = this.names.error;
                }
                break;
            }
            default: {
                Assert.error();
                name = this.names.error;
            }
        }
        Symbol.ModuleSymbol msym = this.syms.enterModule(name);
        msym.module_info.classfile = fo;
        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) && name != this.names.error) {
            msym.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, name.toString());
            if (msym.patchLocation != null) {
                JavaFileObject patchFO = this.getModuleInfoFromLocation(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
                patchFO = this.preferredFileObject(this.getModuleInfoFromLocation(msym.patchLocation, JavaFileObject.Kind.CLASS), patchFO);
                patchFO = this.preferredFileObject(this.getModuleInfoFromLocation(msym.patchLocation, JavaFileObject.Kind.SOURCE), patchFO);
                if (patchFO != null) {
                    msym.module_info.classfile = patchFO;
                }
            }
        }
        msym.completer = Symbol.Completer.NULL_COMPLETER;
        this.classFinder.fillIn(msym.module_info);
        return msym;
    }

    private String readModuleName(JavaFileObject jfo) throws IOException, ModuleNameReader.BadClassFile {
        if (this.moduleNameReader == null) {
            this.moduleNameReader = new ModuleNameReader();
        }
        return this.moduleNameReader.readModuleName(jfo);
    }

    private JavaFileObject getModuleInfoFromLocation(JavaFileManager.Location location, JavaFileObject.Kind kind) throws IOException {
        if (location == null || !this.fileManager.hasLocation(location)) {
            return null;
        }
        return this.fileManager.getJavaFileForInput(location, this.names.module_info.toString(), kind);
    }

    private List<Symbol.ModuleSymbol> scanModulePath(Symbol.ModuleSymbol toFind) {
        ListBuffer<Symbol.ModuleSymbol> results = new ListBuffer<Symbol.ModuleSymbol>();
        HashMap<Name, JavaFileManager.Location> namesInSet = new HashMap<Name, JavaFileManager.Location>();
        boolean multiModuleMode = this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH);
        while (this.moduleLocationIterator.hasNext()) {
            Object locns = this.moduleLocationIterator.next();
            namesInSet.clear();
            Iterator iterator = locns.iterator();
            while (iterator.hasNext()) {
                JavaFileManager.Location l = (JavaFileManager.Location)iterator.next();
                try {
                    Name n = this.names.fromString(this.fileManager.inferModuleName(l));
                    if (namesInSet.put(n, l) == null) {
                        Symbol.ModuleSymbol msym = this.syms.enterModule(n);
                        if (msym.sourceLocation != null || msym.classLocation != null) continue;
                        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) && msym.patchLocation == null) {
                            msym.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, msym.name.toString());
                            if (msym.patchLocation != null && multiModuleMode && this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                msym.patchOutputLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, msym.name.toString());
                            }
                        }
                        if (this.moduleLocationIterator.outer == StandardLocation.MODULE_SOURCE_PATH) {
                            msym.sourceLocation = l;
                            if (this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                msym.classLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, msym.name.toString());
                            }
                        } else {
                            msym.classLocation = l;
                        }
                        if (this.moduleLocationIterator.outer == StandardLocation.SYSTEM_MODULES || this.moduleLocationIterator.outer == StandardLocation.UPGRADE_MODULE_PATH) {
                            msym.flags_field |= 0x20000000000000L;
                        }
                        if (toFind != null && (toFind != msym || msym.sourceLocation == null && msym.classLocation == null)) continue;
                        results.add(msym);
                        continue;
                    }
                    this.log.error(CompilerProperties.Errors.DuplicateModuleOnPath(this.getDescription(this.moduleLocationIterator.outer), n));
                }
                catch (IOException iOException) {}
            }
            if (toFind == null || !results.nonEmpty()) continue;
            return results.toList();
        }
        return results.toList();
    }

    private void findModuleInfo(final Symbol.ModuleSymbol msym) {
        try {
            JavaFileObject fo = this.getModuleInfoFromLocation(msym.patchOutputLocation, JavaFileObject.Kind.CLASS);
            fo = this.preferredFileObject(this.getModuleInfoFromLocation(msym.patchLocation, JavaFileObject.Kind.CLASS), fo);
            fo = this.preferredFileObject(this.getModuleInfoFromLocation(msym.patchLocation, JavaFileObject.Kind.SOURCE), fo);
            if (fo == null) {
                fo = this.getModuleInfoFromLocation(msym.classLocation, JavaFileObject.Kind.CLASS);
                fo = this.preferredFileObject(this.getModuleInfoFromLocation(msym.sourceLocation, JavaFileObject.Kind.SOURCE), fo);
            }
            if (fo == null) {
                String moduleName;
                String string = moduleName = msym.sourceLocation == null && msym.classLocation != null ? this.fileManager.inferModuleName(msym.classLocation) : null;
                if (moduleName != null) {
                    msym.module_info.classfile = null;
                    msym.flags_field |= 0x10000000000000L;
                } else {
                    msym.kind = Kinds.Kind.ERR;
                }
            } else {
                msym.module_info.classfile = fo;
                msym.module_info.completer = new Symbol.Completer(){

                    @Override
                    public void complete(Symbol sym) throws Symbol.CompletionFailure {
                        ModuleFinder.this.classFinder.fillIn(msym.module_info);
                    }

                    public String toString() {
                        return "ModuleInfoCompleter";
                    }
                };
            }
        }
        catch (IOException e) {
            msym.kind = Kinds.Kind.ERR;
        }
    }

    private JavaFileObject preferredFileObject(JavaFileObject fo1, JavaFileObject fo2) {
        if (fo1 == null) {
            return fo2;
        }
        if (fo2 == null) {
            return fo1;
        }
        return this.classFinder.preferredFileObject(fo1, fo2);
    }

    JCDiagnostic.Fragment getDescription(StandardLocation l) {
        switch (l) {
            case MODULE_PATH: {
                return CompilerProperties.Fragments.LocnModule_path;
            }
            case MODULE_SOURCE_PATH: {
                return CompilerProperties.Fragments.LocnModule_source_path;
            }
            case SYSTEM_MODULES: {
                return CompilerProperties.Fragments.LocnSystem_modules;
            }
            case UPGRADE_MODULE_PATH: {
                return CompilerProperties.Fragments.LocnUpgrade_module_path;
            }
        }
        throw new AssertionError();
    }

    public static interface ModuleNameFromSourceReader {
        public Name readModuleName(JavaFileObject var1);
    }

    class ModuleLocationIterator
    implements Iterator<Set<JavaFileManager.Location>> {
        StandardLocation outer;
        Set<JavaFileManager.Location> next = null;
        Iterator<StandardLocation> outerIter = Arrays.asList(StandardLocation.MODULE_SOURCE_PATH, StandardLocation.UPGRADE_MODULE_PATH, StandardLocation.SYSTEM_MODULES, StandardLocation.MODULE_PATH).iterator();
        Iterator<Set<JavaFileManager.Location>> innerIter = null;

        ModuleLocationIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.innerIter == null || !this.innerIter.hasNext()) {
                    if (this.outerIter.hasNext()) {
                        this.outer = this.outerIter.next();
                        try {
                            this.innerIter = ModuleFinder.this.fileManager.listLocationsForModules(this.outer).iterator();
                        }
                        catch (IOException e) {
                            System.err.println("error listing module locations for " + this.outer + ": " + e);
                        }
                        continue;
                    }
                    return false;
                }
                if (!this.innerIter.hasNext()) continue;
                this.next = this.innerIter.next();
            }
            return true;
        }

        @Override
        public Set<JavaFileManager.Location> next() {
            this.hasNext();
            if (this.next != null) {
                Set<JavaFileManager.Location> result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

