/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacFiler
implements Filer,
Closeable {
    private static final String ALREADY_OPENED = "Output stream or writer has already been opened.";
    private static final String NOT_FOR_READING = "FileObject was not opened for reading.";
    private static final String NOT_FOR_WRITING = "FileObject was not opened for writing.";
    JavaFileManager fileManager;
    JavacElements elementUtils;
    Log log;
    Modules modules;
    Names names;
    Symtab syms;
    Context context;
    boolean lastRound;
    private final boolean lint;
    private final Set<FileObject> initialInputs;
    private final Set<FileObject> fileObjectHistory;
    private final Set<String> openTypeNames;
    private Set<String> generatedSourceNames;
    private final Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> generatedClasses;
    private Set<JavaFileObject> generatedSourceFileObjects;
    private final Set<Pair<Symbol.ModuleSymbol, String>> aggregateGeneratedSourceNames;
    private final Set<Pair<Symbol.ModuleSymbol, String>> aggregateGeneratedClassNames;
    private final Set<String> initialClassNames;
    private final String defaultTargetModule;

    JavacFiler(Context context) {
        this.context = context;
        this.fileManager = context.get(JavaFileManager.class);
        this.elementUtils = JavacElements.instance(context);
        this.log = Log.instance(context);
        this.modules = Modules.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.initialInputs = Collections.synchronizedSet(new LinkedHashSet());
        this.fileObjectHistory = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceNames = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedSourceFileObjects = Collections.synchronizedSet(new LinkedHashSet());
        this.generatedClasses = Collections.synchronizedMap(new LinkedHashMap());
        this.openTypeNames = Collections.synchronizedSet(new LinkedHashSet());
        this.aggregateGeneratedSourceNames = new LinkedHashSet<Pair<Symbol.ModuleSymbol, String>>();
        this.aggregateGeneratedClassNames = new LinkedHashSet<Pair<Symbol.ModuleSymbol, String>>();
        this.initialClassNames = new LinkedHashSet<String>();
        this.lint = Lint.instance(context).isEnabled(Lint.LintCategory.PROCESSING);
        Options options = Options.instance(context);
        this.defaultTargetModule = options.get(Option.DEFAULT_MODULE_FOR_CREATED_FILES);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence nameAndModule, Element ... originatingElements) throws IOException {
        Pair<Symbol.ModuleSymbol, String> moduleAndClass = this.checkOrInferModule(nameAndModule);
        return this.createSourceOrClassFile((Symbol.ModuleSymbol)moduleAndClass.fst, true, (String)moduleAndClass.snd);
    }

    @Override
    public JavaFileObject createClassFile(CharSequence nameAndModule, Element ... originatingElements) throws IOException {
        Pair<Symbol.ModuleSymbol, String> moduleAndClass = this.checkOrInferModule(nameAndModule);
        return this.createSourceOrClassFile((Symbol.ModuleSymbol)moduleAndClass.fst, false, (String)moduleAndClass.snd);
    }

    private Pair<Symbol.ModuleSymbol, String> checkOrInferModule(CharSequence moduleAndPkg) throws FilerException {
        String pkg;
        String module;
        String moduleAndPkgString = moduleAndPkg.toString();
        int slash = moduleAndPkgString.indexOf(47);
        if (slash == -1) {
            int lastDot = moduleAndPkgString.lastIndexOf(46);
            String pack = lastDot != -1 ? moduleAndPkgString.substring(0, lastDot) : "";
            Symbol.ModuleSymbol msym = this.inferModule(pack);
            if (msym != null) {
                return Pair.of(msym, moduleAndPkgString);
            }
            if (this.defaultTargetModule == null) {
                throw new FilerException("Cannot determine target module.");
            }
            module = this.defaultTargetModule;
            pkg = moduleAndPkgString;
        } else {
            module = moduleAndPkgString.substring(0, slash);
            pkg = moduleAndPkgString.substring(slash + 1);
        }
        Symbol.ModuleSymbol explicitModule = this.syms.getModule(this.names.fromString(module));
        if (explicitModule == null) {
            throw new FilerException("Module: " + module + " does not exist.");
        }
        if (!this.modules.isRootModule(explicitModule)) {
            throw new FilerException("Cannot write to the given module.");
        }
        return Pair.of(explicitModule, pkg);
    }

    private JavaFileObject createSourceOrClassFile(Symbol.ModuleSymbol mod, boolean isSourceFile, String name) throws IOException {
        JavaFileManager.Location loc;
        int periodIndex;
        Assert.checkNonNull(mod);
        if (this.lint && (periodIndex = name.lastIndexOf(".")) != -1) {
            String extn;
            String base = name.substring(periodIndex);
            String string = extn = isSourceFile ? ".java" : ".class";
            if (base.equals(extn)) {
                this.log.warning(CompilerProperties.Warnings.ProcSuspiciousClassName(name, extn));
            }
        }
        this.checkNameAndExistence(mod, name, isSourceFile);
        StandardLocation standardLocation = loc = isSourceFile ? StandardLocation.SOURCE_OUTPUT : StandardLocation.CLASS_OUTPUT;
        if (this.modules.multiModuleMode) {
            loc = this.fileManager.getLocationForModule(loc, mod.name.toString());
        }
        JavaFileObject.Kind kind = isSourceFile ? JavaFileObject.Kind.SOURCE : JavaFileObject.Kind.CLASS;
        JavaFileObject fileObject = this.fileManager.getJavaFileForOutput(loc, name, kind, null);
        this.checkFileReopening(fileObject, true);
        if (this.lastRound) {
            this.log.warning(CompilerProperties.Warnings.ProcFileCreateLastRound(name));
        }
        if (isSourceFile) {
            this.aggregateGeneratedSourceNames.add(Pair.of(mod, name));
        } else {
            this.aggregateGeneratedClassNames.add(Pair.of(mod, name));
        }
        this.openTypeNames.add(name);
        return new FilerOutputJavaFileObject(mod, name, fileObject);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence moduleAndPkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String> locationModuleAndPackage = this.checkOrInferModule(location, moduleAndPkg, true);
        location = (JavaFileManager.Location)locationModuleAndPackage.a;
        Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)locationModuleAndPackage.b;
        String pkg = (String)locationModuleAndPackage.c;
        this.locationCheck(location);
        String strPkg = pkg.toString();
        if (strPkg.length() > 0) {
            this.checkName(strPkg);
        }
        FileObject fileObject = this.fileManager.getFileForOutput(location, strPkg, relativeName.toString(), null);
        this.checkFileReopening(fileObject, true);
        if (fileObject instanceof JavaFileObject) {
            return new FilerOutputJavaFileObject(msym, null, (JavaFileObject)fileObject);
        }
        return new FilerOutputFileObject(msym, null, fileObject);
    }

    private void locationCheck(JavaFileManager.Location location) {
        StandardLocation stdLoc;
        if (location instanceof StandardLocation && !(stdLoc = (StandardLocation)location).isOutputLocation()) {
            throw new IllegalArgumentException("Resource creation not supported in location " + stdLoc);
        }
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence moduleAndPkg, CharSequence relativeName) throws IOException {
        FileObject fileObject;
        Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String> locationModuleAndPackage = this.checkOrInferModule(location, moduleAndPkg, false);
        location = (JavaFileManager.Location)locationModuleAndPackage.a;
        String pkg = (String)locationModuleAndPackage.c;
        if (pkg.length() > 0) {
            this.checkName(pkg);
        }
        if ((fileObject = location.isOutputLocation() ? this.fileManager.getFileForOutput(location, pkg, relativeName.toString(), null) : this.fileManager.getFileForInput(location, pkg, relativeName.toString())) == null) {
            Object name = pkg.length() == 0 ? relativeName.toString() : pkg + "/" + relativeName;
            throw new FileNotFoundException((String)name);
        }
        this.checkFileReopening(fileObject, false);
        return new FilerInputFileObject(fileObject);
    }

    private Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String> checkOrInferModule(JavaFileManager.Location location, CharSequence moduleAndPkg, boolean write) throws IOException {
        String pkg;
        String module;
        boolean multiModuleLocation;
        String moduleAndPkgString = moduleAndPkg.toString();
        int slash = moduleAndPkgString.indexOf(47);
        boolean bl = multiModuleLocation = location.isModuleOrientedLocation() || this.modules.multiModuleMode && location.isOutputLocation();
        if (slash == -1) {
            Symbol.ModuleSymbol msym;
            if (!multiModuleLocation) {
                return new Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String>(location, this.modules.getDefaultModule(), moduleAndPkgString);
            }
            if (location.isOutputLocation() && (msym = this.inferModule(moduleAndPkgString)) != null) {
                JavaFileManager.Location moduleLoc = this.fileManager.getLocationForModule(location, msym.name.toString());
                return new Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String>(moduleLoc, msym, moduleAndPkgString);
            }
            if (this.defaultTargetModule == null) {
                throw new FilerException("No module specified and the location is either a module-oriented location, or a multi-module output location.");
            }
            module = this.defaultTargetModule;
            pkg = moduleAndPkgString;
        } else {
            module = moduleAndPkgString.substring(0, slash);
            pkg = moduleAndPkgString.substring(slash + 1);
        }
        if (multiModuleLocation) {
            Symbol.ModuleSymbol explicitModule = this.syms.getModule(this.names.fromString(module));
            if (explicitModule == null) {
                throw new FilerException("Module: " + module + " does not exist.");
            }
            if (write && !this.modules.isRootModule(explicitModule)) {
                throw new FilerException("Cannot write to the given module.");
            }
            JavaFileManager.Location moduleLoc = this.fileManager.getLocationForModule(location, module);
            return new Tuple3<JavaFileManager.Location, Symbol.ModuleSymbol, String>(moduleLoc, explicitModule, pkg);
        }
        throw new FilerException("Module specified but the location is neither a module-oriented location, nor a multi-module output location.");
    }

    private Symbol.ModuleSymbol inferModule(String pkg) {
        if (this.modules.getDefaultModule() == this.syms.noModule) {
            return this.modules.getDefaultModule();
        }
        Set<Symbol.ModuleSymbol> rootModules = this.modules.getRootModules();
        if (rootModules.size() == 1) {
            return rootModules.iterator().next();
        }
        Symbol.PackageSymbol pack = this.elementUtils.getPackageElement(pkg);
        if (pack != null && pack.modle != this.syms.unnamedModule) {
            return pack.modle;
        }
        return null;
    }

    private void checkName(String name) throws FilerException {
        this.checkName(name, false);
    }

    private void checkName(String name, boolean allowUnnamedPackageInfo) throws FilerException {
        if (!SourceVersion.isName(name) && !this.isPackageInfo(name, allowUnnamedPackageInfo)) {
            if (this.lint) {
                this.log.warning(CompilerProperties.Warnings.ProcIllegalFileName(name));
            }
            throw new FilerException("Illegal name " + name);
        }
    }

    private boolean isPackageInfo(String name, boolean allowUnnamedPackageInfo) {
        String PKG_INFO = "package-info";
        int periodIndex = name.lastIndexOf(".");
        if (periodIndex == -1) {
            return allowUnnamedPackageInfo ? name.equals("package-info") : false;
        }
        String prefix = name.substring(0, periodIndex);
        String simple = name.substring(periodIndex + 1);
        return SourceVersion.isName(prefix) && simple.equals("package-info");
    }

    private void checkNameAndExistence(Symbol.ModuleSymbol mod, String typename, boolean allowUnnamedPackageInfo) throws FilerException {
        boolean alreadySeen;
        this.checkName(typename, allowUnnamedPackageInfo);
        Symbol.ClassSymbol existing = this.elementUtils.getTypeElement(typename);
        boolean bl = alreadySeen = this.aggregateGeneratedSourceNames.contains(Pair.of(mod, typename)) || this.aggregateGeneratedClassNames.contains(Pair.of(mod, typename)) || this.initialClassNames.contains(typename) || existing != null && this.initialInputs.contains(existing.sourcefile);
        if (alreadySeen) {
            if (this.lint) {
                this.log.warning(CompilerProperties.Warnings.ProcTypeRecreate(typename));
            }
            throw new FilerException("Attempt to recreate a file for type " + typename);
        }
        if (this.lint && existing != null) {
            this.log.warning(CompilerProperties.Warnings.ProcTypeAlreadyExists(typename));
        }
        if (!mod.isUnnamed() && !typename.contains(".")) {
            throw new FilerException("Attempt to create a type in unnamed package of a named module: " + typename);
        }
    }

    private void checkFileReopening(FileObject fileObject, boolean forWriting) throws FilerException {
        if (this.isInFileObjectHistory(fileObject, forWriting)) {
            if (this.lint) {
                this.log.warning(CompilerProperties.Warnings.ProcFileReopening(fileObject.getName()));
            }
            throw new FilerException("Attempt to reopen a file for path " + fileObject.getName());
        }
        if (forWriting) {
            this.fileObjectHistory.add(fileObject);
        }
    }

    private boolean isInFileObjectHistory(FileObject fileObject, boolean forWriting) {
        if (forWriting) {
            for (FileObject veteran : this.initialInputs) {
                try {
                    if (!this.fileManager.isSameFile(veteran, fileObject)) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            for (String className : this.initialClassNames) {
                try {
                    Symbol.ClassSymbol existing = this.elementUtils.getTypeElement(className);
                    if (existing == null || (existing.sourcefile == null || !this.fileManager.isSameFile(existing.sourcefile, fileObject)) && (existing.classfile == null || !this.fileManager.isSameFile(existing.classfile, fileObject))) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        for (FileObject veteran : this.fileObjectHistory) {
            if (!this.fileManager.isSameFile(veteran, fileObject)) continue;
            return true;
        }
        return false;
    }

    public boolean newFiles() {
        return !this.generatedSourceNames.isEmpty() || !this.generatedClasses.isEmpty();
    }

    public Set<String> getGeneratedSourceNames() {
        return this.generatedSourceNames;
    }

    public Set<JavaFileObject> getGeneratedSourceFileObjects() {
        return this.generatedSourceFileObjects;
    }

    public Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> getGeneratedClasses() {
        return this.generatedClasses;
    }

    public void warnIfUnclosedFiles() {
        if (!this.openTypeNames.isEmpty()) {
            this.log.warning(CompilerProperties.Warnings.ProcUnclosedTypeFiles(this.openTypeNames));
        }
    }

    public void newRound() {
        this.clearRoundState();
    }

    void setLastRound(boolean lastRound) {
        this.lastRound = lastRound;
    }

    public void setInitialState(Collection<? extends JavaFileObject> initialInputs, Collection<String> initialClassNames) {
        this.initialInputs.addAll(initialInputs);
        this.initialClassNames.addAll(initialClassNames);
    }

    @Override
    public void close() {
        this.clearRoundState();
        this.initialClassNames.clear();
        this.initialInputs.clear();
        this.fileObjectHistory.clear();
        this.openTypeNames.clear();
        this.aggregateGeneratedSourceNames.clear();
        this.aggregateGeneratedClassNames.clear();
    }

    private void clearRoundState() {
        this.generatedSourceNames.clear();
        this.generatedSourceFileObjects.clear();
        this.generatedClasses.clear();
    }

    public void displayState() {
        PrintWriter xout = this.context.get(Log.logKey).getWriter(Log.WriterKind.STDERR);
        xout.println("File Object History : " + this.fileObjectHistory);
        xout.println("Open Type Names     : " + this.openTypeNames);
        xout.println("Gen. Src Names      : " + this.generatedSourceNames);
        xout.println("Gen. Cls Names      : " + this.generatedClasses.keySet());
        xout.println("Agg. Gen. Src Names : " + this.aggregateGeneratedSourceNames);
        xout.println("Agg. Gen. Cls Names : " + this.aggregateGeneratedClassNames);
    }

    public String toString() {
        return "javac Filer";
    }

    private void closeFileObject(Symbol.ModuleSymbol mod, String typeName, FileObject fileObject) {
        if (typeName != null) {
            if (!(fileObject instanceof JavaFileObject)) {
                throw new AssertionError((Object)("JavaFileOject not found for " + fileObject));
            }
            JavaFileObject javaFileObject = (JavaFileObject)fileObject;
            switch (javaFileObject.getKind()) {
                case SOURCE: {
                    this.generatedSourceNames.add(typeName);
                    this.generatedSourceFileObjects.add(javaFileObject);
                    this.openTypeNames.remove(typeName);
                    break;
                }
                case CLASS: {
                    this.generatedClasses.computeIfAbsent(mod, m -> Collections.synchronizedMap(new LinkedHashMap())).put(typeName, javaFileObject);
                    this.openTypeNames.remove(typeName);
                    break;
                }
            }
        }
    }

    static final class Tuple3<A, B, C> {
        final A a;
        final B b;
        final C c;

        public Tuple3(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    private class FilerWriter
    extends FilterWriter {
        Symbol.ModuleSymbol mod;
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerWriter(Symbol.ModuleSymbol mod, String typeName, FileObject fileObject) throws IOException {
            super(fileObject.openWriter());
            this.closed = false;
            this.mod = mod;
            this.typeName = typeName;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.mod, this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerOutputStream
    extends FilterOutputStream {
        Symbol.ModuleSymbol mod;
        String typeName;
        FileObject fileObject;
        boolean closed;

        FilerOutputStream(Symbol.ModuleSymbol mod, String typeName, FileObject fileObject) throws IOException {
            super(fileObject.openOutputStream());
            this.closed = false;
            this.mod = mod;
            this.typeName = typeName;
            this.fileObject = fileObject;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                JavacFiler.this.closeFileObject(this.mod, this.typeName, this.fileObject);
                this.out.close();
            }
        }
    }

    private class FilerInputJavaFileObject
    extends FilerInputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerInputJavaFileObject(JavaFileObject javaFileObject) {
            super(javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(simpleName, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerInputFileObject
    extends ForwardingFileObject<FileObject> {
        FilerInputFileObject(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_WRITING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }

    private class FilerOutputJavaFileObject
    extends FilerOutputFileObject
    implements JavaFileObject {
        private final JavaFileObject javaFileObject;

        FilerOutputJavaFileObject(Symbol.ModuleSymbol mod, String name, JavaFileObject javaFileObject) {
            super(mod, name, javaFileObject);
            this.javaFileObject = javaFileObject;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.javaFileObject.getKind();
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.javaFileObject.isNameCompatible(simpleName, kind);
        }

        @Override
        public NestingKind getNestingKind() {
            return this.javaFileObject.getNestingKind();
        }

        @Override
        public Modifier getAccessLevel() {
            return this.javaFileObject.getAccessLevel();
        }
    }

    private class FilerOutputFileObject
    extends ForwardingFileObject<FileObject> {
        private boolean opened;
        private Symbol.ModuleSymbol mod;
        private String name;

        FilerOutputFileObject(Symbol.ModuleSymbol mod, String name, FileObject fileObject) {
            super(fileObject);
            this.opened = false;
            this.mod = mod;
            this.name = name;
        }

        @Override
        public synchronized OutputStream openOutputStream() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerOutputStream(this.mod, this.name, this.fileObject);
        }

        @Override
        public synchronized Writer openWriter() throws IOException {
            if (this.opened) {
                throw new IOException(JavacFiler.ALREADY_OPENED);
            }
            this.opened = true;
            return new FilerWriter(this.mod, this.name, this.fileObject);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            throw new IllegalStateException(JavacFiler.NOT_FOR_READING);
        }

        @Override
        public boolean delete() {
            return false;
        }
    }
}

