/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="InjectMoreThanOneScopeAnnotationOnClass", altNames={"MoreThanOneScopeAnnotationOnClass"}, summary="A class can be annotated with at most one scope annotation.", severity=BugPattern.SeverityLevel.ERROR)
public class MoreThanOneScopeAnnotationOnClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final MultiMatcher<Tree, AnnotationTree> SCOPE_ANNOTATION_MATCHER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)InjectMatchers.IS_SCOPING_ANNOTATION);

    public final Description matchClass(ClassTree classTree, VisitorState state) {
        List scopeAnnotations;
        MultiMatcher.MultiMatchResult scopeAnnotationResult = SCOPE_ANNOTATION_MATCHER.multiMatchResult((Tree)classTree, state);
        if (scopeAnnotationResult.matches() && !InjectMatchers.IS_DAGGER_COMPONENT.matches((Tree)classTree, state) && (scopeAnnotations = scopeAnnotationResult.matchingNodes()).size() > 1) {
            return this.buildDescription(classTree).setMessage("This class is annotated with more than one scope annotation: " + this.annotationDebugString(scopeAnnotations) + ". However, classes can only have one scope annotation applied to them. Please remove all but one of them.").build();
        }
        return Description.NO_MATCH;
    }

    private String annotationDebugString(List<AnnotationTree> scopeAnnotations) {
        return Joiner.on((String)", ").join(scopeAnnotations);
    }
}

