/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.javac;

import com.google.common.collect.MapMaker;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import lombok.ast.StringLiteral;

public class JcTreePrinter {
    private final StringBuilder output = new StringBuilder();
    private final boolean includePositions;
    private final boolean includeObjectRefs;
    private int indent;
    private String rel;
    private Map<JCTree, Integer> endPosTable;
    private boolean modsOfEnum;
    private final Map<Object, Integer> visited = new MapMaker().weakKeys().makeMap();
    private int objectCounter = 0;
    private static final Method GET_TAG_METHOD;
    private static final Field TAG_FIELD;
    private final JCTree.Visitor visitor = new JCTree.Visitor(){

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.endPosTable = (Map)((Object)tree.endPositions);
            JcTreePrinter.this.child("pid", tree.pid);
            JcTreePrinter.this.children("defs", tree.defs);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitImport(JCTree.JCImport tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("staticImport", tree.staticImport);
            JcTreePrinter.this.child("qualid", tree.qualid);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.modsOfEnum = tree.mods != null && (tree.mods.flags & 0x4000L) != 0L;
            JcTreePrinter.this.child("mods", tree.mods);
            JcTreePrinter.this.property("name", tree.name);
            JcTreePrinter.this.children("typarams", tree.typarams);
            JcTreePrinter.this.child("extends", tree.extending);
            JcTreePrinter.this.children("implementing", tree.implementing);
            JcTreePrinter.this.children("defs", tree.defs);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("name", tree.name);
            JcTreePrinter.this.child("mods", tree.mods);
            JcTreePrinter.this.children("typarams", tree.typarams);
            JcTreePrinter.this.children("params", tree.params);
            JcTreePrinter.this.children("thrown", tree.thrown);
            JcTreePrinter.this.child("default", tree.defaultValue);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("mods", tree.mods);
            JcTreePrinter.this.child("vartype", tree.vartype);
            JcTreePrinter.this.property("name", tree.name);
            JcTreePrinter.this.child("init", tree.init);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitSkip(JCTree.JCSkip tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("flags", "0x" + Long.toString(tree.flags, 16));
            JcTreePrinter.this.children("stats", tree.stats);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.child("cond", tree.cond);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("cond", tree.cond);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.children("init", tree.init);
            JcTreePrinter.this.child("cond", tree.cond);
            JcTreePrinter.this.children("step", tree.step);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("var", tree.var);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("label", tree.label);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("selector", tree.selector);
            JcTreePrinter.this.children("cases", tree.cases);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitCase(JCTree.JCCase tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("pat", tree.pat);
            JcTreePrinter.this.children("stats", tree.stats);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitSynchronized(JCTree.JCSynchronized tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("lock", tree.lock);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.children("catchers", tree.catchers);
            JcTreePrinter.this.child("finalizer", tree.finalizer);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitCatch(JCTree.JCCatch tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("param", tree.param);
            JcTreePrinter.this.child("body", tree.body);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("cond", tree.cond);
            JcTreePrinter.this.child("truepart", tree.truepart);
            JcTreePrinter.this.child("falsepart", tree.falsepart);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("cond", tree.cond);
            JcTreePrinter.this.child("thenpart", tree.thenpart);
            JcTreePrinter.this.child("elsepart", tree.elsepart);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("label", tree.label);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("label", tree.label);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitAssert(JCTree.JCAssert tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("cond", tree.cond);
            JcTreePrinter.this.child("detail", tree.detail);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.children("typeargs", tree.typeargs);
            JcTreePrinter.this.child("meth", tree.meth);
            JcTreePrinter.this.children("args", tree.args);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("encl", tree.encl);
            JcTreePrinter.this.children("typeargs", tree.typeargs);
            JcTreePrinter.this.child("clazz", tree.clazz);
            JcTreePrinter.this.children("args", tree.args);
            JcTreePrinter.this.child("def", tree.def);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("elemtype", tree.elemtype);
            JcTreePrinter.this.children("dims", tree.dims);
            JcTreePrinter.this.children("elems", tree.elems);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("lhs", tree.lhs);
            JcTreePrinter.this.child("rhs", tree.rhs);
            JcTreePrinter.this.indent--;
        }

        public String operatorName(int tag) {
            switch (tag) {
                case 46: {
                    return "+";
                }
                case 47: {
                    return "-";
                }
                case 48: {
                    return "!";
                }
                case 49: {
                    return "~";
                }
                case 50: {
                    return "++X";
                }
                case 51: {
                    return "--X";
                }
                case 52: {
                    return "X++";
                }
                case 53: {
                    return "X--";
                }
                case 54: {
                    return "<*nullchk*>";
                }
                case 55: {
                    return "||";
                }
                case 56: {
                    return "&&";
                }
                case 60: {
                    return "==";
                }
                case 61: {
                    return "!=";
                }
                case 62: {
                    return "<";
                }
                case 63: {
                    return ">";
                }
                case 64: {
                    return "<=";
                }
                case 65: {
                    return ">=";
                }
                case 57: {
                    return "|";
                }
                case 58: {
                    return "^";
                }
                case 59: {
                    return "&";
                }
                case 66: {
                    return "<<";
                }
                case 67: {
                    return ">>";
                }
                case 68: {
                    return ">>>";
                }
                case 69: {
                    return "+";
                }
                case 70: {
                    return "-";
                }
                case 71: {
                    return "*";
                }
                case 72: {
                    return "/";
                }
                case 73: {
                    return "%";
                }
                case 86: {
                    return "+=";
                }
                case 87: {
                    return "-=";
                }
                case 88: {
                    return "*=";
                }
                case 89: {
                    return "/=";
                }
                case 90: {
                    return "%=";
                }
                case 76: {
                    return "&=";
                }
                case 75: {
                    return "^=";
                }
                case 74: {
                    return "|=";
                }
                case 83: {
                    return "<<=";
                }
                case 84: {
                    return ">>=";
                }
                case 85: {
                    return ">>>=";
                }
                case 32: {
                    return "instanceof";
                }
            }
            throw new Error("Unexpected operator: " + tag);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("lhs", tree.lhs);
            JcTreePrinter.this.property("(operator)", this.operatorName(JcTreePrinter.getTag(tree) - 17) + "=");
            JcTreePrinter.this.child("rhs", tree.rhs);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("arg", tree.arg);
            JcTreePrinter.this.property("(operator)", this.operatorName(JcTreePrinter.getTag(tree)));
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("lhs", tree.lhs);
            JcTreePrinter.this.property("(operator)", this.operatorName(JcTreePrinter.getTag(tree)));
            JcTreePrinter.this.child("rhs", tree.rhs);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("clazz", tree.clazz);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.child("clazz", tree.clazz);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitIndexed(JCTree.JCArrayAccess tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("indexed", tree.indexed);
            JcTreePrinter.this.child("index", tree.index);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("selected", tree.selected);
            JcTreePrinter.this.property("name", tree.name);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("name", tree.name);
            JcTreePrinter.this.indent--;
        }

        public String literalName(int typeTag) {
            switch (typeTag) {
                case 1: {
                    return "BYTE";
                }
                case 3: {
                    return "SHORT";
                }
                case 4: {
                    return "INT";
                }
                case 5: {
                    return "LONG";
                }
                case 6: {
                    return "FLOAT";
                }
                case 7: {
                    return "DOUBLE";
                }
                case 2: {
                    return "CHAR";
                }
                case 8: {
                    return "BOOLEAN";
                }
                case 9: {
                    return "VOID";
                }
                case 10: {
                    return "CLASS/STRING";
                }
                case 17: {
                    return "BOT";
                }
            }
            return "ERROR(" + typeTag + ")";
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("typetag", this.literalName((int)tree.typetag));
            JcTreePrinter.this.property("value", tree.value);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("typetag", this.literalName((int)tree.typetag));
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("elemtype", tree.elemtype);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("clazz", tree.clazz);
            JcTreePrinter.this.children("arguments", tree.arguments);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("name", tree.name);
            JcTreePrinter.this.children("bounds", tree.bounds);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard tree) {
            Object o;
            JcTreePrinter.this.printNode(tree);
            try {
                o = tree.getClass().getField("kind").get(tree);
            }
            catch (Exception e) {
                throw new RuntimeException("There's no field at all named 'kind' in JCWildcard? This is not a javac I understand.", e);
            }
            if (o instanceof JCTree) {
                JcTreePrinter.this.child("kind", (JCTree)o);
            } else if (o instanceof BoundKind) {
                JcTreePrinter.this.property("kind", String.valueOf(o));
            }
            JcTreePrinter.this.child("inner", tree.inner);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTypeBoundKind(JCTree.TypeBoundKind tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.property("kind", String.valueOf((Object)tree.kind));
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitErroneous(JCTree.JCErroneous tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.children("errs", tree.errs);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitLetExpr(JCTree.LetExpr tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.children("defs", tree.defs);
            JcTreePrinter.this.child("expr", tree.expr);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitModifiers(JCTree.JCModifiers tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.children("annotations", tree.annotations);
            JcTreePrinter.this.property("flags", "0x" + Long.toString(tree.flags, 16));
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation tree) {
            JcTreePrinter.this.printNode(tree);
            JcTreePrinter.this.child("annotationType", tree.annotationType);
            JcTreePrinter.this.children("args", tree.args);
            JcTreePrinter.this.indent--;
        }

        @Override
        public void visitTree(JCTree tree) {
            String typeName = tree == null ? "NULL" : tree.getClass().getSimpleName();
            JcTreePrinter.this.printNode("UNKNOWN(" + typeName + ")");
            JcTreePrinter.this.indent--;
        }
    };

    static int getTag(JCTree tree) {
        if (GET_TAG_METHOD != null) {
            try {
                return (Integer)GET_TAG_METHOD.invoke((Object)tree, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        try {
            return TAG_FIELD.getInt(tree);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private JcTreePrinter(boolean includePositions) {
        this.includePositions = includePositions;
        this.includeObjectRefs = true;
    }

    public static JcTreePrinter printerWithPositions() {
        return new JcTreePrinter(true);
    }

    public static JcTreePrinter printerWithoutPositions() {
        return new JcTreePrinter(false);
    }

    public String toString() {
        return this.output.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: Supply a file name to print.");
            return;
        }
        Context context = new Context();
        Options.instance(context).put(OptionName.ENCODING, "UTF-8");
        JavaCompiler compiler = new JavaCompiler(context);
        compiler.genEndPos = true;
        compiler.keepComments = true;
        JCTree.JCCompilationUnit cu = compiler.parse(args[0]);
        JcTreePrinter printer = new JcTreePrinter(true);
        printer.visit(cu);
        System.out.println(printer);
    }

    private void printNode(JCTree tree) {
        if (tree == null) {
            this.printNode("NULL");
        } else {
            int objId;
            String suffix = "";
            Integer backRef = this.visited.get(tree);
            if (backRef == null) {
                objId = ++this.objectCounter;
                this.visited.put(tree, objId);
            } else {
                objId = backRef;
            }
            if (this.includePositions) {
                Integer endPos_ = null;
                if (this.endPosTable != null) {
                    endPos_ = this.endPosTable.get(tree);
                }
                int endPos = endPos_ == null ? tree.getEndPosition(this.endPosTable) : endPos_.intValue();
                int startPos = tree.pos;
                if (tree instanceof JCTree.JCTypeApply || tree instanceof JCTree.JCWildcard || tree instanceof JCTree.JCTypeParameter) {
                    endPos = -2;
                }
                if (tree instanceof JCTree.JCModifiers && endPos - tree.pos <= 0) {
                    startPos = -1;
                    endPos = -1;
                }
                if (tree instanceof JCTree.JCAnnotation || tree instanceof JCTree.JCModifiers) {
                    endPos = -2;
                }
                if (this.modsOfEnum) {
                    startPos = -1;
                    endPos = -1;
                    this.modsOfEnum = false;
                }
                if (startPos == -1 && endPos >= 0) {
                    endPos = -1;
                }
                if (tree instanceof JCTree.JCBinary && ((JCTree.JCBinary)tree).rhs instanceof JCTree.JCBinary && JcTreePrinter.getTag(tree) != JcTreePrinter.getTag(((JCTree.JCBinary)tree).rhs)) {
                    startPos = -2;
                }
                if (tree instanceof JCTree.JCBinary && ((JCTree.JCBinary)tree).rhs instanceof JCTree.JCInstanceOf) {
                    startPos = -2;
                }
                if (tree instanceof JCTree.JCMethodInvocation) {
                    JCTree.JCMethodInvocation invoke = (JCTree.JCMethodInvocation)tree;
                    if (invoke.meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)invoke.meth).selected instanceof JCTree.JCIdent) {
                        JCTree.JCIdent selected = (JCTree.JCIdent)((JCTree.JCFieldAccess)invoke.meth).selected;
                        if (selected.name.toString().equals("super")) {
                            endPos = -2;
                        }
                    }
                }
                if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).selected instanceof JCTree.JCIdent) {
                    JCTree.JCIdent selected = (JCTree.JCIdent)((JCTree.JCFieldAccess)tree).selected;
                    if (selected.name.toString().equals("super")) {
                        endPos = -2;
                    }
                }
                if (tree instanceof JCTree.JCAssign && ((JCTree.JCAssign)tree).rhs instanceof JCTree.JCFieldAccess) {
                    startPos = -2;
                }
                suffix = suffix + String.format("(%d-%d)", startPos, endPos);
            }
            if (this.includeObjectRefs) {
                suffix = suffix + String.format("(id: %d%s)", objId, backRef != null ? " BACKREF" : "");
            }
            this.printNode(String.format("%s%s", tree.getClass().getSimpleName(), suffix));
        }
    }

    private void printNode(String nodeKind) {
        this.printIndent();
        if (this.rel != null) {
            this.output.append(this.rel).append(": ");
        }
        this.rel = null;
        this.output.append("[").append(nodeKind).append("]\n");
        ++this.indent;
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.output.append("\t");
        }
    }

    private void property(String rel, Object val) {
        this.printIndent();
        if (rel != null) {
            this.output.append(rel).append(": ");
        }
        if (val instanceof JCTree) {
            this.output.append("!!JCTree-AS-PROP!!");
        }
        if (val == null) {
            this.output.append("[NULL]\n");
        } else {
            String content = val instanceof String ? new StringLiteral().astValue(val.toString()).rawValue() : String.valueOf(val);
            this.output.append("[").append(val.getClass().getSimpleName()).append(" ").append(content).append("]\n");
        }
    }

    private void child(String rel, JCTree node) {
        this.rel = rel;
        if (node != null) {
            node.accept(this.visitor);
        } else {
            this.printNode("NULL");
            --this.indent;
        }
    }

    private void children(String rel, List<? extends JCTree> nodes) {
        this.rel = rel;
        if (nodes == null) {
            this.printNode("LISTNULL");
            --this.indent;
        } else if (nodes.isEmpty()) {
            this.printNode("LISTEMPTY");
            --this.indent;
        } else {
            int i = 0;
            for (JCTree jCTree : nodes) {
                this.child(String.format("%s[%d]", rel, i++), jCTree);
            }
        }
    }

    public void visit(JCTree tree) {
        tree.accept(this.visitor);
    }

    static {
        Method m = null;
        Field f = null;
        try {
            m = JCTree.class.getDeclaredMethod("getTag", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                f = JCTree.class.getDeclaredField("tag");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        GET_TAG_METHOD = m;
        TAG_FIELD = f;
    }
}

