/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="FieldCanBeStatic", summary="A final field initialized at compile-time with an instance of an immutable type can be static.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class FieldCanBeStatic
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (!FieldCanBeStatic.canBeStatic(sym)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        String name = tree.getName().toString();
        if (!name.equals(Ascii.toUpperCase((String)name))) {
            String renamed = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
            fix.merge(SuggestedFixes.renameVariable((VariableTree)tree, (String)renamed, (VisitorState)state));
        }
        return this.describeMatch(tree.getModifiers(), (Fix)fix.build());
    }

    private static boolean canBeStatic(Symbol.VarSymbol sym) {
        if (sym == null) {
            return false;
        }
        if (!sym.getKind().equals((Object)ElementKind.FIELD)) {
            return false;
        }
        if (!sym.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        if (!sym.isPrivate()) {
            return false;
        }
        if (sym.isStatic()) {
            return false;
        }
        if (sym.getConstantValue() == null) {
            return false;
        }
        return !sym.hasAnnotations();
    }
}

