/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.options;

import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.options.Option;
import com.sun.tools.sjavac.options.OptionHelper;
import com.sun.tools.sjavac.options.SourceLocation;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class Options {
    private Path destDir;
    private Path genSrcDir;
    private Path headerDir;
    private Path stateDir;
    private List<SourceLocation> sources = new ArrayList<SourceLocation>();
    private List<SourceLocation> sourceSearchPaths = new ArrayList<SourceLocation>();
    private List<SourceLocation> classSearchPaths = new ArrayList<SourceLocation>();
    private List<SourceLocation> moduleSearchPaths = new ArrayList<SourceLocation>();
    private String logLevel = "info";
    private Set<String> permitted_artifacts = new HashSet<String>();
    private boolean permitUnidentifiedArtifacts = false;
    private boolean permitSourcesInDefaultPackage = false;
    private Path sourceReferenceList;
    private int numCores = 4;
    private String implicitPolicy = "none";
    private List<String> javacArgs = new ArrayList<String>();
    private Map<String, Transformer> trRules = new HashMap<String, Transformer>();
    private boolean startServer = false;
    private String serverConf;

    public String getImplicitPolicy() {
        return this.implicitPolicy;
    }

    public Path getGenSrcDir() {
        return this.genSrcDir;
    }

    public Path getDestDir() {
        return this.destDir;
    }

    public Path getHeaderDir() {
        return this.headerDir;
    }

    public Path getStateDir() {
        return this.stateDir;
    }

    public List<SourceLocation> getSources() {
        return this.sources;
    }

    public List<SourceLocation> getSourceSearchPaths() {
        return this.sourceSearchPaths;
    }

    public List<SourceLocation> getClassSearchPath() {
        return this.classSearchPaths;
    }

    public List<SourceLocation> getModuleSearchPaths() {
        return this.moduleSearchPaths;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isUnidentifiedArtifactPermitted(String f) {
        return this.permitted_artifacts.contains(f);
    }

    public boolean areUnidentifiedArtifactsPermitted() {
        return this.permitUnidentifiedArtifacts;
    }

    public boolean isDefaultPackagePermitted() {
        return this.permitSourcesInDefaultPackage;
    }

    public Path getSourceReferenceList() {
        return this.sourceReferenceList;
    }

    public int getNumCores() {
        return this.numCores;
    }

    public List<String> getJavacArgs() {
        return this.javacArgs;
    }

    public Map<String, Transformer> getTranslationRules() {
        return this.trRules;
    }

    public boolean startServerFlag() {
        return this.startServer;
    }

    public String getServerConf() {
        return this.serverConf;
    }

    public static Options parseArgs(String ... args) {
        Options options = new Options();
        options.new ArgDecoderOptionHelper().traverse(args);
        return options;
    }

    public boolean isJavaFilesAmongJavacArgs() {
        for (String javacArg : this.javacArgs) {
            if (!javacArg.endsWith(".java")) continue;
            return true;
        }
        return false;
    }

    public String getStateArgsString() {
        class StateArgs {
            private List<String> args = new ArrayList<String>();

            StateArgs() {
            }

            void addArg(Option opt) {
                this.args.add(opt.arg);
            }

            void addArg(Option opt, Object val) {
                this.addArg(opt);
                this.args.add(val.toString());
            }

            void addSourceLocations(Option opt, List<SourceLocation> locs) {
                for (SourceLocation sl : locs) {
                    for (String pkg : sl.includes) {
                        this.addArg(Option.I, pkg);
                    }
                    for (String pkg : sl.excludes) {
                        this.addArg(Option.X, pkg);
                    }
                    this.addArg(opt, sl.getPath());
                }
            }

            String getResult() {
                return String.join((CharSequence)" ", this.args);
            }

            public void addAll(Collection<String> toAdd) {
                this.args.addAll(toAdd);
            }
        }
        StateArgs args = new StateArgs();
        if (this.genSrcDir != null) {
            args.addArg(Option.S, this.genSrcDir.normalize());
        }
        if (this.headerDir != null) {
            args.addArg(Option.H, this.headerDir.normalize());
        }
        if (this.destDir != null) {
            args.addArg(Option.D, this.destDir.normalize());
        }
        if (this.stateDir != null) {
            args.addArg(Option.STATE_DIR, this.stateDir.normalize());
        }
        args.addSourceLocations(Option.SRC, this.sources);
        args.addSourceLocations(Option.SOURCE_PATH, this.sourceSearchPaths);
        args.addSourceLocations(Option.CLASS_PATH, this.classSearchPaths);
        args.addSourceLocations(Option.MODULE_PATH, this.moduleSearchPaths);
        if (this.permitSourcesInDefaultPackage) {
            args.addArg(Option.PERMIT_SOURCES_WITHOUT_PACKAGE);
        }
        for (String string : this.permitted_artifacts) {
            args.addArg(Option.PERMIT_ARTIFACT, string);
        }
        if (this.permitUnidentifiedArtifacts) {
            args.addArg(Option.PERMIT_UNIDENTIFIED_ARTIFACTS);
        }
        for (Map.Entry entry : this.trRules.entrySet()) {
            String val = (String)entry.getKey() + "=" + ((Transformer)entry.getValue()).getClass().getName();
            args.addArg(Option.TR, val);
        }
        args.addAll(this.javacArgs);
        return args.getResult();
    }

    public String[] prepJavacArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-d");
        args.add(this.destDir.toString());
        if (this.getGenSrcDir() != null) {
            args.add("-s");
            args.add(this.genSrcDir.toString());
        }
        if (this.headerDir != null) {
            args.add("-h");
            args.add(this.headerDir.toString());
        }
        ArrayList<SourceLocation> sourcepath = new ArrayList<SourceLocation>();
        sourcepath.addAll(this.sources);
        sourcepath.addAll(this.sourceSearchPaths);
        if (sourcepath.size() > 0) {
            args.add("-sourcepath");
            args.add(Options.concatenateSourceLocations(sourcepath));
        }
        if (this.classSearchPaths.size() > 0) {
            args.add("-classpath");
            args.add(Options.concatenateSourceLocations(this.classSearchPaths));
        }
        args.add("--debug=completionDeps=source,class");
        args.add("-implicit:" + this.implicitPolicy);
        args.addAll(this.javacArgs);
        return args.toArray(new String[args.size()]);
    }

    private static String concatenateSourceLocations(List<SourceLocation> locs) {
        StringJoiner joiner = new StringJoiner(File.pathSeparator);
        for (SourceLocation loc : locs) {
            joiner.add(loc.getPath().toString());
        }
        return joiner.toString();
    }

    private class ArgDecoderOptionHelper
    extends OptionHelper {
        List<String> includes;
        List<String> excludes;
        List<String> includeFiles;
        List<String> excludeFiles;
        boolean headerProvided;
        boolean genSrcProvided;
        boolean stateProvided;

        private ArgDecoderOptionHelper() {
            this.resetFilters();
            this.headerProvided = false;
            this.genSrcProvided = false;
            this.stateProvided = false;
        }

        @Override
        public void reportError(String msg) {
            throw new IllegalArgumentException(msg);
        }

        @Override
        public void sourceRoots(List<Path> paths) {
            Options.this.sources.addAll(this.createSourceLocations(paths));
        }

        @Override
        public void exclude(String exclPattern) {
            exclPattern = Util.normalizeDriveLetter(exclPattern);
            this.excludes.add(exclPattern);
        }

        @Override
        public void include(String inclPattern) {
            inclPattern = Util.normalizeDriveLetter(inclPattern);
            this.includes.add(inclPattern);
        }

        @Override
        public void addTransformer(String suffix, Transformer tr) {
            if (Options.this.trRules.containsKey(suffix)) {
                this.reportError("More than one transformer specified for suffix " + suffix + ".");
                return;
            }
            Options.this.trRules.put(suffix, tr);
        }

        @Override
        public void sourcepath(List<Path> paths) {
            Options.this.sourceSearchPaths.addAll(this.createSourceLocations(paths));
        }

        @Override
        public void modulepath(List<Path> paths) {
            Options.this.moduleSearchPaths.addAll(this.createSourceLocations(paths));
        }

        @Override
        public void classpath(List<Path> paths) {
            Options.this.classSearchPaths.addAll(this.createSourceLocations(paths));
        }

        @Override
        public void numCores(int n) {
            Options.this.numCores = n;
        }

        @Override
        public void logLevel(String level) {
            Options.this.logLevel = level;
        }

        @Override
        public void compareFoundSources(Path referenceList) {
            Options.this.sourceReferenceList = referenceList;
        }

        @Override
        public void permitArtifact(String f) {
            Options.this.permitted_artifacts.add(f);
        }

        @Override
        public void permitUnidentifiedArtifacts() {
            Options.this.permitUnidentifiedArtifacts = true;
        }

        @Override
        public void permitDefaultPackage() {
            Options.this.permitSourcesInDefaultPackage = true;
        }

        @Override
        public void serverConf(String conf) {
            if (Options.this.serverConf != null) {
                this.reportError("Can not specify more than one server configuration.");
            } else {
                Options.this.serverConf = conf;
            }
        }

        @Override
        public void implicit(String policy) {
            Options.this.implicitPolicy = policy;
        }

        @Override
        public void startServerConf(String conf) {
            if (Options.this.serverConf != null) {
                this.reportError("Can not specify more than one server configuration.");
            } else {
                Options.this.startServer = true;
                Options.this.serverConf = conf;
            }
        }

        @Override
        public void javacArg(String ... arg) {
            Options.this.javacArgs.addAll(Arrays.asList(arg));
        }

        @Override
        public void destDir(Path dir) {
            if (Options.this.destDir != null) {
                this.reportError("Destination directory already specified.");
                return;
            }
            Options.this.destDir = dir.toAbsolutePath();
        }

        @Override
        public void generatedSourcesDir(Path dir) {
            if (this.genSrcProvided) {
                this.reportError("Directory for generated sources already specified.");
                return;
            }
            this.genSrcProvided = true;
            Options.this.genSrcDir = dir.toAbsolutePath();
        }

        @Override
        public void headerDir(Path dir) {
            if (this.headerProvided) {
                this.reportError("Header directory already specified.");
                return;
            }
            this.headerProvided = true;
            Options.this.headerDir = dir.toAbsolutePath();
        }

        @Override
        public void stateDir(Path dir) {
            if (this.stateProvided) {
                this.reportError("State directory already specified.");
                return;
            }
            this.stateProvided = true;
            Options.this.stateDir = dir.toAbsolutePath();
        }

        private List<SourceLocation> createSourceLocations(List<Path> paths) {
            ArrayList<SourceLocation> result = new ArrayList<SourceLocation>();
            for (Path path : paths) {
                result.add(new SourceLocation(path, this.includes, this.excludes));
            }
            this.resetFilters();
            return result;
        }

        private void resetFilters() {
            this.includes = new ArrayList<String>();
            this.excludes = new ArrayList<String>();
            this.includeFiles = new ArrayList<String>();
            this.excludeFiles = new ArrayList<String>();
        }
    }
}

