/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class InitialValueFactory {
    private final ValueFactory valueFactory;

    public InitialValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Value createValue(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.valueFactory.createIntegerValue(0);
            }
            case 'J': {
                return this.valueFactory.createLongValue(0L);
            }
            case 'F': {
                return this.valueFactory.createFloatValue(0.0f);
            }
            case 'D': {
                return this.valueFactory.createDoubleValue(0.0);
            }
            case 'L': 
            case '[': {
                return this.valueFactory.createReferenceValueNull();
            }
        }
        throw new IllegalArgumentException("Invalid type [" + string + "]");
    }
}

