/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="DoubleBraceInitialization", summary="Prefer collection factory methods or builders to the double-brace initialization pattern.", severity=BugPattern.SeverityLevel.WARNING)
public class DoubleBraceInitialization
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        ClassTree body = tree.getClassBody();
        if (body == null) {
            return Description.NO_MATCH;
        }
        ImmutableList members = (ImmutableList)body.getMembers().stream().filter(m -> !(m instanceof MethodTree) || !ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)m))).collect(ImmutableList.toImmutableList());
        if (members.size() != 1) {
            return Description.NO_MATCH;
        }
        Tree member = (Tree)Iterables.getOnlyElement((Iterable)members);
        if (!(member instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        BlockTree block = (BlockTree)member;
        Optional<CollectionTypes> collectionType = Stream.of(CollectionTypes.values()).filter(type -> type.constructorMatcher.matches((Tree)tree, state)).findFirst();
        if (!collectionType.isPresent()) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        collectionType.get().maybeFix(tree, state, block).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
        return description.build();
    }

    static enum CollectionTypes {
        MAP("Map", "put", "ImmutableMap"),
        SET("Set", "add", "ImmutableSet"),
        LIST("List", "add", "ImmutableList"),
        COLLECTION("Collection", "add", "ImmutableList");

        final Matcher<ExpressionTree> constructorMatcher;
        final Matcher<StatementTree> mutateMatcher;
        final Matcher<Tree> unmodifiableMatcher;
        final String factoryMethod;
        final String factoryImport;
        final String immutableType;
        final String immutableImport;

        private CollectionTypes(String type, String mutator, String factory) {
            this.immutableType = "Immutable" + type;
            this.immutableImport = "com.google.common.collect.Immutable" + type;
            this.factoryMethod = factory + ".of";
            this.factoryImport = "com.google.common.collect." + factory;
            this.constructorMatcher = MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf((String)("java.util." + type)));
            this.mutateMatcher = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onDescendantOf("java.util." + type).named(mutator));
            this.unmodifiableMatcher = Matchers.toType(ExpressionTree.class, (Matcher)MethodMatchers.staticMethod().onClass("java.util.Collections").named("unmodifiable" + type));
        }

        /*
         * WARNING - void declaration
         */
        Optional<Fix> maybeFix(NewClassTree tree, VisitorState state, BlockTree block) {
            void var6_8;
            String replacement;
            ArrayList<List<? extends ExpressionTree>> arguments = new ArrayList<List<? extends ExpressionTree>>();
            for (StatementTree statementTree : block.getStatements()) {
                if (!this.mutateMatcher.matches((Tree)statementTree, state)) {
                    return Optional.empty();
                }
                arguments.add(((MethodInvocationTree)((ExpressionStatementTree)statementTree).getExpression()).getArguments());
            }
            if (arguments.stream().flatMap(Collection::stream).anyMatch(a -> a.getKind() == Tree.Kind.NULL_LITERAL)) {
                return Optional.empty();
            }
            List args = (List)arguments.stream().map(arg -> arg.stream().map(ASTHelpers::stripParentheses).map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ", "\n", ""))).collect(ImmutableList.toImmutableList());
            Object var6_7 = null;
            VariableTree enclosingVariable = null;
            boolean constant = false;
            for (Tree enclosing : state.getPath().getParentPath()) {
                if (this.unmodifiableMatcher.matches(enclosing, state)) {
                    Tree tree2 = enclosing;
                    continue;
                }
                if (!(enclosing instanceof VariableTree)) break;
                enclosingVariable = (VariableTree)enclosing;
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)enclosingVariable);
                constant = symbol.isStatic() && symbol.getModifiers().contains((Object)Modifier.FINAL) && symbol.getKind() == ElementKind.FIELD;
                break;
            }
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (this.immutableType.equals("ImmutableMap") && args.size() > 5) {
                String typeArguments = tree.getIdentifier() instanceof ParameterizedTypeTree ? ((ParameterizedTypeTree)((Object)tree.getIdentifier())).getTypeArguments().stream().map(arg_0 -> ((VisitorState)state).getSourceForNode(arg_0)).collect(Collectors.joining(", ", "<", ">")) : "";
                replacement = "ImmutableMap." + typeArguments + "builder()" + args.stream().map(a -> ".put(" + a + ")").collect(Collectors.joining("")) + ".build()";
            } else {
                replacement = args.stream().collect(Collectors.joining(", ", this.factoryMethod + "(", ")"));
            }
            fix.addImport(this.factoryImport);
            fix.addImport(this.immutableImport);
            if (var6_8 != null || constant) {
                Tree typeType = enclosingVariable.getType();
                if (typeType instanceof ParameterizedTypeTree) {
                    typeType = ((ParameterizedTypeTree)typeType).getType();
                }
                fix.replace(typeType, this.immutableType).replace((Tree)(var6_8 != null ? var6_8 : enclosingVariable.getInitializer()), replacement);
            } else {
                fix.replace(state.getEndPosition((Tree)tree.getIdentifier()), state.getEndPosition((Tree)tree), "(" + replacement + ")");
            }
            return Optional.of(fix.build());
        }
    }
}

