/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.type.Type;
import com.google.turbine.types.Canonicalize;
import java.util.Map;

public class CanonicalTypeBinder {
    static SourceTypeBoundClass bind(ClassSymbol sym, SourceTypeBoundClass base, Env<ClassSymbol, TypeBoundClass> env) {
        Type.ClassTy superClassType = null;
        if (base.superClassType() != null && base.superClassType().tyKind() == Type.TyKind.CLASS_TY) {
            superClassType = Canonicalize.canonicalizeClassTy(base.source(), base.decl().position(), env, base.owner(), (Type.ClassTy)base.superClassType());
        }
        ImmutableList.Builder interfaceTypes = ImmutableList.builder();
        for (Type i : base.interfaceTypes()) {
            if (i.tyKind() == Type.TyKind.CLASS_TY) {
                i = Canonicalize.canonicalizeClassTy(base.source(), base.decl().position(), env, base.owner(), (Type.ClassTy)i);
            }
            interfaceTypes.add((Object)i);
        }
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typParamTypes = CanonicalTypeBinder.typeParameters(base.source(), base.decl().position(), env, sym, base.typeParameterTypes());
        ImmutableList<TypeBoundClass.MethodInfo> methods = CanonicalTypeBinder.methods(base.source(), base.decl().position(), env, sym, base.methods());
        ImmutableList<TypeBoundClass.FieldInfo> fields = CanonicalTypeBinder.fields(base.source(), env, sym, base.fields());
        return new SourceTypeBoundClass((ImmutableList<Type>)interfaceTypes.build(), superClassType, typParamTypes, base.access(), methods, fields, base.owner(), base.kind(), base.children(), base.typeParameters(), base.enclosingScope(), base.scope(), base.memberImports(), base.annotationMetadata(), base.annotations(), base.source(), base.decl());
    }

    private static ImmutableList<TypeBoundClass.FieldInfo> fields(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<TypeBoundClass.FieldInfo> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo base : fields) {
            result.add((Object)new TypeBoundClass.FieldInfo(base.sym(), Canonicalize.canonicalize(source, base.decl().position(), env, sym, base.type()), base.access(), base.annotations(), base.decl(), base.value()));
        }
        return result.build();
    }

    private static ImmutableList<TypeBoundClass.MethodInfo> methods(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<TypeBoundClass.MethodInfo> methods) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.MethodInfo base : methods) {
            int pos = base.decl() != null ? base.decl().position() : position;
            ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> tps = CanonicalTypeBinder.typeParameters(source, pos, env, sym, base.tyParams());
            Type ret = Canonicalize.canonicalize(source, pos, env, sym, base.returnType());
            ImmutableList.Builder parameters = ImmutableList.builder();
            for (TypeBoundClass.ParamInfo parameter : base.parameters()) {
                parameters.add((Object)CanonicalTypeBinder.param(source, pos, env, sym, parameter));
            }
            ImmutableList<Type> exceptions = CanonicalTypeBinder.canonicalizeList(source, pos, env, sym, base.exceptions());
            result.add((Object)new TypeBoundClass.MethodInfo(base.sym(), tps, ret, (ImmutableList<TypeBoundClass.ParamInfo>)parameters.build(), exceptions, base.access(), base.defaultValue(), base.decl(), base.annotations(), base.receiver() != null ? CanonicalTypeBinder.param(source, base.decl().position(), env, sym, base.receiver()) : null));
        }
        return result.build();
    }

    private static TypeBoundClass.ParamInfo param(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, TypeBoundClass.ParamInfo base) {
        return new TypeBoundClass.ParamInfo(base.sym(), Canonicalize.canonicalize(source, position, env, sym, base.type()), base.annotations(), base.access());
    }

    private static ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameters(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tps) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<TyVarSymbol, TypeBoundClass.TyVarInfo> e : tps.entrySet()) {
            TypeBoundClass.TyVarInfo info = e.getValue();
            Type.IntersectionTy upperBound = (Type.IntersectionTy)Canonicalize.canonicalize(source, position, env, sym, info.upperBound());
            result.put((Object)e.getKey(), (Object)new TypeBoundClass.TyVarInfo(upperBound, null, info.annotations()));
        }
        return result.build();
    }

    private static ImmutableList<Type> canonicalizeList(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)Canonicalize.canonicalize(source, position, env, sym, type));
        }
        return result.build();
    }
}

