/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.ImportDeclaration;
import lombok.ast.Node;

public class WrongImportDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"SuspiciousImport", (String)"'`import android.R`' statement", (String)"Importing `android.R` is usually not intentional; it sometimes happens when you use an IDE and ask it to automatically add imports at a time when your project's R class it not present.\n\nOnce the import is there you might get a lot of \"confusing\" error messages because of course the fields available on `android.R` are not the ones you'd expect from just looking at your own `R` class.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(WrongImportDetector.class, Scope.JAVA_FILE_SCOPE));

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(ImportDeclaration.class);
    }

    public AstVisitor createJavaVisitor(JavaContext context) {
        return new ImportVisitor(context);
    }

    private static class ImportVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public ImportVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitImportDeclaration(ImportDeclaration node) {
            String fqn = node.asFullyQualifiedName();
            if (fqn.equals("android.R")) {
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(ISSUE, (Node)node, location, "Don't include `android.R` here; use a fully qualified name for each usage instead");
            }
            return false;
        }
    }
}

