/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.turbine.diag.SourceFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class TurbineFiler
implements Filer {
    private final Set<String> seen;
    private final List<TurbineJavaFileObject> files = new ArrayList<TurbineJavaFileObject>();
    private final Function<String, Supplier<byte[]>> classPath;
    private final ClassLoader loader;
    private final Map<String, SourceFile> generatedSources = new LinkedHashMap<String, SourceFile>();
    private final Map<String, byte[]> generatedClasses = new LinkedHashMap<String, byte[]>();
    private final Map<String, byte[]> generatedResources = new LinkedHashMap<String, byte[]>();

    public ImmutableList<SourceFile> generatedSources() {
        return ImmutableList.copyOf(this.generatedSources.values());
    }

    public ImmutableMap<String, byte[]> generatedClasses() {
        return ImmutableMap.copyOf(this.generatedClasses);
    }

    public ImmutableMap<String, byte[]> generatedResources() {
        return ImmutableMap.copyOf(this.generatedResources);
    }

    public TurbineFiler(Set<String> seen, Function<String, Supplier<byte[]>> classPath, ClassLoader loader) {
        this.seen = seen;
        this.classPath = classPath;
        this.loader = loader;
    }

    public Collection<SourceFile> finishRound() {
        LinkedHashMap<String, SourceFile> roundSources = new LinkedHashMap<String, SourceFile>();
        for (TurbineJavaFileObject e : this.files) {
            String path = e.getName();
            switch (e.getKind()) {
                case SOURCE: {
                    roundSources.put(path, new SourceFile(path, e.contents()));
                    break;
                }
                case CLASS: {
                    this.generatedClasses.put(path, e.bytes());
                    break;
                }
                case OTHER: {
                    this.generatedResources.put(path, e.bytes());
                    break;
                }
                case HTML: {
                    throw new UnsupportedOperationException(String.valueOf((Object)e.getKind()));
                }
            }
        }
        this.files.clear();
        this.generatedSources.putAll(roundSources);
        return roundSources.values();
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence n, Element ... originatingElements) throws IOException {
        String name = n.toString();
        Preconditions.checkArgument((!name.contains("/") ? 1 : 0) != 0, (String)"invalid type name: %s", (Object)name);
        return this.create(JavaFileObject.Kind.SOURCE, name.replace('.', '/') + ".java");
    }

    @Override
    public JavaFileObject createClassFile(CharSequence n, Element ... originatingElements) throws IOException {
        String name = n.toString();
        Preconditions.checkArgument((!name.contains("/") ? 1 : 0) != 0, (String)"invalid type name: %s", (Object)name);
        return this.create(JavaFileObject.Kind.CLASS, name.replace('.', '/') + ".class");
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence p, CharSequence r, Element ... originatingElements) throws IOException {
        String pkg = p.toString();
        String relativeName = r.toString();
        Preconditions.checkArgument((!pkg.contains("/") ? 1 : 0) != 0, (String)"invalid package: %s", (Object)pkg);
        String path = TurbineFiler.packageRelativePath(pkg, relativeName);
        return this.create(JavaFileObject.Kind.OTHER, path);
    }

    private JavaFileObject create(JavaFileObject.Kind kind, String path) throws FilerException {
        if (!this.seen.add(path)) {
            throw new FilerException("already created " + path);
        }
        TurbineJavaFileObject result = new TurbineJavaFileObject(kind, path);
        this.files.add(result);
        return result;
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence p, CharSequence r) throws IOException {
        String pkg = p.toString();
        String relativeName = r.toString();
        Preconditions.checkArgument((!pkg.contains("/") ? 1 : 0) != 0, (String)"invalid package: %s", (Object)pkg);
        Preconditions.checkArgument((boolean)(location instanceof StandardLocation), (String)"unsupported location %s", (Object)location);
        StandardLocation standardLocation = (StandardLocation)location;
        String path = TurbineFiler.packageRelativePath(pkg, relativeName);
        switch (standardLocation) {
            case CLASS_OUTPUT: {
                byte[] generated = this.generatedClasses.get(path);
                if (generated == null) {
                    throw new FileNotFoundException(path);
                }
                return new BytesFileObject(path, (Supplier<byte[]>)Suppliers.ofInstance((Object)generated));
            }
            case SOURCE_OUTPUT: {
                SourceFile source = this.generatedSources.get(path);
                if (source == null) {
                    throw new FileNotFoundException(path);
                }
                return new SourceFileObject(path, source.source());
            }
            case ANNOTATION_PROCESSOR_PATH: {
                if (this.loader.getResource(path) == null) {
                    throw new FileNotFoundException(path);
                }
                return new ResourceFileObject(this.loader, path);
            }
            case CLASS_PATH: {
                Supplier bytes = (Supplier)this.classPath.apply((Object)path);
                if (bytes == null) {
                    throw new FileNotFoundException(path);
                }
                return new BytesFileObject(path, (Supplier<byte[]>)bytes);
            }
        }
        throw new IllegalArgumentException(standardLocation.getName());
    }

    private static String packageRelativePath(String pkg, String relativeName) {
        if (pkg.isEmpty()) {
            return relativeName;
        }
        return pkg.replace('.', '/') + '/' + relativeName;
    }

    private static class SourceFileObject
    extends ReadOnlyFileObject {
        private final String source;

        public SourceFileObject(String path, String source) {
            super(path);
            this.source = source;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream(this.source.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            return new StringReader(this.source);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }

    private static class BytesFileObject
    extends ReadOnlyFileObject {
        private final Supplier<byte[]> bytes;

        public BytesFileObject(String path, Supplier<byte[]> bytes) {
            super(path);
            this.bytes = bytes;
        }

        @Override
        public InputStream openInputStream() {
            return new ByteArrayInputStream((byte[])this.bytes.get());
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) {
            return new InputStreamReader(this.openInputStream(), StandardCharsets.UTF_8);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return new String((byte[])this.bytes.get(), StandardCharsets.UTF_8);
        }
    }

    private static class ResourceFileObject
    extends ReadOnlyFileObject {
        private final ClassLoader loader;

        public ResourceFileObject(ClassLoader loader, String path) {
            super(path);
            this.loader = loader;
        }

        @Override
        public URI toUri() {
            try {
                return this.loader.getResource(this.path).toURI();
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public InputStream openInputStream() {
            return this.loader.getResourceAsStream(this.path);
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new InputStreamReader(this.openInputStream(), StandardCharsets.UTF_8);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return new String(ByteStreams.toByteArray((InputStream)this.openInputStream()), StandardCharsets.UTF_8);
        }
    }

    private static class TurbineJavaFileObject
    extends WriteOnlyFileObject
    implements JavaFileObject {
        private final JavaFileObject.Kind kind;
        private final CharSequence name;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public TurbineJavaFileObject(JavaFileObject.Kind kind, CharSequence name) {
            this.kind = kind;
            this.name = name;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NestingKind getNestingKind() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Modifier getAccessLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI toUri() {
            return URI.create("file://" + this.name + this.kind.extension);
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public OutputStream openOutputStream() {
            return this.baos;
        }

        @Override
        public Writer openWriter() {
            return new OutputStreamWriter(this.openOutputStream(), StandardCharsets.UTF_8);
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean delete() {
            throw new IllegalStateException();
        }

        public byte[] bytes() {
            return this.baos.toByteArray();
        }

        public String contents() {
            return new String(this.baos.toByteArray(), StandardCharsets.UTF_8);
        }
    }

    private static abstract class WriteOnlyFileObject
    implements FileObject {
        private WriteOnlyFileObject() {
        }

        @Override
        public final InputStream openInputStream() {
            throw new IllegalStateException();
        }

        @Override
        public final Reader openReader(boolean ignoreEncodingErrors) {
            throw new IllegalStateException();
        }

        @Override
        public final CharSequence getCharContent(boolean ignoreEncodingErrors) {
            throw new IllegalStateException();
        }
    }

    private static abstract class ReadOnlyFileObject
    implements FileObject {
        protected final String path;

        public ReadOnlyFileObject(String path) {
            this.path = path;
        }

        @Override
        public final String getName() {
            return this.path;
        }

        @Override
        public URI toUri() {
            return URI.create("file://" + this.path);
        }

        @Override
        public final OutputStream openOutputStream() {
            throw new IllegalStateException();
        }

        @Override
        public final Writer openWriter() {
            throw new IllegalStateException();
        }

        @Override
        public final long getLastModified() {
            return 0L;
        }

        @Override
        public final boolean delete() {
            throw new IllegalStateException();
        }
    }
}

